/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContainerCap {
    RED,
    YELLOW,
    GREY,
    VIOLET,
    BLUE,
    BLACK,
    GREEN,
    NULL;


    public static ContainerCap fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("red".equals(codeString)) {
            return RED;
        }
        if ("yellow".equals(codeString)) {
            return YELLOW;
        }
        if ("grey".equals(codeString)) {
            return GREY;
        }
        if ("violet".equals(codeString)) {
            return VIOLET;
        }
        if ("blue".equals(codeString)) {
            return BLUE;
        }
        if ("black".equals(codeString)) {
            return BLACK;
        }
        if ("green".equals(codeString)) {
            return GREEN;
        }
        throw new FHIRException("Unknown ContainerCap code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RED: {
                return "red";
            }
            case YELLOW: {
                return "yellow";
            }
            case GREY: {
                return "grey";
            }
            case VIOLET: {
                return "violet";
            }
            case BLUE: {
                return "blue";
            }
            case BLACK: {
                return "black";
            }
            case GREEN: {
                return "green";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/container-cap";
    }

    public String getDefinition() {
        switch (this) {
            case RED: {
                return "red cap.";
            }
            case YELLOW: {
                return "yellow cap.";
            }
            case GREY: {
                return "grey cap.";
            }
            case VIOLET: {
                return "violet cap.";
            }
            case BLUE: {
                return "blue cap.";
            }
            case BLACK: {
                return "black cap.";
            }
            case GREEN: {
                return "green cap.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RED: {
                return "red cap";
            }
            case YELLOW: {
                return "yellow cap";
            }
            case GREY: {
                return "grey cap";
            }
            case VIOLET: {
                return "violet cap";
            }
            case BLUE: {
                return "blue cap";
            }
            case BLACK: {
                return "black cap";
            }
            case GREEN: {
                return "green cap";
            }
        }
        return "?";
    }
}

