/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.CourseOfTherapy;

public class CourseOfTherapyEnumFactory
implements EnumFactory<CourseOfTherapy> {
    @Override
    public CourseOfTherapy fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("continuous".equals(codeString)) {
            return CourseOfTherapy.CONTINUOUS;
        }
        if ("acute".equals(codeString)) {
            return CourseOfTherapy.ACUTE;
        }
        if ("seasonal".equals(codeString)) {
            return CourseOfTherapy.SEASONAL;
        }
        throw new IllegalArgumentException("Unknown CourseOfTherapy code '" + codeString + "'");
    }

    @Override
    public String toCode(CourseOfTherapy code) {
        if (code == CourseOfTherapy.CONTINUOUS) {
            return "continuous";
        }
        if (code == CourseOfTherapy.ACUTE) {
            return "acute";
        }
        if (code == CourseOfTherapy.SEASONAL) {
            return "seasonal";
        }
        return "?";
    }

    @Override
    public String toSystem(CourseOfTherapy code) {
        return code.getSystem();
    }
}

