/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.GuideParameterCode;

public class GuideParameterCodeEnumFactory
implements EnumFactory<GuideParameterCode> {
    @Override
    public GuideParameterCode fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("apply-business-version".equals(codeString)) {
            return GuideParameterCode.APPLYBUSINESSVERSION;
        }
        if ("apply-jurisdiction".equals(codeString)) {
            return GuideParameterCode.APPLYJURISDICTION;
        }
        if ("path-resource".equals(codeString)) {
            return GuideParameterCode.PATHRESOURCE;
        }
        if ("path-pages".equals(codeString)) {
            return GuideParameterCode.PATHPAGES;
        }
        if ("path-tx-cache".equals(codeString)) {
            return GuideParameterCode.PATHTXCACHE;
        }
        if ("expansion-parameter".equals(codeString)) {
            return GuideParameterCode.EXPANSIONPARAMETER;
        }
        if ("rule-broken-links".equals(codeString)) {
            return GuideParameterCode.RULEBROKENLINKS;
        }
        if ("generate-xml".equals(codeString)) {
            return GuideParameterCode.GENERATEXML;
        }
        if ("generate-json".equals(codeString)) {
            return GuideParameterCode.GENERATEJSON;
        }
        if ("generate-turtle".equals(codeString)) {
            return GuideParameterCode.GENERATETURTLE;
        }
        if ("html-template".equals(codeString)) {
            return GuideParameterCode.HTMLTEMPLATE;
        }
        throw new IllegalArgumentException("Unknown GuideParameterCode code '" + codeString + "'");
    }

    @Override
    public String toCode(GuideParameterCode code) {
        if (code == GuideParameterCode.APPLYBUSINESSVERSION) {
            return "apply-business-version";
        }
        if (code == GuideParameterCode.APPLYJURISDICTION) {
            return "apply-jurisdiction";
        }
        if (code == GuideParameterCode.PATHRESOURCE) {
            return "path-resource";
        }
        if (code == GuideParameterCode.PATHPAGES) {
            return "path-pages";
        }
        if (code == GuideParameterCode.PATHTXCACHE) {
            return "path-tx-cache";
        }
        if (code == GuideParameterCode.EXPANSIONPARAMETER) {
            return "expansion-parameter";
        }
        if (code == GuideParameterCode.RULEBROKENLINKS) {
            return "rule-broken-links";
        }
        if (code == GuideParameterCode.GENERATEXML) {
            return "generate-xml";
        }
        if (code == GuideParameterCode.GENERATEJSON) {
            return "generate-json";
        }
        if (code == GuideParameterCode.GENERATETURTLE) {
            return "generate-turtle";
        }
        if (code == GuideParameterCode.HTMLTEMPLATE) {
            return "html-template";
        }
        return "?";
    }

    @Override
    public String toSystem(GuideParameterCode code) {
        return code.getSystem();
    }
}

