/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum IdentifierType {
    UDI,
    SNO,
    SB,
    PLAC,
    FILL,
    NULL;


    public static IdentifierType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("UDI".equals(codeString)) {
            return UDI;
        }
        if ("SNO".equals(codeString)) {
            return SNO;
        }
        if ("SB".equals(codeString)) {
            return SB;
        }
        if ("PLAC".equals(codeString)) {
            return PLAC;
        }
        if ("FILL".equals(codeString)) {
            return FILL;
        }
        throw new FHIRException("Unknown IdentifierType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case UDI: {
                return "UDI";
            }
            case SNO: {
                return "SNO";
            }
            case SB: {
                return "SB";
            }
            case PLAC: {
                return "PLAC";
            }
            case FILL: {
                return "FILL";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/identifier-type";
    }

    public String getDefinition() {
        switch (this) {
            case UDI: {
                return "An identifier assigned to a device using the Universal Device Identifier framework as defined by FDA (http://www.fda.gov/MedicalDevices/DeviceRegulationandGuidance/UniqueDeviceIdentification/).";
            }
            case SNO: {
                return "An identifier affixed to an item by the manufacturer when it is first made, where each item has a different identifier.";
            }
            case SB: {
                return "An identifier issued by a governmental organization to an individual for the purpose of the receipt of social services and benefits.";
            }
            case PLAC: {
                return "The identifier associated with the person or service that requests or places an order.";
            }
            case FILL: {
                return "The Identifier associated with the person, or service, who produces the observations or fulfills the order requested by the requestor.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case UDI: {
                return "Universal Device Identifier";
            }
            case SNO: {
                return "Serial Number";
            }
            case SB: {
                return "Social Beneficiary Identifier";
            }
            case PLAC: {
                return "Placer Identifier";
            }
            case FILL: {
                return "Filler Identifier";
            }
        }
        return "?";
    }
}

