/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureImprovementNotation {
    INCREASE,
    DECREASE,
    NULL;


    public static MeasureImprovementNotation fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("increase".equals(codeString)) {
            return INCREASE;
        }
        if ("decrease".equals(codeString)) {
            return DECREASE;
        }
        throw new FHIRException("Unknown MeasureImprovementNotation code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INCREASE: {
                return "increase";
            }
            case DECREASE: {
                return "decrease";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-improvement-notation";
    }

    public String getDefinition() {
        switch (this) {
            case INCREASE: {
                return "Improvement in the measure is noted as an increase in the measure score.";
            }
            case DECREASE: {
                return "Improvement in the measure is noted as a decrease in the measure score.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INCREASE: {
                return "Increase";
            }
            case DECREASE: {
                return "Decrease";
            }
        }
        return "?";
    }
}

