/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MedicationDispenseCategory;

public class MedicationDispenseCategoryEnumFactory
implements EnumFactory<MedicationDispenseCategory> {
    @Override
    public MedicationDispenseCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return MedicationDispenseCategory.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return MedicationDispenseCategory.OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return MedicationDispenseCategory.COMMUNITY;
        }
        if ("discharge".equals(codeString)) {
            return MedicationDispenseCategory.DISCHARGE;
        }
        throw new IllegalArgumentException("Unknown MedicationDispenseCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationDispenseCategory code) {
        if (code == MedicationDispenseCategory.INPATIENT) {
            return "inpatient";
        }
        if (code == MedicationDispenseCategory.OUTPATIENT) {
            return "outpatient";
        }
        if (code == MedicationDispenseCategory.COMMUNITY) {
            return "community";
        }
        if (code == MedicationDispenseCategory.DISCHARGE) {
            return "discharge";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationDispenseCategory code) {
        return code.getSystem();
    }
}

