/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.MedicationRequestCategory;

public class MedicationRequestCategoryEnumFactory
implements EnumFactory<MedicationRequestCategory> {
    @Override
    public MedicationRequestCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("inpatient".equals(codeString)) {
            return MedicationRequestCategory.INPATIENT;
        }
        if ("outpatient".equals(codeString)) {
            return MedicationRequestCategory.OUTPATIENT;
        }
        if ("community".equals(codeString)) {
            return MedicationRequestCategory.COMMUNITY;
        }
        if ("discharge".equals(codeString)) {
            return MedicationRequestCategory.DISCHARGE;
        }
        throw new IllegalArgumentException("Unknown MedicationRequestCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(MedicationRequestCategory code) {
        if (code == MedicationRequestCategory.INPATIENT) {
            return "inpatient";
        }
        if (code == MedicationRequestCategory.OUTPATIENT) {
            return "outpatient";
        }
        if (code == MedicationRequestCategory.COMMUNITY) {
            return "community";
        }
        if (code == MedicationRequestCategory.DISCHARGE) {
            return "discharge";
        }
        return "?";
    }

    @Override
    public String toSystem(MedicationRequestCategory code) {
        return code.getSystem();
    }
}

