/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MissingToothReason {
    E,
    C,
    U,
    O,
    NULL;


    public static MissingToothReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("e".equals(codeString)) {
            return E;
        }
        if ("c".equals(codeString)) {
            return C;
        }
        if ("u".equals(codeString)) {
            return U;
        }
        if ("o".equals(codeString)) {
            return O;
        }
        throw new FHIRException("Unknown MissingToothReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case E: {
                return "e";
            }
            case C: {
                return "c";
            }
            case U: {
                return "u";
            }
            case O: {
                return "o";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/missingtoothreason";
    }

    public String getDefinition() {
        switch (this) {
            case E: {
                return "Extraction";
            }
            case C: {
                return "Congenital";
            }
            case U: {
                return "Unknown";
            }
            case O: {
                return "Other";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case E: {
                return "E";
            }
            case C: {
                return "C";
            }
            case U: {
                return "U";
            }
            case O: {
                return "O";
            }
        }
        return "?";
    }
}

