/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum Need {
    NONE,
    INITIAL,
    PERIODIC,
    NULL;


    public static Need fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("none".equals(codeString)) {
            return NONE;
        }
        if ("initial".equals(codeString)) {
            return INITIAL;
        }
        if ("periodic".equals(codeString)) {
            return PERIODIC;
        }
        throw new FHIRException("Unknown Need code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NONE: {
                return "none";
            }
            case INITIAL: {
                return "initial";
            }
            case PERIODIC: {
                return "periodic";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/need";
    }

    public String getDefinition() {
        switch (this) {
            case NONE: {
                return "";
            }
            case INITIAL: {
                return "";
            }
            case PERIODIC: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NONE: {
                return "None";
            }
            case INITIAL: {
                return "Initial";
            }
            case PERIODIC: {
                return "Periodic";
            }
        }
        return "?";
    }
}

