/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.Need;

public class NeedEnumFactory
implements EnumFactory<Need> {
    @Override
    public Need fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("none".equals(codeString)) {
            return Need.NONE;
        }
        if ("initial".equals(codeString)) {
            return Need.INITIAL;
        }
        if ("periodic".equals(codeString)) {
            return Need.PERIODIC;
        }
        throw new IllegalArgumentException("Unknown Need code '" + codeString + "'");
    }

    @Override
    public String toCode(Need code) {
        if (code == Need.NONE) {
            return "none";
        }
        if (code == Need.INITIAL) {
            return "initial";
        }
        if (code == Need.PERIODIC) {
            return "periodic";
        }
        return "?";
    }

    @Override
    public String toSystem(Need code) {
        return code.getSystem();
    }
}

