/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ObservationStatus {
    REGISTERED,
    PRELIMINARY,
    FINAL,
    AMENDED,
    CORRECTED,
    CANCELLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ObservationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("registered".equals(codeString)) {
            return REGISTERED;
        }
        if ("preliminary".equals(codeString)) {
            return PRELIMINARY;
        }
        if ("final".equals(codeString)) {
            return FINAL;
        }
        if ("amended".equals(codeString)) {
            return AMENDED;
        }
        if ("corrected".equals(codeString)) {
            return CORRECTED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REGISTERED: {
                return "registered";
            }
            case PRELIMINARY: {
                return "preliminary";
            }
            case FINAL: {
                return "final";
            }
            case AMENDED: {
                return "amended";
            }
            case CORRECTED: {
                return "corrected";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/observation-status";
    }

    public String getDefinition() {
        switch (this) {
            case REGISTERED: {
                return "The existence of the observation is registered, but there is no result yet available.";
            }
            case PRELIMINARY: {
                return "This is an initial or interim observation: data may be incomplete or unverified.";
            }
            case FINAL: {
                return "The observation is complete and there are no further actions needed. Additional information such \"released\", \"signed\", etc would be represented using [Provenance](provenance.html) which provides not only the act but also the actors and dates and other related data. These act states would be associated with an observation status of `preliminary` until they are all completed and then a status of `final` would be applied.";
            }
            case AMENDED: {
                return "Subsequent to being Final, the observation has been modified subsequent.  This includes updates/new information and corrections.";
            }
            case CORRECTED: {
                return "Subsequent to being Final, the observation has been modified to correct an error in the test result.";
            }
            case CANCELLED: {
                return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
            }
            case ENTEREDINERROR: {
                return "The observation has been withdrawn following previous final release.  This electronic record should never have existed, though it is possible that real-world decisions were based on it. (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".).";
            }
            case UNKNOWN: {
                return "The authoring system does not know which of the status values currently applies for this request. Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, but the authoring system does not know which.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REGISTERED: {
                return "Registered";
            }
            case PRELIMINARY: {
                return "Preliminary";
            }
            case FINAL: {
                return "Final";
            }
            case AMENDED: {
                return "Amended";
            }
            case CORRECTED: {
                return "Corrected";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

