/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OperationalStatus {
    OFF,
    ON,
    NOTREADY,
    STANDBY,
    TRANSDUCDISCON,
    HWDISCON,
    ENTEREDINERROR,
    NULL;


    public static OperationalStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("off".equals(codeString)) {
            return OFF;
        }
        if ("on".equals(codeString)) {
            return ON;
        }
        if ("not-ready".equals(codeString)) {
            return NOTREADY;
        }
        if ("standby".equals(codeString)) {
            return STANDBY;
        }
        if ("transduc-discon".equals(codeString)) {
            return TRANSDUCDISCON;
        }
        if ("hw-discon".equals(codeString)) {
            return HWDISCON;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown OperationalStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OFF: {
                return "off";
            }
            case ON: {
                return "on";
            }
            case NOTREADY: {
                return "not-ready";
            }
            case STANDBY: {
                return "standby";
            }
            case TRANSDUCDISCON: {
                return "transduc-discon";
            }
            case HWDISCON: {
                return "hw-discon";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/operational-status";
    }

    public String getDefinition() {
        switch (this) {
            case OFF: {
                return "The device is off.";
            }
            case ON: {
                return "The device is fully operational.";
            }
            case NOTREADY: {
                return "The device is not ready.";
            }
            case STANDBY: {
                return "The device is ready but not actively operating.";
            }
            case TRANSDUCDISCON: {
                return "The device transducer is disconnected.";
            }
            case HWDISCON: {
                return "The device hardware is disconnected.";
            }
            case ENTEREDINERROR: {
                return "The device was entered in error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OFF: {
                return "Off";
            }
            case ON: {
                return "On";
            }
            case NOTREADY: {
                return "Not Ready";
            }
            case STANDBY: {
                return "Standby";
            }
            case TRANSDUCDISCON: {
                return "Transducer Disconnected";
            }
            case HWDISCON: {
                return "Hardware Disconnectd";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
        }
        return "?";
    }
}

