/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PractitionerRole {
    DOCTOR,
    NURSE,
    PHARMACIST,
    RESEARCHER,
    TEACHER,
    ICT,
    NULL;


    public static PractitionerRole fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("doctor".equals(codeString)) {
            return DOCTOR;
        }
        if ("nurse".equals(codeString)) {
            return NURSE;
        }
        if ("pharmacist".equals(codeString)) {
            return PHARMACIST;
        }
        if ("researcher".equals(codeString)) {
            return RESEARCHER;
        }
        if ("teacher".equals(codeString)) {
            return TEACHER;
        }
        if ("ict".equals(codeString)) {
            return ICT;
        }
        throw new FHIRException("Unknown PractitionerRole code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DOCTOR: {
                return "doctor";
            }
            case NURSE: {
                return "nurse";
            }
            case PHARMACIST: {
                return "pharmacist";
            }
            case RESEARCHER: {
                return "researcher";
            }
            case TEACHER: {
                return "teacher";
            }
            case ICT: {
                return "ict";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/practitioner-role";
    }

    public String getDefinition() {
        switch (this) {
            case DOCTOR: {
                return "A qualified/registered medical practitioner";
            }
            case NURSE: {
                return "A practitoner with nursing experience that may be qualified/registered";
            }
            case PHARMACIST: {
                return "A qualified/registered/licensed pharmacist";
            }
            case RESEARCHER: {
                return "A practitioner that may perform research";
            }
            case TEACHER: {
                return "Someone who is able to provide educational services";
            }
            case ICT: {
                return "Someone who is qualified in Information and Communication Technologies";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DOCTOR: {
                return "Doctor";
            }
            case NURSE: {
                return "Nurse";
            }
            case PHARMACIST: {
                return "Pharmacist";
            }
            case RESEARCHER: {
                return "Researcher";
            }
            case TEACHER: {
                return "Teacher/educator";
            }
            case ICT: {
                return "ICT professional";
            }
        }
        return "?";
    }
}

