/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PushTypeAvailable {
    SPECIFIC,
    ANY,
    SOURCE,
    NULL;


    public static PushTypeAvailable fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("specific".equals(codeString)) {
            return SPECIFIC;
        }
        if ("any".equals(codeString)) {
            return ANY;
        }
        if ("source".equals(codeString)) {
            return SOURCE;
        }
        throw new FHIRException("Unknown PushTypeAvailable code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SPECIFIC: {
                return "specific";
            }
            case ANY: {
                return "any";
            }
            case SOURCE: {
                return "source";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/push-type-available";
    }

    public String getDefinition() {
        switch (this) {
            case SPECIFIC: {
                return "";
            }
            case ANY: {
                return "";
            }
            case SOURCE: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SPECIFIC: {
                return "Specific requested changes";
            }
            case ANY: {
                return "Any changes";
            }
            case SOURCE: {
                return "As defined by source";
            }
        }
        return "?";
    }
}

