/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.Status;

public class StatusEnumFactory
implements EnumFactory<Status> {
    @Override
    public Status fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("attested".equals(codeString)) {
            return Status.ATTESTED;
        }
        if ("validated".equals(codeString)) {
            return Status.VALIDATED;
        }
        if ("in-process".equals(codeString)) {
            return Status.INPROCESS;
        }
        if ("req-revalid".equals(codeString)) {
            return Status.REQREVALID;
        }
        if ("val-fail".equals(codeString)) {
            return Status.VALFAIL;
        }
        if ("reval-fail".equals(codeString)) {
            return Status.REVALFAIL;
        }
        throw new IllegalArgumentException("Unknown Status code '" + codeString + "'");
    }

    @Override
    public String toCode(Status code) {
        if (code == Status.ATTESTED) {
            return "attested";
        }
        if (code == Status.VALIDATED) {
            return "validated";
        }
        if (code == Status.INPROCESS) {
            return "in-process";
        }
        if (code == Status.REQREVALID) {
            return "req-revalid";
        }
        if (code == Status.VALFAIL) {
            return "val-fail";
        }
        if (code == Status.REVALFAIL) {
            return "reval-fail";
        }
        return "?";
    }

    @Override
    public String toSystem(Status code) {
        return code.getSystem();
    }
}

