/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum UsersessionStatusSource {
    USER,
    SYSTEM,
    NULL;


    public static UsersessionStatusSource fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("user".equals(codeString)) {
            return USER;
        }
        if ("system".equals(codeString)) {
            return SYSTEM;
        }
        throw new FHIRException("Unknown UsersessionStatusSource code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case USER: {
                return "user";
            }
            case SYSTEM: {
                return "system";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/usersession-status-source";
    }

    public String getDefinition() {
        switch (this) {
            case USER: {
                return "The status was reported by the user.";
            }
            case SYSTEM: {
                return "The status was reported by the system.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case USER: {
                return "User";
            }
            case SYSTEM: {
                return "System";
            }
        }
        return "?";
    }
}

