/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.ValidationProcess;

public class ValidationProcessEnumFactory
implements EnumFactory<ValidationProcess> {
    @Override
    public ValidationProcess fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("edit-check".equals(codeString)) {
            return ValidationProcess.EDITCHECK;
        }
        if ("valueset".equals(codeString)) {
            return ValidationProcess.VALUESET;
        }
        if ("primary".equals(codeString)) {
            return ValidationProcess.PRIMARY;
        }
        if ("multi".equals(codeString)) {
            return ValidationProcess.MULTI;
        }
        if ("standalone".equals(codeString)) {
            return ValidationProcess.STANDALONE;
        }
        if ("in-context".equals(codeString)) {
            return ValidationProcess.INCONTEXT;
        }
        throw new IllegalArgumentException("Unknown ValidationProcess code '" + codeString + "'");
    }

    @Override
    public String toCode(ValidationProcess code) {
        if (code == ValidationProcess.EDITCHECK) {
            return "edit-check";
        }
        if (code == ValidationProcess.VALUESET) {
            return "valueset";
        }
        if (code == ValidationProcess.PRIMARY) {
            return "primary";
        }
        if (code == ValidationProcess.MULTI) {
            return "multi";
        }
        if (code == ValidationProcess.STANDALONE) {
            return "standalone";
        }
        if (code == ValidationProcess.INCONTEXT) {
            return "in-context";
        }
        return "?";
    }

    @Override
    public String toSystem(ValidationProcess code) {
        return code.getSystem();
    }
}

