/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.terminologies;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetChecker;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ValueSetCheckerSimple
implements ValueSetChecker {
    private ValueSet valueset;
    private IWorkerContext context;

    public ValueSetCheckerSimple(ValueSet source, IWorkerContext context) {
        this.valueset = source;
        this.context = context;
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept code) throws FHIRException {
        ArrayList<String> errors = new ArrayList<String>();
        ArrayList<String> warnings = new ArrayList<String>();
        for (Coding c : code.getCoding()) {
            CodeSystem cs;
            if (!c.hasSystem()) {
                warnings.add("Coding has no system");
            }
            if ((cs = this.context.fetchCodeSystem(c.getSystem())) == null) {
                throw new FHIRException("Unsupported system " + c.getSystem() + " - system is not specified or implicit");
            }
            if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
                throw new FHIRException("Unable to resolve system " + c.getSystem() + " - system is not complete");
            }
            IWorkerContext.ValidationResult res = this.validateCode(c, cs);
            if (!res.isOk()) {
                errors.add(res.getMessage());
                continue;
            }
            if (res.getMessage() == null) continue;
            warnings.add(res.getMessage());
        }
        if (this.valueset != null) {
            boolean ok = false;
            for (Coding c : code.getCoding()) {
                ok = ok || this.codeInValueSet(c.getSystem(), c.getCode());
            }
            if (!ok) {
                errors.add(0, "None of the provided codes are in the value set " + this.valueset.getUrl());
            }
        }
        if (errors.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, ((Object)errors).toString());
        }
        if (warnings.size() > 0) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, ((Object)warnings).toString());
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.INFORMATION, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding code) throws FHIRException {
        CodeSystem cs;
        String system;
        String string = system = code.hasSystem() ? code.getSystem() : this.getValueSetSystem();
        if (system == null && !code.hasDisplay()) {
            system = this.systemForCodeInValueSet(code.getCode());
        }
        if ((cs = this.context.fetchCodeSystem(system)) == null) {
            throw new FHIRException("Unable to resolve system " + system + " - system is not specified or implicit");
        }
        if (cs.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            throw new FHIRException("Unable to resolve system " + system + " - system is not complete");
        }
        IWorkerContext.ValidationResult res = this.validateCode(code, cs);
        if (res.isOk() && this.valueset != null && !this.codeInValueSet(system, code.getCode())) {
            res.setMessage("Not in value set " + this.valueset.getUrl()).setSeverity(ValidationMessage.IssueSeverity.ERROR);
        }
        return res;
    }

    private IWorkerContext.ValidationResult validateCode(Coding code, CodeSystem cs) {
        CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code.getCode());
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + cs.getUrl());
        }
        if (code.getDisplay() == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (code.getDisplay().equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!code.getDisplay().equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Display Name for " + code + " must be one of '" + b.toString() + "'", cc);
    }

    private String getValueSetSystem() throws FHIRException {
        if (this.valueset == null) {
            throw new FHIRException("Unable to resolve system - no value set");
        }
        if (this.valueset.getCompose().hasExclude()) {
            throw new FHIRException("Unable to resolve system - value set has excludes");
        }
        if (this.valueset.getCompose().getInclude().size() == 0) {
            throw new FHIRException("Unable to resolve system - value set has no includes");
        }
        for (ValueSet.ConceptSetComponent inc : this.valueset.getCompose().getInclude()) {
            if (inc.hasValueSet()) {
                throw new FHIRException("Unable to resolve system - value set has imports");
            }
            if (inc.hasSystem()) continue;
            throw new FHIRException("Unable to resolve system - value set has include with no system");
        }
        if (this.valueset.getCompose().getInclude().size() == 1) {
            return this.valueset.getCompose().getInclude().get(0).getSystem();
        }
        return null;
    }

    private CodeSystem.ConceptDefinitionComponent findCodeInConcept(List<CodeSystem.ConceptDefinitionComponent> concept, String code) {
        for (CodeSystem.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            CodeSystem.ConceptDefinitionComponent c = this.findCodeInConcept(cc.getConcept(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private String systemForCodeInValueSet(String code) {
        String sys = null;
        if (this.valueset.hasCompose()) {
            if (this.valueset.getCompose().hasExclude()) {
                return null;
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                if (vsi.hasValueSet()) {
                    return null;
                }
                if (!vsi.hasSystem()) {
                    return null;
                }
                if (vsi.hasFilter()) {
                    return null;
                }
                CodeSystem cs = this.context.fetchCodeSystem(vsi.getSystem());
                if (cs == null) {
                    return null;
                }
                if (vsi.hasConcept()) {
                    for (ValueSet.ConceptReferenceComponent cc : vsi.getConcept()) {
                        boolean match = cs.getCaseSensitive() ? cc.getCode().equals(code) : cc.getCode().equalsIgnoreCase(code);
                        if (!match) continue;
                        if (sys == null) {
                            sys = vsi.getSystem();
                            continue;
                        }
                        if (sys.equals(vsi.getSystem())) continue;
                        return null;
                    }
                    continue;
                }
                CodeSystem.ConceptDefinitionComponent cc = this.findCodeInConcept(cs.getConcept(), code);
                if (cc == null) continue;
                if (sys == null) {
                    sys = vsi.getSystem();
                    continue;
                }
                if (sys.equals(vsi.getSystem())) continue;
                return null;
            }
        }
        return sys;
    }

    @Override
    public boolean codeInValueSet(String system, String code) throws FHIRException {
        if (this.valueset.hasCompose()) {
            boolean ok = false;
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                ok = ok || this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                ok = ok && !this.inComponent(vsi, system, code, this.valueset.getCompose().getInclude().size() == 1);
            }
            return ok;
        }
        return false;
    }

    private boolean inComponent(ValueSet.ConceptSetComponent vsi, String system, String code, boolean only) throws FHIRException {
        for (UriType uriType : vsi.getValueSet()) {
            if (!this.inImport((String)uriType.getValue(), system, code)) continue;
            return true;
        }
        if (!vsi.hasSystem()) {
            return false;
        }
        if (only && system == null) {
            for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
                if (!conceptReferenceComponent.getCode().equals(code)) continue;
                return true;
            }
        }
        if (!system.equals(vsi.getSystem())) {
            return false;
        }
        if (vsi.hasFilter()) {
            throw new FHIRException("Filters - not done yet");
        }
        CodeSystem def = this.context.fetchCodeSystem(system);
        if (def.getContent() != CodeSystem.CodeSystemContentMode.COMPLETE) {
            throw new FHIRException("Unable to resolve system " + vsi.getSystem() + " - system is not complete");
        }
        List<CodeSystem.ConceptDefinitionComponent> list = def.getConcept();
        return this.validateCodeInConceptList(code, def, list);
    }

    public boolean validateCodeInConceptList(String code, CodeSystem def, List<CodeSystem.ConceptDefinitionComponent> list) {
        if (def.getCaseSensitive()) {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equals(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        } else {
            for (CodeSystem.ConceptDefinitionComponent cc : list) {
                if (cc.getCode().equalsIgnoreCase(code)) {
                    return true;
                }
                if (!cc.hasConcept() || !this.validateCodeInConceptList(code, def, cc.getConcept())) continue;
                return true;
            }
        }
        return false;
    }

    private boolean inImport(String uri, String system, String code) throws FHIRException {
        ValueSet vs = this.context.fetchResource(ValueSet.class, uri);
        ValueSetCheckerSimple vsc = new ValueSetCheckerSimple(vs, this.context);
        return vsc.codeInValueSet(system, code);
    }
}

