/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.NotImplementedException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.elementmodel.Property;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.ExpressionNode;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceFactory;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.TypeDetails;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;
import org.hl7.fhir.r4.utils.FHIRLexer;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.hl7.fhir.r4.utils.IResourceValidator;
import org.hl7.fhir.r4.utils.NarrativeGenerator;
import org.hl7.fhir.r4.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class StructureMapUtilities {
    public static final String MAP_WHERE_CHECK = "map.where.check";
    public static final String MAP_WHERE_LOG = "map.where.log";
    public static final String MAP_WHERE_EXPRESSION = "map.where.expression";
    public static final String MAP_SEARCH_EXPRESSION = "map.search.expression";
    public static final String MAP_EXPRESSION = "map.transform.expression";
    private static final boolean RENDER_MULTIPLE_TARGETS_ONELINE = true;
    private static final String AUTO_VAR_NAME = "vvv";
    private IWorkerContext worker;
    private FHIRPathEngine fpe;
    private ITransformerServices services;
    private ProfileUtilities.ProfileKnowledgeProvider pkp;
    private Map<String, Integer> ids = new HashMap<String, Integer>();

    public StructureMapUtilities(IWorkerContext worker, ITransformerServices services, ProfileUtilities.ProfileKnowledgeProvider pkp) {
        this.worker = worker;
        this.services = services;
        this.pkp = pkp;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FFHIRPathHostServices());
    }

    public StructureMapUtilities(IWorkerContext worker, ITransformerServices services) {
        this.worker = worker;
        this.services = services;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FFHIRPathHostServices());
    }

    public StructureMapUtilities(IWorkerContext worker) {
        this.worker = worker;
        this.fpe = new FHIRPathEngine(worker);
        this.fpe.setHostServices(new FFHIRPathHostServices());
    }

    public static String render(StructureMap map) {
        StringBuilder b = new StringBuilder();
        b.append("map \"");
        b.append(map.getUrl());
        b.append("\" = \"");
        b.append(Utilities.escapeJava((String)map.getName()));
        b.append("\"\r\n\r\n");
        StructureMapUtilities.renderConceptMaps(b, map);
        StructureMapUtilities.renderUses(b, map);
        StructureMapUtilities.renderImports(b, map);
        for (StructureMap.StructureMapGroupComponent g : map.getGroup()) {
            StructureMapUtilities.renderGroup(b, g);
        }
        return b.toString();
    }

    private static void renderConceptMaps(StringBuilder b, StructureMap map) {
        for (Resource r : map.getContained()) {
            if (!(r instanceof ConceptMap)) continue;
            StructureMapUtilities.produceConceptMap(b, (ConceptMap)r);
        }
    }

    private static void produceConceptMap(StringBuilder b, ConceptMap cm) {
        b.append("conceptmap \"");
        b.append(cm.getId());
        b.append("\" {\r\n");
        HashMap<String, String> prefixesSrc = new HashMap<String, String>();
        HashMap<String, String> prefixesTgt = new HashMap<String, String>();
        char prefix = 's';
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            if (!prefixesSrc.containsKey(cg.getSource())) {
                prefixesSrc.put(cg.getSource(), String.valueOf(prefix));
                b.append("  prefix ");
                b.append(prefix);
                b.append(" = \"");
                b.append(cg.getSource());
                b.append("\"\r\n");
                prefix = (char)(prefix + '\u0001');
            }
            if (prefixesTgt.containsKey(cg.getTarget())) continue;
            prefixesTgt.put(cg.getTarget(), String.valueOf(prefix));
            b.append("  prefix ");
            b.append(prefix);
            b.append(" = \"");
            b.append(cg.getTarget());
            b.append("\"\r\n");
            prefix = (char)(prefix + '\u0001');
        }
        b.append("\r\n");
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            if (!cg.hasUnmapped()) continue;
            b.append("  unmapped for ");
            b.append(prefix);
            b.append(" = ");
            b.append((Object)cg.getUnmapped().getMode());
            b.append("\r\n");
        }
        for (ConceptMap.ConceptMapGroupComponent cg : cm.getGroup()) {
            for (ConceptMap.SourceElementComponent ce : cg.getElement()) {
                b.append("  ");
                b.append((String)prefixesSrc.get(cg.getSource()));
                b.append(":");
                b.append(ce.getCode());
                b.append(" ");
                b.append(StructureMapUtilities.getChar(ce.getTargetFirstRep().getEquivalence()));
                b.append(" ");
                b.append((String)prefixesTgt.get(cg.getTarget()));
                b.append(":");
                b.append(ce.getTargetFirstRep().getCode());
                b.append("\r\n");
            }
        }
        b.append("}\r\n\r\n");
    }

    private static Object getChar(Enumerations.ConceptMapEquivalence equivalence) {
        switch (equivalence) {
            case RELATEDTO: {
                return "-";
            }
            case EQUAL: {
                return "=";
            }
            case EQUIVALENT: {
                return "==";
            }
            case DISJOINT: {
                return "!=";
            }
            case UNMATCHED: {
                return "--";
            }
            case WIDER: {
                return "<=";
            }
            case SUBSUMES: {
                return "<-";
            }
            case NARROWER: {
                return ">=";
            }
            case SPECIALIZES: {
                return ">-";
            }
            case INEXACT: {
                return "~";
            }
        }
        return "??";
    }

    private static void renderUses(StringBuilder b, StructureMap map) {
        for (StructureMap.StructureMapStructureComponent s : map.getStructure()) {
            b.append("uses \"");
            b.append(s.getUrl());
            b.append("\" ");
            if (s.hasAlias()) {
                b.append("alias ");
                b.append(s.getAlias());
                b.append(" ");
            }
            b.append("as ");
            b.append(s.getMode().toCode());
            b.append("\r\n");
            StructureMapUtilities.renderDoco(b, s.getDocumentation());
        }
        if (map.hasStructure()) {
            b.append("\r\n");
        }
    }

    private static void renderImports(StringBuilder b, StructureMap map) {
        for (UriType uriType : map.getImport()) {
            b.append("imports \"");
            b.append((String)uriType.getValue());
            b.append("\"\r\n");
        }
        if (map.hasImport()) {
            b.append("\r\n");
        }
    }

    public static String groupToString(StructureMap.StructureMapGroupComponent g) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderGroup(b, g);
        return b.toString();
    }

    private static void renderGroup(StringBuilder b, StructureMap.StructureMapGroupComponent g) {
        b.append("group ");
        switch (g.getTypeMode()) {
            case TYPES: {
                b.append("for types");
                break;
            }
            case TYPEANDTYPES: {
                b.append("for type+types ");
                break;
            }
        }
        b.append(g.getName());
        if (g.hasExtends()) {
            b.append(" extends ");
            b.append(g.getExtends());
        }
        if (g.hasDocumentation()) {
            StructureMapUtilities.renderDoco(b, g.getDocumentation());
        }
        b.append("\r\n");
        for (StructureMap.StructureMapGroupInputComponent gi : g.getInput()) {
            b.append("  input ");
            b.append(gi.getName());
            if (gi.hasType()) {
                b.append(" : ");
                b.append(gi.getType());
            }
            b.append(" as ");
            b.append(gi.getMode().toCode());
            b.append("\r\n");
        }
        if (g.hasInput()) {
            b.append("\r\n");
        }
        for (StructureMap.StructureMapGroupRuleComponent r : g.getRule()) {
            StructureMapUtilities.renderRule(b, r, 2);
        }
        b.append("\r\nendgroup\r\n");
    }

    public static String ruleToString(StructureMap.StructureMapGroupRuleComponent r) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderRule(b, r, 0);
        return b.toString();
    }

    private static void renderRule(StringBuilder b, StructureMap.StructureMapGroupRuleComponent r, int indent) {
        for (int i = 0; i < indent; ++i) {
            b.append(' ');
        }
        b.append(r.getName());
        b.append(" : for ");
        boolean canBeAbbreviated = StructureMapUtilities.checkisSimple(r);
        boolean first = true;
        for (StructureMap.StructureMapGroupRuleSourceComponent rs : r.getSource()) {
            if (first) {
                first = false;
            } else {
                b.append(", ");
            }
            StructureMapUtilities.renderSource(b, rs, canBeAbbreviated);
        }
        if (r.getTarget().size() > 1) {
            b.append(" make ");
            first = true;
            for (StructureMap.StructureMapGroupRuleTargetComponent rt : r.getTarget()) {
                if (first) {
                    first = false;
                } else {
                    b.append(", ");
                }
                b.append(' ');
                StructureMapUtilities.renderTarget(b, rt, false);
            }
        } else if (r.hasTarget()) {
            b.append(" make ");
            StructureMapUtilities.renderTarget(b, r.getTarget().get(0), canBeAbbreviated);
        }
        if (!canBeAbbreviated) {
            if (r.hasRule()) {
                b.append(" then {\r\n");
                StructureMapUtilities.renderDoco(b, r.getDocumentation());
                for (StructureMap.StructureMapGroupRuleComponent ir : r.getRule()) {
                    StructureMapUtilities.renderRule(b, ir, indent + 2);
                }
                for (int i = 0; i < indent; ++i) {
                    b.append(' ');
                }
                b.append("}\r\n");
            } else if (r.hasDependent()) {
                b.append(" then ");
                first = true;
                for (StructureMap.StructureMapGroupRuleDependentComponent rd : r.getDependent()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    b.append(rd.getName());
                    b.append("(");
                    boolean ifirst = true;
                    for (StringType rdp : rd.getVariable()) {
                        if (ifirst) {
                            ifirst = false;
                        } else {
                            b.append(", ");
                        }
                        b.append(rdp.asStringValue());
                    }
                    b.append(")");
                }
            }
        }
        StructureMapUtilities.renderDoco(b, r.getDocumentation());
        b.append("\r\n");
    }

    private static boolean checkisSimple(StructureMap.StructureMapGroupRuleComponent r) {
        return r.getSource().size() == 1 && r.getSourceFirstRep().hasElement() && r.getSourceFirstRep().hasVariable() && r.getTarget().size() == 1 && r.getTargetFirstRep().hasVariable() && (r.getTargetFirstRep().getTransform() == null || r.getTargetFirstRep().getTransform() == StructureMap.StructureMapTransform.CREATE) && r.getTargetFirstRep().getParameter().size() == 0 && r.getDependent().size() == 0;
    }

    public static String sourceToString(StructureMap.StructureMapGroupRuleSourceComponent r) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderSource(b, r, false);
        return b.toString();
    }

    private static void renderSource(StringBuilder b, StructureMap.StructureMapGroupRuleSourceComponent rs, boolean abbreviate) {
        b.append(rs.getContext());
        if (rs.getContext().equals("@search")) {
            b.append('(');
            b.append(rs.getElement());
            b.append(')');
        } else if (rs.hasElement()) {
            b.append('.');
            b.append(rs.getElement());
        }
        if (rs.hasType()) {
            b.append(" : ");
            b.append(rs.getType());
            if (rs.hasMin()) {
                b.append(" ");
                b.append(rs.getMin());
                b.append("..");
                b.append(rs.getMax());
            }
        }
        if (rs.hasListMode()) {
            b.append(" ");
            b.append(rs.getListMode().toCode());
        }
        if (rs.hasDefaultValue()) {
            b.append(" default ");
            assert (rs.getDefaultValue() instanceof StringType);
            b.append("\"" + Utilities.escapeJson((String)((StringType)rs.getDefaultValue()).asStringValue()) + "\"");
        }
        if (!abbreviate && rs.hasVariable()) {
            b.append(" as ");
            b.append(rs.getVariable());
        }
        if (rs.hasCondition()) {
            b.append(" where ");
            b.append(rs.getCondition());
        }
        if (rs.hasCheck()) {
            b.append(" check ");
            b.append(rs.getCheck());
        }
        if (rs.hasLogMessage()) {
            b.append(" log ");
            b.append(rs.getLogMessage());
        }
    }

    public static String targetToString(StructureMap.StructureMapGroupRuleTargetComponent rt) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderTarget(b, rt, false);
        return b.toString();
    }

    private static void renderTarget(StringBuilder b, StructureMap.StructureMapGroupRuleTargetComponent rt, boolean abbreviate) {
        if (rt.hasContext()) {
            if (rt.getContextType() == StructureMap.StructureMapContextType.TYPE) {
                b.append("@");
            }
            b.append(rt.getContext());
            if (rt.hasElement()) {
                b.append('.');
                b.append(rt.getElement());
            }
        }
        if (!abbreviate && rt.hasTransform()) {
            if (rt.hasContext()) {
                b.append(" = ");
            }
            if (rt.getTransform() == StructureMap.StructureMapTransform.COPY && rt.getParameter().size() == 1) {
                StructureMapUtilities.renderTransformParam(b, rt.getParameter().get(0));
            } else if (rt.getTransform() == StructureMap.StructureMapTransform.EVALUATE && rt.getParameter().size() == 1) {
                b.append("(");
                b.append("\"" + ((StringType)rt.getParameter().get(0).getValue()).asStringValue() + "\"");
                b.append(")");
            } else if (rt.getTransform() == StructureMap.StructureMapTransform.EVALUATE && rt.getParameter().size() == 2) {
                b.append(rt.getTransform().toCode());
                b.append("(");
                b.append(((IdType)rt.getParameter().get(0).getValue()).asStringValue());
                b.append("\"" + ((StringType)rt.getParameter().get(1).getValue()).asStringValue() + "\"");
                b.append(")");
            } else {
                b.append(rt.getTransform().toCode());
                b.append("(");
                boolean first = true;
                for (StructureMap.StructureMapGroupRuleTargetParameterComponent rtp : rt.getParameter()) {
                    if (first) {
                        first = false;
                    } else {
                        b.append(", ");
                    }
                    StructureMapUtilities.renderTransformParam(b, rtp);
                }
                b.append(")");
            }
        }
        if (!abbreviate && rt.hasVariable()) {
            b.append(" as ");
            b.append(rt.getVariable());
        }
        for (Enumeration<StructureMap.StructureMapTargetListMode> lm : rt.getListMode()) {
            b.append(" ");
            b.append(((StructureMap.StructureMapTargetListMode)((Object)lm.getValue())).toCode());
            if (lm.getValue() != StructureMap.StructureMapTargetListMode.SHARE) continue;
            b.append(" ");
            b.append(rt.getListRuleId());
        }
    }

    public static String paramToString(StructureMap.StructureMapGroupRuleTargetParameterComponent rtp) {
        StringBuilder b = new StringBuilder();
        StructureMapUtilities.renderTransformParam(b, rtp);
        return b.toString();
    }

    private static void renderTransformParam(StringBuilder b, StructureMap.StructureMapGroupRuleTargetParameterComponent rtp) {
        try {
            if (rtp.hasValueBooleanType()) {
                b.append(rtp.getValueBooleanType().asStringValue());
            } else if (rtp.hasValueDecimalType()) {
                b.append(rtp.getValueDecimalType().asStringValue());
            } else if (rtp.hasValueIdType()) {
                b.append(rtp.getValueIdType().asStringValue());
            } else if (rtp.hasValueDecimalType()) {
                b.append(rtp.getValueDecimalType().asStringValue());
            } else if (rtp.hasValueIntegerType()) {
                b.append(rtp.getValueIntegerType().asStringValue());
            } else {
                b.append("\"" + Utilities.escapeJava((String)rtp.getValueStringType().asStringValue()) + "\"");
            }
        }
        catch (FHIRException e) {
            e.printStackTrace();
            b.append("error!");
        }
    }

    private static void renderDoco(StringBuilder b, String doco) {
        if (Utilities.noString((String)doco)) {
            return;
        }
        b.append(" // ");
        b.append(doco.replace("\r\n", " ").replace("\r", " ").replace("\n", " "));
    }

    public StructureMap parse(String text) throws FHIRException {
        FHIRLexer lexer = new FHIRLexer(text);
        if (lexer.done()) {
            throw lexer.error("Map Input cannot be empty");
        }
        lexer.skipComments();
        lexer.token("map");
        StructureMap result = new StructureMap();
        result.setUrl(lexer.readConstant("url"));
        lexer.token("=");
        result.setName(lexer.readConstant("name"));
        lexer.skipComments();
        while (lexer.hasToken("conceptmap")) {
            this.parseConceptMap(result, lexer);
        }
        while (lexer.hasToken("uses")) {
            this.parseUses(result, lexer);
        }
        while (lexer.hasToken("imports")) {
            this.parseImports(result, lexer);
        }
        this.parseGroup(result, lexer);
        while (!lexer.done()) {
            this.parseGroup(result, lexer);
        }
        return result;
    }

    private void parseConceptMap(StructureMap result, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String n;
        lexer.token("conceptmap");
        ConceptMap map = new ConceptMap();
        String id = lexer.readConstant("map id");
        if (!id.startsWith("#")) {
            lexer.error("Concept Map identifier must start with #");
        }
        map.setId(id);
        map.setStatus(Enumerations.PublicationStatus.DRAFT);
        result.getContained().add(map);
        lexer.token("{");
        lexer.skipComments();
        HashMap<String, String> prefixes = new HashMap<String, String>();
        while (lexer.hasToken("prefix")) {
            lexer.token("prefix");
            n = lexer.take();
            lexer.token("=");
            String v = lexer.readConstant("prefix url");
            prefixes.put(n, v);
        }
        while (lexer.hasToken("unmapped")) {
            lexer.token("unmapped");
            lexer.token("for");
            n = this.readPrefix(prefixes, lexer);
            ConceptMap.ConceptMapGroupComponent g = this.getGroup(map, n, null);
            lexer.token("=");
            String v = lexer.take();
            if (v.equals("provided")) {
                g.getUnmapped().setMode(ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED);
                continue;
            }
            lexer.error("Only unmapped mode PROVIDED is supported at this time");
        }
        while (!lexer.hasToken("}")) {
            String srcs = this.readPrefix(prefixes, lexer);
            lexer.token(":");
            String sc = lexer.getCurrent().startsWith("\"") ? lexer.readConstant("code") : lexer.take();
            Enumerations.ConceptMapEquivalence eq = this.readEquivalence(lexer);
            String tgts = eq != Enumerations.ConceptMapEquivalence.UNMATCHED ? this.readPrefix(prefixes, lexer) : "";
            ConceptMap.ConceptMapGroupComponent g = this.getGroup(map, srcs, tgts);
            ConceptMap.SourceElementComponent e = g.addElement();
            e.setCode(sc);
            if (e.getCode().startsWith("\"")) {
                e.setCode(lexer.processConstant(e.getCode()));
            }
            ConceptMap.TargetElementComponent tgt = e.addTarget();
            if (eq != Enumerations.ConceptMapEquivalence.EQUIVALENT) {
                tgt.setEquivalence(eq);
            }
            if (tgt.getEquivalence() != Enumerations.ConceptMapEquivalence.UNMATCHED) {
                lexer.token(":");
                tgt.setCode(lexer.take());
                if (tgt.getCode().startsWith("\"")) {
                    tgt.setCode(lexer.processConstant(tgt.getCode()));
                }
            }
            if (!lexer.hasComment()) continue;
            tgt.setComment(lexer.take().substring(2).trim());
        }
        lexer.token("}");
    }

    private ConceptMap.ConceptMapGroupComponent getGroup(ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || (tgts != null || grp.hasTarget()) && (tgts == null || !tgts.equals(grp.getTarget()))) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }

    private String readPrefix(Map<String, String> prefixes, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String prefix = lexer.take();
        if (!prefixes.containsKey(prefix)) {
            throw lexer.error("Unknown prefix '" + prefix + "'");
        }
        return prefixes.get(prefix);
    }

    private Enumerations.ConceptMapEquivalence readEquivalence(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        String token = lexer.take();
        if (token.equals("-")) {
            return Enumerations.ConceptMapEquivalence.RELATEDTO;
        }
        if (token.equals("=")) {
            return Enumerations.ConceptMapEquivalence.EQUAL;
        }
        if (token.equals("==")) {
            return Enumerations.ConceptMapEquivalence.EQUIVALENT;
        }
        if (token.equals("!=")) {
            return Enumerations.ConceptMapEquivalence.DISJOINT;
        }
        if (token.equals("--")) {
            return Enumerations.ConceptMapEquivalence.UNMATCHED;
        }
        if (token.equals("<=")) {
            return Enumerations.ConceptMapEquivalence.WIDER;
        }
        if (token.equals("<-")) {
            return Enumerations.ConceptMapEquivalence.SUBSUMES;
        }
        if (token.equals(">=")) {
            return Enumerations.ConceptMapEquivalence.NARROWER;
        }
        if (token.equals(">-")) {
            return Enumerations.ConceptMapEquivalence.SPECIALIZES;
        }
        if (token.equals("~")) {
            return Enumerations.ConceptMapEquivalence.INEXACT;
        }
        throw lexer.error("Unknown equivalence token '" + token + "'");
    }

    private void parseUses(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("uses");
        StructureMap.StructureMapStructureComponent st = result.addStructure();
        st.setUrl(lexer.readConstant("url"));
        if (lexer.hasToken("alias")) {
            lexer.token("alias");
            st.setAlias(lexer.take());
        }
        lexer.token("as");
        st.setMode(StructureMap.StructureMapModelMode.fromCode(lexer.take()));
        lexer.skipToken(";");
        if (lexer.hasComment()) {
            st.setDocumentation(lexer.take().substring(2).trim());
        }
        lexer.skipComments();
    }

    private void parseImports(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("imports");
        result.addImport(lexer.readConstant("url"));
        lexer.skipToken(";");
        if (lexer.hasComment()) {
            lexer.next();
        }
        lexer.skipComments();
    }

    private void parseGroup(StructureMap result, FHIRLexer lexer) throws FHIRException {
        lexer.token("group");
        StructureMap.StructureMapGroupComponent group = result.addGroup();
        if (lexer.hasToken("for")) {
            lexer.token("for");
            if ("type".equals(lexer.getCurrent())) {
                lexer.token("type");
                lexer.token("+");
                lexer.token("types");
                group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES);
            } else {
                lexer.token("types");
                group.setTypeMode(StructureMap.StructureMapGroupTypeMode.TYPES);
            }
        } else {
            group.setTypeMode(StructureMap.StructureMapGroupTypeMode.NONE);
        }
        group.setName(lexer.take());
        if (lexer.hasToken("extends")) {
            lexer.next();
            group.setExtends(lexer.take());
        }
        lexer.skipComments();
        while (lexer.hasToken("input")) {
            this.parseInput(group, lexer);
        }
        while (!lexer.hasToken("endgroup")) {
            if (lexer.done()) {
                throw lexer.error("premature termination expecting 'endgroup'");
            }
            this.parseRule(result, group.getRule(), lexer);
        }
        lexer.next();
        lexer.skipComments();
    }

    private void parseInput(StructureMap.StructureMapGroupComponent group, FHIRLexer lexer) throws FHIRException {
        lexer.token("input");
        StructureMap.StructureMapGroupInputComponent input = group.addInput();
        input.setName(lexer.take());
        if (lexer.hasToken(":")) {
            lexer.token(":");
            input.setType(lexer.take());
        }
        lexer.token("as");
        input.setMode(StructureMap.StructureMapInputMode.fromCode(lexer.take()));
        if (lexer.hasComment()) {
            input.setDocumentation(lexer.take().substring(2).trim());
        }
        lexer.skipToken(";");
        lexer.skipComments();
    }

    private void parseRule(StructureMap map, List<StructureMap.StructureMapGroupRuleComponent> list, FHIRLexer lexer) throws FHIRException {
        StructureMap.StructureMapGroupRuleComponent rule = new StructureMap.StructureMapGroupRuleComponent();
        list.add(rule);
        rule.setName(lexer.takeDottedToken());
        lexer.token(":");
        lexer.token("for");
        boolean done = false;
        while (!done) {
            this.parseSource(rule, lexer);
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        if (lexer.hasToken("make")) {
            lexer.token("make");
            done = false;
            while (!done) {
                this.parseTarget(rule, lexer);
                done = !lexer.hasToken(",");
                if (done) continue;
                lexer.next();
            }
        }
        if (lexer.hasToken("then")) {
            lexer.token("then");
            if (lexer.hasToken("{")) {
                lexer.token("{");
                if (lexer.hasComment()) {
                    rule.setDocumentation(lexer.take().substring(2).trim());
                }
                lexer.skipComments();
                while (!lexer.hasToken("}")) {
                    if (lexer.done()) {
                        throw lexer.error("premature termination expecting '}' in nested group");
                    }
                    this.parseRule(map, rule.getRule(), lexer);
                }
                lexer.token("}");
            } else {
                done = false;
                while (!done) {
                    this.parseRuleReference(rule, lexer);
                    done = !lexer.hasToken(",");
                    if (done) continue;
                    lexer.next();
                }
            }
        } else if (lexer.hasComment()) {
            rule.setDocumentation(lexer.take().substring(2).trim());
        }
        if (this.isSimpleSyntax(rule)) {
            rule.getSourceFirstRep().setVariable(AUTO_VAR_NAME);
            rule.getTargetFirstRep().setVariable(AUTO_VAR_NAME);
            rule.getTargetFirstRep().setTransform(StructureMap.StructureMapTransform.CREATE);
        }
        lexer.skipComments();
    }

    private boolean isSimpleSyntax(StructureMap.StructureMapGroupRuleComponent rule) {
        return rule.getSource().size() == 1 && rule.getSourceFirstRep().hasContext() && rule.getSourceFirstRep().hasElement() && !rule.getSourceFirstRep().hasVariable() && rule.getTarget().size() == 1 && rule.getTargetFirstRep().hasContext() && rule.getTargetFirstRep().hasElement() && !rule.getTargetFirstRep().hasVariable() && !rule.getTargetFirstRep().hasParameter() && rule.getDependent().size() == 0 && rule.getRule().size() == 0;
    }

    private void parseRuleReference(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        StructureMap.StructureMapGroupRuleDependentComponent ref = rule.addDependent();
        ref.setName(lexer.take());
        lexer.token("(");
        boolean done = false;
        while (!done) {
            ref.addVariable(lexer.take());
            done = !lexer.hasToken(",");
            if (done) continue;
            lexer.next();
        }
        lexer.token(")");
    }

    private void parseSource(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        StructureMap.StructureMapGroupRuleSourceComponent source = rule.addSource();
        source.setContext(lexer.take());
        if (source.getContext().equals("search") && lexer.hasToken("(")) {
            source.setContext("@search");
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_SEARCH_EXPRESSION, node);
            source.setElement(node.toString());
            lexer.token(")");
        } else if (lexer.hasToken(".")) {
            lexer.token(".");
            source.setElement(lexer.take());
        }
        if (lexer.hasToken(":")) {
            lexer.token(":");
            source.setType(lexer.takeDottedToken());
            if (!lexer.hasToken("as", "first", "last", "not_first", "not_last", "only_one", "default")) {
                source.setMin(lexer.takeInt());
                lexer.token("..");
                source.setMax(lexer.take());
            }
        }
        if (lexer.hasToken("default")) {
            lexer.token("default");
            source.setDefaultValue(new StringType(lexer.readConstant("default value")));
        }
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "not_first", "not_last", "only_one"})) {
            source.setListMode(StructureMap.StructureMapSourceListMode.fromCode(lexer.take()));
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            source.setVariable(lexer.take());
        }
        if (lexer.hasToken("where")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_EXPRESSION, node);
            source.setCondition(node.toString());
        }
        if (lexer.hasToken("check")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_CHECK, node);
            source.setCheck(node.toString());
        }
        if (lexer.hasToken("log")) {
            lexer.take();
            node = this.fpe.parse(lexer);
            source.setUserData(MAP_WHERE_CHECK, node);
            source.setLogMessage(node.toString());
        }
    }

    private void parseTarget(StructureMap.StructureMapGroupRuleComponent rule, FHIRLexer lexer) throws FHIRException {
        ExpressionNode node;
        String name;
        StructureMap.StructureMapGroupRuleTargetComponent target = rule.addTarget();
        String start = lexer.take();
        if (lexer.hasToken(".")) {
            target.setContext(start);
            target.setContextType(StructureMap.StructureMapContextType.VARIABLE);
            start = null;
            lexer.token(".");
            target.setElement(lexer.take());
        }
        boolean isConstant = false;
        if (lexer.hasToken("=")) {
            if (start != null) {
                target.setContext(start);
            }
            lexer.token("=");
            isConstant = lexer.isConstant(true);
            name = lexer.take();
        } else {
            name = start;
        }
        if ("(".equals(name)) {
            target.setTransform(StructureMap.StructureMapTransform.EVALUATE);
            node = this.fpe.parse(lexer);
            target.setUserData(MAP_EXPRESSION, node);
            target.addParameter().setValue(new StringType(node.toString()));
            lexer.token(")");
        } else if (lexer.hasToken("(")) {
            target.setTransform(StructureMap.StructureMapTransform.fromCode(name));
            lexer.token("(");
            if (target.getTransform() == StructureMap.StructureMapTransform.EVALUATE) {
                this.parseParameter(target, lexer);
                lexer.token(",");
                node = this.fpe.parse(lexer);
                target.setUserData(MAP_EXPRESSION, node);
                target.addParameter().setValue(new StringType(node.toString()));
            } else {
                while (!lexer.hasToken(")")) {
                    this.parseParameter(target, lexer);
                    if (lexer.hasToken(")")) continue;
                    lexer.token(",");
                }
            }
            lexer.token(")");
        } else if (name != null) {
            target.setTransform(StructureMap.StructureMapTransform.COPY);
            if (!isConstant) {
                String id = name;
                while (lexer.hasToken(".")) {
                    id = id + lexer.take() + lexer.take();
                }
                target.addParameter().setValue(new IdType(id));
            } else {
                target.addParameter().setValue(this.readConstant(name, lexer));
            }
        }
        if (lexer.hasToken("as")) {
            lexer.take();
            target.setVariable(lexer.take());
        }
        while (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"first", "last", "share", "collate"})) {
            if (lexer.getCurrent().equals("share")) {
                target.addListMode(StructureMap.StructureMapTargetListMode.SHARE);
                lexer.next();
                target.setListRuleId(lexer.take());
            } else if (lexer.getCurrent().equals("first")) {
                target.addListMode(StructureMap.StructureMapTargetListMode.FIRST);
            } else {
                target.addListMode(StructureMap.StructureMapTargetListMode.LAST);
            }
            lexer.next();
        }
    }

    private void parseParameter(StructureMap.StructureMapGroupRuleTargetComponent target, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException, FHIRFormatError {
        if (!lexer.isConstant(true)) {
            target.addParameter().setValue(new IdType(lexer.take()));
        } else if (lexer.isStringConstant()) {
            target.addParameter().setValue(new StringType(lexer.readConstant("??")));
        } else {
            target.addParameter().setValue(this.readConstant(lexer.take(), lexer));
        }
    }

    private Type readConstant(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (Utilities.isInteger((String)s)) {
            return new IntegerType(s);
        }
        if (Utilities.isDecimal((String)s)) {
            return new DecimalType(s);
        }
        if (Utilities.existsInList((String)s, (String[])new String[]{"true", "false"})) {
            return new BooleanType(s.equals("true"));
        }
        return new StringType(lexer.processConstant(s));
    }

    public StructureDefinition getTargetType(StructureMap map) throws FHIRException {
        boolean found = false;
        StructureDefinition res = null;
        for (StructureMap.StructureMapStructureComponent uses : map.getStructure()) {
            if (uses.getMode() != StructureMap.StructureMapModelMode.TARGET) continue;
            if (found) {
                throw new FHIRException("Multiple targets found in map " + map.getUrl());
            }
            found = true;
            res = this.worker.fetchResource(StructureDefinition.class, uses.getUrl());
            if (res != null) continue;
            throw new FHIRException("Unable to find " + uses.getUrl() + " referenced from map " + map.getUrl());
        }
        if (res == null) {
            throw new FHIRException("No targets found in map " + map.getUrl());
        }
        return res;
    }

    private void log(String cnt) {
        if (this.services != null) {
            this.services.log(cnt);
        }
    }

    protected void getChildrenByName(Base item, String name, List<Base> result) throws FHIRException {
        for (Base v : item.listChildrenByName(name, true)) {
            if (v == null) continue;
            result.add(v);
        }
    }

    public void transform(Object appInfo, Base source, StructureMap map, Base target) throws FHIRException {
        TransformContext context = new TransformContext(appInfo);
        this.log("Start Transform " + map.getUrl());
        StructureMap.StructureMapGroupComponent g = map.getGroup().get(0);
        Variables vars = new Variables();
        vars.add(VariableMode.INPUT, this.getInputName(g, StructureMap.StructureMapInputMode.SOURCE, "source"), source);
        vars.add(VariableMode.OUTPUT, this.getInputName(g, StructureMap.StructureMapInputMode.TARGET, "target"), target);
        this.executeGroup("", context, map, vars, g, true);
        if (target instanceof Element) {
            ((Element)target).sort();
        }
    }

    private String getInputName(StructureMap.StructureMapGroupComponent g, StructureMap.StructureMapInputMode mode, String def) throws DefinitionException {
        String name = null;
        for (StructureMap.StructureMapGroupInputComponent inp : g.getInput()) {
            if (inp.getMode() != mode) continue;
            if (name != null) {
                throw new DefinitionException("This engine does not support multiple source inputs");
            }
            name = inp.getName();
        }
        return name == null ? def : name;
    }

    private void executeGroup(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group, boolean atRoot) throws FHIRException {
        this.log(indent + "Group : " + group.getName());
        if (group.hasExtends()) {
            ResolvedGroup rg = this.resolveGroupReference(map, group, group.getExtends());
            this.executeGroup(indent + " ", context, rg.targetMap, vars, rg.target, false);
        }
        for (StructureMap.StructureMapGroupRuleComponent r : group.getRule()) {
            this.executeRule(indent + "  ", context, map, vars, group, r, atRoot);
        }
    }

    private void executeRule(String indent, TransformContext context, StructureMap map, Variables vars, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleComponent rule, boolean atRoot) throws FHIRException {
        this.log(indent + "rule : " + rule.getName());
        if (rule.getName().contains("CarePlan.participant-unlink")) {
            System.out.println("debug");
        }
        Variables srcVars = vars.copy();
        if (rule.getSource().size() != 1) {
            throw new FHIRException("Rule \"" + rule.getName() + "\": not handled yet");
        }
        List<Variables> source = this.processSource(rule.getName(), context, srcVars, rule.getSource().get(0), map.getUrl());
        if (source != null) {
            for (Variables v : source) {
                for (StructureMap.StructureMapGroupRuleTargetComponent t : rule.getTarget()) {
                    this.processTarget(rule.getName(), context, v, map, group, t, rule.getSource().size() == 1 ? rule.getSourceFirstRep().getVariable() : null, atRoot);
                }
                if (rule.hasRule()) {
                    for (StructureMap.StructureMapGroupRuleComponent childrule : rule.getRule()) {
                        this.executeRule(indent + "  ", context, map, v, group, childrule, false);
                    }
                    continue;
                }
                if (rule.hasDependent()) {
                    for (StructureMap.StructureMapGroupRuleDependentComponent dependent : rule.getDependent()) {
                        this.executeDependency(indent + "  ", context, map, v, group, dependent);
                    }
                    continue;
                }
                if (rule.getSource().size() != 1 || !rule.getSourceFirstRep().hasVariable() || rule.getTarget().size() != 1 || !rule.getTargetFirstRep().hasVariable() || rule.getTargetFirstRep().getTransform() != StructureMap.StructureMapTransform.CREATE || rule.getTargetFirstRep().hasParameter()) continue;
                Base src = v.get(VariableMode.INPUT, rule.getSourceFirstRep().getVariable());
                Base tgt = v.get(VariableMode.OUTPUT, rule.getTargetFirstRep().getVariable());
                String srcType = src.fhirType();
                String tgtType = tgt.fhirType();
                ResolvedGroup defGroup = this.resolveGroupByTypes(map, rule.getName(), group, srcType, tgtType);
                Variables vdef = new Variables();
                vdef.add(VariableMode.INPUT, defGroup.target.getInput().get(0).getName(), src);
                vdef.add(VariableMode.OUTPUT, defGroup.target.getInput().get(1).getName(), tgt);
                this.executeGroup(indent + "  ", context, defGroup.targetMap, vdef, defGroup.target, false);
            }
        }
    }

    private void executeDependency(String indent, TransformContext context, StructureMap map, Variables vin, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleDependentComponent dependent) throws FHIRException {
        ResolvedGroup rg = this.resolveGroupReference(map, group, dependent.getName());
        if (rg.target.getInput().size() != dependent.getVariable().size()) {
            throw new FHIRException("Rule '" + dependent.getName() + "' has " + Integer.toString(rg.target.getInput().size()) + " but the invocation has " + Integer.toString(dependent.getVariable().size()) + " variables");
        }
        Variables v = new Variables();
        for (int i = 0; i < rg.target.getInput().size(); ++i) {
            StructureMap.StructureMapGroupInputComponent input = rg.target.getInput().get(i);
            StringType rdp = dependent.getVariable().get(i);
            String var = rdp.asStringValue();
            VariableMode mode = input.getMode() == StructureMap.StructureMapInputMode.SOURCE ? VariableMode.INPUT : VariableMode.OUTPUT;
            Base vv = vin.get(mode, var);
            if (vv == null && mode == VariableMode.INPUT) {
                vv = vin.get(VariableMode.OUTPUT, var);
            }
            if (vv == null) {
                throw new FHIRException("Rule '" + dependent.getName() + "' " + mode.toString() + " variable '" + input.getName() + "' named as '" + var + "' has no value");
            }
            v.add(mode, input.getName(), vv);
        }
        this.executeGroup(indent + "  ", context, rg.targetMap, v, rg.target, false);
    }

    private String determineTypeFromSourceType(StructureMap map, StructureMap.StructureMapGroupComponent source, Base base, String[] types) throws FHIRException {
        Object result;
        String type = base.fhirType();
        String kn = "type^" + type;
        if (source.hasUserData(kn)) {
            return source.getUserString(kn);
        }
        ResolvedGroup res = new ResolvedGroup();
        res.targetMap = null;
        res.target = null;
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : map.getGroup()) {
            if (!this.matchesByType(map, structureMapGroupComponent, type)) continue;
            if (res.targetMap == null) {
                res.targetMap = map;
                res.target = structureMapGroupComponent;
                continue;
            }
            throw new FHIRException("Multiple possible matches looking for default rule for '" + type + "'");
        }
        if (res.targetMap != null) {
            result = this.getActualType(res.targetMap, res.target.getInput().get(1).getType());
            source.setUserData(kn, result);
            return result;
        }
        for (UriType uriType : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)uriType.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)uriType.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!this.matchesByType(impMap, grp, type)) continue;
                    if (res.targetMap == null) {
                        res.targetMap = impMap;
                        res.target = grp;
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for default rule for '" + type + "' in " + res.targetMap.getUrl() + " (" + res.target.getName() + ") and " + impMap.getUrl() + " (" + grp.getName() + ")");
                }
            }
        }
        if (res.target == null) {
            throw new FHIRException("No matches found for default rule for '" + type + "' from " + map.getUrl());
        }
        result = this.getActualType(res.targetMap, res.target.getInput().get(1).getType());
        source.setUserData(kn, result);
        return result;
    }

    private List<StructureMap> findMatchingMaps(String value) {
        ArrayList<StructureMap> res = new ArrayList<StructureMap>();
        if (value.contains("*")) {
            for (StructureMap sm : this.worker.listTransforms()) {
                if (!this.urlMatches(value, sm.getUrl())) continue;
                res.add(sm);
            }
        } else {
            StructureMap sm = this.worker.getTransform(value);
            if (sm != null) {
                res.add(sm);
            }
        }
        HashSet<String> check = new HashSet<String>();
        for (StructureMap sm : res) {
            if (check.contains(sm.getUrl())) {
                throw new Error("duplicate");
            }
            check.add(sm.getUrl());
        }
        return res;
    }

    private boolean urlMatches(String mask, String url) {
        return url.length() > mask.length() && url.startsWith(mask.substring(0, mask.indexOf("*"))) && url.endsWith(mask.substring(mask.indexOf("*") + 1));
    }

    private ResolvedGroup resolveGroupByTypes(StructureMap map, String ruleid, StructureMap.StructureMapGroupComponent source, String srcType, String tgtType) throws FHIRException {
        String kn = "types^" + srcType + ":" + tgtType;
        if (source.hasUserData(kn)) {
            return (ResolvedGroup)source.getUserData(kn);
        }
        ResolvedGroup res = new ResolvedGroup();
        res.targetMap = null;
        res.target = null;
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : map.getGroup()) {
            if (!this.matchesByType(map, structureMapGroupComponent, srcType, tgtType)) continue;
            if (res.targetMap == null) {
                res.targetMap = map;
                res.target = structureMapGroupComponent;
                continue;
            }
            throw new FHIRException("Multiple possible matches looking for rule for '" + srcType + "/" + tgtType + "', from rule '" + ruleid + "'");
        }
        if (res.targetMap != null) {
            source.setUserData(kn, res);
            return res;
        }
        for (UriType uriType : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)uriType.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)uriType.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!this.matchesByType(impMap, grp, srcType, tgtType)) continue;
                    if (res.targetMap == null) {
                        res.targetMap = impMap;
                        res.target = grp;
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for rule for '" + srcType + "/" + tgtType + "' in " + res.targetMap.getUrl() + " and " + impMap.getUrl() + ", from rule '" + ruleid + "'");
                }
            }
        }
        if (res.target == null) {
            throw new FHIRException("No matches found for rule for '" + srcType + " to " + tgtType + "' from " + map.getUrl() + ", from rule '" + ruleid + "'");
        }
        source.setUserData(kn, res);
        return res;
    }

    private boolean matchesByType(StructureMap map, StructureMap.StructureMapGroupComponent grp, String type) throws FHIRException {
        if (grp.getTypeMode() != StructureMap.StructureMapGroupTypeMode.TYPEANDTYPES) {
            return false;
        }
        if (grp.getInput().size() != 2 || grp.getInput().get(0).getMode() != StructureMap.StructureMapInputMode.SOURCE || grp.getInput().get(1).getMode() != StructureMap.StructureMapInputMode.TARGET) {
            return false;
        }
        return this.matchesType(map, type, grp.getInput().get(0).getType());
    }

    private boolean matchesByType(StructureMap map, StructureMap.StructureMapGroupComponent grp, String srcType, String tgtType) throws FHIRException {
        if (grp.getTypeMode() == StructureMap.StructureMapGroupTypeMode.NONE) {
            return false;
        }
        if (grp.getInput().size() != 2 || grp.getInput().get(0).getMode() != StructureMap.StructureMapInputMode.SOURCE || grp.getInput().get(1).getMode() != StructureMap.StructureMapInputMode.TARGET) {
            return false;
        }
        if (!grp.getInput().get(0).hasType() || !grp.getInput().get(1).hasType()) {
            return false;
        }
        return this.matchesType(map, srcType, grp.getInput().get(0).getType()) && this.matchesType(map, tgtType, grp.getInput().get(1).getType());
    }

    private boolean matchesType(StructureMap map, String actualType, String statedType) throws FHIRException {
        StructureDefinition sd;
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if (!imp.hasAlias() || !statedType.equals(imp.getAlias())) continue;
            StructureDefinition sd2 = this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd2 == null) break;
            statedType = sd2.getType();
            break;
        }
        if (Utilities.isAbsoluteUrl((String)actualType) && (sd = this.worker.fetchResource(StructureDefinition.class, actualType)) != null) {
            actualType = sd.getType();
        }
        if (Utilities.isAbsoluteUrl((String)statedType) && (sd = this.worker.fetchResource(StructureDefinition.class, statedType)) != null) {
            statedType = sd.getType();
        }
        return actualType.equals(statedType);
    }

    private String getActualType(StructureMap map, String statedType) throws FHIRException {
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if (!imp.hasAlias() || !statedType.equals(imp.getAlias())) continue;
            StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd == null) {
                throw new FHIRException("Unable to resolve structure " + imp.getUrl());
            }
            return sd.getId();
        }
        return statedType;
    }

    private ResolvedGroup resolveGroupReference(StructureMap map, StructureMap.StructureMapGroupComponent source, String name) throws FHIRException {
        String kn = "ref^" + name;
        if (source.hasUserData(kn)) {
            return (ResolvedGroup)source.getUserData(kn);
        }
        ResolvedGroup res = new ResolvedGroup();
        res.targetMap = null;
        res.target = null;
        for (StructureMap.StructureMapGroupComponent structureMapGroupComponent : map.getGroup()) {
            if (!structureMapGroupComponent.getName().equals(name)) continue;
            if (res.targetMap == null) {
                res.targetMap = map;
                res.target = structureMapGroupComponent;
                continue;
            }
            throw new FHIRException("Multiple possible matches for rule '" + name + "'");
        }
        if (res.targetMap != null) {
            source.setUserData(kn, res);
            return res;
        }
        for (UriType uriType : map.getImport()) {
            List<StructureMap> impMapList = this.findMatchingMaps((String)uriType.getValue());
            if (impMapList.size() == 0) {
                throw new FHIRException("Unable to find map(s) for " + (String)uriType.getValue());
            }
            for (StructureMap impMap : impMapList) {
                if (impMap.getUrl().equals(map.getUrl())) continue;
                for (StructureMap.StructureMapGroupComponent grp : impMap.getGroup()) {
                    if (!grp.getName().equals(name)) continue;
                    if (res.targetMap == null) {
                        res.targetMap = impMap;
                        res.target = grp;
                        continue;
                    }
                    throw new FHIRException("Multiple possible matches for rule '" + name + "' in " + res.targetMap.getUrl() + " and " + impMap.getUrl());
                }
            }
        }
        if (res.target == null) {
            throw new FHIRException("No matches found for rule '" + name + "'. Reference found in " + map.getUrl());
        }
        source.setUserData(kn, res);
        return res;
    }

    private List<Variables> processSource(String ruleId, TransformContext context, Variables vars, StructureMap.StructureMapGroupRuleSourceComponent src, String pathForErrors) throws FHIRException {
        ArrayList<Base> remove;
        List<Base> items;
        ExpressionNode expr;
        if (src.getContext().equals("@search")) {
            expr = (ExpressionNode)src.getUserData(MAP_SEARCH_EXPRESSION);
            if (expr == null) {
                expr = this.fpe.parse(src.getElement());
                src.setUserData(MAP_SEARCH_EXPRESSION, expr);
            }
            String search = this.fpe.evaluateToString(vars, null, new StringType(), expr);
            items = this.services.performSearch(context.appInfo, search);
        } else {
            items = new ArrayList<Base>();
            Base b = vars.get(VariableMode.INPUT, src.getContext());
            if (b == null) {
                throw new FHIRException("Unknown input variable " + src.getContext() + " in " + pathForErrors + " rule " + ruleId + " (vars = " + vars.summary() + ")");
            }
            if (!src.hasElement()) {
                items.add(b);
            } else {
                this.getChildrenByName(b, src.getElement(), items);
                if (items.size() == 0 && src.hasDefaultValue()) {
                    items.add(src.getDefaultValue());
                }
            }
        }
        if (src.hasType()) {
            ArrayList<Base> remove2 = new ArrayList<Base>();
            for (Base base : items) {
                if (base == null || this.isType(base, src.getType())) continue;
                remove2.add(base);
            }
            items.removeAll(remove2);
        }
        if (src.hasCondition()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_EXPRESSION);
            if (expr == null) {
                expr = this.fpe.parse(src.getCondition());
                src.setUserData(MAP_WHERE_EXPRESSION, expr);
            }
            remove = new ArrayList<Base>();
            for (Base item : items) {
                if (this.fpe.evaluateToBoolean(vars, null, item, expr)) continue;
                remove.add(item);
            }
            items.removeAll(remove);
        }
        if (src.hasCheck()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_CHECK);
            if (expr == null) {
                expr = this.fpe.parse(src.getCheck());
                src.setUserData(MAP_WHERE_CHECK, expr);
            }
            remove = new ArrayList();
            for (Base item : items) {
                if (this.fpe.evaluateToBoolean(vars, null, item, expr)) continue;
                throw new FHIRException("Rule \"" + ruleId + "\": Check condition failed");
            }
        }
        if (src.hasLogMessage()) {
            expr = (ExpressionNode)src.getUserData(MAP_WHERE_LOG);
            if (expr == null) {
                expr = this.fpe.parse(src.getLogMessage());
                src.setUserData(MAP_WHERE_LOG, expr);
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (Base item : items) {
                b.appendIfNotNull(this.fpe.evaluateToString(vars, null, item, expr));
            }
            if (b.length() > 0) {
                this.services.log(b.toString());
            }
        }
        if (src.hasListMode() && !items.isEmpty()) {
            switch (src.getListMode()) {
                case FIRST: {
                    Base bt = items.get(0);
                    items.clear();
                    items.add(bt);
                    break;
                }
                case NOTFIRST: {
                    if (items.size() <= 0) break;
                    items.remove(0);
                    break;
                }
                case LAST: {
                    Base bt = items.get(items.size() - 1);
                    items.clear();
                    items.add(bt);
                    break;
                }
                case NOTLAST: {
                    if (items.size() <= 0) break;
                    items.remove(items.size() - 1);
                    break;
                }
                case ONLYONE: {
                    if (items.size() <= 1) break;
                    throw new FHIRException("Rule \"" + ruleId + "\": Check condition failed: the collection has more than one item");
                }
            }
        }
        ArrayList<Variables> result = new ArrayList<Variables>();
        for (Base base : items) {
            Variables v = vars.copy();
            if (src.hasVariable()) {
                v.add(VariableMode.INPUT, src.getVariable(), base);
            }
            result.add(v);
        }
        return result;
    }

    private boolean isType(Base item, String type) {
        return type.equals(item.fhirType());
    }

    private void processTarget(String ruleId, TransformContext context, Variables vars, StructureMap map, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleTargetComponent tgt, String srcVar, boolean atRoot) throws FHIRException {
        Base dest = null;
        if (tgt.hasContext()) {
            dest = vars.get(VariableMode.OUTPUT, tgt.getContext());
            if (dest == null) {
                throw new FHIRException("Rule \"" + ruleId + "\": target context not known: " + tgt.getContext());
            }
            if (!tgt.hasElement()) {
                throw new FHIRException("Rule \"" + ruleId + "\": Not supported yet");
            }
        }
        Base v = null;
        if (tgt.hasTransform()) {
            v = this.runTransform(ruleId, context, map, group, tgt, vars, dest, tgt.getElement(), srcVar, atRoot);
            if (v != null && dest != null) {
                v = dest.setProperty(tgt.getElement().hashCode(), tgt.getElement(), v);
            }
        } else if (dest != null) {
            v = dest.makeProperty(tgt.getElement().hashCode(), tgt.getElement());
        }
        if (tgt.hasVariable() && v != null) {
            vars.add(VariableMode.OUTPUT, tgt.getVariable(), v);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Base runTransform(String ruleId, TransformContext context, StructureMap map, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleTargetComponent tgt, Variables vars, Base dest, String element, String srcVar, boolean root) throws FHIRException {
        try {
            switch (tgt.getTransform()) {
                case CREATE: {
                    Base res;
                    Object tn;
                    if (tgt.getParameter().isEmpty()) {
                        String[] types = dest.getTypesForProperty(element.hashCode(), element);
                        if (types.length == 1 && !"*".equals(types[0]) && !((String)types[0]).equals("Resource")) {
                            tn = types[0];
                        } else {
                            if (srcVar == null) throw new Error("Cannot determine type implicitly because there is no single input variable");
                            tn = this.determineTypeFromSourceType(map, group, vars.get(VariableMode.INPUT, srcVar), types);
                        }
                    } else {
                        tn = this.getParamStringNoNull(vars, tgt.getParameter().get(0), tgt.toString());
                        for (StructureMap.StructureMapStructureComponent uses : map.getStructure()) {
                            if (uses.getMode() != StructureMap.StructureMapModelMode.TARGET || !uses.hasAlias() || !((String)tn).equals(uses.getAlias())) continue;
                            tn = uses.getUrl();
                            break;
                        }
                    }
                    Base base = res = this.services != null ? this.services.createType(context.getAppInfo(), (String)tn) : ResourceFactory.createResourceOrType((String)tn);
                    if (res.isResource() && !res.fhirType().equals("Parameters") && this.services != null) {
                        res = this.services.createResource(context.getAppInfo(), res, root);
                    }
                    if (!tgt.hasUserData("profile")) return res;
                    res.setUserData("profile", tgt.getUserData("profile"));
                    return res;
                }
                case COPY: {
                    return this.getParam(vars, tgt.getParameter().get(0));
                }
                case EVALUATE: {
                    List<Base> v;
                    ExpressionNode expr = (ExpressionNode)tgt.getUserData(MAP_EXPRESSION);
                    if (expr == null) {
                        expr = this.fpe.parse(this.getParamStringNoNull(vars, tgt.getParameter().get(1), tgt.toString()));
                        tgt.setUserData(MAP_WHERE_EXPRESSION, expr);
                    }
                    if ((v = this.fpe.evaluate((Object)vars, null, tgt.getParameter().size() == 2 ? this.getParam(vars, tgt.getParameter().get(0)) : new BooleanType(false), expr)).size() == 0) {
                        return null;
                    }
                    if (v.size() == 1) return v.get(0);
                    throw new FHIRException("Rule \"" + ruleId + "\": Evaluation of " + expr.toString() + " returned " + Integer.toString(v.size()) + " objects");
                }
                case TRUNCATE: {
                    String src = this.getParamString(vars, tgt.getParameter().get(0));
                    String len = this.getParamStringNoNull(vars, tgt.getParameter().get(1), tgt.toString());
                    if (!Utilities.isInteger((String)len)) return new StringType(src);
                    int l = Integer.parseInt(len);
                    if (src.length() <= l) return new StringType(src);
                    src = src.substring(0, l);
                    return new StringType(src);
                }
                case ESCAPE: {
                    throw new Error("Rule \"" + ruleId + "\": Transform " + tgt.getTransform().toCode() + " not supported yet");
                }
                case CAST: {
                    String src = this.getParamString(vars, tgt.getParameter().get(0));
                    if (tgt.getParameter().size() == 1) {
                        throw new FHIRException("Implicit type parameters on cast not yet supported");
                    }
                    String t = this.getParamString(vars, tgt.getParameter().get(1));
                    if (!t.equals("string")) throw new FHIRException("cast to " + t + " not yet supported");
                    return new StringType(src);
                }
                case APPEND: {
                    StringBuilder sb = new StringBuilder(this.getParamString(vars, tgt.getParameter().get(0)));
                    int i = 1;
                    while (i < tgt.getParameter().size()) {
                        sb.append(this.getParamString(vars, tgt.getParameter().get(1)));
                        ++i;
                    }
                    return new StringType(sb.toString());
                }
                case TRANSLATE: {
                    return this.translate(context, map, vars, tgt.getParameter());
                }
                case REFERENCE: {
                    Base b = this.getParam(vars, tgt.getParameter().get(0));
                    if (b == null) {
                        throw new FHIRException("Rule \"" + ruleId + "\": Unable to find parameter " + ((IdType)tgt.getParameter().get(0).getValue()).asStringValue());
                    }
                    if (!b.isResource()) {
                        throw new FHIRException("Rule \"" + ruleId + "\": Transform engine cannot point at an element of type " + b.fhirType());
                    }
                    String id = b.getIdBase();
                    if (id != null) return new Reference().setReference(b.fhirType() + "/" + id);
                    id = UUID.randomUUID().toString().toLowerCase();
                    b.setIdBase(id);
                    return new Reference().setReference(b.fhirType() + "/" + id);
                }
                case DATEOP: {
                    throw new Error("Rule \"" + ruleId + "\": Transform " + tgt.getTransform().toCode() + " not supported yet");
                }
                case UUID: {
                    return new IdType(UUID.randomUUID().toString());
                }
                case POINTER: {
                    Base b = this.getParam(vars, tgt.getParameter().get(0));
                    if (!(b instanceof Resource)) throw new FHIRException("Rule \"" + ruleId + "\": Transform engine cannot point at an element of type " + b.fhirType());
                    return new UriType("urn:uuid:" + ((Resource)b).getId());
                }
                case CC: {
                    CodeableConcept cc = new CodeableConcept();
                    cc.addCoding(this.buildCoding(this.getParamStringNoNull(vars, tgt.getParameter().get(0), tgt.toString()), this.getParamStringNoNull(vars, tgt.getParameter().get(1), tgt.toString())));
                    return cc;
                }
                case C: {
                    return this.buildCoding(this.getParamStringNoNull(vars, tgt.getParameter().get(0), tgt.toString()), this.getParamStringNoNull(vars, tgt.getParameter().get(1), tgt.toString()));
                }
            }
            throw new Error("Rule \"" + ruleId + "\": Transform Unknown: " + tgt.getTransform().toCode());
        }
        catch (Exception e) {
            throw new FHIRException("Exception executing transform " + tgt.toString() + " on Rule \"" + ruleId + "\": " + e.getMessage(), (Throwable)e);
        }
    }

    private Coding buildCoding(String uri, String code) throws FHIRException {
        IWorkerContext.ValidationResult vr;
        ValueSet vs;
        String system = null;
        String display = null;
        ValueSet valueSet = vs = Utilities.noString((String)uri) ? null : this.worker.fetchResourceWithException(ValueSet.class, uri);
        if (vs != null) {
            ValueSetExpander.ValueSetExpansionOutcome vse = this.worker.expandVS(vs, true, false);
            if (vse.getError() != null) {
                throw new FHIRException(vse.getError());
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            for (ValueSet.ValueSetExpansionContainsComponent t : vse.getValueset().getExpansion().getContains()) {
                if (t.hasCode()) {
                    b.append(t.getCode());
                }
                if (code.equals(t.getCode()) && t.hasSystem()) {
                    system = t.getSystem();
                    display = t.getDisplay();
                    break;
                }
                if (!code.equalsIgnoreCase(t.getDisplay()) || !t.hasSystem()) continue;
                system = t.getSystem();
                display = t.getDisplay();
                break;
            }
            if (system == null) {
                throw new FHIRException("The code '" + code + "' is not in the value set '" + uri + "' (valid codes: " + b.toString() + "; also checked displays)");
            }
        } else {
            system = uri;
        }
        if ((vr = this.worker.validateCode(system, code, null)) != null && vr.getDisplay() != null) {
            display = vr.getDisplay();
        }
        return new Coding().setSystem(system).setCode(code).setDisplay(display);
    }

    private String getParamStringNoNull(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter, String message) throws FHIRException {
        Base b = this.getParam(vars, parameter);
        if (b == null) {
            throw new FHIRException("Unable to find a value for " + parameter.toString() + ". Context: " + message);
        }
        if (!b.hasPrimitiveValue()) {
            throw new FHIRException("Found a value for " + parameter.toString() + ", but it has a type of " + b.fhirType() + " and cannot be treated as a string. Context: " + message);
        }
        return b.primitiveValue();
    }

    private String getParamString(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        Base b = this.getParam(vars, parameter);
        if (b == null || !b.hasPrimitiveValue()) {
            return null;
        }
        return b.primitiveValue();
    }

    private Base getParam(Variables vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        Type p = parameter.getValue();
        if (!(p instanceof IdType)) {
            return p;
        }
        String n = ((IdType)p).asStringValue();
        Base b = vars.get(VariableMode.INPUT, n);
        if (b == null) {
            b = vars.get(VariableMode.OUTPUT, n);
        }
        if (b == null) {
            throw new DefinitionException("Variable " + n + " not found (" + vars.summary() + ")");
        }
        return b;
    }

    private Base translate(TransformContext context, StructureMap map, Variables vars, List<StructureMap.StructureMapGroupRuleTargetParameterComponent> parameter) throws FHIRException {
        Base src = this.getParam(vars, parameter.get(0));
        String id = this.getParamString(vars, parameter.get(1));
        String fld = parameter.size() > 2 ? this.getParamString(vars, parameter.get(2)) : null;
        return this.translate(context, map, src, id, fld);
    }

    public Base translate(TransformContext context, StructureMap map, Base source, String conceptMapUrl, String fieldToReturn) throws FHIRException {
        Base[] b;
        Coding src = new Coding();
        if (source.isPrimitive()) {
            src.setCode(source.primitiveValue());
        } else if ("Coding".equals(source.fhirType())) {
            b = source.getProperty("system".hashCode(), "system", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else if ("CE".equals(source.fhirType())) {
            b = source.getProperty("codeSystem".hashCode(), "codeSystem", true);
            if (b.length == 1) {
                src.setSystem(b[0].primitiveValue());
            }
            if ((b = source.getProperty("code".hashCode(), "code", true)).length == 1) {
                src.setCode(b[0].primitiveValue());
            }
        } else {
            throw new FHIRException("Unable to translate source " + source.fhirType());
        }
        String su = conceptMapUrl;
        if (conceptMapUrl.equals("http://hl7.org/fhir/ConceptMap/special-oid2uri")) {
            String uri = this.worker.oid2Uri(src.getCode());
            if (uri == null) {
                uri = "urn:oid:" + src.getCode();
            }
            if ("uri".equals(fieldToReturn)) {
                return new UriType(uri);
            }
            throw new FHIRException("Error in return code");
        }
        ConceptMap cmap = null;
        if (conceptMapUrl.startsWith("#")) {
            for (Resource r : map.getContained()) {
                if (!(r instanceof ConceptMap) || !((ConceptMap)r).getId().equals(conceptMapUrl.substring(1))) continue;
                cmap = (ConceptMap)r;
                su = map.getUrl() + conceptMapUrl;
            }
            if (cmap == null) {
                throw new FHIRException("Unable to translate - cannot find map " + conceptMapUrl);
            }
        } else {
            cmap = this.worker.fetchResource(ConceptMap.class, conceptMapUrl);
        }
        Coding outcome = null;
        boolean done = false;
        String message = null;
        if (cmap == null) {
            if (this.services == null) {
                message = "No map found for " + conceptMapUrl;
            } else {
                outcome = this.services.translate(context.appInfo, src, conceptMapUrl);
                done = true;
            }
        } else {
            ArrayList<SourceElementComponentWrapper> list = new ArrayList<SourceElementComponentWrapper>();
            for (ConceptMap.ConceptMapGroupComponent g : cmap.getGroup()) {
                for (ConceptMap.SourceElementComponent e : g.getElement()) {
                    if (!src.hasSystem() && src.getCode().equals(e.getCode())) {
                        list.add(new SourceElementComponentWrapper(g, e));
                        continue;
                    }
                    if (!src.hasSystem() || !src.getSystem().equals(g.getSource()) || !src.getCode().equals(e.getCode())) continue;
                    list.add(new SourceElementComponentWrapper(g, e));
                }
            }
            if (list.size() == 0) {
                done = true;
            } else if (((SourceElementComponentWrapper)list.get(0)).comp.getTarget().size() == 0) {
                message = "Concept map " + su + " found no translation for " + src.getCode();
            } else {
                for (ConceptMap.TargetElementComponent tgt : ((SourceElementComponentWrapper)list.get(0)).comp.getTarget()) {
                    if (tgt.getEquivalence() == null || EnumSet.of(Enumerations.ConceptMapEquivalence.EQUAL, Enumerations.ConceptMapEquivalence.RELATEDTO, Enumerations.ConceptMapEquivalence.EQUIVALENT, Enumerations.ConceptMapEquivalence.WIDER).contains((Object)tgt.getEquivalence())) {
                        if (done) {
                            message = "Concept map " + su + " found multiple matches for " + src.getCode();
                            done = false;
                            continue;
                        }
                        done = true;
                        outcome = new Coding().setCode(tgt.getCode()).setSystem(((SourceElementComponentWrapper)list.get(0)).group.getTarget());
                        continue;
                    }
                    if (tgt.getEquivalence() != Enumerations.ConceptMapEquivalence.UNMATCHED) continue;
                    done = true;
                }
                if (!done) {
                    message = "Concept map " + su + " found no usable translation for " + src.getCode();
                }
            }
        }
        if (!done) {
            throw new FHIRException(message);
        }
        if (outcome == null) {
            return null;
        }
        if ("code".equals(fieldToReturn)) {
            return new CodeType(outcome.getCode());
        }
        return outcome;
    }

    public StructureMapAnalysis analyse(Object appInfo, StructureMap map) throws Exception {
        this.ids.clear();
        StructureMapAnalysis result = new StructureMapAnalysis();
        TransformContext context = new TransformContext(appInfo);
        VariablesForProfiling vars = new VariablesForProfiling(false, false);
        StructureMap.StructureMapGroupComponent start = map.getGroup().get(0);
        for (StructureMap.StructureMapGroupInputComponent t : start.getInput()) {
            PropertyWithType ti = this.resolveType(map, t.getType(), t.getMode());
            if (t.getMode() == StructureMap.StructureMapInputMode.SOURCE) {
                vars.add(VariableMode.INPUT, t.getName(), ti);
                continue;
            }
            vars.add(VariableMode.OUTPUT, t.getName(), this.createProfile(map, result.profiles, ti, start.getName(), start));
        }
        result.summary = new XhtmlNode(NodeType.Element, "table").setAttribute("class", "grid");
        XhtmlNode tr = result.summary.addTag("tr");
        tr.addTag("td").addTag("b").addText("Source");
        tr.addTag("td").addTag("b").addText("Target");
        this.log("Start Profiling Transform " + map.getUrl());
        this.analyseGroup("", context, map, vars, start, result);
        ProfileUtilities pu = new ProfileUtilities(this.worker, null, this.pkp);
        for (StructureDefinition sd : result.getProfiles()) {
            pu.cleanUpDifferential(sd);
        }
        return result;
    }

    private void analyseGroup(String indent, TransformContext context, StructureMap map, VariablesForProfiling vars, StructureMap.StructureMapGroupComponent group, StructureMapAnalysis result) throws Exception {
        this.log(indent + "Analyse Group : " + group.getName());
        XhtmlNode tr = result.summary.addTag("tr").setAttribute("class", "diff-title");
        XhtmlNode xs = tr.addTag("td");
        XhtmlNode xt = tr.addTag("td");
        for (StructureMap.StructureMapGroupInputComponent inp : group.getInput()) {
            if (inp.getMode() == StructureMap.StructureMapInputMode.SOURCE) {
                this.noteInput(vars, inp, VariableMode.INPUT, xs);
            }
            if (inp.getMode() != StructureMap.StructureMapInputMode.TARGET) continue;
            this.noteInput(vars, inp, VariableMode.OUTPUT, xt);
        }
        for (StructureMap.StructureMapGroupRuleComponent r : group.getRule()) {
            this.analyseRule(indent + "  ", context, map, vars, group, r, result);
        }
    }

    private void noteInput(VariablesForProfiling vars, StructureMap.StructureMapGroupInputComponent inp, VariableMode mode, XhtmlNode xs) {
        VariableForProfiling v = vars.get(mode, inp.getName());
        if (v != null) {
            xs.addText("Input: " + v.property.getPath());
        }
    }

    private void analyseRule(String indent, TransformContext context, StructureMap map, VariablesForProfiling vars, StructureMap.StructureMapGroupComponent group, StructureMap.StructureMapGroupRuleComponent rule, StructureMapAnalysis result) throws Exception {
        this.log(indent + "Analyse rule : " + rule.getName());
        XhtmlNode tr = result.summary.addTag("tr");
        XhtmlNode xs = tr.addTag("td");
        XhtmlNode xt = tr.addTag("td");
        VariablesForProfiling srcVars = vars.copy();
        if (rule.getSource().size() != 1) {
            throw new Exception("Rule \"" + rule.getName() + "\": not handled yet");
        }
        VariablesForProfiling source = this.analyseSource(rule.getName(), context, srcVars, rule.getSourceFirstRep(), xs);
        TargetWriter tw = new TargetWriter();
        for (StructureMap.StructureMapGroupRuleTargetComponent t : rule.getTarget()) {
            this.analyseTarget(rule.getName(), context, source, map, t, rule.getSourceFirstRep().getVariable(), tw, result.profiles, rule.getName());
        }
        tw.commit(xt);
        for (StructureMap.StructureMapGroupRuleComponent childrule : rule.getRule()) {
            this.analyseRule(indent + "  ", context, map, source, group, childrule, result);
        }
    }

    private VariablesForProfiling analyseSource(String ruleId, TransformContext context, VariablesForProfiling vars, StructureMap.StructureMapGroupRuleSourceComponent src, XhtmlNode td) throws Exception {
        VariableForProfiling var = vars.get(VariableMode.INPUT, src.getContext());
        if (var == null) {
            throw new FHIRException("Rule \"" + ruleId + "\": Unknown input variable " + src.getContext());
        }
        PropertyWithType prop = var.getProperty();
        boolean optional = false;
        boolean repeating = false;
        if (src.hasCondition()) {
            optional = true;
        }
        if (src.hasElement()) {
            Property element = prop.getBaseProperty().getChild(prop.types.getType(), src.getElement());
            if (element == null) {
                throw new Exception("Rule \"" + ruleId + "\": Unknown element name " + src.getElement());
            }
            if (element.getDefinition().getMin() == 0) {
                optional = true;
            }
            if (element.getDefinition().getMax().equals("*")) {
                repeating = true;
            }
            VariablesForProfiling result = vars.copy(optional, repeating);
            TypeDetails type = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
            for (ElementDefinition.TypeRefComponent tr : element.getDefinition().getType()) {
                if (!tr.hasCode()) {
                    throw new Error("Rule \"" + ruleId + "\": Element has no type");
                }
                TypeDetails.ProfiledType pt = new TypeDetails.ProfiledType(tr.getCode());
                if (tr.hasProfile()) {
                    pt.addProfiles(tr.getProfile());
                }
                if (element.getDefinition().hasBinding()) {
                    pt.addBinding(element.getDefinition().getBinding());
                }
                type.addType(pt);
            }
            td.addText(prop.getPath() + "." + src.getElement());
            if (src.hasVariable()) {
                result.add(VariableMode.INPUT, src.getVariable(), new PropertyWithType(prop.getPath() + "." + src.getElement(), element, null, type));
            }
            return result;
        }
        td.addText(prop.getPath());
        return vars.copy(optional, repeating);
    }

    private void analyseTarget(String ruleId, TransformContext context, VariablesForProfiling vars, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt, String tv, TargetWriter tw, List<StructureDefinition> profiles, String sliceName) throws Exception {
        VariableForProfiling var = null;
        if (tgt.hasContext()) {
            var = vars.get(VariableMode.OUTPUT, tgt.getContext());
            if (var == null) {
                throw new Exception("Rule \"" + ruleId + "\": target context not known: " + tgt.getContext());
            }
            if (!tgt.hasElement()) {
                throw new Exception("Rule \"" + ruleId + "\": Not supported yet");
            }
        }
        TypeDetails type = null;
        if (tgt.hasTransform()) {
            type = this.analyseTransform(context, map, tgt, var, vars);
        } else {
            Property vp = var.property.baseProperty.getChild(tgt.getElement(), tgt.getElement());
            if (vp == null) {
                throw new Exception("Unknown Property " + tgt.getElement() + " on " + var.property.path);
            }
            type = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, vp.getType(tgt.getElement()));
        }
        if (tgt.getTransform() == StructureMap.StructureMapTransform.CREATE) {
            String s = this.getParamString(vars, tgt.getParameter().get(0));
            if (this.worker.getResourceNames().contains(s)) {
                tw.newResource(tgt.getVariable(), s);
            }
        } else {
            String td;
            boolean mapsSrc = false;
            for (StructureMap.StructureMapGroupRuleTargetParameterComponent p : tgt.getParameter()) {
                Type pr = p.getValue();
                if (!(pr instanceof IdType) || !((IdType)pr).asStringValue().equals(tv)) continue;
                mapsSrc = true;
            }
            if (mapsSrc) {
                if (var == null) {
                    throw new Error("Rule \"" + ruleId + "\": Attempt to assign with no context");
                }
                tw.valueAssignment(tgt.getContext(), var.property.getPath() + "." + tgt.getElement() + this.getTransformSuffix(tgt.getTransform()));
            } else if (tgt.hasContext() && this.isSignificantElement(var.property, tgt.getElement()) && (td = this.describeTransform(tgt)) != null) {
                tw.keyAssignment(tgt.getContext(), var.property.getPath() + "." + tgt.getElement() + " = " + td);
            }
        }
        Type fixed = this.generateFixedValue(tgt);
        PropertyWithType prop = this.updateProfile(var, tgt.getElement(), type, map, profiles, sliceName, fixed, tgt);
        if (tgt.hasVariable()) {
            if (tgt.hasElement()) {
                vars.add(VariableMode.OUTPUT, tgt.getVariable(), prop);
            } else {
                vars.add(VariableMode.OUTPUT, tgt.getVariable(), prop);
            }
        }
    }

    private Type generateFixedValue(StructureMap.StructureMapGroupRuleTargetComponent tgt) {
        if (!this.allParametersFixed(tgt)) {
            return null;
        }
        if (!tgt.hasTransform()) {
            return null;
        }
        switch (tgt.getTransform()) {
            case COPY: {
                return tgt.getParameter().get(0).getValue();
            }
            case TRUNCATE: {
                return null;
            }
            case TRANSLATE: {
                return null;
            }
            case CC: {
                CodeableConcept cc = new CodeableConcept();
                cc.addCoding(this.buildCoding(tgt.getParameter().get(0).getValue(), tgt.getParameter().get(1).getValue()));
                return cc;
            }
            case C: {
                return this.buildCoding(tgt.getParameter().get(0).getValue(), tgt.getParameter().get(1).getValue());
            }
            case QTY: {
                return null;
            }
        }
        return null;
    }

    private Coding buildCoding(Type value1, Type value2) {
        return new Coding().setSystem(((PrimitiveType)value1).asStringValue()).setCode(((PrimitiveType)value2).asStringValue());
    }

    private boolean allParametersFixed(StructureMap.StructureMapGroupRuleTargetComponent tgt) {
        for (StructureMap.StructureMapGroupRuleTargetParameterComponent p : tgt.getParameter()) {
            Type pr = p.getValue();
            if (!(pr instanceof IdType)) continue;
            return false;
        }
        return true;
    }

    private String describeTransform(StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        switch (tgt.getTransform()) {
            case COPY: {
                return null;
            }
            case TRUNCATE: {
                return null;
            }
            case TRANSLATE: {
                return null;
            }
            case CC: {
                return this.describeTransformCCorC(tgt);
            }
            case C: {
                return this.describeTransformCCorC(tgt);
            }
            case QTY: {
                return null;
            }
        }
        return null;
    }

    private String describeTransformCCorC(StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        if (tgt.getParameter().size() < 2) {
            return null;
        }
        Type p1 = tgt.getParameter().get(0).getValue();
        Type p2 = tgt.getParameter().get(1).getValue();
        if (p1 instanceof IdType || p2 instanceof IdType) {
            return null;
        }
        if (!(p1 instanceof PrimitiveType) || !(p2 instanceof PrimitiveType)) {
            return null;
        }
        String uri = ((PrimitiveType)p1).asStringValue();
        String code = ((PrimitiveType)p2).asStringValue();
        if (Utilities.noString((String)uri)) {
            throw new FHIRException("Describe Transform, but the uri is blank");
        }
        if (Utilities.noString((String)code)) {
            throw new FHIRException("Describe Transform, but the code is blank");
        }
        Coding c = this.buildCoding(uri, code);
        return NarrativeGenerator.describeSystem(c.getSystem()) + "#" + c.getCode() + (c.hasDisplay() ? "(" + c.getDisplay() + ")" : "");
    }

    private boolean isSignificantElement(PropertyWithType property, String element) {
        if ("Observation".equals(property.getPath())) {
            return "code".equals(element);
        }
        if ("Bundle".equals(property.getPath())) {
            return "type".equals(element);
        }
        return false;
    }

    private String getTransformSuffix(StructureMap.StructureMapTransform transform) {
        switch (transform) {
            case COPY: {
                return "";
            }
            case TRUNCATE: {
                return " (truncated)";
            }
            case TRANSLATE: {
                return " (translated)";
            }
            case CC: {
                return " (--> CodeableConcept)";
            }
            case C: {
                return " (--> Coding)";
            }
            case QTY: {
                return " (--> Quantity)";
            }
        }
        return " {??)";
    }

    private PropertyWithType updateProfile(VariableForProfiling var, String element, TypeDetails type, StructureMap map, List<StructureDefinition> profiles, String sliceName, Type fixed, StructureMap.StructureMapGroupRuleTargetComponent tgt) throws FHIRException {
        if (var == null) {
            assert (Utilities.noString((String)element));
            StructureDefinition sdn = this.worker.fetchResource(StructureDefinition.class, type.getType());
            if (sdn == null) {
                throw new FHIRException("Unable to find definition for " + type.getType());
            }
            ElementDefinition edn = sdn.getSnapshot().getElementFirstRep();
            PropertyWithType pn = this.createProfile(map, profiles, new PropertyWithType(sdn.getId(), new Property(this.worker, edn, sdn), null, type), sliceName, tgt);
            return pn;
        }
        assert (!Utilities.noString((String)element));
        Property pvb = var.getProperty().getBaseProperty();
        Property pvd = var.getProperty().getProfileProperty();
        Property pc = pvb.getChild(element, var.property.types);
        if (pc == null) {
            throw new DefinitionException("Unable to find a definition for " + pvb.getDefinition().getPath() + "." + element);
        }
        StructureDefinition sd = var.getProperty().profileProperty.getStructure();
        ElementDefinition ednew = sd.getDifferential().addElement();
        ednew.setPath(var.getProperty().profileProperty.getDefinition().getPath() + "." + pc.getName());
        ednew.setUserData("slice-name", sliceName);
        ednew.setFixed(fixed);
        for (TypeDetails.ProfiledType pt : type.getProfiledTypes()) {
            if (pt.hasBindings()) {
                ednew.setBinding(pt.getBindings().get(0));
            }
            if (!pt.getUri().startsWith("http://hl7.org/fhir/StructureDefinition/")) continue;
            String t = pt.getUri().substring(40);
            if ((t = this.checkType(t, pc, pt.getProfiles())) == null) continue;
            if (pt.hasProfiles()) {
                for (String p : pt.getProfiles()) {
                    if (t.equals("Reference")) {
                        ednew.getType(t).addTargetProfile(p);
                        continue;
                    }
                    ednew.getType(t).addProfile(p);
                }
                continue;
            }
            ednew.getType(t);
        }
        return new PropertyWithType(var.property.path + "." + element, pc, new Property(this.worker, ednew, sd), type);
    }

    private String checkType(String t, Property pvb, List<String> profiles) throws FHIRException {
        if (pvb.getDefinition().getType().size() == 1 && this.isCompatibleType(t, pvb.getDefinition().getType().get(0).getCode()) && this.profilesMatch(profiles, pvb.getDefinition().getType().get(0).getProfile())) {
            return null;
        }
        for (ElementDefinition.TypeRefComponent tr : pvb.getDefinition().getType()) {
            if (!this.isCompatibleType(t, tr.getCode())) continue;
            return tr.getCode();
        }
        throw new FHIRException("The type " + t + " is not compatible with the allowed types for " + pvb.getDefinition().getPath());
    }

    private boolean profilesMatch(List<String> profiles, List<CanonicalType> profile) {
        return profiles == null || profiles.size() == 0 || profile.size() == 0 || profiles.size() == 1 && profiles.get(0).equals(profile.get(0).getValue());
    }

    private boolean isCompatibleType(String t, String code) {
        StructureDefinition sd;
        if (t.equals(code)) {
            return true;
        }
        return t.equals("string") && (sd = this.worker.fetchTypeDefinition(code)) != null && sd.getBaseDefinition().equals("http://hl7.org/fhir/StructureDefinition/string");
    }

    private TypeDetails analyseTransform(TransformContext context, StructureMap map, StructureMap.StructureMapGroupRuleTargetComponent tgt, VariableForProfiling var, VariablesForProfiling vars) throws FHIRException {
        switch (tgt.getTransform()) {
            case CREATE: {
                String p = this.getParamString(vars, tgt.getParameter().get(0));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, p);
            }
            case COPY: {
                return this.getParam(vars, tgt.getParameter().get(0));
            }
            case EVALUATE: {
                ExpressionNode expr = (ExpressionNode)tgt.getUserData(MAP_EXPRESSION);
                if (expr == null) {
                    expr = this.fpe.parse(this.getParamString(vars, tgt.getParameter().get(tgt.getParameter().size() - 1)));
                    tgt.setUserData(MAP_WHERE_EXPRESSION, expr);
                }
                return this.fpe.check(vars, null, expr);
            }
            case TRANSLATE: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "CodeableConcept");
            }
            case CC: {
                TypeDetails td;
                TypeDetails.ProfiledType res = new TypeDetails.ProfiledType("CodeableConcept");
                if (tgt.getParameter().size() >= 2 && this.isParamId(vars, tgt.getParameter().get(1)) && (td = vars.get(null, this.getParamId(vars, tgt.getParameter().get(1))).property.types) != null && td.hasBinding()) {
                    res.addBinding(td.getBinding());
                }
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, res);
            }
            case C: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Coding");
            }
            case QTY: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Quantity");
            }
            case REFERENCE: {
                VariableForProfiling vrs = vars.get(VariableMode.OUTPUT, this.getParamId(vars, tgt.getParameterFirstRep()));
                if (vrs == null) {
                    throw new FHIRException("Unable to resolve variable \"" + this.getParamId(vars, tgt.getParameterFirstRep()) + "\"");
                }
                String profile = vrs.property.getProfileProperty().getStructure().getUrl();
                TypeDetails td = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                td.addType("Reference", profile);
                return td;
            }
        }
        throw new Error("Transform Unknown or not handled yet: " + tgt.getTransform().toCode());
    }

    private String getParamString(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        Type p = parameter.getValue();
        if (p == null || p instanceof IdType) {
            return null;
        }
        if (!p.hasPrimitiveValue()) {
            return null;
        }
        return p.primitiveValue();
    }

    private String getParamId(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        Type p = parameter.getValue();
        if (p == null || !(p instanceof IdType)) {
            return null;
        }
        return p.primitiveValue();
    }

    private boolean isParamId(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) {
        Type p = parameter.getValue();
        if (p == null || !(p instanceof IdType)) {
            return false;
        }
        return vars.get(null, p.primitiveValue()) != null;
    }

    private TypeDetails getParam(VariablesForProfiling vars, StructureMap.StructureMapGroupRuleTargetParameterComponent parameter) throws DefinitionException {
        Type p = parameter.getValue();
        if (!(p instanceof IdType)) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ProfileUtilities.sdNs(p.fhirType(), this.worker.getOverrideVersionNs()));
        }
        String n = ((IdType)p).asStringValue();
        VariableForProfiling b = vars.get(VariableMode.INPUT, n);
        if (b == null) {
            b = vars.get(VariableMode.OUTPUT, n);
        }
        if (b == null) {
            throw new DefinitionException("Variable " + n + " not found (" + vars.summary() + ")");
        }
        return b.getProperty().getTypes();
    }

    private PropertyWithType createProfile(StructureMap map, List<StructureDefinition> profiles, PropertyWithType prop, String sliceName, Base ctxt) throws DefinitionException {
        if (prop.getBaseProperty().getDefinition().getPath().contains(".")) {
            throw new DefinitionException("Unable to process entry point");
        }
        String type = prop.getBaseProperty().getDefinition().getPath();
        String suffix = "";
        if (this.ids.containsKey(type)) {
            int id = this.ids.get(type);
            this.ids.put(type, ++id);
            suffix = "-" + Integer.toString(id);
        } else {
            this.ids.put(type, 0);
        }
        StructureDefinition profile = new StructureDefinition();
        profiles.add(profile);
        profile.setDerivation(StructureDefinition.TypeDerivationRule.CONSTRAINT);
        profile.setType(type);
        profile.setBaseDefinition(prop.getBaseProperty().getStructure().getUrl());
        profile.setName("Profile for " + profile.getType() + " for " + sliceName);
        profile.setUrl(map.getUrl().replace("StructureMap", "StructureDefinition") + "-" + profile.getType() + suffix);
        ctxt.setUserData("profile", profile.getUrl());
        profile.setId(map.getId() + "-" + profile.getType() + suffix);
        profile.setStatus(map.getStatus());
        profile.setExperimental(map.getExperimental());
        profile.setDescription("Generated automatically from the mapping by the Java Reference Implementation");
        for (ContactDetail c : map.getContact()) {
            ContactDetail p = profile.addContact();
            p.setName(c.getName());
            for (ContactPoint cc : c.getTelecom()) {
                p.addTelecom(cc);
            }
        }
        profile.setDate(map.getDate());
        profile.setCopyright(map.getCopyright());
        profile.setFhirVersion("3.5.0");
        profile.setKind(prop.getBaseProperty().getStructure().getKind());
        profile.setAbstract(false);
        ElementDefinition ed = profile.getDifferential().addElement();
        ed.setPath(profile.getType());
        prop.profileProperty = new Property(this.worker, ed, profile);
        return prop;
    }

    private PropertyWithType resolveType(StructureMap map, String type, StructureMap.StructureMapInputMode mode) throws Exception {
        for (StructureMap.StructureMapStructureComponent imp : map.getStructure()) {
            if ((imp.getMode() != StructureMap.StructureMapModelMode.SOURCE || mode != StructureMap.StructureMapInputMode.SOURCE) && (imp.getMode() != StructureMap.StructureMapModelMode.TARGET || mode != StructureMap.StructureMapInputMode.TARGET)) continue;
            StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, imp.getUrl());
            if (sd == null) {
                throw new Exception("Import " + imp.getUrl() + " cannot be resolved");
            }
            if (!sd.getId().equals(type)) continue;
            return new PropertyWithType(sd.getType(), new Property(this.worker, sd.getSnapshot().getElement().get(0), sd), null, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl()));
        }
        throw new Exception("Unable to find structure definition for " + type + " in imports");
    }

    public StructureMap generateMapFromMappings(StructureDefinition sd) throws IOException, FHIRException {
        String id = this.getLogicalMappingId(sd);
        if (id == null) {
            return null;
        }
        String prefix = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-prefix");
        String suffix = ToolingExtensions.readStringExtension(sd, "http://hl7.org/fhir/tools/StructureDefinition/logical-mapping-suffix");
        if (prefix == null || suffix == null) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        b.append(prefix);
        ElementDefinition root = sd.getSnapshot().getElementFirstRep();
        String m = this.getMapping(root, id);
        if (m != null) {
            b.append(m + "\r\n");
        }
        this.addChildMappings(b, id, "", sd, root, false);
        b.append("\r\n");
        b.append(suffix);
        b.append("\r\n");
        StructureMap map = this.parse(b.toString());
        map.setId(this.tail(map.getUrl()));
        if (!map.hasStatus()) {
            map.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        map.getText().setStatus(Narrative.NarrativeStatus.GENERATED);
        map.getText().setDiv(new XhtmlNode(NodeType.Element, "div"));
        map.getText().getDiv().addTag("pre").addText(StructureMapUtilities.render(map));
        return map;
    }

    private String tail(String url) {
        return url.substring(url.lastIndexOf("/") + 1);
    }

    private void addChildMappings(StringBuilder b, String id, String indent, StructureDefinition sd, ElementDefinition ed, boolean inner) throws DefinitionException {
        boolean first = true;
        List<ElementDefinition> children = ProfileUtilities.getChildMap(sd, ed);
        for (ElementDefinition child : children) {
            String map;
            if (first && inner) {
                b.append(" then {\r\n");
                first = false;
            }
            if ((map = this.getMapping(child, id)) == null) continue;
            b.append(indent + "  " + child.getPath() + ": " + map);
            this.addChildMappings(b, id, indent + "  ", sd, child, true);
            b.append("\r\n");
        }
        if (!first && inner) {
            b.append(indent + "}");
        }
    }

    private String getMapping(ElementDefinition ed, String id) {
        for (ElementDefinition.ElementDefinitionMappingComponent map : ed.getMapping()) {
            if (!id.equals(map.getIdentity())) continue;
            return map.getMap();
        }
        return null;
    }

    private String getLogicalMappingId(StructureDefinition sd) {
        Object id = null;
        for (StructureDefinition.StructureDefinitionMappingComponent map : sd.getMapping()) {
            if (!"http://hl7.org/fhir/logical".equals(map.getUri())) continue;
            return map.getIdentity();
        }
        return null;
    }

    public class TargetWriter {
        private Map<String, String> newResources = new HashMap<String, String>();
        private List<StringPair> assignments = new ArrayList<StringPair>();
        private List<StringPair> keyProps = new ArrayList<StringPair>();
        private CommaSeparatedStringBuilder txt = new CommaSeparatedStringBuilder();

        public void newResource(String var, String name) {
            this.newResources.put(var, name);
            this.txt.append("new " + name);
        }

        public void valueAssignment(String context, String desc) {
            this.assignments.add(new StringPair(context, desc));
            this.txt.append(desc);
        }

        public void keyAssignment(String context, String desc) {
            this.keyProps.add(new StringPair(context, desc));
            this.txt.append(desc);
        }

        public void commit(XhtmlNode xt) {
            if (this.newResources.size() == 1 && this.assignments.size() == 1 && this.newResources.containsKey(this.assignments.get(0).getVar()) && this.keyProps.size() == 1 && this.newResources.containsKey(this.keyProps.get(0).getVar())) {
                xt.addText("new " + this.assignments.get(0).desc + " (" + this.keyProps.get(0).desc.substring(this.keyProps.get(0).desc.indexOf(".") + 1) + ")");
            } else if (this.newResources.size() == 1 && this.assignments.size() == 1 && this.newResources.containsKey(this.assignments.get(0).getVar()) && this.keyProps.size() == 0) {
                xt.addText("new " + this.assignments.get(0).desc);
            } else {
                xt.addText(this.txt.toString());
            }
        }
    }

    public class StringPair {
        private String var;
        private String desc;

        public StringPair(String var, String desc) {
            this.var = var;
            this.desc = desc;
        }

        public String getVar() {
            return this.var;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public class StructureMapAnalysis {
        private List<StructureDefinition> profiles = new ArrayList<StructureDefinition>();
        private XhtmlNode summary;

        public List<StructureDefinition> getProfiles() {
            return this.profiles;
        }

        public XhtmlNode getSummary() {
            return this.summary;
        }
    }

    public class VariablesForProfiling {
        private List<VariableForProfiling> list = new ArrayList<VariableForProfiling>();
        private boolean optional;
        private boolean repeating;

        public VariablesForProfiling(boolean optional, boolean repeating) {
            this.optional = optional;
            this.repeating = repeating;
        }

        public void add(VariableMode mode, String name, String path, Property property, TypeDetails types) {
            this.add(mode, name, new PropertyWithType(path, property, null, types));
        }

        public void add(VariableMode mode, String name, String path, Property baseProperty, Property profileProperty, TypeDetails types) {
            this.add(mode, name, new PropertyWithType(path, baseProperty, profileProperty, types));
        }

        public void add(VariableMode mode, String name, PropertyWithType property) {
            VariableForProfiling vv = null;
            for (VariableForProfiling v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                vv = v;
            }
            if (vv != null) {
                this.list.remove(vv);
            }
            this.list.add(new VariableForProfiling(mode, name, property));
        }

        public VariablesForProfiling copy(boolean optional, boolean repeating) {
            VariablesForProfiling result = new VariablesForProfiling(optional, repeating);
            result.list.addAll(this.list);
            return result;
        }

        public VariablesForProfiling copy() {
            VariablesForProfiling result = new VariablesForProfiling(this.optional, this.repeating);
            result.list.addAll(this.list);
            return result;
        }

        public VariableForProfiling get(VariableMode mode, String name) {
            if (mode == null) {
                for (VariableForProfiling v : this.list) {
                    if (v.mode != VariableMode.OUTPUT || !v.getName().equals(name)) continue;
                    return v;
                }
                for (VariableForProfiling v : this.list) {
                    if (v.mode != VariableMode.INPUT || !v.getName().equals(name)) continue;
                    return v;
                }
            }
            for (VariableForProfiling v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                return v;
            }
            return null;
        }

        public String summary() {
            CommaSeparatedStringBuilder s = new CommaSeparatedStringBuilder();
            CommaSeparatedStringBuilder t = new CommaSeparatedStringBuilder();
            for (VariableForProfiling v : this.list) {
                if (v.mode == VariableMode.INPUT) {
                    s.append(v.summary());
                    continue;
                }
                t.append(v.summary());
            }
            return "source variables [" + s.toString() + "], target variables [" + t.toString() + "]";
        }
    }

    public class VariableForProfiling {
        private VariableMode mode;
        private String name;
        private PropertyWithType property;

        public VariableForProfiling(VariableMode mode, String name, PropertyWithType property) {
            this.mode = mode;
            this.name = name;
            this.property = property;
        }

        public VariableMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public PropertyWithType getProperty() {
            return this.property;
        }

        public String summary() {
            return this.name + ": " + this.property.summary();
        }
    }

    public class PropertyWithType {
        private String path;
        private Property baseProperty;
        private Property profileProperty;
        private TypeDetails types;

        public PropertyWithType(String path, Property baseProperty, Property profileProperty, TypeDetails types) {
            this.baseProperty = baseProperty;
            this.profileProperty = profileProperty;
            this.path = path;
            this.types = types;
        }

        public TypeDetails getTypes() {
            return this.types;
        }

        public String getPath() {
            return this.path;
        }

        public Property getBaseProperty() {
            return this.baseProperty;
        }

        public void setBaseProperty(Property baseProperty) {
            this.baseProperty = baseProperty;
        }

        public Property getProfileProperty() {
            return this.profileProperty;
        }

        public void setProfileProperty(Property profileProperty) {
            this.profileProperty = profileProperty;
        }

        public String summary() {
            return this.path;
        }
    }

    private class SourceElementComponentWrapper {
        private ConceptMap.ConceptMapGroupComponent group;
        private ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.ConceptMapGroupComponent group, ConceptMap.SourceElementComponent comp) {
            this.group = group;
            this.comp = comp;
        }
    }

    public class TransformContext {
        private Object appInfo;

        public TransformContext(Object appInfo) {
            this.appInfo = appInfo;
        }

        public Object getAppInfo() {
            return this.appInfo;
        }
    }

    public class Variables {
        private List<Variable> list = new ArrayList<Variable>();

        public void add(VariableMode mode, String name, Base object) {
            Variable vv = null;
            for (Variable v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                vv = v;
            }
            if (vv != null) {
                this.list.remove(vv);
            }
            this.list.add(new Variable(mode, name, object));
        }

        public Variables copy() {
            Variables result = new Variables();
            result.list.addAll(this.list);
            return result;
        }

        public Base get(VariableMode mode, String name) {
            for (Variable v : this.list) {
                if (v.mode != mode || !v.getName().equals(name)) continue;
                return v.getObject();
            }
            return null;
        }

        public String summary() {
            CommaSeparatedStringBuilder s = new CommaSeparatedStringBuilder();
            CommaSeparatedStringBuilder t = new CommaSeparatedStringBuilder();
            for (Variable v : this.list) {
                if (v.mode == VariableMode.INPUT) {
                    s.append(v.summary());
                    continue;
                }
                t.append(v.summary());
            }
            return "source variables [" + s.toString() + "], target variables [" + t.toString() + "]";
        }
    }

    public class Variable {
        private VariableMode mode;
        private String name;
        private Base object;

        public Variable(VariableMode mode, String name, Base object) {
            this.mode = mode;
            this.name = name;
            this.object = object;
        }

        public VariableMode getMode() {
            return this.mode;
        }

        public String getName() {
            return this.name;
        }

        public Base getObject() {
            return this.object;
        }

        public String summary() {
            return this.name + ": " + this.object.fhirType();
        }
    }

    public static enum VariableMode {
        INPUT,
        OUTPUT;

    }

    private class FFHIRPathHostServices
    implements FHIRPathEngine.IEvaluationContext {
        private FFHIRPathHostServices() {
        }

        @Override
        public Base resolveConstant(Object appContext, String name) throws PathEngineException {
            Variables vars = (Variables)appContext;
            Base res = vars.get(VariableMode.INPUT, name);
            if (res == null) {
                res = vars.get(VariableMode.OUTPUT, name);
            }
            return res;
        }

        @Override
        public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
            if (!(appContext instanceof VariablesForProfiling)) {
                throw new Error("Internal Logic Error (wrong type '" + appContext.getClass().getName() + "' in resolveConstantType)");
            }
            VariablesForProfiling vars = (VariablesForProfiling)appContext;
            VariableForProfiling v = vars.get(null, name);
            if (v == null) {
                throw new PathEngineException("Unknown variable '" + name + "' from variables " + vars.summary());
            }
            return v.property.types;
        }

        @Override
        public boolean log(String argument, List<Base> focus) {
            throw new Error("Not Implemented Yet");
        }

        @Override
        public FHIRPathEngine.IEvaluationContext.FunctionDetails resolveFunction(String functionName) {
            return null;
        }

        @Override
        public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
            throw new Error("Not Implemented Yet");
        }

        @Override
        public List<Base> executeFunction(Object appContext, String functionName, List<List<Base>> parameters) {
            throw new Error("Not Implemented Yet");
        }

        @Override
        public Base resolveReference(Object appContext, String url) throws FHIRException {
            if (StructureMapUtilities.this.services == null) {
                return null;
            }
            return StructureMapUtilities.this.services.resolveReference(appContext, url);
        }

        @Override
        public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
            IResourceValidator val = StructureMapUtilities.this.worker.newValidator();
            ArrayList<ValidationMessage> valerrors = new ArrayList<ValidationMessage>();
            if (item instanceof Resource) {
                val.validate(appContext, valerrors, (Resource)item, url);
                boolean ok = true;
                for (ValidationMessage v : valerrors) {
                    ok = ok && v.getLevel().isError();
                }
                return ok;
            }
            throw new NotImplementedException("Not done yet (FFHIRPathHostServices.conformsToProfile), when item is element");
        }
    }

    public static interface ITransformerServices {
        public void log(String var1);

        public Base createType(Object var1, String var2) throws FHIRException;

        public Base createResource(Object var1, Base var2, boolean var3);

        public Coding translate(Object var1, Coding var2, String var3) throws FHIRException;

        public Base resolveReference(Object var1, String var2) throws FHIRException;

        public List<Base> performSearch(Object var1, String var2) throws FHIRException;
    }

    public class ResolvedGroup {
        public StructureMap.StructureMapGroupComponent target;
        public StructureMap targetMap;
    }
}

