/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.fluentpath;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.FhirPathExecutionException;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.fhirpath.IFhirPathEvaluationContext;
import ca.uhn.fhir.i18n.Msg;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Optional;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.ExpressionNode;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.TypeDetails;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.utils.FHIRPathEngine;
import org.hl7.fhir.r4.utils.FHIRPathUtilityClasses;

public class FhirPathR4
implements IFhirPath {
    private final FHIRPathEngine myEngine;

    public FhirPathR4(FhirContext theCtx) {
        IValidationSupport validationSupport = theCtx.getValidationSupport();
        this.myEngine = new FHIRPathEngine((IWorkerContext)new HapiWorkerContext(theCtx, validationSupport));
        this.myEngine.setDoNotEnforceAsCaseSensitive(true);
        this.myEngine.setDoNotEnforceAsSingletonRule(true);
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, String thePath, Class<T> theReturnType) {
        ExpressionNode parsed;
        try {
            parsed = this.myEngine.parse(thePath);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)2409) + e);
        }
        return this.evaluate(theInput, parsed, theReturnType);
    }

    public <T extends IBase> List<T> evaluate(IBase theInput, IFhirPath.IParsedExpression theParsedExpression, Class<T> theReturnType) {
        ExpressionNode expressionNode = ((ParsedExpression)theParsedExpression).myParsedExpression;
        return this.evaluate(theInput, expressionNode, theReturnType);
    }

    @Nonnull
    private <T extends IBase> List<Base> evaluate(IBase theInput, ExpressionNode expressionNode, Class<T> theReturnType) {
        List result;
        try {
            result = this.myEngine.evaluate((Base)theInput, expressionNode);
        }
        catch (FHIRException e) {
            throw new FhirPathExecutionException(Msg.code((int)255) + e.getMessage(), (Throwable)e);
        }
        for (IBase next : result) {
            if (theReturnType.isAssignableFrom(next.getClass())) continue;
            throw new FhirPathExecutionException(Msg.code((int)256) + "FhirPath expression returned unexpected type " + next.getClass().getSimpleName() + " - Expected " + theReturnType.getName());
        }
        return result;
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, String thePath, Class<T> theReturnType) {
        return this.evaluate(theInput, thePath, theReturnType).stream().findFirst();
    }

    public <T extends IBase> Optional<T> evaluateFirst(IBase theInput, IFhirPath.IParsedExpression theParsedExpression, Class<T> theReturnType) {
        return this.evaluate(theInput, theParsedExpression, theReturnType).stream().findFirst();
    }

    public IFhirPath.IParsedExpression parse(String theExpression) {
        return new ParsedExpression(this.myEngine.parse(theExpression));
    }

    public void setEvaluationContext(final @Nonnull IFhirPathEvaluationContext theEvaluationContext) {
        this.myEngine.setHostServices(new FHIRPathEngine.IEvaluationContext(){

            public List<Base> resolveConstant(Object appContext, String name, boolean beforeContext) throws PathEngineException {
                return null;
            }

            public TypeDetails resolveConstantType(Object appContext, String name) throws PathEngineException {
                return null;
            }

            public boolean log(String argument, List<Base> focus) {
                return false;
            }

            public FHIRPathUtilityClasses.FunctionDetails resolveFunction(String functionName) {
                return null;
            }

            public TypeDetails checkFunction(Object appContext, String functionName, List<TypeDetails> parameters) throws PathEngineException {
                return null;
            }

            public List<Base> executeFunction(Object appContext, List<Base> focus, String functionName, List<List<Base>> parameters) {
                return null;
            }

            public Base resolveReference(Object appContext, String theUrl, Base theRefContext) throws FHIRException {
                return (Base)theEvaluationContext.resolveReference((IIdType)new IdType(theUrl), (IBase)theRefContext);
            }

            public boolean conformsToProfile(Object appContext, Base item, String url) throws FHIRException {
                return false;
            }

            public ValueSet resolveValueSet(Object appContext, String url) {
                return null;
            }
        });
    }

    private static class ParsedExpression
    implements IFhirPath.IParsedExpression {
        private final ExpressionNode myParsedExpression;

        public ParsedExpression(ExpressionNode theParsedExpression) {
            this.myParsedExpression = theParsedExpression;
        }
    }
}

