/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.dstu2.resource.Conformance;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.rest.client.impl.GenericClient;
import ca.uhn.fhir.to.BaseController;
import ca.uhn.fhir.to.TesterConfig;
import ca.uhn.fhir.to.model.HomeRequest;
import ca.uhn.fhir.util.UrlUtil;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.hl7.fhir.dstu3.model.CapabilityStatement;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.DecimalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import org.thymeleaf.ITemplateEngine;

/*
 * Exception performing whole class analysis ignored.
 */
public class BaseController {
    static final String PARAM_RESOURCE = "resource";
    static final String RESOURCE_COUNT_EXT_URL = "http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount";
    private static final Logger ourLog = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    protected TesterConfig myConfig;
    private final Map<FhirVersionEnum, FhirContext> myContexts = new HashMap();
    private List<String> myFilterHeaders;
    @Autowired
    private ITemplateEngine myTemplateEngine;

    protected IBaseResource addCommonParams(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        String serverId = theRequest.getServerIdWithDefault(this.myConfig);
        String serverBase = theRequest.getServerBase(theServletRequest, this.myConfig);
        String serverName = theRequest.getServerName(this.myConfig);
        String apiKey = theRequest.getApiKey(theServletRequest, this.myConfig);
        theModel.put((Object)"serverId", (Object)BaseController.sanitizeInput((String)serverId));
        theModel.put((Object)"baseName", (Object)BaseController.sanitizeInput((String)serverName));
        theModel.put((Object)"apiKey", (Object)BaseController.sanitizeInput((String)apiKey));
        theModel.put((Object)"resourceName", (Object)BaseController.sanitizeInput((String)StringUtils.defaultString((String)theRequest.getResource())));
        theModel.put((Object)"encoding", (Object)BaseController.sanitizeInput((String)theRequest.getEncoding()));
        theModel.put((Object)"pretty", (Object)BaseController.sanitizeInput((String)theRequest.getPretty()));
        theModel.put((Object)"_summary", (Object)BaseController.sanitizeInput((String)theRequest.get_summary()));
        theModel.put((Object)"serverEntries", (Object)this.myConfig.getIdToServerName());
        theModel.put((Object)"base", (Object)serverBase);
        return this.loadAndAddConf(theServletRequest, theRequest, theModel);
    }

    private Header[] applyHeaderFilters(Map<String, List<String>> theAllHeaders) {
        ArrayList<BasicHeader> retVal = new ArrayList<BasicHeader>();
        for (String nextKey : theAllHeaders.keySet()) {
            for (String nextValue : theAllHeaders.get(nextKey)) {
                if (this.myFilterHeaders != null && this.myFilterHeaders.contains(nextKey.toLowerCase())) continue;
                retVal.add(new BasicHeader(nextKey, nextValue));
            }
        }
        return retVal.toArray(new Header[retVal.size()]);
    }

    private String format(String theResultBody, EncodingEnum theEncodingEnum) {
        String str = StringEscapeUtils.escapeHtml4((String)theResultBody);
        if (str == null || theEncodingEnum == null) {
            return str;
        }
        StringBuilder b = new StringBuilder();
        if (theEncodingEnum == EncodingEnum.JSON) {
            boolean inValue = false;
            boolean inQuote = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                int prevChar = i > 0 ? (int)str.charAt(i - 1) : 32;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (prevChar != 92 && nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("quot;</span>");
                        i += 5;
                        inQuote = false;
                        continue;
                    }
                    if (nextChar != '\\' || nextChar2 != 34) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (nextChar == ':') {
                    inValue = true;
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '[' || nextChar == '{') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '{' || nextChar == '}' || nextChar == ',') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = false;
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                    if (inValue) {
                        b.append("<span class='hlQuot'>&quot;");
                    } else {
                        b.append("<span class='hlTagName'>&quot;");
                    }
                    inQuote = true;
                    i += 5;
                    continue;
                }
                if (nextChar == ':') {
                    b.append("<span class='hlControl'>");
                    b.append(nextChar);
                    b.append("</span>");
                    inValue = true;
                    continue;
                }
                b.append(nextChar);
            }
        } else {
            boolean inQuote = false;
            boolean inTag = false;
            for (int i = 0; i < str.length(); ++i) {
                int nextChar6;
                char nextChar = str.charAt(i);
                int nextChar2 = i + 1 < str.length() ? (int)str.charAt(i + 1) : 32;
                int nextChar3 = i + 2 < str.length() ? (int)str.charAt(i + 2) : 32;
                int nextChar4 = i + 3 < str.length() ? (int)str.charAt(i + 3) : 32;
                int nextChar5 = i + 4 < str.length() ? (int)str.charAt(i + 4) : 32;
                int n = nextChar6 = i + 5 < str.length() ? (int)str.charAt(i + 5) : 32;
                if (inQuote) {
                    b.append(nextChar);
                    if (nextChar != '&' || nextChar2 != 113 || nextChar3 != 117 || nextChar4 != 111 || nextChar5 != 116 || nextChar6 != 59) continue;
                    b.append("quot;</span>");
                    i += 5;
                    inQuote = false;
                    continue;
                }
                if (inTag) {
                    if (nextChar == '&' && nextChar2 == 103 && nextChar3 == 116 && nextChar4 == 59) {
                        b.append("</span><span class='hlControl'>&gt;</span>");
                        inTag = false;
                        i += 3;
                        continue;
                    }
                    if (nextChar == ' ') {
                        b.append("</span><span class='hlAttr'>");
                        b.append(nextChar);
                        continue;
                    }
                    if (nextChar == '&' && nextChar2 == 113 && nextChar3 == 117 && nextChar4 == 111 && nextChar5 == 116 && nextChar6 == 59) {
                        b.append("<span class='hlQuot'>&quot;");
                        inQuote = true;
                        i += 5;
                        continue;
                    }
                    b.append(nextChar);
                    continue;
                }
                if (nextChar == '&' && nextChar2 == 108 && nextChar3 == 116 && nextChar4 == 59) {
                    b.append("<span class='hlControl'>&lt;</span><span class='hlTagName'>");
                    inTag = true;
                    i += 3;
                    continue;
                }
                b.append(nextChar);
            }
        }
        return b.toString();
    }

    private String formatUrl(String theUrlBase, String theResultBody) {
        String str = theResultBody;
        if (str == null) {
            return str;
        }
        try {
            str = URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            ourLog.error("Should not happen", (Throwable)e);
        }
        StringBuilder b = new StringBuilder();
        b.append("<span class='hlUrlBase'>");
        boolean inParams = false;
        for (int i = 0; i < str.length(); ++i) {
            char nextChar = str.charAt(i);
            if (!inParams) {
                if (nextChar == '?') {
                    inParams = true;
                    b.append("</span><wbr /><span class='hlControl'>?</span><span class='hlTagName'>");
                    continue;
                }
                if (i == theUrlBase.length()) {
                    b.append("</span><wbr /><span class='hlText'>");
                }
                b.append(nextChar);
                continue;
            }
            if (nextChar == '&') {
                b.append("</span><wbr /><span class='hlControl'>&amp;</span><span class='hlTagName'>");
                continue;
            }
            if (nextChar == '=') {
                b.append("</span><span class='hlControl'>=</span><span class='hlAttr'>");
                continue;
            }
            b.append(nextChar);
        }
        if (inParams) {
            b.append("</span>");
        }
        return b.toString();
    }

    protected FhirContext getContext(HomeRequest theRequest) {
        FhirVersionEnum version = theRequest.getFhirVersion(this.myConfig);
        FhirContext retVal = (FhirContext)this.myContexts.get(version);
        if (retVal == null) {
            retVal = this.newContext(version);
            this.myContexts.put(version, retVal);
        }
        return retVal;
    }

    protected RuntimeResourceDefinition getResourceType(HomeRequest theRequest, HttpServletRequest theReq) throws ServletException {
        String resourceName = UrlUtil.sanitizeUrlPart((CharSequence)StringUtils.defaultString((String)theReq.getParameter("resource")));
        RuntimeResourceDefinition def = this.getContext(theRequest).getResourceDefinition(resourceName);
        if (def == null) {
            throw new ServletException(Msg.code((int)192) + "Invalid resourceName: " + resourceName);
        }
        return def;
    }

    protected ResultType handleClientException(GenericClient theClient, Exception e, ModelMap theModel) {
        ResultType returnsResource = ResultType.NONE;
        ourLog.warn("Failed to invoke server", (Throwable)e);
        if (e != null) {
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Error: " + e.getMessage(), e));
        }
        return returnsResource;
    }

    private IBaseResource loadAndAddConf(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        switch (5.$SwitchMap$ca$uhn$fhir$context$FhirVersionEnum[theRequest.getFhirVersion(this.myConfig).ordinal()]) {
            case 1: {
                return this.loadAndAddConfDstu2(theServletRequest, theRequest, theModel);
            }
            case 2: {
                return this.loadAndAddConfDstu3(theServletRequest, theRequest, theModel);
            }
            case 3: {
                return this.loadAndAddConfR4(theServletRequest, theRequest, theModel);
            }
            case 4: {
                return this.loadAndAddConfR5(theServletRequest, theRequest, theModel);
            }
        }
        throw new IllegalStateException(Msg.code((int)193) + "Unknown version: " + theRequest.getFhirVersion(this.myConfig));
    }

    private IResource loadAndAddConfDstu2(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        Conformance conformance;
        CaptureInterceptor interceptor = new CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        try {
            conformance = (Conformance)client.fetchConformance().ofType(Conformance.class).execute();
        }
        catch (Exception e) {
            ourLog.warn("Failed to load conformance statement, error was: {}", (Object)e.toString());
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to load conformance statement, error was: " + e.toString(), e));
            conformance = new Conformance();
        }
        theModel.put((Object)"jsonEncodedConf", (Object)this.getContext(theRequest).newJsonParser().encodeResourceToString((IBaseResource)conformance));
        HashMap<String, Number> resourceCounts = new HashMap<String, Number>();
        long total = 0L;
        for (Conformance.Rest nextRest : conformance.getRest()) {
            for (Conformance.RestResource nextResource : nextRest.getResource()) {
                List exts = nextResource.getUndeclaredExtensionsByUrl("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount");
                if (exts == null || exts.size() <= 0) continue;
                Number nextCount = ((DecimalDt)((ExtensionDt)exts.get(0)).getValue()).getValueAsNumber();
                resourceCounts.put((String)nextResource.getTypeElement().getValue(), nextCount);
                total += nextCount.longValue();
            }
        }
        theModel.put((Object)"resourceCounts", resourceCounts);
        if (total > 0L) {
            for (Conformance.Rest nextRest : conformance.getRest()) {
                Collections.sort(nextRest.getResource(), new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        theModel.put((Object)"conf", (Object)conformance);
        theModel.put((Object)"requiredParamExtension", (Object)"http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#paramIsRequired");
        return conformance;
    }

    private IBaseResource loadAndAddConfDstu3(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        CaptureInterceptor interceptor = new CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        org.hl7.fhir.dstu3.model.CapabilityStatement capabilityStatement = new org.hl7.fhir.dstu3.model.CapabilityStatement();
        try {
            capabilityStatement = (org.hl7.fhir.dstu3.model.CapabilityStatement)client.fetchConformance().ofType(org.hl7.fhir.dstu3.model.CapabilityStatement.class).execute();
        }
        catch (Exception ex) {
            ourLog.warn("Failed to load conformance statement, error was: {}", (Object)ex.toString());
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to load conformance statement, error was: " + ex.toString(), ex));
        }
        theModel.put((Object)"jsonEncodedConf", (Object)this.getContext(theRequest).newJsonParser().encodeResourceToString((IBaseResource)capabilityStatement));
        HashMap<String, Number> resourceCounts = new HashMap<String, Number>();
        long total = 0L;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : nextRest.getResource()) {
                List exts = nextResource.getExtensionsByUrl("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount");
                if (exts == null || exts.size() <= 0) continue;
                Number nextCount = ((org.hl7.fhir.dstu3.model.DecimalType)((org.hl7.fhir.dstu3.model.Extension)exts.get(0)).getValue()).getValueAsNumber();
                resourceCounts.put((String)nextResource.getTypeElement().getValue(), nextCount);
                total += nextCount.longValue();
            }
        }
        theModel.put((Object)"resourceCounts", resourceCounts);
        if (total > 0L) {
            for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
                Collections.sort(nextRest.getResource(), new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        theModel.put((Object)"requiredParamExtension", (Object)"http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#paramIsRequired");
        theModel.put((Object)"conf", (Object)capabilityStatement);
        return capabilityStatement;
    }

    private IBaseResource loadAndAddConfR4(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        CaptureInterceptor interceptor = new CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        org.hl7.fhir.r4.model.CapabilityStatement capabilityStatement = new org.hl7.fhir.r4.model.CapabilityStatement();
        try {
            capabilityStatement = (org.hl7.fhir.r4.model.CapabilityStatement)client.fetchConformance().ofType(org.hl7.fhir.r4.model.CapabilityStatement.class).execute();
        }
        catch (Exception ex) {
            ourLog.warn("Failed to load conformance statement, error was: {}", (Object)ex.toString());
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to load conformance statement, error was: " + ex.toString(), ex));
        }
        theModel.put((Object)"jsonEncodedConf", (Object)this.getContext(theRequest).newJsonParser().encodeResourceToString((IBaseResource)capabilityStatement));
        HashMap<String, Number> resourceCounts = new HashMap<String, Number>();
        long total = 0L;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : nextRest.getResource()) {
                List exts = nextResource.getExtensionsByUrl("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount");
                if (exts == null || exts.size() <= 0) continue;
                Number nextCount = ((org.hl7.fhir.r4.model.DecimalType)((Extension)exts.get(0)).getValue()).getValueAsNumber();
                resourceCounts.put((String)nextResource.getTypeElement().getValue(), nextCount);
                total += nextCount.longValue();
            }
        }
        theModel.put((Object)"resourceCounts", resourceCounts);
        if (total > 0L) {
            for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
                Collections.sort(nextRest.getResource(), new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        theModel.put((Object)"requiredParamExtension", (Object)"http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#paramIsRequired");
        theModel.put((Object)"conf", (Object)capabilityStatement);
        return capabilityStatement;
    }

    private IBaseResource loadAndAddConfR5(HttpServletRequest theServletRequest, HomeRequest theRequest, ModelMap theModel) {
        CaptureInterceptor interceptor = new CaptureInterceptor();
        GenericClient client = theRequest.newClient(theServletRequest, this.getContext(theRequest), this.myConfig, interceptor);
        CapabilityStatement capabilityStatement = new CapabilityStatement();
        try {
            capabilityStatement = (CapabilityStatement)client.fetchConformance().ofType(CapabilityStatement.class).execute();
        }
        catch (Exception ex) {
            ourLog.warn("Failed to load conformance statement, error was: {}", (Object)ex.toString());
            theModel.put((Object)"errorMsg", (Object)this.toDisplayError("Failed to load conformance statement, error was: " + ex.toString(), ex));
        }
        theModel.put((Object)"jsonEncodedConf", (Object)this.getContext(theRequest).newJsonParser().encodeResourceToString((IBaseResource)capabilityStatement));
        HashMap<String, Number> resourceCounts = new HashMap<String, Number>();
        long total = 0L;
        for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent nextResource : nextRest.getResource()) {
                List exts = nextResource.getExtensionsByUrl("http://hl7api.sourceforge.net/hapi-fhir/res/extdefs.html#resourceCount");
                if (exts == null || exts.size() <= 0) continue;
                Number nextCount = ((DecimalType)((org.hl7.fhir.r5.model.Extension)exts.get(0)).getValue()).getValueAsNumber();
                resourceCounts.put((String)nextResource.getTypeElement().getValue(), nextCount);
                total += nextCount.longValue();
            }
        }
        theModel.put((Object)"resourceCounts", resourceCounts);
        if (total > 0L) {
            for (CapabilityStatement.CapabilityStatementRestComponent nextRest : capabilityStatement.getRest()) {
                Collections.sort(nextRest.getResource(), new /* Unavailable Anonymous Inner Class!! */);
            }
        }
        theModel.put((Object)"requiredParamExtension", (Object)"http://hl7api.sourceforge.net/hapi-fhir/extensions.xml#paramIsRequired");
        theModel.put((Object)"conf", (Object)capabilityStatement);
        return capabilityStatement;
    }

    protected String logPrefix(ModelMap theModel) {
        return "[server=" + theModel.get((Object)"serverId") + "] - ";
    }

    protected FhirContext newContext(FhirVersionEnum version) {
        FhirContext retVal = new FhirContext(version);
        return retVal;
    }

    private String parseNarrative(HomeRequest theRequest, EncodingEnum theCtEnum, String theResultBody) {
        try {
            String retVal;
            IBaseResource par = theCtEnum.newParser(this.getContext(theRequest)).parseResource(theResultBody);
            if (par instanceof IResource) {
                IResource resource = (IResource)par;
                retVal = resource.getText().getDiv().getValueAsString();
            } else {
                retVal = par instanceof IDomainResource ? ((IDomainResource)par).getText().getDivAsString() : null;
            }
            return StringUtils.defaultString(retVal);
        }
        catch (Exception e) {
            ourLog.error("Failed to parse resource", (Throwable)e);
            return "";
        }
    }

    protected String preProcessMessageBody(String theBody) {
        if (theBody == null) {
            return "";
        }
        String retVal = theBody.trim();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < retVal.length(); ++i) {
            char nextChar = retVal.charAt(i);
            char nextCharI = nextChar;
            if (nextCharI == '\ufffd') {
                b.append(' ');
                continue;
            }
            if (nextCharI == '\u00a0') {
                b.append(' ');
                continue;
            }
            if (nextCharI == '\u00c2') {
                b.append(' ');
                continue;
            }
            b.append(nextChar);
        }
        retVal = b.toString();
        return retVal;
    }

    protected void processAndAddLastClientInvocation(GenericClient theClient, ResultType theResultType, ModelMap theModelMap, long theLatency, String outcomeDescription, CaptureInterceptor theInterceptor, HomeRequest theRequest) {
        try {
            IHttpRequest lastRequest = theInterceptor.getLastRequest();
            IHttpResponse lastResponse = theInterceptor.getLastResponse();
            String requestBody = null;
            String requestUrl = null;
            String action = null;
            String resultStatus = null;
            String resultBody = null;
            String mimeType = null;
            ContentType ct = null;
            if (lastRequest != null) {
                requestBody = lastRequest.getRequestBodyFromStream();
                requestUrl = lastRequest.getUri();
                action = lastRequest.getHttpVerbName();
            }
            if (lastResponse != null) {
                resultStatus = "HTTP " + lastResponse.getStatus() + " " + lastResponse.getStatusInfo();
                lastResponse.bufferEntity();
                try (InputStream input = lastResponse.readEntity();){
                    resultBody = IOUtils.toString((InputStream)input, (Charset)Constants.CHARSET_UTF8);
                }
                List ctStrings = lastResponse.getHeaders("Content-Type");
                if (ctStrings != null && !ctStrings.isEmpty()) {
                    ct = ContentType.parse((String)((String)ctStrings.get(0)));
                    mimeType = ct.getMimeType();
                }
            }
            EncodingEnum ctEnum = EncodingEnum.forContentType(mimeType);
            String narrativeString = "";
            StringBuilder resultDescription = new StringBuilder();
            IBaseResource riBundle = null;
            FhirContext context = this.getContext(theRequest);
            if (ctEnum == null) {
                resultDescription.append("Non-FHIR response");
            } else {
                switch (5.$SwitchMap$ca$uhn$fhir$rest$api$EncodingEnum[ctEnum.ordinal()]) {
                    case 1: {
                        if (theResultType == ResultType.RESOURCE) {
                            narrativeString = this.parseNarrative(theRequest, ctEnum, resultBody);
                            resultDescription.append("JSON resource");
                            break;
                        }
                        if (theResultType != ResultType.BUNDLE) break;
                        resultDescription.append("JSON bundle");
                        riBundle = context.newJsonParser().parseResource(resultBody);
                        break;
                    }
                    default: {
                        if (theResultType == ResultType.RESOURCE) {
                            narrativeString = this.parseNarrative(theRequest, ctEnum, resultBody);
                            resultDescription.append("XML resource");
                            break;
                        }
                        if (theResultType != ResultType.BUNDLE) break;
                        resultDescription.append("XML bundle");
                        riBundle = context.newXmlParser().parseResource(resultBody);
                    }
                }
            }
            resultDescription.append(" (").append(StringUtils.defaultString((String)resultBody).length() + " bytes)");
            Header[] requestHeaders = lastRequest != null ? this.applyHeaderFilters(lastRequest.getAllHeaders()) : new Header[]{};
            Header[] responseHeaders = lastResponse != null ? this.applyHeaderFilters(lastResponse.getAllHeaders()) : new Header[]{};
            theModelMap.put((Object)"resultDescription", (Object)resultDescription.toString());
            theModelMap.put((Object)"action", (Object)action);
            theModelMap.put((Object)"ri", (Object)(riBundle instanceof IAnyResource));
            theModelMap.put((Object)"riBundle", (Object)riBundle);
            theModelMap.put((Object)"resultStatus", (Object)resultStatus);
            theModelMap.put((Object)"requestUrl", (Object)requestUrl);
            theModelMap.put((Object)"requestUrlText", (Object)this.formatUrl(theClient.getUrlBase(), requestUrl));
            String requestBodyText = this.format(requestBody, ctEnum);
            theModelMap.put((Object)"requestBody", (Object)requestBodyText);
            String resultBodyText = this.format(resultBody, ctEnum);
            theModelMap.put((Object)"resultBody", (Object)resultBodyText);
            theModelMap.put((Object)"resultBodyIsLong", (Object)(resultBodyText.length() > 1000 ? 1 : 0));
            theModelMap.put((Object)"requestHeaders", (Object)requestHeaders);
            theModelMap.put((Object)"responseHeaders", (Object)responseHeaders);
            theModelMap.put((Object)"narrative", (Object)narrativeString);
            theModelMap.put((Object)"latencyMs", (Object)theLatency);
        }
        catch (Exception e) {
            ourLog.error("Failure during processing", (Throwable)e);
            theModelMap.put((Object)"errorMsg", (Object)this.toDisplayError("Error during processing: " + e.getMessage(), e));
        }
    }

    protected String toDisplayError(String theErrorMsg, Exception theException) {
        return theErrorMsg;
    }

    private static String sanitizeInput(String theString) {
        String retVal = theString;
        if (retVal != null) {
            for (int i = 0; i < retVal.length(); ++i) {
                char nextChar = retVal.charAt(i);
                switch (nextChar) {
                    case '\"': 
                    case '&': 
                    case '\'': 
                    case '/': 
                    case '<': 
                    case '>': {
                        retVal = retVal.replace(nextChar, '_');
                    }
                }
            }
        }
        return retVal;
    }
}

