/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to;

import ca.uhn.fhir.to.mvc.AnnotationMethodHandlerAdapterConfigurer;
import ca.uhn.fhir.to.util.WebUtil;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.thymeleaf.spring5.ISpringTemplateEngine;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.templateresolver.SpringResourceTemplateResolver;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ITemplateResolver;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"ca.uhn.fhir.to"})
public class FhirTesterMvcConfig
extends WebMvcConfigurerAdapter {
    public void addResourceHandlers(ResourceHandlerRegistry theRegistry) {
        WebUtil.webJarAddBoostrap((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddJQuery((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddFontAwesome((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddJSTZ((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddEonasdanBootstrapDatetimepicker((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddMomentJS((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddSelect2((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddAwesomeCheckbox((ResourceHandlerRegistry)theRegistry);
        WebUtil.webJarAddPopperJs((ResourceHandlerRegistry)theRegistry);
        theRegistry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"/css/"});
        theRegistry.addResourceHandler(new String[]{"/fa/**"}).addResourceLocations(new String[]{"/fa/"});
        theRegistry.addResourceHandler(new String[]{"/fonts/**"}).addResourceLocations(new String[]{"/fonts/"});
        theRegistry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"/img/"});
        theRegistry.addResourceHandler(new String[]{"/js/**"}).addResourceLocations(new String[]{"/js/"});
    }

    @Bean
    public SpringResourceTemplateResolver templateResolver() {
        SpringResourceTemplateResolver resolver = new SpringResourceTemplateResolver();
        resolver.setPrefix("/WEB-INF/templates/");
        resolver.setSuffix(".html");
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setCharacterEncoding("UTF-8");
        return resolver;
    }

    @Bean
    public AnnotationMethodHandlerAdapterConfigurer annotationMethodHandlerAdapterConfigurer() {
        return new AnnotationMethodHandlerAdapterConfigurer();
    }

    @Bean
    public ThymeleafViewResolver viewResolver() {
        ThymeleafViewResolver viewResolver = new ThymeleafViewResolver();
        viewResolver.setTemplateEngine((ISpringTemplateEngine)this.templateEngine());
        viewResolver.setCharacterEncoding("UTF-8");
        return viewResolver;
    }

    @Bean
    public SpringTemplateEngine templateEngine() {
        SpringTemplateEngine templateEngine = new SpringTemplateEngine();
        templateEngine.setTemplateResolver((ITemplateResolver)this.templateResolver());
        return templateEngine;
    }
}

