/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.to;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.server.util.ITestingUiClientFactory;
import ca.uhn.fhir.to.TesterConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;

public class TesterConfig {
    private static final Logger ourLog = LoggerFactory.getLogger(TesterConfig.class);
    public static final String SYSPROP_FORCE_SERVERS = "ca.uhn.fhir.to.TesterConfig_SYSPROP_FORCE_SERVERS";
    private ITestingUiClientFactory myClientFactory;
    private LinkedHashMap<String, Boolean> myIdToAllowsApiKey = new LinkedHashMap();
    private LinkedHashMap<String, FhirVersionEnum> myIdToFhirVersion = new LinkedHashMap();
    private LinkedHashMap<String, String> myIdToServerBase = new LinkedHashMap();
    private LinkedHashMap<String, String> myIdToServerName = new LinkedHashMap();
    private boolean myRefuseToFetchThirdPartyUrls = true;
    private List<ServerBuilder> myServerBuilders = new ArrayList();

    public IServerBuilderStep1 addServer() {
        ServerBuilder retVal = new ServerBuilder(this);
        this.myServerBuilders.add(retVal);
        return retVal;
    }

    @PostConstruct
    public void build() {
        for (ServerBuilder next : this.myServerBuilders) {
            Validate.notBlank((CharSequence)next.myId, (String)"Found invalid server configuration - No ID supplied", (Object[])new Object[0]);
            Validate.notNull((Object)next.myVersion, (String)"Found invalid server configuration - No FHIR version supplied", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)next.myBaseUrl, (String)"Found invalid server configuration - No base URL supplied", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)next.myName, (String)"Found invalid server configuration - No name supplied", (Object[])new Object[0]);
            this.myIdToFhirVersion.put(next.myId, next.myVersion);
            this.myIdToServerBase.put(next.myId, next.myBaseUrl);
            this.myIdToServerName.put(next.myId, next.myName);
            this.myIdToAllowsApiKey.put(next.myId, next.myAllowsApiKey);
        }
        this.myServerBuilders.clear();
    }

    public ITestingUiClientFactory getClientFactory() {
        return this.myClientFactory;
    }

    public boolean getDebugTemplatesMode() {
        return true;
    }

    public LinkedHashMap<String, Boolean> getIdToAllowsApiKey() {
        return this.myIdToAllowsApiKey;
    }

    public LinkedHashMap<String, FhirVersionEnum> getIdToFhirVersion() {
        return this.myIdToFhirVersion;
    }

    public LinkedHashMap<String, String> getIdToServerBase() {
        return this.myIdToServerBase;
    }

    public LinkedHashMap<String, String> getIdToServerName() {
        return this.myIdToServerName;
    }

    public boolean isRefuseToFetchThirdPartyUrls() {
        return this.myRefuseToFetchThirdPartyUrls;
    }

    public void setClientFactory(ITestingUiClientFactory theClientFactory) {
        this.myClientFactory = theClientFactory;
    }

    public void setRefuseToFetchThirdPartyUrls(boolean theRefuseToFetchThirdPartyUrls) {
        this.myRefuseToFetchThirdPartyUrls = theRefuseToFetchThirdPartyUrls;
    }

    @Required
    public void setServers(List<String> theServers) {
        List<String> servers = theServers;
        String force = System.getProperty(SYSPROP_FORCE_SERVERS);
        if (StringUtils.isNotBlank((CharSequence)force)) {
            ourLog.warn("Forcing server confirguration because of system property: {}", (Object)force);
            servers = Collections.singletonList(force);
        }
        for (String nextRaw : servers) {
            String[] nextSplit = nextRaw.split(",");
            if (nextSplit.length < 3) {
                throw new IllegalArgumentException(Msg.code((int)195) + "Invalid serveer line '" + nextRaw + "' - Must be comma separated");
            }
            Validate.notBlank((CharSequence)nextSplit[0], (String)"theId can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[1], (String)"theVersion can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[2], (String)"theDisplayName can not be blank", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)nextSplit[3], (String)"theServerBase can not be blank", (Object[])new Object[0]);
            this.myIdToServerName.put(nextSplit[0].trim(), nextSplit[2].trim());
            this.myIdToServerBase.put(nextSplit[0].trim(), nextSplit[3].trim());
            this.myIdToFhirVersion.put(nextSplit[0].trim(), FhirVersionEnum.valueOf((String)nextSplit[1].trim().toUpperCase().replace('.', '_')));
        }
    }
}

