/*
 * Decompiled with CFR 0.152.
 */
package org.fhir.ucum;

import java.util.ArrayList;
import java.util.List;
import org.fhir.ucum.Concept;
import org.fhir.ucum.ConceptKind;
import org.fhir.ucum.Prefix;
import org.fhir.ucum.UcumModel;
import org.fhir.ucum.Unit;

public class Search {
    public List<Concept> doSearch(UcumModel model, ConceptKind kind, String text, boolean isRegex) {
        ArrayList<Concept> concepts = new ArrayList<Concept>();
        if (kind == null || kind == ConceptKind.PREFIX) {
            this.searchPrefixes(concepts, model.getPrefixes(), text, isRegex);
        }
        if (kind == null || kind == ConceptKind.BASEUNIT) {
            this.searchUnits(concepts, model.getBaseUnits(), text, isRegex);
        }
        if (kind == null || kind == ConceptKind.UNIT) {
            this.searchUnits(concepts, model.getDefinedUnits(), text, isRegex);
        }
        return concepts;
    }

    private void searchUnits(List<Concept> concepts, List<? extends Unit> units, String text, boolean isRegex) {
        for (Unit unit : units) {
            if (!this.matchesUnit(unit, text, isRegex)) continue;
            concepts.add(unit);
        }
    }

    private boolean matchesUnit(Unit unit, String text, boolean isRegex) {
        return this.matches(unit.getProperty(), text, isRegex) || this.matchesConcept(unit, text, isRegex);
    }

    private void searchPrefixes(List<Concept> concepts, List<? extends Prefix> prefixes, String text, boolean isRegex) {
        for (Concept concept : prefixes) {
            if (!this.matchesConcept(concept, text, isRegex)) continue;
            concepts.add(concept);
        }
    }

    private boolean matchesConcept(Concept concept, String text, boolean isRegex) {
        for (String name : concept.getNames()) {
            if (!this.matches(name, text, isRegex)) continue;
            return true;
        }
        if (this.matches(concept.getCode(), text, isRegex)) {
            return true;
        }
        if (this.matches(concept.getCodeUC(), text, isRegex)) {
            return true;
        }
        return this.matches(concept.getPrintSymbol(), text, isRegex);
    }

    private boolean matches(String value, String text, boolean isRegex) {
        return value != null && (isRegex && value.matches(text) || !isRegex && value.toLowerCase().contains(text.toLowerCase()));
    }
}

