/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.cache;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.hl7.fhir.utilities.IniFile;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.PackageGenerator;

public class NpmPackage {
    private String path;
    private List<String> folders = new ArrayList<String>();
    private Map<String, byte[]> content = new HashMap<String, byte[]>();
    private JsonObject npm;
    private IniFile cache;

    public NpmPackage(JsonObject npm, Map<String, byte[]> content, List<String> folders) {
        this.path = null;
        this.content = content;
        this.npm = npm;
        this.folders = folders;
    }

    public NpmPackage(String path) throws IOException {
        this.path = path;
        if (path != null) {
            for (String f : this.sorted(new File(path).list())) {
                if (!new File(Utilities.path(path, f)).isDirectory()) continue;
                this.folders.add(f);
            }
            this.npm = (JsonObject)new JsonParser().parse(TextFile.fileToString(Utilities.path(path, "package", "package.json")));
            this.cache = new IniFile(Utilities.path(path, "cache.ini"));
        }
    }

    private List<String> sorted(String[] keys) {
        ArrayList<String> names = new ArrayList<String>();
        for (String s : keys) {
            names.add(s);
        }
        Collections.sort(names);
        return names;
    }

    public static NpmPackage fromZip(InputStream stream, boolean dropRootFolder) throws IOException {
        ZipEntry ze;
        NpmPackage res = new NpmPackage(null);
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            int size;
            byte[] buffer = new byte[2048];
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(bytes, buffer.length);
            while ((size = zip.read(buffer, 0, buffer.length)) != -1) {
                bos.write(buffer, 0, size);
            }
            bos.flush();
            bos.close();
            if (bytes.size() > 0) {
                if (dropRootFolder) {
                    res.content.put(ze.getName().substring(ze.getName().indexOf("/") + 1), bytes.toByteArray());
                } else {
                    res.content.put(ze.getName(), bytes.toByteArray());
                }
            }
            zip.closeEntry();
        }
        zip.close();
        res.npm = (JsonObject)new JsonParser().parse(new String(res.content.get("package/package.json")));
        return res;
    }

    public List<String> list(String folder) throws IOException {
        ArrayList<String> res;
        block3: {
            block2: {
                res = new ArrayList<String>();
                if (this.path == null) break block2;
                File f = new File(Utilities.path(this.path, folder));
                if (!f.exists() || !f.isDirectory()) break block3;
                for (String s : f.list()) {
                    res.add(s);
                }
                break block3;
            }
            for (String s : this.content.keySet()) {
                if (!s.startsWith(folder + "/") || s.substring(folder.length() + 2).contains("/")) continue;
                res.add(s.substring(folder.length() + 1));
            }
        }
        return res;
    }

    public List<String> copyTo(String folder, String dest) throws IOException {
        ArrayList<String> res = new ArrayList<String>();
        if (this.path != null) {
            this.copyToDest(Utilities.path(this.path, folder), Utilities.path(this.path, folder), dest, res);
        } else {
            for (Map.Entry<String, byte[]> e : this.content.entrySet()) {
                if (!e.getKey().startsWith(folder + "/")) continue;
                String s = e.getKey().substring(folder.length() + 1);
                res.add(s);
                String dst = Utilities.path(dest, s);
                String dstDir = Utilities.getDirectoryForFile(dst);
                Utilities.createDirectory(dstDir);
                TextFile.bytesToFile(e.getValue(), dst);
            }
        }
        return res;
    }

    private void copyToDest(String base, String folder, String dest, List<String> res) throws IOException {
        for (File f : new File(folder).listFiles()) {
            if (f.isDirectory()) {
                this.copyToDest(base, f.getAbsolutePath(), Utilities.path(dest, f.getName()), res);
                continue;
            }
            String dst = Utilities.path(dest, f.getName());
            FileUtils.copyFile((File)f, (File)new File(dst), (boolean)true);
            res.add(f.getAbsolutePath().substring(base.length() + 1));
        }
    }

    public InputStream load(String folder, String file) throws IOException {
        if (this.content.containsKey(folder + "/" + file)) {
            return new ByteArrayInputStream(this.content.get(folder + "/" + file));
        }
        File f = new File(Utilities.path(this.path, folder, file));
        if (f.exists()) {
            return new FileInputStream(f);
        }
        throw new IOException("Unable to find the file " + folder + "/" + file + " in the package " + this.name());
    }

    public JsonObject getNpm() {
        return this.npm;
    }

    public String name() {
        return this.npm.get("name").getAsString();
    }

    public String canonical() {
        return this.npm.get("canonical").getAsString();
    }

    public String version() {
        return this.npm.get("version").getAsString();
    }

    public String fhirVersion() {
        if ("hl7.fhir.core".equals(this.npm.get("name").getAsString())) {
            return this.npm.get("version").getAsString();
        }
        return this.npm.getAsJsonObject("dependencies").get("hl7.fhir.core").getAsString();
    }

    public String description() {
        if (this.path != null) {
            return this.path;
        }
        return "memory";
    }

    public boolean isType(PackageGenerator.PackageType template) {
        return template.getCode().equals(this.type());
    }

    public String type() {
        return this.npm.get("type").getAsString();
    }

    public String getPath() {
        return this.path;
    }

    public IniFile getCache() {
        return this.cache;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getWebLocation() {
        if (this.npm.has("url")) {
            return this.npm.get("url").getAsString();
        }
        return this.npm.get("canonical").getAsString();
    }
}

