/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.exceptions.UcumException;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.ucum.BaseUnit;
import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Concept;
import org.hl7.fhir.utilities.ucum.ConceptKind;
import org.hl7.fhir.utilities.ucum.Converter;
import org.hl7.fhir.utilities.ucum.Decimal;
import org.hl7.fhir.utilities.ucum.DefinedUnit;
import org.hl7.fhir.utilities.ucum.DefinitionParser;
import org.hl7.fhir.utilities.ucum.ExpressionComposer;
import org.hl7.fhir.utilities.ucum.ExpressionParser;
import org.hl7.fhir.utilities.ucum.FormalStructureComposer;
import org.hl7.fhir.utilities.ucum.Pair;
import org.hl7.fhir.utilities.ucum.Search;
import org.hl7.fhir.utilities.ucum.Term;
import org.hl7.fhir.utilities.ucum.UcumModel;
import org.hl7.fhir.utilities.ucum.UcumService;
import org.hl7.fhir.utilities.ucum.UcumValidator;
import org.hl7.fhir.utilities.ucum.special.Registry;

public class UcumEssenceService
implements UcumService {
    public static final String UCUM_OID = "2.16.840.1.113883.6.8";
    private UcumModel model;
    private Registry handlers = new Registry();

    public UcumEssenceService(InputStream stream) throws UcumException {
        assert (stream != null) : this.paramError("factory", "stream", "must not be null");
        try {
            this.model = new DefinitionParser().parse(stream);
        }
        catch (Exception e) {
            throw new UcumException(e);
        }
    }

    public UcumEssenceService(String filename) throws UcumException {
        assert (new File(filename).exists()) : this.paramError("factory", "file", "must exist");
        try {
            this.model = new DefinitionParser().parse(filename);
        }
        catch (Exception e) {
            throw new UcumException(e);
        }
    }

    private String paramError(String method, String param, String msg) {
        return this.getClass().getName() + "." + method + "." + param + " is not acceptable: " + msg;
    }

    @Override
    public UcumService.UcumVersionDetails ucumIdentification() {
        return new UcumService.UcumVersionDetails(this.model.getRevisionDate(), this.model.getVersion());
    }

    @Override
    public UcumModel getModel() {
        return this.model;
    }

    @Override
    public List<Concept> search(ConceptKind kind, String text, boolean isRegex) {
        assert (this.checkStringParam(text)) : this.paramError("search", "text", "must not be null or empty");
        return new Search().doSearch(this.model, kind, text, isRegex);
    }

    @Override
    public List<String> validateUCUM() {
        return new UcumValidator(this.model, this.handlers).validate();
    }

    @Override
    public Set<String> getProperties() {
        HashSet<String> result = new HashSet<String>();
        for (DefinedUnit unit : this.model.getDefinedUnits()) {
            result.add(unit.getProperty());
        }
        return result;
    }

    @Override
    public String validate(String unit) {
        assert (unit != null) : this.paramError("validate", "unit", "must not be null");
        try {
            new ExpressionParser(this.model).parse(unit);
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String validateInProperty(String unit, String property) {
        assert (this.checkStringParam(unit)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(property)) : this.paramError("validateInProperty", "property", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(unit);
            Canonical can = new Converter(this.model, this.handlers).convert(term);
            String cu = new ExpressionComposer().compose(can, false);
            if (can.getUnits().size() == 1) {
                if (property.equals(can.getUnits().get(0).getBase().getProperty())) {
                    return null;
                }
                return "unit " + unit + " is of the property type " + can.getUnits().get(0).getBase().getProperty() + " (" + cu + "), not " + property + " as required.";
            }
            if ("concentration".equals(property) && ("g/L".equals(cu) || "mol/L".equals(cu))) {
                return null;
            }
            return "unit " + unit + " has the base units " + cu + ", and are not from the property " + property + " as required.";
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String validateCanonicalUnits(String unit, String canonical) {
        assert (this.checkStringParam(unit)) : this.paramError("validate", "unit", "must not be null or empty");
        assert (this.checkStringParam(canonical)) : this.paramError("validateCanonicalUnits", "canonical", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(unit);
            Canonical can = new Converter(this.model, this.handlers).convert(term);
            String cu = new ExpressionComposer().compose(can, false);
            if (!canonical.equals(cu)) {
                return "unit " + unit + " has the base units " + cu + ", not " + canonical + " as required.";
            }
            return null;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public String analyse(String unit) throws UcumException {
        if (Utilities.noString(unit)) {
            return "(unity)";
        }
        assert (this.checkStringParam(unit)) : this.paramError("analyse", "unit", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse(unit);
        return new FormalStructureComposer().compose(term);
    }

    @Override
    public String getCanonicalUnits(String unit) throws UcumException {
        assert (this.checkStringParam(unit)) : this.paramError("getCanonicalUnits", "unit", "must not be null or empty");
        try {
            Term term = new ExpressionParser(this.model).parse(unit);
            return new ExpressionComposer().compose(new Converter(this.model, this.handlers).convert(term), false);
        }
        catch (Exception e) {
            throw new UcumException("Error processing " + unit + ": " + e.getMessage(), e);
        }
    }

    @Override
    public List<DefinedUnit> getDefinedForms(String code) throws UcumException {
        assert (this.checkStringParam(code)) : this.paramError("getDefinedForms", "code", "must not be null or empty");
        ArrayList<DefinedUnit> result = new ArrayList<DefinedUnit>();
        BaseUnit base = this.model.getBaseUnit(code);
        if (base != null) {
            for (DefinedUnit unit : this.model.getDefinedUnits()) {
                if (unit.isSpecial() || !code.equals(this.getCanonicalUnits(unit.getCode()))) continue;
                result.add(unit);
            }
        }
        return result;
    }

    private boolean checkStringParam(String s) {
        return s != null && !s.equals("");
    }

    @Override
    public Pair getCanonicalForm(Pair value) throws UcumException {
        assert (value != null) : this.paramError("getCanonicalForm", "value", "must not be null");
        assert (this.checkStringParam(value.getCode())) : this.paramError("getCanonicalForm", "value.code", "must not be null or empty");
        Term term = new ExpressionParser(this.model).parse(value.getCode());
        Canonical c = new Converter(this.model, this.handlers).convert(term);
        if (value.getValue() == null) {
            return new Pair(null, new ExpressionComposer().compose(c, false));
        }
        return new Pair(value.getValue().multiply(c.getValue()), new ExpressionComposer().compose(c, false));
    }

    @Override
    public Decimal convert(Decimal value, String sourceUnit, String destUnit) throws UcumException {
        String d;
        assert (value != null) : this.paramError("convert", "value", "must not be null");
        assert (this.checkStringParam(sourceUnit)) : this.paramError("convert", "sourceUnit", "must not be null or empty");
        assert (this.checkStringParam(destUnit)) : this.paramError("convert", "destUnit", "must not be null or empty");
        if (sourceUnit.equals(destUnit)) {
            return value;
        }
        Canonical src = new Converter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(sourceUnit));
        Canonical dst = new Converter(this.model, this.handlers).convert(new ExpressionParser(this.model).parse(destUnit));
        String s = new ExpressionComposer().compose(src, false);
        if (!s.equals(d = new ExpressionComposer().compose(dst, false))) {
            throw new UcumException("Unable to convert between units " + sourceUnit + " and " + destUnit + " as they do not have matching canonical forms (" + s + " and " + d + " respectively)");
        }
        Decimal canValue = value.multiply(src.getValue());
        return canValue.divide(dst.getValue());
    }

    @Override
    public Pair multiply(Pair o1, Pair o2) throws UcumException {
        Pair res = new Pair(o1.getValue().multiply(o2.getValue()), o1.getCode() + "." + o2.getCode());
        return this.getCanonicalForm(res);
    }

    @Override
    public String getCommonDisplay(String code) {
        return code.replace("[", "").replace("]", "");
    }

    @Override
    public boolean isComparable(String units1, String units2) throws UcumException {
        if (units1 == null) {
            return false;
        }
        if (units2 == null) {
            return false;
        }
        String u1 = this.getCanonicalUnits(units1);
        String u2 = this.getCanonicalUnits(units2);
        return u1.equals(u2);
    }
}

