/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.common.hapi.validation.ValidatorWrapper;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.DefaultProfileValidationSupport;
import org.hl7.fhir.dstu3.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.dstu3.hapi.ctx.IValidationSupport;
import org.hl7.fhir.dstu3.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.dstu3.model.CodeSystem;
import org.hl7.fhir.dstu3.model.ImplementationGuide;
import org.hl7.fhir.dstu3.model.Questionnaire;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.dstu3.terminologies.ValueSetExpander;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IInstanceValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirInstanceValidator.class);
    private boolean myAnyExtensionsAllowed = true;
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private StructureDefinition myStructureDefintion;
    private IValidationSupport myValidationSupport;
    private boolean noTerminologyChecks = false;
    private volatile WorkerContextWrapper myWrappedWorkerContext;
    private boolean errorForUnknownProfiles;
    private List<String> myExtensionDomains = Collections.emptyList();

    public FhirInstanceValidator() {
        this((IValidationSupport)new DefaultProfileValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    public FhirInstanceValidator setCustomExtensionDomains(List<String> extensionDomains) {
        this.myExtensionDomains = extensionDomains;
        return this;
    }

    public FhirInstanceValidator setCustomExtensionDomains(String ... extensionDomains) {
        this.myExtensionDomains = Arrays.asList(extensionDomains);
        return this;
    }

    private String determineResourceName(Document theDocument) {
        NodeList list = theDocument.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            return list.item(i).getLocalName();
        }
        return theDocument.getDocumentElement().getLocalName();
    }

    private ArrayList<String> determineIfProfilesSpecified(Document theDocument) {
        ArrayList<String> profileNames = new ArrayList<String>();
        NodeList list = theDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().compareToIgnoreCase("meta") != 0) continue;
            NodeList metaList = list.item(i).getChildNodes();
            for (int j = 0; j < metaList.getLength(); ++j) {
                if (metaList.item(j).getNodeName().compareToIgnoreCase("profile") != 0) continue;
                profileNames.add(metaList.item(j).getAttributes().item(0).getNodeValue());
            }
            break;
        }
        return profileNames;
    }

    private StructureDefinition findStructureDefinitionForResourceName(FhirContext theCtx, String resourceName) {
        String sdName = null;
        try {
            URL testIfUrl = new URL(resourceName);
            sdName = resourceName;
        }
        catch (MalformedURLException e) {
            sdName = "http://hl7.org/fhir/StructureDefinition/" + resourceName;
        }
        StructureDefinition profile = this.myStructureDefintion != null ? this.myStructureDefintion : this.myValidationSupport.fetchStructureDefinition(theCtx, sdName);
        return profile;
    }

    public void flushCaches() {
        this.myWrappedWorkerContext = null;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        this.myWrappedWorkerContext = null;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isErrorForUnknownProfiles() {
        return this.errorForUnknownProfiles;
    }

    public void setErrorForUnknownProfiles(boolean errorForUnknownProfiles) {
        this.errorForUnknownProfiles = errorForUnknownProfiles;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.noTerminologyChecks = theNoTerminologyChecks;
    }

    public void setStructureDefintion(StructureDefinition theStructureDefintion) {
        this.myStructureDefintion = theStructureDefintion;
    }

    private List<String> getExtensionDomains() {
        return this.myExtensionDomains;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theValidationCtx) {
        FhirContext ctx = theValidationCtx.getFhirContext();
        WorkerContextWrapper wrappedWorkerContext = this.myWrappedWorkerContext;
        if (wrappedWorkerContext == null) {
            HapiWorkerContext workerContext = new HapiWorkerContext(ctx, this.myValidationSupport);
            wrappedWorkerContext = new WorkerContextWrapper(workerContext);
        }
        this.myWrappedWorkerContext = wrappedWorkerContext;
        return new ValidatorWrapper().setAnyExtensionsAllowed(this.isAnyExtensionsAllowed()).setBestPracticeWarningLevel(this.getBestPracticeWarningLevel()).setErrorForUnknownProfiles(this.isErrorForUnknownProfiles()).setExtensionDomains(this.getExtensionDomains()).setNoTerminologyChecks(this.isNoTerminologyChecks()).validate(wrappedWorkerContext, theValidationCtx);
    }

    private static class ResourceKey {
        private final int myHashCode;
        private String myResourceName;
        private String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    private static class WorkerContextWrapper
    implements IWorkerContext {
        private final HapiWorkerContext myWrap;
        private final VersionConvertor_30_50 myConverter;
        private volatile List<org.hl7.fhir.r5.model.StructureDefinition> myAllStructures;
        private LoadingCache<ResourceKey, Resource> myFetchResourceCache;
        private Parameters myExpansionProfile;

        WorkerContextWrapper(HapiWorkerContext theWorkerContext) {
            this.myWrap = theWorkerContext;
            this.myConverter = new VersionConvertor_30_50();
            long timeoutMillis = 10000L;
            if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
                timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
            }
            this.myFetchResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).maximumSize(10000L).build(key -> {
                org.hl7.fhir.dstu3.model.Resource fetched;
                switch (key.getResourceName()) {
                    case "StructureDefinition": {
                        fetched = this.myWrap.fetchResource(StructureDefinition.class, key.getUri());
                        break;
                    }
                    case "ValueSet": {
                        fetched = this.myWrap.fetchResource(ValueSet.class, key.getUri());
                        break;
                    }
                    case "CodeSystem": {
                        fetched = this.myWrap.fetchResource(CodeSystem.class, key.getUri());
                        break;
                    }
                    case "Questionnaire": {
                        fetched = this.myWrap.fetchResource(Questionnaire.class, key.getUri());
                        break;
                    }
                    case "ImplementationGuide": {
                        fetched = this.myWrap.fetchResource(ImplementationGuide.class, key.getUri());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't know how to fetch " + key.getResourceName());
                    }
                }
                if (fetched == null) {
                    return null;
                }
                try {
                    return VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)fetched, (boolean)true);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            });
        }

        public List<MetadataResource> allConformanceResources() {
            throw new UnsupportedOperationException();
        }

        public String getLinkForUrl(String corePath, String url) {
            throw new UnsupportedOperationException();
        }

        public void generateSnapshot(org.hl7.fhir.r5.model.StructureDefinition p) throws FHIRException {
        }

        public Parameters getExpansionParameters() {
            return this.myExpansionProfile;
        }

        public void setExpansionProfile(Parameters expParameters) {
            this.myExpansionProfile = expParameters;
        }

        public List<org.hl7.fhir.r5.model.StructureDefinition> allStructures() {
            List<org.hl7.fhir.r5.model.StructureDefinition> retVal = this.myAllStructures;
            if (retVal == null) {
                retVal = new ArrayList<org.hl7.fhir.r5.model.StructureDefinition>();
                for (StructureDefinition next : this.myWrap.allStructures()) {
                    try {
                        retVal.add(VersionConvertor_30_50.convertStructureDefinition((StructureDefinition)next));
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                this.myAllStructures = retVal;
            }
            return retVal;
        }

        public List<org.hl7.fhir.r5.model.StructureDefinition> getStructures() {
            return this.allStructures();
        }

        public void cacheResource(Resource res) {
            throw new UnsupportedOperationException();
        }

        @Nonnull
        private IWorkerContext.ValidationResult convertValidationResult(@Nullable IWorkerContext.ValidationResult theResult) {
            IWorkerContext.ValidationResult retVal = null;
            if (theResult != null) {
                ValidationMessage.IssueSeverity issueSeverity = theResult.getSeverity();
                String message = theResult.getMessage();
                CodeSystem.ConceptDefinitionComponent conceptDefinition = null;
                if (theResult.asConceptDefinition() != null) {
                    try {
                        conceptDefinition = VersionConvertor_30_50.convertConceptDefinitionComponent((CodeSystem.ConceptDefinitionComponent)theResult.asConceptDefinition());
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                retVal = new IWorkerContext.ValidationResult(issueSeverity, message, conceptDefinition);
            }
            if (retVal == null) {
                retVal = new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Validation failed");
            }
            return retVal;
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(org.hl7.fhir.r5.model.ValueSet source, boolean cacheOk, boolean heiarchical) {
            ValueSet convertedSource;
            try {
                convertedSource = VersionConvertor_30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)source);
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            ValueSetExpander.ValueSetExpansionOutcome expanded = this.myWrap.expandVS(convertedSource, cacheOk, heiarchical);
            org.hl7.fhir.r5.model.ValueSet convertedResult = null;
            if (expanded.getValueset() != null) {
                try {
                    convertedResult = VersionConvertor_30_50.convertValueSet((ValueSet)expanded.getValueset());
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            String error = expanded.getError();
            ValueSetExpander.TerminologyServiceErrorClass result = null;
            return new ValueSetExpander.ValueSetExpansionOutcome(convertedResult, error, result);
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heiarchical) {
            throw new UnsupportedOperationException();
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirarchical) throws TerminologyServiceException {
            ValueSet.ConceptSetComponent convertedInc = null;
            if (inc != null) {
                try {
                    convertedInc = VersionConvertor_30_50.convertConceptSetComponent((ValueSet.ConceptSetComponent)inc);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSet.ValueSetExpansionComponent expansion = this.myWrap.expandVS(convertedInc, heirarchical);
            ValueSet.ValueSetExpansionComponent valueSetExpansionComponent = null;
            if (expansion != null) {
                try {
                    valueSetExpansionComponent = VersionConvertor_30_50.convertValueSetExpansionComponent((ValueSet.ValueSetExpansionComponent)expansion);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSetExpander.ValueSetExpansionOutcome outcome = new ValueSetExpander.ValueSetExpansionOutcome(new org.hl7.fhir.r5.model.ValueSet());
            outcome.getValueset().setExpansion(valueSetExpansionComponent);
            return outcome;
        }

        public org.hl7.fhir.r5.model.CodeSystem fetchCodeSystem(String system) {
            CodeSystem fetched = this.myWrap.fetchCodeSystem(system);
            if (fetched == null) {
                return null;
            }
            try {
                return VersionConvertor_30_50.convertCodeSystem((CodeSystem)fetched);
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
        }

        public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
            ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
            Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
            return (T)retVal;
        }

        public Resource fetchResourceById(String type, String uri) {
            throw new UnsupportedOperationException();
        }

        public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
            T retVal = this.fetchResource(class_, uri);
            if (retVal == null) {
                throw new FHIRException("Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
            }
            return retVal;
        }

        public List<ConceptMap> findMapsForSource(String url) {
            throw new UnsupportedOperationException();
        }

        public String getAbbreviation(String name) {
            return this.myWrap.getAbbreviation(name);
        }

        public VersionConvertor_30_50 getConverter() {
            return this.myConverter;
        }

        public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(ParserType type) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(String type) {
            throw new UnsupportedOperationException();
        }

        public List<String> getResourceNames() {
            return this.myWrap.getResourceNames();
        }

        public Set<String> getResourceNamesAsSet() {
            return new HashSet<String>(this.myWrap.getResourceNames());
        }

        public StructureMap getTransform(String url) {
            throw new UnsupportedOperationException();
        }

        public String getOverrideVersionNs() {
            return null;
        }

        public void setOverrideVersionNs(String value) {
        }

        public org.hl7.fhir.r5.model.StructureDefinition fetchTypeDefinition(String typeName) {
            return this.fetchResource(org.hl7.fhir.r5.model.StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
        }

        public List<String> getTypeNames() {
            return this.myWrap.getTypeNames();
        }

        public UcumService getUcumService() {
            throw new UnsupportedOperationException();
        }

        public void setUcumService(UcumService ucumService) {
            throw new UnsupportedOperationException();
        }

        public String getVersion() {
            return this.myWrap.getVersion();
        }

        public boolean hasCache() {
            return this.myWrap.hasCache();
        }

        public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
            throw new UnsupportedOperationException();
        }

        public boolean isNoTerminologyServer() {
            return this.myWrap.isNoTerminologyServer();
        }

        public List<StructureMap> listTransforms() {
            throw new UnsupportedOperationException();
        }

        public IParser newJsonParser() {
            throw new UnsupportedOperationException();
        }

        public IResourceValidator newValidator() {
            throw new UnsupportedOperationException();
        }

        public IParser newXmlParser() {
            throw new UnsupportedOperationException();
        }

        public String oid2Uri(String code) {
            return this.myWrap.oid2Uri(code);
        }

        public IWorkerContext.ILoggingService getLogger() {
            return null;
        }

        public void setLogger(IWorkerContext.ILoggingService logger) {
            throw new UnsupportedOperationException();
        }

        public boolean supportsSystem(String system) {
            return this.myWrap.supportsSystem(system);
        }

        public TranslationServices translator() {
            throw new UnsupportedOperationException();
        }

        public Set<String> typeTails() {
            return this.myWrap.typeTails();
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display) {
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, org.hl7.fhir.r5.model.ValueSet vs) {
            ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    convertedVs = VersionConvertor_30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String code, org.hl7.fhir.r5.model.ValueSet vs) {
            ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    convertedVs = VersionConvertor_30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(Constants.CODESYSTEM_VALIDATE_NOT_NEEDED, code, null, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, Coding code, org.hl7.fhir.r5.model.ValueSet vs) {
            org.hl7.fhir.dstu3.model.Coding convertedCode = null;
            ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = VersionConvertor_30_50.convertCoding((Coding)code);
                }
                if (vs != null) {
                    convertedVs = VersionConvertor_30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, CodeableConcept code, org.hl7.fhir.r5.model.ValueSet vs) {
            org.hl7.fhir.dstu3.model.CodeableConcept convertedCode = null;
            ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = VersionConvertor_30_50.convertCodeableConcept((CodeableConcept)code);
                }
                if (vs != null) {
                    convertedVs = VersionConvertor_30_50.convertValueSet((org.hl7.fhir.r5.model.ValueSet)vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
            ValueSet.ConceptSetComponent conceptSetComponent = null;
            if (vsi != null) {
                try {
                    conceptSetComponent = VersionConvertor_30_50.convertConceptSetComponent((ValueSet.ConceptSetComponent)vsi);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display, conceptSetComponent);
            return this.convertValidationResult(result);
        }
    }
}

