/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.XmlUtil;
import ca.uhn.fhir.validation.IInstanceValidatorModule;
import ca.uhn.fhir.validation.IValidationContext;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.converter.NullVersionConverterAdvisor50;
import org.hl7.fhir.convertors.VersionConvertorAdvisor50;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.hapi.validation.BaseValidatorBridge;
import org.hl7.fhir.instance.hapi.validation.DefaultProfileValidationSupport;
import org.hl7.fhir.instance.hapi.validation.HapiWorkerContext;
import org.hl7.fhir.instance.hapi.validation.IValidationSupport;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.hapi.validation.FhirInstanceValidator;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.MetadataResource;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.r5.validation.InstanceValidator;
import org.hl7.fhir.utilities.TerminologyServiceOptions;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FhirInstanceValidator
extends BaseValidatorBridge
implements IInstanceValidatorModule {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirInstanceValidator.class);
    private static final FhirContext FHIR_CONTEXT = FhirContext.forDstu2();
    private static FhirContext ourHl7OrgCtx;
    private boolean myAnyExtensionsAllowed = true;
    private IResourceValidator.BestPracticeWarningLevel myBestPracticeWarningLevel;
    private StructureDefinition myStructureDefintion;
    private IValidationSupport myValidationSupport;
    private boolean noTerminologyChecks = false;
    private volatile WorkerContextWrapper myWrappedWorkerContext;
    private VersionConvertorAdvisor50 myAdvisor = new NullVersionConverterAdvisor50();

    public FhirInstanceValidator() {
        this(new DefaultProfileValidationSupport());
    }

    public FhirInstanceValidator(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    private CodeSystem convertCodeSystem(org.hl7.fhir.dstu2.model.ValueSet theFetched) {
        CodeSystem retVal = new CodeSystem();
        retVal.setUrl(theFetched.getCodeSystem().getSystem());
        retVal.setVersion(theFetched.getVersion());
        List sourceConceptList = theFetched.getCodeSystem().getConcept();
        List targetConceptList = retVal.getConcept();
        this.convertConceptList(sourceConceptList, targetConceptList);
        return retVal;
    }

    private CodeSystem.ConceptDefinitionComponent convertConceptDefinition(ValueSet.ConceptDefinitionComponent next) {
        CodeSystem.ConceptDefinitionComponent convertedConceptDef = new CodeSystem.ConceptDefinitionComponent();
        convertedConceptDef.setCode(next.getCode());
        convertedConceptDef.setDisplay(next.getDisplay());
        this.convertConceptList(next.getConcept(), convertedConceptDef.getConcept());
        return convertedConceptDef;
    }

    private void convertConceptList(List<ValueSet.ConceptDefinitionComponent> theSourceConceptList, List<CodeSystem.ConceptDefinitionComponent> theTargetConceptList) {
        for (ValueSet.ConceptDefinitionComponent next : theSourceConceptList) {
            CodeSystem.ConceptDefinitionComponent convertedConceptDef = this.convertConceptDefinition(next);
            theTargetConceptList.add(convertedConceptDef);
        }
    }

    private String determineResourceName(Document theDocument) {
        Element root = null;
        NodeList list = theDocument.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (!(list.item(i) instanceof Element)) continue;
            root = (Element)list.item(i);
            break;
        }
        root = theDocument.getDocumentElement();
        return root.getLocalName();
    }

    private ArrayList<String> determineIfProfilesSpecified(Document theDocument) {
        ArrayList<String> profileNames = new ArrayList<String>();
        NodeList list = theDocument.getChildNodes().item(0).getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            if (list.item(i).getNodeName().compareToIgnoreCase("meta") != 0) continue;
            NodeList metaList = list.item(i).getChildNodes();
            for (int j = 0; j < metaList.getLength(); ++j) {
                if (metaList.item(j).getNodeName().compareToIgnoreCase("profile") != 0) continue;
                profileNames.add(metaList.item(j).getAttributes().item(0).getNodeValue());
            }
            break;
        }
        return profileNames;
    }

    private StructureDefinition findStructureDefinitionForResourceName(FhirContext theCtx, String resourceName) {
        String sdName = null;
        try {
            URL testIfUrl = new URL(resourceName);
            sdName = resourceName;
        }
        catch (MalformedURLException e) {
            sdName = "http://hl7.org/fhir/StructureDefinition/" + resourceName;
        }
        StructureDefinition profile = this.myStructureDefintion != null ? this.myStructureDefintion : this.myValidationSupport.fetchResource(theCtx, StructureDefinition.class, sdName);
        return profile;
    }

    public IResourceValidator.BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.myBestPracticeWarningLevel;
    }

    public void setBestPracticeWarningLevel(IResourceValidator.BestPracticeWarningLevel theBestPracticeWarningLevel) {
        Validate.notNull((Object)theBestPracticeWarningLevel);
        this.myBestPracticeWarningLevel = theBestPracticeWarningLevel;
    }

    public IValidationSupport getValidationSupport() {
        return this.myValidationSupport;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
        this.myWrappedWorkerContext = null;
    }

    public boolean isAnyExtensionsAllowed() {
        return this.myAnyExtensionsAllowed;
    }

    public void setAnyExtensionsAllowed(boolean theAnyExtensionsAllowed) {
        this.myAnyExtensionsAllowed = theAnyExtensionsAllowed;
    }

    public boolean isNoTerminologyChecks() {
        return this.noTerminologyChecks;
    }

    public void setNoTerminologyChecks(boolean theNoTerminologyChecks) {
        this.noTerminologyChecks = theNoTerminologyChecks;
    }

    public void setStructureDefintion(StructureDefinition theStructureDefintion) {
        this.myStructureDefintion = theStructureDefintion;
    }

    protected List<ValidationMessage> validate(FhirContext theCtx, String theInput, EncodingEnum theEncoding) {
        InstanceValidator v;
        WorkerContextWrapper wrappedWorkerContext = this.myWrappedWorkerContext;
        if (wrappedWorkerContext == null) {
            HapiWorkerContext workerContext = new HapiWorkerContext(theCtx, this.myValidationSupport);
            wrappedWorkerContext = new WorkerContextWrapper(workerContext);
        }
        this.myWrappedWorkerContext = wrappedWorkerContext;
        FhirInstanceValidator.NullEvaluationContext evaluationCtx = new FhirInstanceValidator.NullEvaluationContext();
        try {
            v = new InstanceValidator((IWorkerContext)wrappedWorkerContext, (FHIRPathEngine.IEvaluationContext)evaluationCtx);
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
        v.setBestPracticeWarningLevel(this.getBestPracticeWarningLevel());
        v.setAnyExtensionsAllowed(this.isAnyExtensionsAllowed());
        v.setResourceIdRule(IResourceValidator.IdStatus.OPTIONAL);
        v.setNoTerminologyChecks(this.isNoTerminologyChecks());
        ArrayList<ValidationMessage> messages = new ArrayList<ValidationMessage>();
        if (theEncoding == EncodingEnum.XML) {
            Document document;
            try {
                document = XmlUtil.parseDocument((String)theInput);
            }
            catch (Exception e2) {
                ourLog.error("Failure to parse XML input", (Throwable)e2);
                ValidationMessage m = new ValidationMessage();
                m.setLevel(ValidationMessage.IssueSeverity.FATAL);
                m.setMessage("Failed to parse input, it does not appear to be valid XML:" + e2.getMessage());
                return Collections.singletonList(m);
            }
            ArrayList<String> resourceNames = this.determineIfProfilesSpecified(document);
            if (resourceNames.isEmpty()) {
                resourceNames.add(this.determineResourceName(document));
            }
            for (String resourceName : resourceNames) {
                Object profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
                if (profile != null) {
                    try {
                        v.validate(null, messages, document, profile.getUrl());
                        continue;
                    }
                    catch (Exception e) {
                        ourLog.error("Failure during validation", (Throwable)e);
                        throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                    }
                }
                profile = this.findStructureDefinitionForResourceName(theCtx, this.determineResourceName(document));
                if (profile == null) continue;
                try {
                    v.validate(null, messages, document, profile.getUrl());
                }
                catch (Exception e) {
                    ourLog.error("Failure during validation", (Throwable)e);
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else if (theEncoding == EncodingEnum.JSON) {
            Gson gson = new GsonBuilder().create();
            JsonObject json = (JsonObject)gson.fromJson(theInput, JsonObject.class);
            ArrayList<String> resourceNames = new ArrayList<String>();
            JsonArray profiles = null;
            try {
                profiles = json.getAsJsonObject("meta").getAsJsonArray("profile");
                for (JsonElement element : profiles) {
                    resourceNames.add(element.getAsString());
                }
            }
            catch (Exception e) {
                resourceNames.add(json.get("resourceType").getAsString());
            }
            for (String resourceName : resourceNames) {
                StructureDefinition profile = this.findStructureDefinitionForResourceName(theCtx, resourceName);
                if (profile != null) {
                    try {
                        v.validate(null, messages, json, profile.getUrl());
                        continue;
                    }
                    catch (Exception e) {
                        throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                    }
                }
                profile = this.findStructureDefinitionForResourceName(theCtx, json.get("resourceType").getAsString());
                if (profile == null) continue;
                try {
                    v.validate(null, messages, json, profile.getUrl());
                }
                catch (Exception e) {
                    ourLog.error("Failure during validation", (Throwable)e);
                    throw new InternalErrorException("Unexpected failure while validating resource", (Throwable)e);
                }
            }
        } else {
            throw new IllegalArgumentException("Unknown encoding: " + theEncoding);
        }
        for (int i = 0; i < messages.size(); ++i) {
            ValidationMessage next = (ValidationMessage)messages.get(i);
            if ("Binding has no source, so can't be checked".equals(next.getMessage())) {
                messages.remove(i);
                --i;
            }
            if (!next.getLocation().contains("text")) continue;
            messages.remove(i);
            --i;
        }
        return messages;
    }

    @Override
    protected List<ValidationMessage> validate(IValidationContext<?> theCtx) {
        return this.validate(theCtx.getFhirContext(), theCtx.getResourceAsString(), theCtx.getResourceAsStringEncoding());
    }

    static FhirContext getHl7OrgDstu2Ctx(FhirContext theCtx) {
        if (theCtx.getVersion().getVersion() == FhirVersionEnum.DSTU2_HL7ORG) {
            return theCtx;
        }
        FhirContext retVal = ourHl7OrgCtx;
        if (retVal == null) {
            ourHl7OrgCtx = retVal = FhirContext.forDstu2Hl7Org();
        }
        return retVal;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static StructureDefinition loadProfileOrReturnNull(List<ValidationMessage> theMessages, FhirContext theCtx, String theResourceName) {
        if (StringUtils.isBlank((CharSequence)theResourceName)) {
            if (theMessages == null) return null;
            theMessages.add(new ValidationMessage().setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("Could not determine resource type from request. Content appears invalid."));
            return null;
        }
        String profileClasspath = theCtx.getVersion().getPathToSchemaDefinitions().replace("/schema", "/profile");
        String profileCpName = profileClasspath + '/' + theResourceName.toLowerCase() + ".profile.xml";
        try (InputStream inputStream = FhirInstanceValidator.class.getResourceAsStream(profileCpName);){
            if (inputStream == null) {
                if (theMessages != null) {
                    theMessages.add(new ValidationMessage().setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("No profile found for resource type " + theResourceName));
                    StructureDefinition structureDefinition = null;
                    return structureDefinition;
                }
                StructureDefinition structureDefinition = null;
                return structureDefinition;
            }
            String profileText = IOUtils.toString((InputStream)inputStream, (String)"UTF-8");
            return (StructureDefinition)FhirInstanceValidator.getHl7OrgDstu2Ctx(theCtx).newXmlParser().parseResource(StructureDefinition.class, profileText);
        }
        catch (IOException e1) {
            if (theMessages == null) return null;
            theMessages.add(new ValidationMessage().setLevel(ValidationMessage.IssueSeverity.FATAL).setMessage("No profile found for resource type " + theResourceName));
            return null;
        }
    }

    private static class ResourceKey {
        private final int myHashCode;
        private String myResourceName;
        private String myUri;

        private ResourceKey(String theResourceName, String theUri) {
            this.myResourceName = theResourceName;
            this.myUri = theUri;
            this.myHashCode = new HashCodeBuilder(17, 37).append((Object)this.myResourceName).append((Object)this.myUri).toHashCode();
        }

        public boolean equals(Object theO) {
            if (this == theO) {
                return true;
            }
            if (theO == null || this.getClass() != theO.getClass()) {
                return false;
            }
            ResourceKey that = (ResourceKey)theO;
            return new EqualsBuilder().append((Object)this.myResourceName, (Object)that.myResourceName).append((Object)this.myUri, (Object)that.myUri).isEquals();
        }

        public String getResourceName() {
            return this.myResourceName;
        }

        public String getUri() {
            return this.myUri;
        }

        public int hashCode() {
            return this.myHashCode;
        }
    }

    private class WorkerContextWrapper
    implements IWorkerContext {
        private final HapiWorkerContext myWrap;
        private final VersionConvertor_10_50 myConverter;
        private volatile List<org.hl7.fhir.r5.model.StructureDefinition> myAllStructures;
        private LoadingCache<ResourceKey, Resource> myFetchResourceCache = Caffeine.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).maximumSize(10000L).build((CacheLoader)new CacheLoader<ResourceKey, Resource>(){

            public Resource load(ResourceKey key) throws Exception {
                StructureDefinition fetched;
                switch (key.getResourceName()) {
                    case "StructureDefinition": {
                        fetched = WorkerContextWrapper.this.myWrap.fetchResource(StructureDefinition.class, key.getUri());
                        break;
                    }
                    case "ValueSet": {
                        fetched = WorkerContextWrapper.this.myWrap.fetchResource(org.hl7.fhir.dstu2.model.ValueSet.class, key.getUri());
                        break;
                    }
                    case "CodeSystem": {
                        fetched = WorkerContextWrapper.this.myWrap.fetchResource(org.hl7.fhir.dstu2.model.ValueSet.class, key.getUri());
                        break;
                    }
                    case "Questionnaire": {
                        fetched = WorkerContextWrapper.this.myWrap.fetchResource(Questionnaire.class, key.getUri());
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Don't know how to fetch " + key.getResourceName());
                    }
                }
                if (fetched == null && key.getUri().equals("http://hl7.org/fhir/StructureDefinition/xhtml")) {
                    return null;
                }
                try {
                    BaseRuntimeElementDefinition element;
                    StructureDefinition fetchedSd;
                    StructureDefinition.StructureDefinitionKind kind;
                    Resource converted = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertResource((org.hl7.fhir.dstu2.model.Resource)fetched);
                    if (fetched instanceof StructureDefinition && (kind = (fetchedSd = fetched).getKind()) == StructureDefinition.StructureDefinitionKind.DATATYPE && (element = FHIR_CONTEXT.getElementDefinition(fetchedSd.getName())) instanceof RuntimePrimitiveDatatypeDefinition) {
                        org.hl7.fhir.r5.model.StructureDefinition convertedSd = (org.hl7.fhir.r5.model.StructureDefinition)converted;
                        convertedSd.setKind(StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                    }
                    return converted;
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
        });
        private Parameters myExpansionProfile;

        public WorkerContextWrapper(HapiWorkerContext theWorkerContext) {
            this.myWrap = theWorkerContext;
            this.myConverter = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor);
        }

        public List<MetadataResource> allConformanceResources() {
            throw new UnsupportedOperationException();
        }

        public void generateSnapshot(org.hl7.fhir.r5.model.StructureDefinition p) throws DefinitionException, FHIRException {
        }

        public String getLinkForUrl(String corePath, String url) {
            throw new UnsupportedOperationException();
        }

        public Parameters getExpansionParameters() {
            return this.myExpansionProfile;
        }

        public void setExpansionProfile(Parameters expParameters) {
            this.myExpansionProfile = expParameters;
        }

        public List<org.hl7.fhir.r5.model.StructureDefinition> allStructures() {
            List<org.hl7.fhir.r5.model.StructureDefinition> retVal = this.myAllStructures;
            if (retVal == null) {
                retVal = new ArrayList<org.hl7.fhir.r5.model.StructureDefinition>();
                for (StructureDefinition next : this.myWrap.allStructures()) {
                    try {
                        org.hl7.fhir.r5.model.StructureDefinition converted = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertStructureDefinition(next);
                        if (converted == null) continue;
                        retVal.add(converted);
                    }
                    catch (FHIRException e) {
                        throw new InternalErrorException((Throwable)e);
                    }
                }
                this.myAllStructures = retVal;
            }
            return retVal;
        }

        public List<org.hl7.fhir.r5.model.StructureDefinition> getStructures() {
            return this.allStructures();
        }

        public void cacheResource(Resource res) throws FHIRException {
            throw new UnsupportedOperationException();
        }

        private IWorkerContext.ValidationResult convertValidationResult(IWorkerContext.ValidationResult theResult) {
            ValidationMessage.IssueSeverity issueSeverity = theResult.getSeverity();
            String message = theResult.getMessage();
            CodeSystem.ConceptDefinitionComponent conceptDefinition = null;
            if (theResult.asConceptDefinition() != null) {
                conceptDefinition = FhirInstanceValidator.this.convertConceptDefinition(theResult.asConceptDefinition());
            }
            IWorkerContext.ValidationResult retVal = new IWorkerContext.ValidationResult(issueSeverity, message, conceptDefinition);
            return retVal;
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet source, boolean cacheOk, boolean heiarchical) {
            org.hl7.fhir.dstu2.model.ValueSet convertedSource = null;
            try {
                convertedSource = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSet(source);
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            ValueSetExpander.ValueSetExpansionOutcome expanded = this.myWrap.expandVS(convertedSource, cacheOk);
            ValueSet convertedResult = null;
            if (expanded.getValueset() != null) {
                try {
                    convertedResult = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSet(expanded.getValueset());
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            String error = expanded.getError();
            ValueSetExpander.TerminologyServiceErrorClass result = null;
            return new ValueSetExpander.ValueSetExpansionOutcome(convertedResult, error, result);
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heiarchical) throws FHIRException {
            throw new UnsupportedOperationException();
        }

        public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean heirarchical) throws TerminologyServiceException {
            ValueSet.ConceptSetComponent convertedInc = null;
            if (inc != null) {
                try {
                    convertedInc = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertConceptSetComponent(inc);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSet.ValueSetExpansionComponent expansion = this.myWrap.expandVS(convertedInc);
            ValueSet.ValueSetExpansionComponent valueSetExpansionComponent = null;
            if (expansion != null) {
                try {
                    valueSetExpansionComponent = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSetExpansionComponent(expansion);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            ValueSetExpander.ValueSetExpansionOutcome outcome = new ValueSetExpander.ValueSetExpansionOutcome(new ValueSet());
            outcome.getValueset().setExpansion(valueSetExpansionComponent);
            return outcome;
        }

        public CodeSystem fetchCodeSystem(String system) {
            org.hl7.fhir.dstu2.model.ValueSet fetched = this.myWrap.fetchCodeSystem(system);
            if (fetched == null) {
                return null;
            }
            return FhirInstanceValidator.this.convertCodeSystem(fetched);
        }

        public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
            ResourceKey key = new ResourceKey(class_.getSimpleName(), uri);
            Resource retVal = (Resource)this.myFetchResourceCache.get((Object)key);
            return (T)retVal;
        }

        public Resource fetchResourceById(String type, String uri) {
            throw new UnsupportedOperationException();
        }

        public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
            T retVal = this.fetchResource(class_, uri);
            if (retVal == null) {
                throw new FHIRException("Can not find resource of type " + class_.getSimpleName() + " with uri " + uri);
            }
            return retVal;
        }

        public List<ConceptMap> findMapsForSource(String url) {
            throw new UnsupportedOperationException();
        }

        public String getAbbreviation(String name) {
            return this.myWrap.getAbbreviation(name);
        }

        public VersionConvertor_10_50 getConverter() {
            return this.myConverter;
        }

        public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(ParserType type) {
            throw new UnsupportedOperationException();
        }

        public IParser getParser(String type) {
            throw new UnsupportedOperationException();
        }

        public List<String> getResourceNames() {
            return this.myWrap.getResourceNames();
        }

        public Set<String> getResourceNamesAsSet() {
            return new HashSet<String>(this.myWrap.getResourceNames());
        }

        public StructureMap getTransform(String url) {
            throw new UnsupportedOperationException();
        }

        public String getOverrideVersionNs() {
            return null;
        }

        public void setOverrideVersionNs(String value) {
        }

        public org.hl7.fhir.r5.model.StructureDefinition fetchTypeDefinition(String typeName) {
            return this.fetchResource(org.hl7.fhir.r5.model.StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
        }

        public void setUcumService(UcumService ucumService) {
            throw new UnsupportedOperationException();
        }

        public List<String> getTypeNames() {
            throw new UnsupportedOperationException();
        }

        public String getVersion() {
            return FhirVersionEnum.DSTU2.getFhirVersionString();
        }

        public UcumService getUcumService() {
            throw new UnsupportedOperationException();
        }

        public boolean hasCache() {
            return false;
        }

        public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
            throw new UnsupportedOperationException();
        }

        public boolean isNoTerminologyServer() {
            return true;
        }

        public List<StructureMap> listTransforms() {
            throw new UnsupportedOperationException();
        }

        public IParser newJsonParser() {
            throw new UnsupportedOperationException();
        }

        public IResourceValidator newValidator() throws FHIRException {
            throw new UnsupportedOperationException();
        }

        public IParser newXmlParser() {
            throw new UnsupportedOperationException();
        }

        public String oid2Uri(String code) {
            throw new UnsupportedOperationException();
        }

        public void setLogger(IWorkerContext.ILoggingService logger) {
            throw new UnsupportedOperationException();
        }

        public IWorkerContext.ILoggingService getLogger() {
            return null;
        }

        public boolean supportsSystem(String system) throws TerminologyServiceException {
            return this.myWrap.supportsSystem(system);
        }

        public TranslationServices translator() {
            throw new UnsupportedOperationException();
        }

        public Set<String> typeTails() {
            throw new UnsupportedOperationException();
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display) {
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, ValueSet vs) {
            org.hl7.fhir.dstu2.model.ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    convertedVs = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSet(vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String code, ValueSet vs) {
            org.hl7.fhir.dstu2.model.ValueSet convertedVs = null;
            try {
                if (vs != null) {
                    NullVersionConverterAdvisor50 advisor50 = new NullVersionConverterAdvisor50();
                    convertedVs = new VersionConvertor_10_50((VersionConvertorAdvisor50)advisor50).convertValueSet(vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(Constants.CODESYSTEM_VALIDATE_NOT_NEEDED, code, null, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, Coding code, ValueSet vs) {
            org.hl7.fhir.dstu2.model.Coding convertedCode = null;
            org.hl7.fhir.dstu2.model.ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertCoding(code);
                }
                if (vs != null) {
                    convertedVs = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSet(vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, CodeableConcept code, ValueSet vs) {
            org.hl7.fhir.dstu2.model.CodeableConcept convertedCode = null;
            org.hl7.fhir.dstu2.model.ValueSet convertedVs = null;
            try {
                if (code != null) {
                    convertedCode = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertCodeableConcept(code);
                }
                if (vs != null) {
                    convertedVs = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertValueSet(vs);
                }
            }
            catch (FHIRException e) {
                throw new InternalErrorException((Throwable)e);
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(convertedCode, convertedVs);
            return this.convertValidationResult(result);
        }

        public IWorkerContext.ValidationResult validateCode(TerminologyServiceOptions theOptions, String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
            ValueSet.ConceptSetComponent conceptSetComponent = null;
            if (vsi != null) {
                try {
                    conceptSetComponent = new VersionConvertor_10_50(FhirInstanceValidator.this.myAdvisor).convertConceptSetComponent(vsi);
                }
                catch (FHIRException e) {
                    throw new InternalErrorException((Throwable)e);
                }
            }
            IWorkerContext.ValidationResult result = this.myWrap.validateCode(system, code, display, conceptSetComponent);
            return this.convertValidationResult(result);
        }
    }
}

