/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;

public class PrePopulatedValidationSupport
implements IValidationSupport {
    private Map<String, CodeSystem> myCodeSystems;
    private Map<String, StructureDefinition> myStructureDefinitions;
    private Map<String, ValueSet> myValueSets;

    public PrePopulatedValidationSupport() {
        this.myStructureDefinitions = new HashMap<String, StructureDefinition>();
        this.myValueSets = new HashMap<String, ValueSet>();
        this.myCodeSystems = new HashMap<String, CodeSystem>();
    }

    public PrePopulatedValidationSupport(Map<String, StructureDefinition> theStructureDefinitions, Map<String, ValueSet> theValueSets, Map<String, CodeSystem> theCodeSystems) {
        this.myStructureDefinitions = theStructureDefinitions;
        this.myValueSets = theValueSets;
        this.myCodeSystems = theCodeSystems;
    }

    public void addCodeSystem(CodeSystem theCodeSystem) {
        Validate.notBlank((CharSequence)theCodeSystem.getUrl(), (String)"theCodeSystem.getUrl() must not return a value", (Object[])new Object[0]);
        this.addToMap(theCodeSystem, this.myCodeSystems, theCodeSystem.getUrl());
    }

    public void addStructureDefinition(StructureDefinition theStructureDefinition) {
        Validate.notBlank((CharSequence)theStructureDefinition.getUrl(), (String)"theStructureDefinition.getUrl() must not return a value", (Object[])new Object[0]);
        this.addToMap(theStructureDefinition, this.myStructureDefinitions, theStructureDefinition.getUrl());
    }

    private <T extends MetadataResource> void addToMap(T theStructureDefinition, Map<String, T> map, String theUrl) {
        if (StringUtils.isNotBlank((CharSequence)theUrl)) {
            map.put(theUrl, theStructureDefinition);
            int lastSlashIdx = theUrl.lastIndexOf(47);
            if (lastSlashIdx != -1) {
                map.put(theUrl.substring(lastSlashIdx + 1), theStructureDefinition);
                int previousSlashIdx = theUrl.lastIndexOf(47, lastSlashIdx - 1);
                if (previousSlashIdx != -1) {
                    map.put(theUrl.substring(previousSlashIdx + 1), theStructureDefinition);
                }
            }
        }
    }

    public void addValueSet(ValueSet theValueSet) {
        Validate.notBlank((CharSequence)theValueSet.getUrl(), (String)"theValueSet.getUrl() must not return a value", (Object[])new Object[0]);
        this.addToMap(theValueSet, this.myValueSets, theValueSet.getUrl());
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return null;
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        retVal.addAll(this.myCodeSystems.values());
        retVal.addAll(this.myStructureDefinitions.values());
        retVal.addAll(this.myValueSets.values());
        return retVal;
    }

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return new ArrayList<StructureDefinition>(this.myStructureDefinitions.values());
    }

    public CodeSystem fetchCodeSystem(FhirContext theContext, String uri) {
        return this.myCodeSystems.get(uri);
    }

    public ValueSet fetchValueSet(FhirContext theContext, String uri) {
        return this.myValueSets.get(uri);
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        if (theClass.equals(StructureDefinition.class)) {
            return (T)((IBaseResource)this.myStructureDefinitions.get(theUri));
        }
        if (theClass.equals(ValueSet.class)) {
            return (T)((IBaseResource)this.myValueSets.get(theUri));
        }
        if (theClass.equals(CodeSystem.class)) {
            return (T)((IBaseResource)this.myCodeSystems.get(theUri));
        }
        return null;
    }

    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        return this.myStructureDefinitions.get(theUrl);
    }

    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return false;
    }

    public StructureDefinition generateSnapshot(StructureDefinition theInput, String theUrl, String theWebUrl, String theProfileName) {
        return null;
    }

    public IContextValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return null;
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        return null;
    }
}

