/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.validation;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeCompositeDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.rest.server.exceptions.PreconditionFailedException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.HapiWorkerContext;
import org.hl7.fhir.r4.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.ValueSetExpander;

public class SnapshotGeneratingValidationSupport
implements IValidationSupport {
    private final FhirContext myCtx;
    private final IValidationSupport myValidationSupport;

    public SnapshotGeneratingValidationSupport(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx);
        Validate.notNull((Object)theValidationSupport);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandValueSet(FhirContext theContext, ValueSet.ConceptSetComponent theInclude) {
        return null;
    }

    public List<IBaseResource> fetchAllConformanceResources(FhirContext theContext) {
        return null;
    }

    public List<StructureDefinition> fetchAllStructureDefinitions(FhirContext theContext) {
        return null;
    }

    public CodeSystem fetchCodeSystem(FhirContext theContext, String uri) {
        return null;
    }

    public ValueSet fetchValueSet(FhirContext theContext, String uri) {
        return null;
    }

    public <T extends IBaseResource> T fetchResource(FhirContext theContext, Class<T> theClass, String theUri) {
        return null;
    }

    public StructureDefinition fetchStructureDefinition(FhirContext theCtx, String theUrl) {
        return null;
    }

    public boolean isCodeSystemSupported(FhirContext theContext, String theSystem) {
        return false;
    }

    public StructureDefinition generateSnapshot(StructureDefinition theInput, String theUrl, String theWebUrl, String theProfileName) {
        HapiWorkerContext context = new HapiWorkerContext(this.myCtx, this.myValidationSupport);
        MyProfileKnowledgeWorker profileKnowledgeProvider = new MyProfileKnowledgeWorker();
        ArrayList messages = new ArrayList();
        StructureDefinition base = this.myValidationSupport.fetchStructureDefinition(this.myCtx, theInput.getBaseDefinition());
        if (base == null) {
            throw new PreconditionFailedException("Unknown base definition: " + theInput.getBaseDefinition());
        }
        new ProfileUtilities((IWorkerContext)context, messages, (ProfileUtilities.ProfileKnowledgeProvider)profileKnowledgeProvider).generateSnapshot(base, theInput, theUrl, theWebUrl, theProfileName);
        return theInput;
    }

    public IContextValidationSupport.CodeValidationResult validateCode(FhirContext theContext, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return null;
    }

    public IContextValidationSupport.LookupCodeResult lookupCode(FhirContext theContext, String theSystem, String theCode) {
        return null;
    }

    private class MyProfileKnowledgeWorker
    implements ProfileUtilities.ProfileKnowledgeProvider {
        private MyProfileKnowledgeWorker() {
        }

        public boolean isDatatype(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimePrimitiveDatatypeDefinition || def instanceof RuntimeCompositeDatatypeDefinition;
        }

        public boolean isResource(String typeSimple) {
            BaseRuntimeElementDefinition def = SnapshotGeneratingValidationSupport.this.myCtx.getElementDefinition(typeSimple);
            Validate.notNull((Object)typeSimple);
            return def instanceof RuntimeResourceDefinition;
        }

        public boolean hasLinkFor(String typeSimple) {
            return false;
        }

        public String getLinkFor(String corePath, String typeSimple) {
            return null;
        }

        public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, ElementDefinition.ElementDefinitionBindingComponent binding, String path) throws FHIRException {
            return null;
        }

        public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(StructureDefinition def, String url, String path) throws FHIRException {
            return null;
        }

        public String getLinkForProfile(StructureDefinition profile, String url) {
            return null;
        }

        public boolean prependLinks() {
            return false;
        }

        public String getLinkForUrl(String corePath, String url) {
            throw new UnsupportedOperationException();
        }
    }
}

