/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Order;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="OrderResponse", profile="http://hl7.org/fhir/Profile/OrderResponse")
public class OrderResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers assigned to this order by the orderer or by the receiver", formalDefinition="Identifiers assigned to this order. The identifiers are usually assigned by the system responding to the order, but they may be provided or added to by other systems.")
    protected List<Identifier> identifier;
    @Child(name="request", type={Order.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The order that this is a response to", formalDefinition="A reference to the order that this is in response to.")
    protected Reference request;
    protected Order requestTarget;
    @Child(name="date", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the response was made", formalDefinition="The date and time at which this order response was made (created/posted).")
    protected DateTimeType date;
    @Child(name="who", type={Practitioner.class, Organization.class, Device.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who made the response", formalDefinition="The person, organization, or device credited with making the response.")
    protected Reference who;
    protected Resource whoTarget;
    @Child(name="orderStatus", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="pending | review | rejected | error | accepted | cancelled | replaced | aborted | completed", formalDefinition="What this response says about the status of the original order.")
    protected Enumeration<OrderStatus> orderStatus;
    @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Additional description of the response", formalDefinition="Additional description about the response - e.g. a text description provided by a human user when making decisions about the order.")
    protected StringType description;
    @Child(name="fulfillment", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Details of the outcome of performing the order", formalDefinition="Links to resources that provide details of the outcome of performing the order; e.g. Diagnostic Reports in a response that is made to an order that referenced a diagnostic order.")
    protected List<Reference> fulfillment;
    protected List<Resource> fulfillmentTarget;
    private static final long serialVersionUID = -856633109L;
    @SearchParamDefinition(name="date", path="OrderResponse.date", description="When the response was made", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="request", path="OrderResponse.request", description="The order that this is a response to", type="reference")
    public static final String SP_REQUEST = "request";
    @SearchParamDefinition(name="identifier", path="OrderResponse.identifier", description="Identifiers assigned to this order by the orderer or by the receiver", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="OrderResponse.orderStatus", description="pending | review | rejected | error | accepted | cancelled | replaced | aborted | completed", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="fulfillment", path="OrderResponse.fulfillment", description="Details of the outcome of performing the order", type="reference")
    public static final String SP_FULFILLMENT = "fulfillment";
    @SearchParamDefinition(name="who", path="OrderResponse.who", description="Who made the response", type="reference")
    public static final String SP_WHO = "who";

    public OrderResponse() {
    }

    public OrderResponse(Reference request, Enumeration<OrderStatus> orderStatus) {
        this.request = request;
        this.orderStatus = orderStatus;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public OrderResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public OrderResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Order getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new Order();
            }
        }
        return this.requestTarget;
    }

    public OrderResponse setRequestTarget(Order value) {
        this.requestTarget = value;
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public OrderResponse setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public OrderResponse setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public Reference getWho() {
        if (this.who == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.who");
            }
            if (Configuration.doAutoCreate()) {
                this.who = new Reference();
            }
        }
        return this.who;
    }

    public boolean hasWho() {
        return this.who != null && !this.who.isEmpty();
    }

    public OrderResponse setWho(Reference value) {
        this.who = value;
        return this;
    }

    public Resource getWhoTarget() {
        return this.whoTarget;
    }

    public OrderResponse setWhoTarget(Resource value) {
        this.whoTarget = value;
        return this;
    }

    public Enumeration<OrderStatus> getOrderStatusElement() {
        if (this.orderStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.orderStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.orderStatus = new Enumeration<OrderStatus>(new OrderStatusEnumFactory());
            }
        }
        return this.orderStatus;
    }

    public boolean hasOrderStatusElement() {
        return this.orderStatus != null && !this.orderStatus.isEmpty();
    }

    public boolean hasOrderStatus() {
        return this.orderStatus != null && !this.orderStatus.isEmpty();
    }

    public OrderResponse setOrderStatusElement(Enumeration<OrderStatus> value) {
        this.orderStatus = value;
        return this;
    }

    public OrderStatus getOrderStatus() {
        return this.orderStatus == null ? null : (OrderStatus)((Object)this.orderStatus.getValue());
    }

    public OrderResponse setOrderStatus(OrderStatus value) {
        if (this.orderStatus == null) {
            this.orderStatus = new Enumeration<OrderStatus>(new OrderStatusEnumFactory());
        }
        this.orderStatus.setValue((Object)value);
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create OrderResponse.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public OrderResponse setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public OrderResponse setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<Reference> getFulfillment() {
        if (this.fulfillment == null) {
            this.fulfillment = new ArrayList<Reference>();
        }
        return this.fulfillment;
    }

    public boolean hasFulfillment() {
        if (this.fulfillment == null) {
            return false;
        }
        for (Reference item : this.fulfillment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addFulfillment() {
        Reference t = new Reference();
        if (this.fulfillment == null) {
            this.fulfillment = new ArrayList<Reference>();
        }
        this.fulfillment.add(t);
        return t;
    }

    public OrderResponse addFulfillment(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.fulfillment == null) {
            this.fulfillment = new ArrayList<Reference>();
        }
        this.fulfillment.add(t);
        return this;
    }

    public List<Resource> getFulfillmentTarget() {
        if (this.fulfillmentTarget == null) {
            this.fulfillmentTarget = new ArrayList<Resource>();
        }
        return this.fulfillmentTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order. The identifiers are usually assigned by the system responding to the order, but they may be provided or added to by other systems.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_REQUEST, "Reference(Order)", "A reference to the order that this is in response to.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date and time at which this order response was made (created/posted).", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_WHO, "Reference(Practitioner|Organization|Device)", "The person, organization, or device credited with making the response.", 0, Integer.MAX_VALUE, this.who));
        childrenList.add(new Property("orderStatus", SP_CODE, "What this response says about the status of the original order.", 0, Integer.MAX_VALUE, this.orderStatus));
        childrenList.add(new Property("description", "string", "Additional description about the response - e.g. a text description provided by a human user when making decisions about the order.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property(SP_FULFILLMENT, "Reference(Any)", "Links to resources that provide details of the outcome of performing the order; e.g. Diagnostic Reports in a response that is made to an order that referenced a diagnostic order.", 0, Integer.MAX_VALUE, this.fulfillment));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_REQUEST)) {
            this.request = this.castToReference(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_WHO)) {
            this.who = this.castToReference(value);
        } else if (name.equals("orderStatus")) {
            this.orderStatus = new OrderStatusEnumFactory().fromType(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_FULFILLMENT)) {
            this.getFulfillment().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_REQUEST)) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type OrderResponse.date");
        }
        if (name.equals(SP_WHO)) {
            this.who = new Reference();
            return this.who;
        }
        if (name.equals("orderStatus")) {
            throw new FHIRException("Cannot call addChild on a primitive type OrderResponse.orderStatus");
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type OrderResponse.description");
        }
        if (name.equals(SP_FULFILLMENT)) {
            return this.addFulfillment();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "OrderResponse";
    }

    @Override
    public OrderResponse copy() {
        OrderResponse dst = new OrderResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.date = this.date == null ? null : this.date.copy();
        dst.who = this.who == null ? null : this.who.copy();
        dst.orderStatus = this.orderStatus == null ? null : this.orderStatus.copy();
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.fulfillment != null) {
            dst.fulfillment = new ArrayList<Reference>();
            for (Reference reference : this.fulfillment) {
                dst.fulfillment.add(reference.copy());
            }
        }
        return dst;
    }

    protected OrderResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof OrderResponse)) {
            return false;
        }
        OrderResponse o = (OrderResponse)other;
        return OrderResponse.compareDeep(this.identifier, o.identifier, true) && OrderResponse.compareDeep(this.request, o.request, true) && OrderResponse.compareDeep(this.date, o.date, true) && OrderResponse.compareDeep(this.who, o.who, true) && OrderResponse.compareDeep(this.orderStatus, o.orderStatus, true) && OrderResponse.compareDeep(this.description, o.description, true) && OrderResponse.compareDeep(this.fulfillment, o.fulfillment, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof OrderResponse)) {
            return false;
        }
        OrderResponse o = (OrderResponse)other;
        return OrderResponse.compareValues(this.date, o.date, true) && OrderResponse.compareValues(this.orderStatus, o.orderStatus, true) && OrderResponse.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.date != null && !this.date.isEmpty() || this.who != null && !this.who.isEmpty() || this.orderStatus != null && !this.orderStatus.isEmpty() || this.description != null && !this.description.isEmpty() || this.fulfillment != null && !this.fulfillment.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.OrderResponse;
    }

    public static class OrderStatusEnumFactory
    implements EnumFactory<OrderStatus> {
        @Override
        public OrderStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("pending".equals(codeString)) {
                return OrderStatus.PENDING;
            }
            if ("review".equals(codeString)) {
                return OrderStatus.REVIEW;
            }
            if ("rejected".equals(codeString)) {
                return OrderStatus.REJECTED;
            }
            if ("error".equals(codeString)) {
                return OrderStatus.ERROR;
            }
            if ("accepted".equals(codeString)) {
                return OrderStatus.ACCEPTED;
            }
            if ("cancelled".equals(codeString)) {
                return OrderStatus.CANCELLED;
            }
            if ("replaced".equals(codeString)) {
                return OrderStatus.REPLACED;
            }
            if ("aborted".equals(codeString)) {
                return OrderStatus.ABORTED;
            }
            if ("completed".equals(codeString)) {
                return OrderStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown OrderStatus code '" + codeString + "'");
        }

        public Enumeration<OrderStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pending".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.PENDING);
            }
            if ("review".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.REVIEW);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.REJECTED);
            }
            if ("error".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.ERROR);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.ACCEPTED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.CANCELLED);
            }
            if ("replaced".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.REPLACED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.ABORTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<OrderStatus>(this, OrderStatus.COMPLETED);
            }
            throw new FHIRException("Unknown OrderStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(OrderStatus code) {
            if (code == OrderStatus.PENDING) {
                return "pending";
            }
            if (code == OrderStatus.REVIEW) {
                return "review";
            }
            if (code == OrderStatus.REJECTED) {
                return "rejected";
            }
            if (code == OrderStatus.ERROR) {
                return "error";
            }
            if (code == OrderStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == OrderStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == OrderStatus.REPLACED) {
                return "replaced";
            }
            if (code == OrderStatus.ABORTED) {
                return "aborted";
            }
            if (code == OrderStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }
    }

    public static enum OrderStatus {
        PENDING,
        REVIEW,
        REJECTED,
        ERROR,
        ACCEPTED,
        CANCELLED,
        REPLACED,
        ABORTED,
        COMPLETED,
        NULL;


        public static OrderStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("pending".equals(codeString)) {
                return PENDING;
            }
            if ("review".equals(codeString)) {
                return REVIEW;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("error".equals(codeString)) {
                return ERROR;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("replaced".equals(codeString)) {
                return REPLACED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            throw new FHIRException("Unknown OrderStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PENDING: {
                    return "pending";
                }
                case REVIEW: {
                    return "review";
                }
                case REJECTED: {
                    return "rejected";
                }
                case ERROR: {
                    return "error";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case REPLACED: {
                    return "replaced";
                }
                case ABORTED: {
                    return "aborted";
                }
                case COMPLETED: {
                    return "completed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PENDING: {
                    return "http://hl7.org/fhir/order-status";
                }
                case REVIEW: {
                    return "http://hl7.org/fhir/order-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/order-status";
                }
                case ERROR: {
                    return "http://hl7.org/fhir/order-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/order-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/order-status";
                }
                case REPLACED: {
                    return "http://hl7.org/fhir/order-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/order-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/order-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PENDING: {
                    return "The order is known, but no processing has occurred at this time";
                }
                case REVIEW: {
                    return "The order is undergoing initial processing to determine whether it will be accepted (usually this involves human review)";
                }
                case REJECTED: {
                    return "The order was rejected because of a workflow/business logic reason";
                }
                case ERROR: {
                    return "The order was unable to be processed because of a technical error (i.e. unexpected error)";
                }
                case ACCEPTED: {
                    return "The order has been accepted, and work is in progress.";
                }
                case CANCELLED: {
                    return "Processing the order was halted at the initiators request.";
                }
                case REPLACED: {
                    return "The order has been cancelled and replaced by another.";
                }
                case ABORTED: {
                    return "Processing the order was stopped because of some workflow/business logic reason.";
                }
                case COMPLETED: {
                    return "The order has been completed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PENDING: {
                    return "Pending";
                }
                case REVIEW: {
                    return "Review";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case ERROR: {
                    return "Error";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case REPLACED: {
                    return "Replaced";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case COMPLETED: {
                    return "Completed";
                }
            }
            return "?";
        }
    }
}

