/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.Schedule;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Slot", profile="http://hl7.org/fhir/Profile/Slot")
public class Slot
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="External Ids for this item.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource", formalDefinition="The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.")
    protected CodeableConcept type;
    @Child(name="schedule", type={Schedule.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The schedule resource that this slot defines an interval of status information", formalDefinition="The schedule resource that this slot defines an interval of status information.")
    protected Reference schedule;
    protected Schedule scheduleTarget;
    @Child(name="freeBusyType", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="busy | free | busy-unavailable | busy-tentative", formalDefinition="busy | free | busy-unavailable | busy-tentative.")
    protected Enumeration<SlotStatus> freeBusyType;
    @Child(name="start", type={InstantType.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time that the slot is to begin", formalDefinition="Date/Time that the slot is to begin.")
    protected InstantType start;
    @Child(name="end", type={InstantType.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date/Time that the slot is to conclude", formalDefinition="Date/Time that the slot is to conclude.")
    protected InstantType end;
    @Child(name="overbooked", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="This slot has already been overbooked, appointments are unlikely to be accepted for this time", formalDefinition="This slot has already been overbooked, appointments are unlikely to be accepted for this time.")
    protected BooleanType overbooked;
    @Child(name="comment", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the slot to describe any extended information. Such as custom constraints on the slot", formalDefinition="Comments on the slot to describe any extended information. Such as custom constraints on the slot.")
    protected StringType comment;
    private static final long serialVersionUID = 1984269299L;
    @SearchParamDefinition(name="schedule", path="Slot.schedule", description="The Schedule Resource that we are seeking a slot within", type="reference")
    public static final String SP_SCHEDULE = "schedule";
    @SearchParamDefinition(name="identifier", path="Slot.identifier", description="A Slot Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="start", path="Slot.start", description="Appointment date/time.", type="date")
    public static final String SP_START = "start";
    @SearchParamDefinition(name="slot-type", path="Slot.type", description="The type of appointments that can be booked into the slot", type="token")
    public static final String SP_SLOTTYPE = "slot-type";
    @SearchParamDefinition(name="fb-type", path="Slot.freeBusyType", description="The free/busy status of the appointment", type="token")
    public static final String SP_FBTYPE = "fb-type";

    public Slot() {
    }

    public Slot(Reference schedule, Enumeration<SlotStatus> freeBusyType, InstantType start, InstantType end) {
        this.schedule = schedule;
        this.freeBusyType = freeBusyType;
        this.start = start;
        this.end = end;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Slot addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Slot setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Reference getSchedule() {
        if (this.schedule == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.schedule");
            }
            if (Configuration.doAutoCreate()) {
                this.schedule = new Reference();
            }
        }
        return this.schedule;
    }

    public boolean hasSchedule() {
        return this.schedule != null && !this.schedule.isEmpty();
    }

    public Slot setSchedule(Reference value) {
        this.schedule = value;
        return this;
    }

    public Schedule getScheduleTarget() {
        if (this.scheduleTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.schedule");
            }
            if (Configuration.doAutoCreate()) {
                this.scheduleTarget = new Schedule();
            }
        }
        return this.scheduleTarget;
    }

    public Slot setScheduleTarget(Schedule value) {
        this.scheduleTarget = value;
        return this;
    }

    public Enumeration<SlotStatus> getFreeBusyTypeElement() {
        if (this.freeBusyType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.freeBusyType");
            }
            if (Configuration.doAutoCreate()) {
                this.freeBusyType = new Enumeration<SlotStatus>(new SlotStatusEnumFactory());
            }
        }
        return this.freeBusyType;
    }

    public boolean hasFreeBusyTypeElement() {
        return this.freeBusyType != null && !this.freeBusyType.isEmpty();
    }

    public boolean hasFreeBusyType() {
        return this.freeBusyType != null && !this.freeBusyType.isEmpty();
    }

    public Slot setFreeBusyTypeElement(Enumeration<SlotStatus> value) {
        this.freeBusyType = value;
        return this;
    }

    public SlotStatus getFreeBusyType() {
        return this.freeBusyType == null ? null : (SlotStatus)((Object)this.freeBusyType.getValue());
    }

    public Slot setFreeBusyType(SlotStatus value) {
        if (this.freeBusyType == null) {
            this.freeBusyType = new Enumeration<SlotStatus>(new SlotStatusEnumFactory());
        }
        this.freeBusyType.setValue((Object)value);
        return this;
    }

    public InstantType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new InstantType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public Slot setStartElement(InstantType value) {
        this.start = value;
        return this;
    }

    public Date getStart() {
        return this.start == null ? null : (Date)this.start.getValue();
    }

    public Slot setStart(Date value) {
        if (this.start == null) {
            this.start = new InstantType();
        }
        this.start.setValue(value);
        return this;
    }

    public InstantType getEndElement() {
        if (this.end == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.end");
            }
            if (Configuration.doAutoCreate()) {
                this.end = new InstantType();
            }
        }
        return this.end;
    }

    public boolean hasEndElement() {
        return this.end != null && !this.end.isEmpty();
    }

    public boolean hasEnd() {
        return this.end != null && !this.end.isEmpty();
    }

    public Slot setEndElement(InstantType value) {
        this.end = value;
        return this;
    }

    public Date getEnd() {
        return this.end == null ? null : (Date)this.end.getValue();
    }

    public Slot setEnd(Date value) {
        if (this.end == null) {
            this.end = new InstantType();
        }
        this.end.setValue(value);
        return this;
    }

    public BooleanType getOverbookedElement() {
        if (this.overbooked == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.overbooked");
            }
            if (Configuration.doAutoCreate()) {
                this.overbooked = new BooleanType();
            }
        }
        return this.overbooked;
    }

    public boolean hasOverbookedElement() {
        return this.overbooked != null && !this.overbooked.isEmpty();
    }

    public boolean hasOverbooked() {
        return this.overbooked != null && !this.overbooked.isEmpty();
    }

    public Slot setOverbookedElement(BooleanType value) {
        this.overbooked = value;
        return this;
    }

    public boolean getOverbooked() {
        return this.overbooked == null || this.overbooked.isEmpty() ? false : (Boolean)this.overbooked.getValue();
    }

    public Slot setOverbooked(boolean value) {
        if (this.overbooked == null) {
            this.overbooked = new BooleanType();
        }
        this.overbooked.setValue((Object)value);
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Slot.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Slot setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Slot setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("type", "CodeableConcept", "The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_SCHEDULE, "Reference(Schedule)", "The schedule resource that this slot defines an interval of status information.", 0, Integer.MAX_VALUE, this.schedule));
        childrenList.add(new Property("freeBusyType", "code", "busy | free | busy-unavailable | busy-tentative.", 0, Integer.MAX_VALUE, this.freeBusyType));
        childrenList.add(new Property(SP_START, "instant", "Date/Time that the slot is to begin.", 0, Integer.MAX_VALUE, this.start));
        childrenList.add(new Property("end", "instant", "Date/Time that the slot is to conclude.", 0, Integer.MAX_VALUE, this.end));
        childrenList.add(new Property("overbooked", "boolean", "This slot has already been overbooked, appointments are unlikely to be accepted for this time.", 0, Integer.MAX_VALUE, this.overbooked));
        childrenList.add(new Property("comment", "string", "Comments on the slot to describe any extended information. Such as custom constraints on the slot.", 0, Integer.MAX_VALUE, this.comment));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SCHEDULE)) {
            this.schedule = this.castToReference(value);
        } else if (name.equals("freeBusyType")) {
            this.freeBusyType = new SlotStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_START)) {
            this.start = this.castToInstant(value);
        } else if (name.equals("end")) {
            this.end = this.castToInstant(value);
        } else if (name.equals("overbooked")) {
            this.overbooked = this.castToBoolean(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_SCHEDULE)) {
            this.schedule = new Reference();
            return this.schedule;
        }
        if (name.equals("freeBusyType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.freeBusyType");
        }
        if (name.equals(SP_START)) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.start");
        }
        if (name.equals("end")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.end");
        }
        if (name.equals("overbooked")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.overbooked");
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Slot.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Slot";
    }

    @Override
    public Slot copy() {
        Slot dst = new Slot();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.schedule = this.schedule == null ? null : this.schedule.copy();
        dst.freeBusyType = this.freeBusyType == null ? null : this.freeBusyType.copy();
        dst.start = this.start == null ? null : this.start.copy();
        dst.end = this.end == null ? null : this.end.copy();
        dst.overbooked = this.overbooked == null ? null : this.overbooked.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        return dst;
    }

    protected Slot typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Slot)) {
            return false;
        }
        Slot o = (Slot)other;
        return Slot.compareDeep(this.identifier, o.identifier, true) && Slot.compareDeep(this.type, o.type, true) && Slot.compareDeep(this.schedule, o.schedule, true) && Slot.compareDeep(this.freeBusyType, o.freeBusyType, true) && Slot.compareDeep(this.start, o.start, true) && Slot.compareDeep(this.end, o.end, true) && Slot.compareDeep(this.overbooked, o.overbooked, true) && Slot.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Slot)) {
            return false;
        }
        Slot o = (Slot)other;
        return Slot.compareValues(this.freeBusyType, o.freeBusyType, true) && Slot.compareValues(this.start, o.start, true) && Slot.compareValues(this.end, o.end, true) && Slot.compareValues(this.overbooked, o.overbooked, true) && Slot.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.schedule != null && !this.schedule.isEmpty() || this.freeBusyType != null && !this.freeBusyType.isEmpty() || this.start != null && !this.start.isEmpty() || this.end != null && !this.end.isEmpty() || this.overbooked != null && !this.overbooked.isEmpty() || this.comment != null && !this.comment.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Slot;
    }

    public static class SlotStatusEnumFactory
    implements EnumFactory<SlotStatus> {
        @Override
        public SlotStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return SlotStatus.BUSY;
            }
            if ("free".equals(codeString)) {
                return SlotStatus.FREE;
            }
            if ("busy-unavailable".equals(codeString)) {
                return SlotStatus.BUSYUNAVAILABLE;
            }
            if ("busy-tentative".equals(codeString)) {
                return SlotStatus.BUSYTENTATIVE;
            }
            throw new IllegalArgumentException("Unknown SlotStatus code '" + codeString + "'");
        }

        public Enumeration<SlotStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSY);
            }
            if ("free".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.FREE);
            }
            if ("busy-unavailable".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSYUNAVAILABLE);
            }
            if ("busy-tentative".equals(codeString)) {
                return new Enumeration<SlotStatus>(this, SlotStatus.BUSYTENTATIVE);
            }
            throw new FHIRException("Unknown SlotStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(SlotStatus code) {
            if (code == SlotStatus.BUSY) {
                return "busy";
            }
            if (code == SlotStatus.FREE) {
                return "free";
            }
            if (code == SlotStatus.BUSYUNAVAILABLE) {
                return "busy-unavailable";
            }
            if (code == SlotStatus.BUSYTENTATIVE) {
                return "busy-tentative";
            }
            return "?";
        }
    }

    public static enum SlotStatus {
        BUSY,
        FREE,
        BUSYUNAVAILABLE,
        BUSYTENTATIVE,
        NULL;


        public static SlotStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("busy".equals(codeString)) {
                return BUSY;
            }
            if ("free".equals(codeString)) {
                return FREE;
            }
            if ("busy-unavailable".equals(codeString)) {
                return BUSYUNAVAILABLE;
            }
            if ("busy-tentative".equals(codeString)) {
                return BUSYTENTATIVE;
            }
            throw new FHIRException("Unknown SlotStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BUSY: {
                    return "busy";
                }
                case FREE: {
                    return "free";
                }
                case BUSYUNAVAILABLE: {
                    return "busy-unavailable";
                }
                case BUSYTENTATIVE: {
                    return "busy-tentative";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BUSY: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case FREE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case BUSYUNAVAILABLE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
                case BUSYTENTATIVE: {
                    return "http://hl7.org/fhir/slotstatus";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BUSY: {
                    return "Indicates that the time interval is busy because one  or more events have been scheduled for that interval.";
                }
                case FREE: {
                    return "Indicates that the time interval is free for scheduling.";
                }
                case BUSYUNAVAILABLE: {
                    return "Indicates that the time interval is busy and that the interval can not be scheduled.";
                }
                case BUSYTENTATIVE: {
                    return "Indicates that the time interval is busy because one or more events have been tentatively scheduled for that interval.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BUSY: {
                    return "Busy";
                }
                case FREE: {
                    return "Free";
                }
                case BUSYUNAVAILABLE: {
                    return "Busy (Unavailable)";
                }
                case BUSYTENTATIVE: {
                    return "Busy (Tentative)";
                }
            }
            return "?";
        }
    }
}

