/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@DatatypeDef(name="BackboneElement")
public abstract class BackboneElement
extends Element
implements IBaseBackboneElement {
    @Child(name="modifierExtension", type={Extension.class}, order=0, min=0, max=-1, modifier=true, summary=false)
    @Description(shortDefinition="Extensions that cannot be ignored", formalDefinition="May be used to represent additional information that is not part of the basic definition of the element, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.")
    protected List<Extension> modifierExtension;
    private static final long serialVersionUID = -1431673179L;

    public List<Extension> getModifierExtension() {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        return this.modifierExtension;
    }

    public boolean hasModifierExtension() {
        if (this.modifierExtension == null) {
            return false;
        }
        for (Extension item : this.modifierExtension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addModifierExtension() {
        Extension t = new Extension();
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return t;
    }

    public BackboneElement addModifierExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        childrenList.add(new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the element, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.", 0, Integer.MAX_VALUE, this.modifierExtension));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("modifierExtension")) {
            this.getModifierExtension().add(this.castToExtension(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("modifierExtension")) {
            return this.addModifierExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "BackboneElement";
    }

    @Override
    public abstract BackboneElement copy();

    public void copyValues(BackboneElement dst) {
        super.copyValues(dst);
        if (this.modifierExtension != null) {
            dst.modifierExtension = new ArrayList<Extension>();
            for (Extension i : this.modifierExtension) {
                dst.modifierExtension.add(i.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof BackboneElement)) {
            return false;
        }
        BackboneElement o = (BackboneElement)other;
        return BackboneElement.compareDeep(this.modifierExtension, o.modifierExtension, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof BackboneElement)) {
            return false;
        }
        BackboneElement o = (BackboneElement)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && (this.modifierExtension == null || this.modifierExtension.isEmpty());
    }
}

