/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.instance.model.api.IBaseDecimalDatatype;

@DatatypeDef(name="decimal")
public class DecimalType
extends PrimitiveType<BigDecimal>
implements Comparable<DecimalType>,
IBaseDecimalDatatype {
    private static final long serialVersionUID = 3L;

    public DecimalType() {
    }

    public DecimalType(BigDecimal theValue) {
        this.setValue(theValue);
    }

    public DecimalType(double theValue) {
        this.setValue(BigDecimal.valueOf(theValue));
    }

    public DecimalType(long theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    public DecimalType(String theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    @Override
    public int compareTo(DecimalType theObj) {
        if (this.getValue() == null && theObj.getValue() == null) {
            return 0;
        }
        if (this.getValue() != null && theObj.getValue() == null) {
            return 1;
        }
        if (this.getValue() == null && theObj.getValue() != null) {
            return -1;
        }
        return ((BigDecimal)this.getValue()).compareTo((BigDecimal)theObj.getValue());
    }

    @Override
    protected String encode(BigDecimal theValue) {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    public int getValueAsInteger() {
        return ((BigDecimal)this.getValue()).intValue();
    }

    public Number getValueAsNumber() {
        return (Number)this.getValue();
    }

    @Override
    protected BigDecimal parse(String theValue) {
        return new BigDecimal(theValue);
    }

    public void round(int thePrecision) {
        if (this.getValue() != null) {
            BigDecimal newValue = ((BigDecimal)this.getValue()).round(new MathContext(thePrecision));
            this.setValue(newValue);
        }
    }

    public void round(int thePrecision, RoundingMode theRoundingMode) {
        if (this.getValue() != null) {
            BigDecimal newValue = ((BigDecimal)this.getValue()).round(new MathContext(thePrecision, theRoundingMode));
            this.setValue(newValue);
        }
    }

    public void setValueAsInteger(int theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    @Override
    public DecimalType copy() {
        return new DecimalType((BigDecimal)this.getValue());
    }

    @Override
    public String fhirType() {
        return "decimal";
    }
}

