/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Annotation;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Condition;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="DiagnosticOrder", profile="http://hl7.org/fhir/Profile/DiagnosticOrder")
public class DiagnosticOrder
extends DomainResource {
    @Child(name="subject", type={Patient.class, Group.class, Location.class, Device.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who and/or what test is about", formalDefinition="Who or what the investigation is to be performed on. This is usually a human patient, but diagnostic tests can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="orderer", type={Practitioner.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who ordered the test", formalDefinition="The practitioner that holds legal responsibility for ordering the investigation.")
    protected Reference orderer;
    protected Practitioner ordererTarget;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers assigned to this order", formalDefinition="Identifiers assigned to this order instance by the orderer and/or  the receiver and/or order fulfiller.")
    protected List<Identifier> identifier;
    @Child(name="encounter", type={Encounter.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The encounter that this diagnostic order is associated with", formalDefinition="An encounter that provides additional information about the healthcare context in which this request is made.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Explanation/Justification for test", formalDefinition="An explanation or justification for why this diagnostic investigation is being requested.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.")
    protected List<CodeableConcept> reason;
    @Child(name="supportingInformation", type={Observation.class, Condition.class, DocumentReference.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional clinical information", formalDefinition="Additional clinical information about the patient or specimen that may influence test interpretations.  This includes observations explicitly requested by the producer(filler) to provide context or supporting information needed to complete the order.")
    protected List<Reference> supportingInformation;
    protected List<Resource> supportingInformationTarget;
    @Child(name="specimen", type={Specimen.class}, order=6, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="If the whole order relates to specific specimens", formalDefinition="One or more specimens that the diagnostic investigation is about.")
    protected List<Reference> specimen;
    protected List<Specimen> specimenTarget;
    @Child(name="status", type={CodeType.class}, order=7, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", formalDefinition="The status of the order.")
    protected Enumeration<DiagnosticOrderStatus> status;
    @Child(name="priority", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | stat | asap", formalDefinition="The clinical priority associated with this order.")
    protected Enumeration<DiagnosticOrderPriority> priority;
    @Child(name="event", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of events of interest in the lifecycle", formalDefinition="A summary of the events of interest that have occurred as the request is processed; e.g. when the order was made, various processing steps (specimens received), when it was completed.")
    protected List<DiagnosticOrderEventComponent> event;
    @Child(name="item", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The items the orderer requested", formalDefinition="The specific diagnostic investigations that are requested as part of this request. Sometimes, there can only be one item per request, but in most contexts, more than one investigation can be requested.")
    protected List<DiagnosticOrderItemComponent> item;
    @Child(name="note", type={Annotation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Other notes and comments", formalDefinition="Any other notes associated with this patient, specimen or order (e.g. \"patient hates needles\").")
    protected List<Annotation> note;
    private static final long serialVersionUID = 700891227L;
    @SearchParamDefinition(name="item-past-status", path="DiagnosticOrder.item.event.status", description="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", type="token")
    public static final String SP_ITEMPASTSTATUS = "item-past-status";
    @SearchParamDefinition(name="identifier", path="DiagnosticOrder.identifier", description="Identifiers assigned to this order", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="bodysite", path="DiagnosticOrder.item.bodySite", description="Location of requested test (if applicable)", type="token")
    public static final String SP_BODYSITE = "bodysite";
    @SearchParamDefinition(name="code", path="DiagnosticOrder.item.code", description="Code to indicate the item (test or panel) being ordered", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="event-date", path="DiagnosticOrder.event.dateTime", description="The date at which the event happened", type="date")
    public static final String SP_EVENTDATE = "event-date";
    @SearchParamDefinition(name="event-status-date", path="null", description="A combination of past-status and date", type="composite")
    public static final String SP_EVENTSTATUSDATE = "event-status-date";
    @SearchParamDefinition(name="subject", path="DiagnosticOrder.subject", description="Who and/or what test is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="encounter", path="DiagnosticOrder.encounter", description="The encounter that this diagnostic order is associated with", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="actor", path="DiagnosticOrder.event.actor | DiagnosticOrder.item.event.actor", description="Who recorded or did this", type="reference")
    public static final String SP_ACTOR = "actor";
    @SearchParamDefinition(name="item-date", path="DiagnosticOrder.item.event.dateTime", description="The date at which the event happened", type="date")
    public static final String SP_ITEMDATE = "item-date";
    @SearchParamDefinition(name="item-status-date", path="null", description="A combination of item-past-status and item-date", type="composite")
    public static final String SP_ITEMSTATUSDATE = "item-status-date";
    @SearchParamDefinition(name="event-status", path="DiagnosticOrder.event.status", description="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", type="token")
    public static final String SP_EVENTSTATUS = "event-status";
    @SearchParamDefinition(name="item-status", path="DiagnosticOrder.item.status", description="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", type="token")
    public static final String SP_ITEMSTATUS = "item-status";
    @SearchParamDefinition(name="patient", path="DiagnosticOrder.subject", description="Who and/or what test is about", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="orderer", path="DiagnosticOrder.orderer", description="Who ordered the test", type="reference")
    public static final String SP_ORDERER = "orderer";
    @SearchParamDefinition(name="specimen", path="DiagnosticOrder.specimen | DiagnosticOrder.item.specimen", description="If the whole order relates to specific specimens", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    @SearchParamDefinition(name="status", path="DiagnosticOrder.status", description="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", type="token")
    public static final String SP_STATUS = "status";

    public DiagnosticOrder() {
    }

    public DiagnosticOrder(Reference subject) {
        this.subject = subject;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DiagnosticOrder setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DiagnosticOrder setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getOrderer() {
        if (this.orderer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.orderer = new Reference();
            }
        }
        return this.orderer;
    }

    public boolean hasOrderer() {
        return this.orderer != null && !this.orderer.isEmpty();
    }

    public DiagnosticOrder setOrderer(Reference value) {
        this.orderer = value;
        return this;
    }

    public Practitioner getOrdererTarget() {
        if (this.ordererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.orderer");
            }
            if (Configuration.doAutoCreate()) {
                this.ordererTarget = new Practitioner();
            }
        }
        return this.ordererTarget;
    }

    public DiagnosticOrder setOrdererTarget(Practitioner value) {
        this.ordererTarget = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DiagnosticOrder addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DiagnosticOrder setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public DiagnosticOrder setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public DiagnosticOrder addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public List<Reference> getSupportingInformation() {
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        return this.supportingInformation;
    }

    public boolean hasSupportingInformation() {
        if (this.supportingInformation == null) {
            return false;
        }
        for (Reference item : this.supportingInformation) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInformation() {
        Reference t = new Reference();
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return t;
    }

    public DiagnosticOrder addSupportingInformation(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInformation == null) {
            this.supportingInformation = new ArrayList<Reference>();
        }
        this.supportingInformation.add(t);
        return this;
    }

    public List<Resource> getSupportingInformationTarget() {
        if (this.supportingInformationTarget == null) {
            this.supportingInformationTarget = new ArrayList<Resource>();
        }
        return this.supportingInformationTarget;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public DiagnosticOrder addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public List<Specimen> getSpecimenTarget() {
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        return this.specimenTarget;
    }

    public Specimen addSpecimenTarget() {
        Specimen r = new Specimen();
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        this.specimenTarget.add(r);
        return r;
    }

    public Enumeration<DiagnosticOrderStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DiagnosticOrder setStatusElement(Enumeration<DiagnosticOrderStatus> value) {
        this.status = value;
        return this;
    }

    public DiagnosticOrderStatus getStatus() {
        return this.status == null ? null : (DiagnosticOrderStatus)((Object)this.status.getValue());
    }

    public DiagnosticOrder setStatus(DiagnosticOrderStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Enumeration<DiagnosticOrderPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticOrder.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<DiagnosticOrderPriority>(new DiagnosticOrderPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public DiagnosticOrder setPriorityElement(Enumeration<DiagnosticOrderPriority> value) {
        this.priority = value;
        return this;
    }

    public DiagnosticOrderPriority getPriority() {
        return this.priority == null ? null : (DiagnosticOrderPriority)((Object)this.priority.getValue());
    }

    public DiagnosticOrder setPriority(DiagnosticOrderPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<DiagnosticOrderPriority>(new DiagnosticOrderPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public List<DiagnosticOrderEventComponent> getEvent() {
        if (this.event == null) {
            this.event = new ArrayList<DiagnosticOrderEventComponent>();
        }
        return this.event;
    }

    public boolean hasEvent() {
        if (this.event == null) {
            return false;
        }
        for (DiagnosticOrderEventComponent item : this.event) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticOrderEventComponent addEvent() {
        DiagnosticOrderEventComponent t = new DiagnosticOrderEventComponent();
        if (this.event == null) {
            this.event = new ArrayList<DiagnosticOrderEventComponent>();
        }
        this.event.add(t);
        return t;
    }

    public DiagnosticOrder addEvent(DiagnosticOrderEventComponent t) {
        if (t == null) {
            return this;
        }
        if (this.event == null) {
            this.event = new ArrayList<DiagnosticOrderEventComponent>();
        }
        this.event.add(t);
        return this;
    }

    public List<DiagnosticOrderItemComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<DiagnosticOrderItemComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (DiagnosticOrderItemComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticOrderItemComponent addItem() {
        DiagnosticOrderItemComponent t = new DiagnosticOrderItemComponent();
        if (this.item == null) {
            this.item = new ArrayList<DiagnosticOrderItemComponent>();
        }
        this.item.add(t);
        return t;
    }

    public DiagnosticOrder addItem(DiagnosticOrderItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<DiagnosticOrderItemComponent>();
        }
        this.item.add(t);
        return this;
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public DiagnosticOrder addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Location|Device)", "Who or what the investigation is to be performed on. This is usually a human patient, but diagnostic tests can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_ORDERER, "Reference(Practitioner)", "The practitioner that holds legal responsibility for ordering the investigation.", 0, Integer.MAX_VALUE, this.orderer));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order instance by the orderer and/or  the receiver and/or order fulfiller.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "An encounter that provides additional information about the healthcare context in which this request is made.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("reason", "CodeableConcept", "An explanation or justification for why this diagnostic investigation is being requested.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property("supportingInformation", "Reference(Observation|Condition|DocumentReference)", "Additional clinical information about the patient or specimen that may influence test interpretations.  This includes observations explicitly requested by the producer(filler) to provide context or supporting information needed to complete the order.", 0, Integer.MAX_VALUE, this.supportingInformation));
        childrenList.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "One or more specimens that the diagnostic investigation is about.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the order.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("priority", SP_CODE, "The clinical priority associated with this order.", 0, Integer.MAX_VALUE, this.priority));
        childrenList.add(new Property("event", "", "A summary of the events of interest that have occurred as the request is processed; e.g. when the order was made, various processing steps (specimens received), when it was completed.", 0, Integer.MAX_VALUE, this.event));
        childrenList.add(new Property("item", "", "The specific diagnostic investigations that are requested as part of this request. Sometimes, there can only be one item per request, but in most contexts, more than one investigation can be requested.", 0, Integer.MAX_VALUE, this.item));
        childrenList.add(new Property("note", "Annotation", "Any other notes associated with this patient, specimen or order (e.g. \"patient hates needles\").", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ORDERER)) {
            this.orderer = this.castToReference(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("reason")) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("supportingInformation")) {
            this.getSupportingInformation().add(this.castToReference(value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new DiagnosticOrderStatusEnumFactory().fromType(value);
        } else if (name.equals("priority")) {
            this.priority = new DiagnosticOrderPriorityEnumFactory().fromType(value);
        } else if (name.equals("event")) {
            this.getEvent().add((DiagnosticOrderEventComponent)value);
        } else if (name.equals("item")) {
            this.getItem().add((DiagnosticOrderItemComponent)value);
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ORDERER)) {
            this.orderer = new Reference();
            return this.orderer;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals("supportingInformation")) {
            return this.addSupportingInformation();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticOrder.status");
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a primitive type DiagnosticOrder.priority");
        }
        if (name.equals("event")) {
            return this.addEvent();
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DiagnosticOrder";
    }

    @Override
    public DiagnosticOrder copy() {
        DiagnosticOrder dst = new DiagnosticOrder();
        this.copyValues(dst);
        dst.subject = this.subject == null ? null : this.subject.copy();
        Reference reference = dst.orderer = this.orderer == null ? null : this.orderer.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Reference reference2 = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        if (this.supportingInformation != null) {
            dst.supportingInformation = new ArrayList<Reference>();
            for (Reference reference3 : this.supportingInformation) {
                dst.supportingInformation.add(reference3.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference4 : this.specimen) {
                dst.specimen.add(reference4.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        Enumeration<DiagnosticOrderPriority> enumeration = dst.priority = this.priority == null ? null : this.priority.copy();
        if (this.event != null) {
            dst.event = new ArrayList<DiagnosticOrderEventComponent>();
            for (DiagnosticOrderEventComponent diagnosticOrderEventComponent : this.event) {
                dst.event.add(diagnosticOrderEventComponent.copy());
            }
        }
        if (this.item != null) {
            dst.item = new ArrayList<DiagnosticOrderItemComponent>();
            for (DiagnosticOrderItemComponent diagnosticOrderItemComponent : this.item) {
                dst.item.add(diagnosticOrderItemComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected DiagnosticOrder typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticOrder)) {
            return false;
        }
        DiagnosticOrder o = (DiagnosticOrder)other;
        return DiagnosticOrder.compareDeep(this.subject, o.subject, true) && DiagnosticOrder.compareDeep(this.orderer, o.orderer, true) && DiagnosticOrder.compareDeep(this.identifier, o.identifier, true) && DiagnosticOrder.compareDeep(this.encounter, o.encounter, true) && DiagnosticOrder.compareDeep(this.reason, o.reason, true) && DiagnosticOrder.compareDeep(this.supportingInformation, o.supportingInformation, true) && DiagnosticOrder.compareDeep(this.specimen, o.specimen, true) && DiagnosticOrder.compareDeep(this.status, o.status, true) && DiagnosticOrder.compareDeep(this.priority, o.priority, true) && DiagnosticOrder.compareDeep(this.event, o.event, true) && DiagnosticOrder.compareDeep(this.item, o.item, true) && DiagnosticOrder.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticOrder)) {
            return false;
        }
        DiagnosticOrder o = (DiagnosticOrder)other;
        return DiagnosticOrder.compareValues(this.status, o.status, true) && DiagnosticOrder.compareValues(this.priority, o.priority, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.orderer != null && !this.orderer.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.supportingInformation != null && !this.supportingInformation.isEmpty() || this.specimen != null && !this.specimen.isEmpty() || this.status != null && !this.status.isEmpty() || this.priority != null && !this.priority.isEmpty() || this.event != null && !this.event.isEmpty() || this.item != null && !this.item.isEmpty() || this.note != null && !this.note.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticOrder;
    }

    @Block
    public static class DiagnosticOrderItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Code to indicate the item (test or panel) being ordered", formalDefinition="A code that identifies a particular diagnostic investigation, or panel of investigations, that have been requested.")
        protected CodeableConcept code;
        @Child(name="specimen", type={Specimen.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="If this item relates to specific specimens", formalDefinition="If the item is related to a specific specimen.")
        protected List<Reference> specimen;
        protected List<Specimen> specimenTarget;
        @Child(name="bodySite", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location of requested test (if applicable)", formalDefinition="Anatomical location where the request test should be performed.  This is the target site.")
        protected CodeableConcept bodySite;
        @Child(name="status", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", formalDefinition="The status of this individual item within the order.")
        protected Enumeration<DiagnosticOrderStatus> status;
        @Child(name="event", type={DiagnosticOrderEventComponent.class}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Events specific to this item", formalDefinition="A summary of the events of interest that have occurred as this item of the request is processed.")
        protected List<DiagnosticOrderEventComponent> event;
        private static final long serialVersionUID = 381238192L;

        public DiagnosticOrderItemComponent() {
        }

        public DiagnosticOrderItemComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderItemComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DiagnosticOrderItemComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public List<Reference> getSpecimen() {
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            return this.specimen;
        }

        public boolean hasSpecimen() {
            if (this.specimen == null) {
                return false;
            }
            for (Reference item : this.specimen) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Reference addSpecimen() {
            Reference t = new Reference();
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return t;
        }

        public DiagnosticOrderItemComponent addSpecimen(Reference t) {
            if (t == null) {
                return this;
            }
            if (this.specimen == null) {
                this.specimen = new ArrayList<Reference>();
            }
            this.specimen.add(t);
            return this;
        }

        public List<Specimen> getSpecimenTarget() {
            if (this.specimenTarget == null) {
                this.specimenTarget = new ArrayList<Specimen>();
            }
            return this.specimenTarget;
        }

        public Specimen addSpecimenTarget() {
            Specimen r = new Specimen();
            if (this.specimenTarget == null) {
                this.specimenTarget = new ArrayList<Specimen>();
            }
            this.specimenTarget.add(r);
            return r;
        }

        public CodeableConcept getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderItemComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new CodeableConcept();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public DiagnosticOrderItemComponent setBodySite(CodeableConcept value) {
            this.bodySite = value;
            return this;
        }

        public Enumeration<DiagnosticOrderStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderItemComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public DiagnosticOrderItemComponent setStatusElement(Enumeration<DiagnosticOrderStatus> value) {
            this.status = value;
            return this;
        }

        public DiagnosticOrderStatus getStatus() {
            return this.status == null ? null : (DiagnosticOrderStatus)((Object)this.status.getValue());
        }

        public DiagnosticOrderItemComponent setStatus(DiagnosticOrderStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public List<DiagnosticOrderEventComponent> getEvent() {
            if (this.event == null) {
                this.event = new ArrayList<DiagnosticOrderEventComponent>();
            }
            return this.event;
        }

        public boolean hasEvent() {
            if (this.event == null) {
                return false;
            }
            for (DiagnosticOrderEventComponent item : this.event) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DiagnosticOrderEventComponent addEvent() {
            DiagnosticOrderEventComponent t = new DiagnosticOrderEventComponent();
            if (this.event == null) {
                this.event = new ArrayList<DiagnosticOrderEventComponent>();
            }
            this.event.add(t);
            return t;
        }

        public DiagnosticOrderItemComponent addEvent(DiagnosticOrderEventComponent t) {
            if (t == null) {
                return this;
            }
            if (this.event == null) {
                this.event = new ArrayList<DiagnosticOrderEventComponent>();
            }
            this.event.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(DiagnosticOrder.SP_CODE, "CodeableConcept", "A code that identifies a particular diagnostic investigation, or panel of investigations, that have been requested.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property(DiagnosticOrder.SP_SPECIMEN, "Reference(Specimen)", "If the item is related to a specific specimen.", 0, Integer.MAX_VALUE, this.specimen));
            childrenList.add(new Property("bodySite", "CodeableConcept", "Anatomical location where the request test should be performed.  This is the target site.", 0, Integer.MAX_VALUE, this.bodySite));
            childrenList.add(new Property(DiagnosticOrder.SP_STATUS, DiagnosticOrder.SP_CODE, "The status of this individual item within the order.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("event", "@DiagnosticOrder.event", "A summary of the events of interest that have occurred as this item of the request is processed.", 0, Integer.MAX_VALUE, this.event));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DiagnosticOrder.SP_CODE)) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals(DiagnosticOrder.SP_SPECIMEN)) {
                this.getSpecimen().add(this.castToReference(value));
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCodeableConcept(value);
            } else if (name.equals(DiagnosticOrder.SP_STATUS)) {
                this.status = new DiagnosticOrderStatusEnumFactory().fromType(value);
            } else if (name.equals("event")) {
                this.getEvent().add((DiagnosticOrderEventComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DiagnosticOrder.SP_CODE)) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals(DiagnosticOrder.SP_SPECIMEN)) {
                return this.addSpecimen();
            }
            if (name.equals("bodySite")) {
                this.bodySite = new CodeableConcept();
                return this.bodySite;
            }
            if (name.equals(DiagnosticOrder.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type DiagnosticOrder.status");
            }
            if (name.equals("event")) {
                return this.addEvent();
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticOrderItemComponent copy() {
            DiagnosticOrderItemComponent dst = new DiagnosticOrderItemComponent();
            this.copyValues(dst);
            CodeableConcept codeableConcept = dst.code = this.code == null ? null : this.code.copy();
            if (this.specimen != null) {
                dst.specimen = new ArrayList<Reference>();
                for (Reference reference : this.specimen) {
                    dst.specimen.add(reference.copy());
                }
            }
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            Enumeration<DiagnosticOrderStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
            if (this.event != null) {
                dst.event = new ArrayList<DiagnosticOrderEventComponent>();
                for (DiagnosticOrderEventComponent diagnosticOrderEventComponent : this.event) {
                    dst.event.add(diagnosticOrderEventComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticOrderItemComponent)) {
                return false;
            }
            DiagnosticOrderItemComponent o = (DiagnosticOrderItemComponent)other;
            return DiagnosticOrderItemComponent.compareDeep(this.code, o.code, true) && DiagnosticOrderItemComponent.compareDeep(this.specimen, o.specimen, true) && DiagnosticOrderItemComponent.compareDeep(this.bodySite, o.bodySite, true) && DiagnosticOrderItemComponent.compareDeep(this.status, o.status, true) && DiagnosticOrderItemComponent.compareDeep(this.event, o.event, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticOrderItemComponent)) {
                return false;
            }
            DiagnosticOrderItemComponent o = (DiagnosticOrderItemComponent)other;
            return DiagnosticOrderItemComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.specimen != null && !this.specimen.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.status != null && !this.status.isEmpty() || this.event != null && !this.event.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DiagnosticOrder.item";
        }
    }

    @Block
    public static class DiagnosticOrderEventComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="proposed | draft | planned | requested | received | accepted | in-progress | review | completed | cancelled | suspended | rejected | failed", formalDefinition="The status for the event.")
        protected Enumeration<DiagnosticOrderStatus> status;
        @Child(name="description", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="More information about the event and its context", formalDefinition="Additional information about the event that occurred - e.g. if the status remained unchanged.")
        protected CodeableConcept description;
        @Child(name="dateTime", type={DateTimeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The date at which the event happened", formalDefinition="The date/time at which the event occurred.")
        protected DateTimeType dateTime;
        @Child(name="actor", type={Practitioner.class, Device.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Who recorded or did this", formalDefinition="The person responsible for performing or recording the action.")
        protected Reference actor;
        protected Resource actorTarget;
        private static final long serialVersionUID = -370793723L;

        public DiagnosticOrderEventComponent() {
        }

        public DiagnosticOrderEventComponent(Enumeration<DiagnosticOrderStatus> status, DateTimeType dateTime) {
            this.status = status;
            this.dateTime = dateTime;
        }

        public Enumeration<DiagnosticOrderStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderEventComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public DiagnosticOrderEventComponent setStatusElement(Enumeration<DiagnosticOrderStatus> value) {
            this.status = value;
            return this;
        }

        public DiagnosticOrderStatus getStatus() {
            return this.status == null ? null : (DiagnosticOrderStatus)((Object)this.status.getValue());
        }

        public DiagnosticOrderEventComponent setStatus(DiagnosticOrderStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<DiagnosticOrderStatus>(new DiagnosticOrderStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public CodeableConcept getDescription() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderEventComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new CodeableConcept();
                }
            }
            return this.description;
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public DiagnosticOrderEventComponent setDescription(CodeableConcept value) {
            this.description = value;
            return this;
        }

        public DateTimeType getDateTimeElement() {
            if (this.dateTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderEventComponent.dateTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.dateTime = new DateTimeType();
                }
            }
            return this.dateTime;
        }

        public boolean hasDateTimeElement() {
            return this.dateTime != null && !this.dateTime.isEmpty();
        }

        public boolean hasDateTime() {
            return this.dateTime != null && !this.dateTime.isEmpty();
        }

        public DiagnosticOrderEventComponent setDateTimeElement(DateTimeType value) {
            this.dateTime = value;
            return this;
        }

        public Date getDateTime() {
            return this.dateTime == null ? null : (Date)this.dateTime.getValue();
        }

        public DiagnosticOrderEventComponent setDateTime(Date value) {
            if (this.dateTime == null) {
                this.dateTime = new DateTimeType();
            }
            this.dateTime.setValue(value);
            return this;
        }

        public Reference getActor() {
            if (this.actor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticOrderEventComponent.actor");
                }
                if (Configuration.doAutoCreate()) {
                    this.actor = new Reference();
                }
            }
            return this.actor;
        }

        public boolean hasActor() {
            return this.actor != null && !this.actor.isEmpty();
        }

        public DiagnosticOrderEventComponent setActor(Reference value) {
            this.actor = value;
            return this;
        }

        public Resource getActorTarget() {
            return this.actorTarget;
        }

        public DiagnosticOrderEventComponent setActorTarget(Resource value) {
            this.actorTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(DiagnosticOrder.SP_STATUS, DiagnosticOrder.SP_CODE, "The status for the event.", 0, Integer.MAX_VALUE, this.status));
            childrenList.add(new Property("description", "CodeableConcept", "Additional information about the event that occurred - e.g. if the status remained unchanged.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("dateTime", "dateTime", "The date/time at which the event occurred.", 0, Integer.MAX_VALUE, this.dateTime));
            childrenList.add(new Property(DiagnosticOrder.SP_ACTOR, "Reference(Practitioner|Device)", "The person responsible for performing or recording the action.", 0, Integer.MAX_VALUE, this.actor));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(DiagnosticOrder.SP_STATUS)) {
                this.status = new DiagnosticOrderStatusEnumFactory().fromType(value);
            } else if (name.equals("description")) {
                this.description = this.castToCodeableConcept(value);
            } else if (name.equals("dateTime")) {
                this.dateTime = this.castToDateTime(value);
            } else if (name.equals(DiagnosticOrder.SP_ACTOR)) {
                this.actor = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(DiagnosticOrder.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type DiagnosticOrder.status");
            }
            if (name.equals("description")) {
                this.description = new CodeableConcept();
                return this.description;
            }
            if (name.equals("dateTime")) {
                throw new FHIRException("Cannot call addChild on a primitive type DiagnosticOrder.dateTime");
            }
            if (name.equals(DiagnosticOrder.SP_ACTOR)) {
                this.actor = new Reference();
                return this.actor;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticOrderEventComponent copy() {
            DiagnosticOrderEventComponent dst = new DiagnosticOrderEventComponent();
            this.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.dateTime = this.dateTime == null ? null : this.dateTime.copy();
            dst.actor = this.actor == null ? null : this.actor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticOrderEventComponent)) {
                return false;
            }
            DiagnosticOrderEventComponent o = (DiagnosticOrderEventComponent)other;
            return DiagnosticOrderEventComponent.compareDeep(this.status, o.status, true) && DiagnosticOrderEventComponent.compareDeep(this.description, o.description, true) && DiagnosticOrderEventComponent.compareDeep(this.dateTime, o.dateTime, true) && DiagnosticOrderEventComponent.compareDeep(this.actor, o.actor, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticOrderEventComponent)) {
                return false;
            }
            DiagnosticOrderEventComponent o = (DiagnosticOrderEventComponent)other;
            return DiagnosticOrderEventComponent.compareValues(this.status, o.status, true) && DiagnosticOrderEventComponent.compareValues(this.dateTime, o.dateTime, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.status != null && !this.status.isEmpty() || this.description != null && !this.description.isEmpty() || this.dateTime != null && !this.dateTime.isEmpty() || this.actor != null && !this.actor.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DiagnosticOrder.event";
        }
    }

    public static class DiagnosticOrderPriorityEnumFactory
    implements EnumFactory<DiagnosticOrderPriority> {
        @Override
        public DiagnosticOrderPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return DiagnosticOrderPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return DiagnosticOrderPriority.URGENT;
            }
            if ("stat".equals(codeString)) {
                return DiagnosticOrderPriority.STAT;
            }
            if ("asap".equals(codeString)) {
                return DiagnosticOrderPriority.ASAP;
            }
            throw new IllegalArgumentException("Unknown DiagnosticOrderPriority code '" + codeString + "'");
        }

        public Enumeration<DiagnosticOrderPriority> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<DiagnosticOrderPriority>(this, DiagnosticOrderPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<DiagnosticOrderPriority>(this, DiagnosticOrderPriority.URGENT);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<DiagnosticOrderPriority>(this, DiagnosticOrderPriority.STAT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<DiagnosticOrderPriority>(this, DiagnosticOrderPriority.ASAP);
            }
            throw new FHIRException("Unknown DiagnosticOrderPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticOrderPriority code) {
            if (code == DiagnosticOrderPriority.ROUTINE) {
                return "routine";
            }
            if (code == DiagnosticOrderPriority.URGENT) {
                return "urgent";
            }
            if (code == DiagnosticOrderPriority.STAT) {
                return "stat";
            }
            if (code == DiagnosticOrderPriority.ASAP) {
                return "asap";
            }
            return "?";
        }
    }

    public static enum DiagnosticOrderPriority {
        ROUTINE,
        URGENT,
        STAT,
        ASAP,
        NULL;


        public static DiagnosticOrderPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            throw new FHIRException("Unknown DiagnosticOrderPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case STAT: {
                    return "stat";
                }
                case ASAP: {
                    return "asap";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/diagnostic-order-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/diagnostic-order-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/diagnostic-order-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/diagnostic-order-priority";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The order has a normal priority .";
                }
                case URGENT: {
                    return "The order should be urgently.";
                }
                case STAT: {
                    return "The order is time-critical.";
                }
                case ASAP: {
                    return "The order should be acted on as soon as possible.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case STAT: {
                    return "Stat";
                }
                case ASAP: {
                    return "ASAP";
                }
            }
            return "?";
        }
    }

    public static class DiagnosticOrderStatusEnumFactory
    implements EnumFactory<DiagnosticOrderStatus> {
        @Override
        public DiagnosticOrderStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return DiagnosticOrderStatus.PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return DiagnosticOrderStatus.DRAFT;
            }
            if ("planned".equals(codeString)) {
                return DiagnosticOrderStatus.PLANNED;
            }
            if ("requested".equals(codeString)) {
                return DiagnosticOrderStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return DiagnosticOrderStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return DiagnosticOrderStatus.ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return DiagnosticOrderStatus.INPROGRESS;
            }
            if ("review".equals(codeString)) {
                return DiagnosticOrderStatus.REVIEW;
            }
            if ("completed".equals(codeString)) {
                return DiagnosticOrderStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return DiagnosticOrderStatus.CANCELLED;
            }
            if ("suspended".equals(codeString)) {
                return DiagnosticOrderStatus.SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return DiagnosticOrderStatus.REJECTED;
            }
            if ("failed".equals(codeString)) {
                return DiagnosticOrderStatus.FAILED;
            }
            throw new IllegalArgumentException("Unknown DiagnosticOrderStatus code '" + codeString + "'");
        }

        public Enumeration<DiagnosticOrderStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.PROPOSED);
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.DRAFT);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.PLANNED);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.ACCEPTED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.INPROGRESS);
            }
            if ("review".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.REVIEW);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.CANCELLED);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.SUSPENDED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.REJECTED);
            }
            if ("failed".equals(codeString)) {
                return new Enumeration<DiagnosticOrderStatus>(this, DiagnosticOrderStatus.FAILED);
            }
            throw new FHIRException("Unknown DiagnosticOrderStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticOrderStatus code) {
            if (code == DiagnosticOrderStatus.PROPOSED) {
                return "proposed";
            }
            if (code == DiagnosticOrderStatus.DRAFT) {
                return "draft";
            }
            if (code == DiagnosticOrderStatus.PLANNED) {
                return "planned";
            }
            if (code == DiagnosticOrderStatus.REQUESTED) {
                return "requested";
            }
            if (code == DiagnosticOrderStatus.RECEIVED) {
                return "received";
            }
            if (code == DiagnosticOrderStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == DiagnosticOrderStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == DiagnosticOrderStatus.REVIEW) {
                return "review";
            }
            if (code == DiagnosticOrderStatus.COMPLETED) {
                return "completed";
            }
            if (code == DiagnosticOrderStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DiagnosticOrderStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == DiagnosticOrderStatus.REJECTED) {
                return "rejected";
            }
            if (code == DiagnosticOrderStatus.FAILED) {
                return "failed";
            }
            return "?";
        }
    }

    public static enum DiagnosticOrderStatus {
        PROPOSED,
        DRAFT,
        PLANNED,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        INPROGRESS,
        REVIEW,
        COMPLETED,
        CANCELLED,
        SUSPENDED,
        REJECTED,
        FAILED,
        NULL;


        public static DiagnosticOrderStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("review".equals(codeString)) {
                return REVIEW;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("failed".equals(codeString)) {
                return FAILED;
            }
            throw new FHIRException("Unknown DiagnosticOrderStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case DRAFT: {
                    return "draft";
                }
                case PLANNED: {
                    return "planned";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case REVIEW: {
                    return "review";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case REJECTED: {
                    return "rejected";
                }
                case FAILED: {
                    return "failed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case DRAFT: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case REVIEW: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
                case FAILED: {
                    return "http://hl7.org/fhir/diagnostic-order-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The request has been proposed.";
                }
                case DRAFT: {
                    return "The request is in preliminary form prior to being sent.";
                }
                case PLANNED: {
                    return "The request has been planned.";
                }
                case REQUESTED: {
                    return "The request has been placed.";
                }
                case RECEIVED: {
                    return "The receiving system has received the order, but not yet decided whether it will be performed.";
                }
                case ACCEPTED: {
                    return "The receiving system has accepted the order, but work has not yet commenced.";
                }
                case INPROGRESS: {
                    return "The work to fulfill the order is happening.";
                }
                case REVIEW: {
                    return "The work is complete, and the outcomes are being reviewed for approval.";
                }
                case COMPLETED: {
                    return "The work has been completed, the report(s) released, and no further work is planned.";
                }
                case CANCELLED: {
                    return "The request has been withdrawn.";
                }
                case SUSPENDED: {
                    return "The request has been held by originating system/user request.";
                }
                case REJECTED: {
                    return "The receiving system has declined to fulfill the request.";
                }
                case FAILED: {
                    return "The diagnostic investigation was attempted, but due to some procedural error, it could not be completed.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case DRAFT: {
                    return "Draft";
                }
                case PLANNED: {
                    return "Planned";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case INPROGRESS: {
                    return "In-Progress";
                }
                case REVIEW: {
                    return "Review";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case FAILED: {
                    return "Failed";
                }
            }
            return "?";
        }
    }
}

