/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Questionnaire", profile="http://hl7.org/fhir/Profile/Questionnaire")
public class Questionnaire
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External identifiers for this questionnaire", formalDefinition="This records identifiers associated with this question set that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Logical identifier for this version of Questionnaire", formalDefinition="The version number assigned by the publisher for business reasons.  It may remain the same when the resource is updated.")
    protected StringType version;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | published | retired", formalDefinition="The lifecycle status of the questionnaire as a whole.")
    protected Enumeration<QuestionnaireStatus> status;
    @Child(name="date", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date this version was authored", formalDefinition="The date that this questionnaire was last changed.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization/individual who designed the questionnaire", formalDefinition="Organization or person responsible for developing and maintaining the questionnaire.")
    protected StringType publisher;
    @Child(name="telecom", type={ContactPoint.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact information of the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactPoint> telecom;
    @Child(name="subjectType", type={CodeType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Resource that can be subject of QuestionnaireResponse", formalDefinition="Identifies the types of subjects that can be the subject of the questionnaire.")
    protected List<CodeType> subjectType;
    @Child(name="group", type={}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Grouped questions", formalDefinition="A collection of related questions (or further groupings of questions).")
    protected GroupComponent group;
    private static final long serialVersionUID = -1348292652L;
    @SearchParamDefinition(name="date", path="Questionnaire.date", description="When the questionnaire was last changed", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="Questionnaire.identifier", description="An identifier for the questionnaire", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="code", path="Questionnaire.group.concept", description="A code that corresponds to the questionnaire or one of its groups", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="publisher", path="Questionnaire.publisher", description="The author of the questionnaire", type="string")
    public static final String SP_PUBLISHER = "publisher";
    @SearchParamDefinition(name="title", path="Questionnaire.group.title", description="All or part of the name of the questionnaire (title for the root group of the questionnaire)", type="string")
    public static final String SP_TITLE = "title";
    @SearchParamDefinition(name="version", path="Questionnaire.version", description="The business version of the questionnaire", type="string")
    public static final String SP_VERSION = "version";
    @SearchParamDefinition(name="status", path="Questionnaire.status", description="The status of the questionnaire", type="token")
    public static final String SP_STATUS = "status";

    public Questionnaire() {
    }

    public Questionnaire(Enumeration<QuestionnaireStatus> status, GroupComponent group) {
        this.status = status;
        this.group = group;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Questionnaire addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    public Questionnaire setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    public Questionnaire setVersion(String value) {
        if (Utilities.noString((String)value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    public Enumeration<QuestionnaireStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<QuestionnaireStatus>(new QuestionnaireStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Questionnaire setStatusElement(Enumeration<QuestionnaireStatus> value) {
        this.status = value;
        return this;
    }

    public QuestionnaireStatus getStatus() {
        return this.status == null ? null : (QuestionnaireStatus)((Object)this.status.getValue());
    }

    public Questionnaire setStatus(QuestionnaireStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<QuestionnaireStatus>(new QuestionnaireStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    public Questionnaire setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    public Questionnaire setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    public Questionnaire setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    public Questionnaire setPublisher(String value) {
        if (Utilities.noString((String)value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Questionnaire addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public List<CodeType> getSubjectType() {
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        return this.subjectType;
    }

    public boolean hasSubjectType() {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType item : this.subjectType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addSubjectTypeElement() {
        CodeType t = new CodeType();
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return t;
    }

    public Questionnaire addSubjectType(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.subjectType == null) {
            this.subjectType = new ArrayList<CodeType>();
        }
        this.subjectType.add(t);
        return this;
    }

    public boolean hasSubjectType(String value) {
        if (this.subjectType == null) {
            return false;
        }
        for (CodeType v : this.subjectType) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public GroupComponent getGroup() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Questionnaire.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new GroupComponent();
            }
        }
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public Questionnaire setGroup(GroupComponent value) {
        this.group = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "This records identifiers associated with this question set that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_VERSION, "string", "The version number assigned by the publisher for business reasons.  It may remain the same when the resource is updated.", 0, Integer.MAX_VALUE, this.version));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The lifecycle status of the questionnaire as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DATE, "dateTime", "The date that this questionnaire was last changed.", 0, Integer.MAX_VALUE, this.date));
        childrenList.add(new Property(SP_PUBLISHER, "string", "Organization or person responsible for developing and maintaining the questionnaire.", 0, Integer.MAX_VALUE, this.publisher));
        childrenList.add(new Property("telecom", "ContactPoint", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property("subjectType", SP_CODE, "Identifies the types of subjects that can be the subject of the questionnaire.", 0, Integer.MAX_VALUE, this.subjectType));
        childrenList.add(new Property("group", "", "A collection of related questions (or further groupings of questions).", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new QuestionnaireStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals("subjectType")) {
            this.getSubjectType().add(this.castToCode(value));
        } else if (name.equals("group")) {
            this.group = (GroupComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.version");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.status");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.publisher");
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals("subjectType")) {
            throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.subjectType");
        }
        if (name.equals("group")) {
            this.group = new GroupComponent();
            return this.group;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Questionnaire";
    }

    @Override
    public Questionnaire copy() {
        Questionnaire dst = new Questionnaire();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.subjectType != null) {
            dst.subjectType = new ArrayList<CodeType>();
            for (CodeType codeType : this.subjectType) {
                dst.subjectType.add(codeType.copy());
            }
        }
        dst.group = this.group == null ? null : this.group.copy();
        return dst;
    }

    protected Questionnaire typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other;
        return Questionnaire.compareDeep(this.identifier, o.identifier, true) && Questionnaire.compareDeep(this.version, o.version, true) && Questionnaire.compareDeep(this.status, o.status, true) && Questionnaire.compareDeep(this.date, o.date, true) && Questionnaire.compareDeep(this.publisher, o.publisher, true) && Questionnaire.compareDeep(this.telecom, o.telecom, true) && Questionnaire.compareDeep(this.subjectType, o.subjectType, true) && Questionnaire.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Questionnaire)) {
            return false;
        }
        Questionnaire o = (Questionnaire)other;
        return Questionnaire.compareValues(this.version, o.version, true) && Questionnaire.compareValues(this.status, o.status, true) && Questionnaire.compareValues(this.date, o.date, true) && Questionnaire.compareValues(this.publisher, o.publisher, true) && Questionnaire.compareValues(this.subjectType, o.subjectType, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.version != null && !this.version.isEmpty() || this.status != null && !this.status.isEmpty() || this.date != null && !this.date.isEmpty() || this.publisher != null && !this.publisher.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.subjectType != null && !this.subjectType.isEmpty() || this.group != null && !this.group.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Questionnaire;
    }

    @Block
    public static class QuestionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="To link questionnaire with questionnaire response", formalDefinition="An identifier that is unique within the questionnaire allowing linkage to the equivalent group in a [[[QuestionnaireResponse]]] resource.")
        protected StringType linkId;
        @Child(name="concept", type={Coding.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Concept that represents this question on a questionnaire", formalDefinition="Identifies a how this question is known in a particular terminology such as LOINC.")
        protected List<Coding> concept;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text of the question as it is shown to the user", formalDefinition="The actual question as shown to the user to prompt them for an answer.")
        protected StringType text;
        @Child(name="type", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="boolean | decimal | integer | date | dateTime +", formalDefinition="The expected format of the answer, e.g. the type of input (string, integer) or whether a (multiple) choice is expected.")
        protected Enumeration<AnswerFormat> type;
        @Child(name="required", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the question must be answered in data results", formalDefinition="If true, indicates that the question must be answered and have required groups within it also present.  If false, the question and any contained groups may be skipped when answering the questionnaire.")
        protected BooleanType required;
        @Child(name="repeats", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the question  can have multiple answers", formalDefinition="If true, the question may have more than one answer.")
        protected BooleanType repeats;
        @Child(name="options", type={ValueSet.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Valueset containing permitted answers", formalDefinition="Reference to a value set containing a list of codes representing permitted answers for the question.")
        protected Reference options;
        protected ValueSet optionsTarget;
        @Child(name="option", type={Coding.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Permitted answer", formalDefinition="For a \"choice\" question, identifies one of the permitted answers for the question.")
        protected List<Coding> option;
        @Child(name="group", type={GroupComponent.class}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire group", formalDefinition="Nested group, containing nested question for this question. The order of groups within the question is relevant.")
        protected List<GroupComponent> group;
        private static final long serialVersionUID = -1078951042L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public List<Coding> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (Coding item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addConcept() {
            Coding t = new Coding();
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return t;
        }

        public QuestionComponent addConcept(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Enumeration<AnswerFormat> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<AnswerFormat>(new AnswerFormatEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public QuestionComponent setTypeElement(Enumeration<AnswerFormat> value) {
            this.type = value;
            return this;
        }

        public AnswerFormat getType() {
            return this.type == null ? null : (AnswerFormat)((Object)this.type.getValue());
        }

        public QuestionComponent setType(AnswerFormat value) {
            if (value == null) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new Enumeration<AnswerFormat>(new AnswerFormatEnumFactory());
                }
                this.type.setValue((Object)value);
            }
            return this;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public QuestionComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public QuestionComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getRepeatsElement() {
            if (this.repeats == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.repeats");
                }
                if (Configuration.doAutoCreate()) {
                    this.repeats = new BooleanType();
                }
            }
            return this.repeats;
        }

        public boolean hasRepeatsElement() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public boolean hasRepeats() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public QuestionComponent setRepeatsElement(BooleanType value) {
            this.repeats = value;
            return this;
        }

        public boolean getRepeats() {
            return this.repeats == null || this.repeats.isEmpty() ? false : (Boolean)this.repeats.getValue();
        }

        public QuestionComponent setRepeats(boolean value) {
            if (this.repeats == null) {
                this.repeats = new BooleanType();
            }
            this.repeats.setValue((Object)value);
            return this;
        }

        public Reference getOptions() {
            if (this.options == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.options");
                }
                if (Configuration.doAutoCreate()) {
                    this.options = new Reference();
                }
            }
            return this.options;
        }

        public boolean hasOptions() {
            return this.options != null && !this.options.isEmpty();
        }

        public QuestionComponent setOptions(Reference value) {
            this.options = value;
            return this;
        }

        public ValueSet getOptionsTarget() {
            if (this.optionsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.options");
                }
                if (Configuration.doAutoCreate()) {
                    this.optionsTarget = new ValueSet();
                }
            }
            return this.optionsTarget;
        }

        public QuestionComponent setOptionsTarget(ValueSet value) {
            this.optionsTarget = value;
            return this;
        }

        public List<Coding> getOption() {
            if (this.option == null) {
                this.option = new ArrayList<Coding>();
            }
            return this.option;
        }

        public boolean hasOption() {
            if (this.option == null) {
                return false;
            }
            for (Coding item : this.option) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addOption() {
            Coding t = new Coding();
            if (this.option == null) {
                this.option = new ArrayList<Coding>();
            }
            this.option.add(t);
            return t;
        }

        public QuestionComponent addOption(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.option == null) {
                this.option = new ArrayList<Coding>();
            }
            this.option.add(t);
            return this;
        }

        public List<GroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (GroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GroupComponent addGroup() {
            GroupComponent t = new GroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public QuestionComponent addGroup(GroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "An identifier that is unique within the questionnaire allowing linkage to the equivalent group in a [[[QuestionnaireResponse]]] resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property("concept", "Coding", "Identifies a how this question is known in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.concept));
            childrenList.add(new Property("text", "string", "The actual question as shown to the user to prompt them for an answer.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("type", Questionnaire.SP_CODE, "The expected format of the answer, e.g. the type of input (string, integer) or whether a (multiple) choice is expected.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("required", "boolean", "If true, indicates that the question must be answered and have required groups within it also present.  If false, the question and any contained groups may be skipped when answering the questionnaire.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property("repeats", "boolean", "If true, the question may have more than one answer.", 0, Integer.MAX_VALUE, this.repeats));
            childrenList.add(new Property("options", "Reference(ValueSet)", "Reference to a value set containing a list of codes representing permitted answers for the question.", 0, Integer.MAX_VALUE, this.options));
            childrenList.add(new Property("option", "Coding", "For a \"choice\" question, identifies one of the permitted answers for the question.", 0, Integer.MAX_VALUE, this.option));
            childrenList.add(new Property("group", "@Questionnaire.group", "Nested group, containing nested question for this question. The order of groups within the question is relevant.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add(this.castToCoding(value));
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("type")) {
                this.type = new AnswerFormatEnumFactory().fromType(value);
            } else if (name.equals("required")) {
                this.required = this.castToBoolean(value);
            } else if (name.equals("repeats")) {
                this.repeats = this.castToBoolean(value);
            } else if (name.equals("options")) {
                this.options = this.castToReference(value);
            } else if (name.equals("option")) {
                this.getOption().add(this.castToCoding(value));
            } else if (name.equals("group")) {
                this.getGroup().add((GroupComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.linkId");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.text");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.type");
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.required");
            }
            if (name.equals("repeats")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.repeats");
            }
            if (name.equals("options")) {
                this.options = new Reference();
                return this.options;
            }
            if (name.equals("option")) {
                return this.addOption();
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionComponent copy() {
            QuestionComponent dst = new QuestionComponent();
            this.copyValues(dst);
            StringType stringType = dst.linkId = this.linkId == null ? null : this.linkId.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<Coding>();
                for (Coding coding : this.concept) {
                    dst.concept.add(coding.copy());
                }
            }
            dst.text = this.text == null ? null : this.text.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.required = this.required == null ? null : this.required.copy();
            dst.repeats = this.repeats == null ? null : this.repeats.copy();
            Reference reference = dst.options = this.options == null ? null : this.options.copy();
            if (this.option != null) {
                dst.option = new ArrayList<Coding>();
                for (Coding coding : this.option) {
                    dst.option.add(coding.copy());
                }
            }
            if (this.group != null) {
                dst.group = new ArrayList<GroupComponent>();
                for (GroupComponent groupComponent : this.group) {
                    dst.group.add(groupComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionComponent)) {
                return false;
            }
            QuestionComponent o = (QuestionComponent)other;
            return QuestionComponent.compareDeep(this.linkId, o.linkId, true) && QuestionComponent.compareDeep(this.concept, o.concept, true) && QuestionComponent.compareDeep(this.text, o.text, true) && QuestionComponent.compareDeep(this.type, o.type, true) && QuestionComponent.compareDeep(this.required, o.required, true) && QuestionComponent.compareDeep(this.repeats, o.repeats, true) && QuestionComponent.compareDeep(this.options, o.options, true) && QuestionComponent.compareDeep(this.option, o.option, true) && QuestionComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionComponent)) {
                return false;
            }
            QuestionComponent o = (QuestionComponent)other;
            return QuestionComponent.compareValues(this.linkId, o.linkId, true) && QuestionComponent.compareValues(this.text, o.text, true) && QuestionComponent.compareValues(this.type, o.type, true) && QuestionComponent.compareValues(this.required, o.required, true) && QuestionComponent.compareValues(this.repeats, o.repeats, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.text != null && !this.text.isEmpty() || this.type != null && !this.type.isEmpty() || this.required != null && !this.required.isEmpty() || this.repeats != null && !this.repeats.isEmpty() || this.options != null && !this.options.isEmpty() || this.option != null && !this.option.isEmpty() || this.group != null && !this.group.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Questionnaire.group.question";
        }
    }

    @Block
    public static class GroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="To link questionnaire with questionnaire response", formalDefinition="An identifier that is unique within the Questionnaire allowing linkage to the equivalent group in a QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name to be displayed for group", formalDefinition="The human-readable name for this section of the questionnaire.")
        protected StringType title;
        @Child(name="concept", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Concept that represents this section in a questionnaire", formalDefinition="Identifies a how this group of questions is known in a particular terminology such as LOINC.")
        protected List<Coding> concept;
        @Child(name="text", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional text for the group", formalDefinition="Additional text for the group, used for display purposes.")
        protected StringType text;
        @Child(name="required", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the group must be included in data results", formalDefinition="If true, indicates that the group must be present and have required questions within it answered.  If false, the group may be skipped when answering the questionnaire.")
        protected BooleanType required;
        @Child(name="repeats", type={BooleanType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Whether the group may repeat", formalDefinition="Whether the group may occur multiple times in the instance, containing multiple sets of answers.")
        protected BooleanType repeats;
        @Child(name="group", type={GroupComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire group", formalDefinition="A sub-group within a group. The ordering of groups within this group is relevant.")
        protected List<GroupComponent> group;
        @Child(name="question", type={}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Questions in this group", formalDefinition="Set of questions within this group. The order of questions within the group is relevant.")
        protected List<QuestionComponent> question;
        private static final long serialVersionUID = 494129548L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public GroupComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public GroupComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public GroupComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public GroupComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public List<Coding> getConcept() {
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            return this.concept;
        }

        public boolean hasConcept() {
            if (this.concept == null) {
                return false;
            }
            for (Coding item : this.concept) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Coding addConcept() {
            Coding t = new Coding();
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return t;
        }

        public GroupComponent addConcept(Coding t) {
            if (t == null) {
                return this;
            }
            if (this.concept == null) {
                this.concept = new ArrayList<Coding>();
            }
            this.concept.add(t);
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public GroupComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public GroupComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public BooleanType getRequiredElement() {
            if (this.required == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.required");
                }
                if (Configuration.doAutoCreate()) {
                    this.required = new BooleanType();
                }
            }
            return this.required;
        }

        public boolean hasRequiredElement() {
            return this.required != null && !this.required.isEmpty();
        }

        public boolean hasRequired() {
            return this.required != null && !this.required.isEmpty();
        }

        public GroupComponent setRequiredElement(BooleanType value) {
            this.required = value;
            return this;
        }

        public boolean getRequired() {
            return this.required == null || this.required.isEmpty() ? false : (Boolean)this.required.getValue();
        }

        public GroupComponent setRequired(boolean value) {
            if (this.required == null) {
                this.required = new BooleanType();
            }
            this.required.setValue((Object)value);
            return this;
        }

        public BooleanType getRepeatsElement() {
            if (this.repeats == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.repeats");
                }
                if (Configuration.doAutoCreate()) {
                    this.repeats = new BooleanType();
                }
            }
            return this.repeats;
        }

        public boolean hasRepeatsElement() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public boolean hasRepeats() {
            return this.repeats != null && !this.repeats.isEmpty();
        }

        public GroupComponent setRepeatsElement(BooleanType value) {
            this.repeats = value;
            return this;
        }

        public boolean getRepeats() {
            return this.repeats == null || this.repeats.isEmpty() ? false : (Boolean)this.repeats.getValue();
        }

        public GroupComponent setRepeats(boolean value) {
            if (this.repeats == null) {
                this.repeats = new BooleanType();
            }
            this.repeats.setValue((Object)value);
            return this;
        }

        public List<GroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (GroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GroupComponent addGroup() {
            GroupComponent t = new GroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public GroupComponent addGroup(GroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        public List<QuestionComponent> getQuestion() {
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            return this.question;
        }

        public boolean hasQuestion() {
            if (this.question == null) {
                return false;
            }
            for (QuestionComponent item : this.question) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionComponent addQuestion() {
            QuestionComponent t = new QuestionComponent();
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            this.question.add(t);
            return t;
        }

        public GroupComponent addQuestion(QuestionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            this.question.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "An identifier that is unique within the Questionnaire allowing linkage to the equivalent group in a QuestionnaireResponse resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property(Questionnaire.SP_TITLE, "string", "The human-readable name for this section of the questionnaire.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("concept", "Coding", "Identifies a how this group of questions is known in a particular terminology such as LOINC.", 0, Integer.MAX_VALUE, this.concept));
            childrenList.add(new Property("text", "string", "Additional text for the group, used for display purposes.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("required", "boolean", "If true, indicates that the group must be present and have required questions within it answered.  If false, the group may be skipped when answering the questionnaire.", 0, Integer.MAX_VALUE, this.required));
            childrenList.add(new Property("repeats", "boolean", "Whether the group may occur multiple times in the instance, containing multiple sets of answers.", 0, Integer.MAX_VALUE, this.repeats));
            childrenList.add(new Property("group", "@Questionnaire.group", "A sub-group within a group. The ordering of groups within this group is relevant.", 0, Integer.MAX_VALUE, this.group));
            childrenList.add(new Property("question", "", "Set of questions within this group. The order of questions within the group is relevant.", 0, Integer.MAX_VALUE, this.question));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals(Questionnaire.SP_TITLE)) {
                this.title = this.castToString(value);
            } else if (name.equals("concept")) {
                this.getConcept().add(this.castToCoding(value));
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("required")) {
                this.required = this.castToBoolean(value);
            } else if (name.equals("repeats")) {
                this.repeats = this.castToBoolean(value);
            } else if (name.equals("group")) {
                this.getGroup().add((GroupComponent)value);
            } else if (name.equals("question")) {
                this.getQuestion().add((QuestionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.linkId");
            }
            if (name.equals(Questionnaire.SP_TITLE)) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.title");
            }
            if (name.equals("concept")) {
                return this.addConcept();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.text");
            }
            if (name.equals("required")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.required");
            }
            if (name.equals("repeats")) {
                throw new FHIRException("Cannot call addChild on a primitive type Questionnaire.repeats");
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            if (name.equals("question")) {
                return this.addQuestion();
            }
            return super.addChild(name);
        }

        @Override
        public GroupComponent copy() {
            GroupComponent dst = new GroupComponent();
            this.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            StringType stringType = dst.title = this.title == null ? null : this.title.copy();
            if (this.concept != null) {
                dst.concept = new ArrayList<Coding>();
                for (Coding coding : this.concept) {
                    dst.concept.add(coding.copy());
                }
            }
            dst.text = this.text == null ? null : this.text.copy();
            dst.required = this.required == null ? null : this.required.copy();
            BooleanType booleanType = dst.repeats = this.repeats == null ? null : this.repeats.copy();
            if (this.group != null) {
                dst.group = new ArrayList<GroupComponent>();
                for (GroupComponent groupComponent : this.group) {
                    dst.group.add(groupComponent.copy());
                }
            }
            if (this.question != null) {
                dst.question = new ArrayList<QuestionComponent>();
                for (QuestionComponent questionComponent : this.question) {
                    dst.question.add(questionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other;
            return GroupComponent.compareDeep(this.linkId, o.linkId, true) && GroupComponent.compareDeep(this.title, o.title, true) && GroupComponent.compareDeep(this.concept, o.concept, true) && GroupComponent.compareDeep(this.text, o.text, true) && GroupComponent.compareDeep(this.required, o.required, true) && GroupComponent.compareDeep(this.repeats, o.repeats, true) && GroupComponent.compareDeep(this.group, o.group, true) && GroupComponent.compareDeep(this.question, o.question, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other;
            return GroupComponent.compareValues(this.linkId, o.linkId, true) && GroupComponent.compareValues(this.title, o.title, true) && GroupComponent.compareValues(this.text, o.text, true) && GroupComponent.compareValues(this.required, o.required, true) && GroupComponent.compareValues(this.repeats, o.repeats, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.title != null && !this.title.isEmpty() || this.concept != null && !this.concept.isEmpty() || this.text != null && !this.text.isEmpty() || this.required != null && !this.required.isEmpty() || this.repeats != null && !this.repeats.isEmpty() || this.group != null && !this.group.isEmpty() || this.question != null && !this.question.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Questionnaire.group";
        }
    }

    public static class AnswerFormatEnumFactory
    implements EnumFactory<AnswerFormat> {
        @Override
        public AnswerFormat fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("boolean".equals(codeString)) {
                return AnswerFormat.BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return AnswerFormat.DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return AnswerFormat.INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return AnswerFormat.DATE;
            }
            if ("dateTime".equals(codeString)) {
                return AnswerFormat.DATETIME;
            }
            if ("instant".equals(codeString)) {
                return AnswerFormat.INSTANT;
            }
            if ("time".equals(codeString)) {
                return AnswerFormat.TIME;
            }
            if ("string".equals(codeString)) {
                return AnswerFormat.STRING;
            }
            if ("text".equals(codeString)) {
                return AnswerFormat.TEXT;
            }
            if ("url".equals(codeString)) {
                return AnswerFormat.URL;
            }
            if ("choice".equals(codeString)) {
                return AnswerFormat.CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return AnswerFormat.OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return AnswerFormat.ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return AnswerFormat.REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return AnswerFormat.QUANTITY;
            }
            throw new IllegalArgumentException("Unknown AnswerFormat code '" + codeString + "'");
        }

        public Enumeration<AnswerFormat> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("boolean".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.BOOLEAN);
            }
            if ("decimal".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.DECIMAL);
            }
            if ("integer".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.INTEGER);
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.DATE);
            }
            if ("dateTime".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.DATETIME);
            }
            if ("instant".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.INSTANT);
            }
            if ("time".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.TIME);
            }
            if ("string".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.STRING);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.TEXT);
            }
            if ("url".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.URL);
            }
            if ("choice".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.CHOICE);
            }
            if ("open-choice".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.OPENCHOICE);
            }
            if ("attachment".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.ATTACHMENT);
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.REFERENCE);
            }
            if ("quantity".equals(codeString)) {
                return new Enumeration<AnswerFormat>(this, AnswerFormat.QUANTITY);
            }
            throw new FHIRException("Unknown AnswerFormat code '" + codeString + "'");
        }

        @Override
        public String toCode(AnswerFormat code) {
            if (code == AnswerFormat.BOOLEAN) {
                return "boolean";
            }
            if (code == AnswerFormat.DECIMAL) {
                return "decimal";
            }
            if (code == AnswerFormat.INTEGER) {
                return "integer";
            }
            if (code == AnswerFormat.DATE) {
                return Questionnaire.SP_DATE;
            }
            if (code == AnswerFormat.DATETIME) {
                return "dateTime";
            }
            if (code == AnswerFormat.INSTANT) {
                return "instant";
            }
            if (code == AnswerFormat.TIME) {
                return "time";
            }
            if (code == AnswerFormat.STRING) {
                return "string";
            }
            if (code == AnswerFormat.TEXT) {
                return "text";
            }
            if (code == AnswerFormat.URL) {
                return "url";
            }
            if (code == AnswerFormat.CHOICE) {
                return "choice";
            }
            if (code == AnswerFormat.OPENCHOICE) {
                return "open-choice";
            }
            if (code == AnswerFormat.ATTACHMENT) {
                return "attachment";
            }
            if (code == AnswerFormat.REFERENCE) {
                return "reference";
            }
            if (code == AnswerFormat.QUANTITY) {
                return "quantity";
            }
            return "?";
        }
    }

    public static enum AnswerFormat {
        BOOLEAN,
        DECIMAL,
        INTEGER,
        DATE,
        DATETIME,
        INSTANT,
        TIME,
        STRING,
        TEXT,
        URL,
        CHOICE,
        OPENCHOICE,
        ATTACHMENT,
        REFERENCE,
        QUANTITY,
        NULL;


        public static AnswerFormat fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("boolean".equals(codeString)) {
                return BOOLEAN;
            }
            if ("decimal".equals(codeString)) {
                return DECIMAL;
            }
            if ("integer".equals(codeString)) {
                return INTEGER;
            }
            if (Questionnaire.SP_DATE.equals(codeString)) {
                return DATE;
            }
            if ("dateTime".equals(codeString)) {
                return DATETIME;
            }
            if ("instant".equals(codeString)) {
                return INSTANT;
            }
            if ("time".equals(codeString)) {
                return TIME;
            }
            if ("string".equals(codeString)) {
                return STRING;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if ("url".equals(codeString)) {
                return URL;
            }
            if ("choice".equals(codeString)) {
                return CHOICE;
            }
            if ("open-choice".equals(codeString)) {
                return OPENCHOICE;
            }
            if ("attachment".equals(codeString)) {
                return ATTACHMENT;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("quantity".equals(codeString)) {
                return QUANTITY;
            }
            throw new FHIRException("Unknown AnswerFormat code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case BOOLEAN: {
                    return "boolean";
                }
                case DECIMAL: {
                    return "decimal";
                }
                case INTEGER: {
                    return "integer";
                }
                case DATE: {
                    return Questionnaire.SP_DATE;
                }
                case DATETIME: {
                    return "dateTime";
                }
                case INSTANT: {
                    return "instant";
                }
                case TIME: {
                    return "time";
                }
                case STRING: {
                    return "string";
                }
                case TEXT: {
                    return "text";
                }
                case URL: {
                    return "url";
                }
                case CHOICE: {
                    return "choice";
                }
                case OPENCHOICE: {
                    return "open-choice";
                }
                case ATTACHMENT: {
                    return "attachment";
                }
                case REFERENCE: {
                    return "reference";
                }
                case QUANTITY: {
                    return "quantity";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case BOOLEAN: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case DECIMAL: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case INTEGER: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case DATE: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case DATETIME: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case INSTANT: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case TIME: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case STRING: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case URL: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case CHOICE: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case OPENCHOICE: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case ATTACHMENT: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case REFERENCE: {
                    return "http://hl7.org/fhir/answer-format";
                }
                case QUANTITY: {
                    return "http://hl7.org/fhir/answer-format";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case BOOLEAN: {
                    return "Answer is a yes/no answer.";
                }
                case DECIMAL: {
                    return "Answer is a floating point number.";
                }
                case INTEGER: {
                    return "Answer is an integer.";
                }
                case DATE: {
                    return "Answer is a date.";
                }
                case DATETIME: {
                    return "Answer is a date and time.";
                }
                case INSTANT: {
                    return "Answer is a system timestamp.";
                }
                case TIME: {
                    return "Answer is a time (hour/minute/second) independent of date.";
                }
                case STRING: {
                    return "Answer is a short (few words to short sentence) free-text entry.";
                }
                case TEXT: {
                    return "Answer is a long (potentially multi-paragraph) free-text entry (still captured as a string).";
                }
                case URL: {
                    return "Answer is a url (website, FTP site, etc.).";
                }
                case CHOICE: {
                    return "Answer is a Coding drawn from a list of options.";
                }
                case OPENCHOICE: {
                    return "Answer is a Coding drawn from a list of options or a free-text entry.";
                }
                case ATTACHMENT: {
                    return "Answer is binary content such as a image, PDF, etc.";
                }
                case REFERENCE: {
                    return "Answer is a reference to another resource (practitioner, organization, etc.).";
                }
                case QUANTITY: {
                    return "Answer is a combination of a numeric value and unit, potentially with a comparator (<, >, etc.).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case BOOLEAN: {
                    return "Boolean";
                }
                case DECIMAL: {
                    return "Decimal";
                }
                case INTEGER: {
                    return "Integer";
                }
                case DATE: {
                    return "Date";
                }
                case DATETIME: {
                    return "Date Time";
                }
                case INSTANT: {
                    return "Instant";
                }
                case TIME: {
                    return "Time";
                }
                case STRING: {
                    return "String";
                }
                case TEXT: {
                    return "Text";
                }
                case URL: {
                    return "Url";
                }
                case CHOICE: {
                    return "Choice";
                }
                case OPENCHOICE: {
                    return "Open Choice";
                }
                case ATTACHMENT: {
                    return "Attachment";
                }
                case REFERENCE: {
                    return "Reference";
                }
                case QUANTITY: {
                    return "Quantity";
                }
            }
            return "?";
        }
    }

    public static class QuestionnaireStatusEnumFactory
    implements EnumFactory<QuestionnaireStatus> {
        @Override
        public QuestionnaireStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return QuestionnaireStatus.DRAFT;
            }
            if ("published".equals(codeString)) {
                return QuestionnaireStatus.PUBLISHED;
            }
            if ("retired".equals(codeString)) {
                return QuestionnaireStatus.RETIRED;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.DRAFT);
            }
            if ("published".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.PUBLISHED);
            }
            if ("retired".equals(codeString)) {
                return new Enumeration<QuestionnaireStatus>(this, QuestionnaireStatus.RETIRED);
            }
            throw new FHIRException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireStatus code) {
            if (code == QuestionnaireStatus.DRAFT) {
                return "draft";
            }
            if (code == QuestionnaireStatus.PUBLISHED) {
                return "published";
            }
            if (code == QuestionnaireStatus.RETIRED) {
                return "retired";
            }
            return "?";
        }
    }

    public static enum QuestionnaireStatus {
        DRAFT,
        PUBLISHED,
        RETIRED,
        NULL;


        public static QuestionnaireStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("published".equals(codeString)) {
                return PUBLISHED;
            }
            if ("retired".equals(codeString)) {
                return RETIRED;
            }
            throw new FHIRException("Unknown QuestionnaireStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case PUBLISHED: {
                    return "published";
                }
                case RETIRED: {
                    return "retired";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
                case PUBLISHED: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
                case RETIRED: {
                    return "http://hl7.org/fhir/questionnaire-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "This Questionnaire is not ready for official use.";
                }
                case PUBLISHED: {
                    return "This Questionnaire is ready for use.";
                }
                case RETIRED: {
                    return "This Questionnaire should no longer be used to gather data.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case PUBLISHED: {
                    return "Published";
                }
                case RETIRED: {
                    return "Retired";
                }
            }
            return "?";
        }
    }
}

