/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.Narrative;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IDomainResource;

public abstract class DomainResource
extends Resource
implements IBaseHasExtensions,
IBaseHasModifierExtensions,
IDomainResource {
    @Child(name="text", type={Narrative.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Text summary of the resource, for human interpretation", formalDefinition="A human-readable narrative that contains a summary of the resource, and may be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.")
    protected Narrative text;
    @Child(name="contained", type={Resource.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contained, inline Resources", formalDefinition="These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.")
    protected List<Resource> contained;
    @Child(name="extension", type={Extension.class}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional Content defined by implementations", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource. In order to make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.")
    protected List<Extension> extension;
    @Child(name="modifierExtension", type={Extension.class}, order=3, min=0, max=-1, modifier=true, summary=false)
    @Description(shortDefinition="Extensions that cannot be ignored", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.")
    protected List<Extension> modifierExtension;
    private static final long serialVersionUID = -970285559L;

    public Narrative getText() {
        if (this.text == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DomainResource.text");
            }
            if (Configuration.doAutoCreate()) {
                this.text = new Narrative();
            }
        }
        return this.text;
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public DomainResource setText(Narrative value) {
        this.text = value;
        return this;
    }

    public List<Resource> getContained() {
        if (this.contained == null) {
            this.contained = new ArrayList<Resource>();
        }
        return this.contained;
    }

    public boolean hasContained() {
        if (this.contained == null) {
            return false;
        }
        for (Resource item : this.contained) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DomainResource addContained(Resource t) {
        if (t == null) {
            return this;
        }
        if (this.contained == null) {
            this.contained = new ArrayList<Resource>();
        }
        this.contained.add(t);
        return this;
    }

    public List<Extension> getExtension() {
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        return this.extension;
    }

    public boolean hasExtension() {
        if (this.extension == null) {
            return false;
        }
        for (Extension item : this.extension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addExtension() {
        Extension t = new Extension();
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return t;
    }

    public DomainResource addExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.extension == null) {
            this.extension = new ArrayList<Extension>();
        }
        this.extension.add(t);
        return this;
    }

    public List<Extension> getModifierExtension() {
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        return this.modifierExtension;
    }

    public boolean hasModifierExtension() {
        if (this.modifierExtension == null) {
            return false;
        }
        for (Extension item : this.modifierExtension) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Extension addModifierExtension() {
        Extension t = new Extension();
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return t;
    }

    public DomainResource addModifierExtension(Extension t) {
        if (t == null) {
            return this;
        }
        if (this.modifierExtension == null) {
            this.modifierExtension = new ArrayList<Extension>();
        }
        this.modifierExtension.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        childrenList.add(new Property("text", "Narrative", "A human-readable narrative that contains a summary of the resource, and may be used to represent the content of the resource to a human. The narrative need not encode all the structured data, but is required to contain sufficient detail to make it \"clinically safe\" for a human to just read the narrative. Resource definitions may define what content should be represented in the narrative to ensure clinical safety.", 0, Integer.MAX_VALUE, this.text));
        childrenList.add(new Property("contained", "Resource", "These resources do not have an independent existence apart from the resource that contains them - they cannot be identified independently, and nor can they have their own independent transaction scope.", 0, Integer.MAX_VALUE, this.contained));
        childrenList.add(new Property("extension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource. In order to make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.", 0, Integer.MAX_VALUE, this.extension));
        childrenList.add(new Property("modifierExtension", "Extension", "May be used to represent additional information that is not part of the basic definition of the resource, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.", 0, Integer.MAX_VALUE, this.modifierExtension));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("text")) {
            this.text = this.castToNarrative(value);
        } else if (name.equals("contained")) {
            this.getContained().add(this.castToResource(value));
        } else if (name.equals("extension")) {
            this.getExtension().add(this.castToExtension(value));
        } else if (name.equals("modifierExtension")) {
            this.getModifierExtension().add(this.castToExtension(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("text")) {
            this.text = new Narrative();
            return this.text;
        }
        if (name.equals("contained")) {
            throw new FHIRException("Cannot call addChild on an abstract type DomainResource.contained");
        }
        if (name.equals("extension")) {
            return this.addExtension();
        }
        if (name.equals("modifierExtension")) {
            return this.addModifierExtension();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DomainResource";
    }

    @Override
    public abstract DomainResource copy();

    public void copyValues(DomainResource dst) {
        super.copyValues(dst);
        Narrative narrative = dst.text = this.text == null ? null : this.text.copy();
        if (this.contained != null) {
            dst.contained = new ArrayList<Resource>();
            for (Resource resource : this.contained) {
                dst.contained.add(resource.copy());
            }
        }
        if (this.extension != null) {
            dst.extension = new ArrayList<Extension>();
            for (Extension extension : this.extension) {
                dst.extension.add(extension.copy());
            }
        }
        if (this.modifierExtension != null) {
            dst.modifierExtension = new ArrayList<Extension>();
            for (Extension extension : this.modifierExtension) {
                dst.modifierExtension.add(extension.copy());
            }
        }
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DomainResource)) {
            return false;
        }
        DomainResource o = (DomainResource)other;
        return DomainResource.compareDeep(this.text, o.text, true) && DomainResource.compareDeep(this.contained, o.contained, true) && DomainResource.compareDeep(this.extension, o.extension, true) && DomainResource.compareDeep(this.modifierExtension, o.modifierExtension, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DomainResource)) {
            return false;
        }
        DomainResource o = (DomainResource)other;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.text != null && !this.text.isEmpty() || this.contained != null && !this.contained.isEmpty() || this.extension != null && !this.extension.isEmpty() || this.modifierExtension != null && !this.modifierExtension.isEmpty());
    }
}

