/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Organization", profile="http://hl7.org/fhir/Profile/Organization")
public class Organization
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifies this organization  across multiple systems", formalDefinition="Identifier for the organization that is used to identify the organization across multiple disparate systems.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether the organization's record is still in active use", formalDefinition="Whether the organization's record is still in active use.")
    protected BooleanType active;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Kind of organization", formalDefinition="The kind of organization that this is.")
    protected CodeableConcept type;
    @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name used for the organization", formalDefinition="A name associated with the organization.")
    protected StringType name;
    @Child(name="telecom", type={ContactPoint.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A contact detail for the organization", formalDefinition="A contact detail for the organization.")
    protected List<ContactPoint> telecom;
    @Child(name="address", type={Address.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="An address for the organization", formalDefinition="An address for the organization.")
    protected List<Address> address;
    @Child(name="partOf", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The organization of which this organization forms a part", formalDefinition="The organization of which this organization forms a part.")
    protected Reference partOf;
    protected Organization partOfTarget;
    @Child(name="contact", type={}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contact for the organization for a certain purpose", formalDefinition="Contact for the organization for a certain purpose.")
    protected List<OrganizationContactComponent> contact;
    private static final long serialVersionUID = -749567123L;
    @SearchParamDefinition(name="identifier", path="Organization.identifier", description="Any identifier for the organization (not the accreditation issuer's identifier)", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="partof", path="Organization.partOf", description="Search all organizations that are part of the given organization", type="reference")
    public static final String SP_PARTOF = "partof";
    @SearchParamDefinition(name="phonetic", path="Organization.name", description="A portion of the organization's name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    @SearchParamDefinition(name="address", path="Organization.address", description="A (part of the) address of the Organization", type="string")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="address-state", path="Organization.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESSSTATE = "address-state";
    @SearchParamDefinition(name="name", path="Organization.name", description="A portion of the organization's name", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="address-use", path="Organization.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESSUSE = "address-use";
    @SearchParamDefinition(name="active", path="Organization.active", description="Whether the organization's record is active", type="token")
    public static final String SP_ACTIVE = "active";
    @SearchParamDefinition(name="type", path="Organization.type", description="A code for the type of organization", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="address-city", path="Organization.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESSCITY = "address-city";
    @SearchParamDefinition(name="address-postalcode", path="Organization.address.postalCode", description="A postal code specified in an address", type="string")
    public static final String SP_ADDRESSPOSTALCODE = "address-postalcode";
    @SearchParamDefinition(name="address-country", path="Organization.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESSCOUNTRY = "address-country";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Organization addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Organization setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Organization setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Organization setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Organization setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Organization setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Organization addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Organization addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Organization setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Organization getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Organization.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Organization();
            }
        }
        return this.partOfTarget;
    }

    public Organization setPartOfTarget(Organization value) {
        this.partOfTarget = value;
        return this;
    }

    public List<OrganizationContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (OrganizationContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public OrganizationContactComponent addContact() {
        OrganizationContactComponent t = new OrganizationContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public Organization addContact(OrganizationContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<OrganizationContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for the organization that is used to identify the organization across multiple disparate systems.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_ACTIVE, "boolean", "Whether the organization's record is still in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "The kind of organization that this is.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_NAME, "string", "A name associated with the organization.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property("telecom", "ContactPoint", "A contact detail for the organization.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_ADDRESS, "Address", "An address for the organization.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("partOf", "Reference(Organization)", "The organization of which this organization forms a part.", 0, Integer.MAX_VALUE, this.partOf));
        childrenList.add(new Property("contact", "", "Contact for the organization for a certain purpose.", 0, Integer.MAX_VALUE, this.contact));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals("telecom")) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else if (name.equals("contact")) {
            this.getContact().add((OrganizationContactComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.active");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type Organization.name");
        }
        if (name.equals("telecom")) {
            return this.addTelecom();
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Organization";
    }

    @Override
    public Organization copy() {
        Organization dst = new Organization();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        dst.type = this.type == null ? null : this.type.copy();
        StringType stringType = dst.name = this.name == null ? null : this.name.copy();
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        Reference reference = dst.partOf = this.partOf == null ? null : this.partOf.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<OrganizationContactComponent>();
            for (OrganizationContactComponent organizationContactComponent : this.contact) {
                dst.contact.add(organizationContactComponent.copy());
            }
        }
        return dst;
    }

    protected Organization typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other;
        return Organization.compareDeep(this.identifier, o.identifier, true) && Organization.compareDeep(this.active, o.active, true) && Organization.compareDeep(this.type, o.type, true) && Organization.compareDeep(this.name, o.name, true) && Organization.compareDeep(this.telecom, o.telecom, true) && Organization.compareDeep(this.address, o.address, true) && Organization.compareDeep(this.partOf, o.partOf, true) && Organization.compareDeep(this.contact, o.contact, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Organization)) {
            return false;
        }
        Organization o = (Organization)other;
        return Organization.compareValues(this.active, o.active, true) && Organization.compareValues(this.name, o.name, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.active != null && !this.active.isEmpty() || this.type != null && !this.type.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.address != null && !this.address.isEmpty() || this.partOf != null && !this.partOf.isEmpty() || this.contact != null && !this.contact.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Organization;
    }

    @Block
    public static class OrganizationContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="purpose", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of contact", formalDefinition="Indicates a purpose for which the contact can be reached.")
        protected CodeableConcept purpose;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact", formalDefinition="A name associated with the contact.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contact details (telephone, email, etc.)  for a contact", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Visiting or postal addresses for the contact", formalDefinition="Visiting or postal addresses for the contact.")
        protected Address address;
        private static final long serialVersionUID = 1831121305L;

        public CodeableConcept getPurpose() {
            if (this.purpose == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.purpose");
                }
                if (Configuration.doAutoCreate()) {
                    this.purpose = new CodeableConcept();
                }
            }
            return this.purpose;
        }

        public boolean hasPurpose() {
            return this.purpose != null && !this.purpose.isEmpty();
        }

        public OrganizationContactComponent setPurpose(CodeableConcept value) {
            this.purpose = value;
            return this;
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public OrganizationContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public OrganizationContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create OrganizationContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public OrganizationContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("purpose", "CodeableConcept", "Indicates a purpose for which the contact can be reached.", 0, Integer.MAX_VALUE, this.purpose));
            childrenList.add(new Property(Organization.SP_NAME, "HumanName", "A name associated with the contact.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("telecom", "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the party may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
            childrenList.add(new Property(Organization.SP_ADDRESS, "Address", "Visiting or postal addresses for the contact.", 0, Integer.MAX_VALUE, this.address));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = this.castToCodeableConcept(value);
            } else if (name.equals(Organization.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals("telecom")) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(Organization.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("purpose")) {
                this.purpose = new CodeableConcept();
                return this.purpose;
            }
            if (name.equals(Organization.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals("telecom")) {
                return this.addTelecom();
            }
            if (name.equals(Organization.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            return super.addChild(name);
        }

        @Override
        public OrganizationContactComponent copy() {
            OrganizationContactComponent dst = new OrganizationContactComponent();
            this.copyValues(dst);
            dst.purpose = this.purpose == null ? null : this.purpose.copy();
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint i : this.telecom) {
                    dst.telecom.add(i.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof OrganizationContactComponent)) {
                return false;
            }
            OrganizationContactComponent o = (OrganizationContactComponent)other;
            return OrganizationContactComponent.compareDeep(this.purpose, o.purpose, true) && OrganizationContactComponent.compareDeep(this.name, o.name, true) && OrganizationContactComponent.compareDeep(this.telecom, o.telecom, true) && OrganizationContactComponent.compareDeep(this.address, o.address, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof OrganizationContactComponent)) {
                return false;
            }
            OrganizationContactComponent o = (OrganizationContactComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.purpose != null && !this.purpose.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.address != null && !this.address.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Organization.contact";
        }
    }
}

