/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.util.List;
import java.util.Locale;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.formats.ParserType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2.utils.validation.IResourceValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public interface IWorkerContext {
    public IParser getParser(ParserType var1);

    public IParser getParser(String var1);

    public IParser newJsonParser();

    public IParser newXmlParser();

    public INarrativeGenerator getNarrativeGenerator(String var1, String var2);

    public IResourceValidator newValidator();

    public <T extends Resource> T fetchResource(Class<T> var1, String var2);

    public <T extends Resource> boolean hasResource(Class<T> var1, String var2);

    public List<String> getResourceNames();

    public ValueSet fetchCodeSystem(String var1);

    public boolean supportsSystem(String var1);

    public List<ConceptMap> findMapsForSource(String var1);

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet var1, boolean var2);

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent var1);

    public Locale getLocale();

    public void setLocale(Locale var1);

    public String formatMessage(String var1, Object ... var2);

    public void setValidationMessageLanguage(Locale var1);

    public ValidationResult validateCode(String var1, String var2, String var3);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet var4);

    public ValidationResult validateCode(Coding var1, ValueSet var2);

    public ValidationResult validateCode(CodeableConcept var1, ValueSet var2);

    public ValidationResult validateCode(String var1, String var2, String var3, ValueSet.ConceptSetComponent var4);

    public String getAbbreviation(String var1);

    public List<StructureDefinition> allStructures();

    public StructureDefinition fetchTypeDefinition(String var1);

    public static class ValidationResult {
        private ValueSet.ConceptDefinitionComponent definition;
        private ValidationMessage.IssueSeverity severity;
        private String message;

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public ValidationResult(ValueSet.ConceptDefinitionComponent definition) {
            this.definition = definition;
        }

        public ValidationResult(ValidationMessage.IssueSeverity severity, String message, ValueSet.ConceptDefinitionComponent definition) {
            this.severity = severity;
            this.message = message;
            this.definition = definition;
        }

        public boolean isOk() {
            return this.definition != null;
        }

        public String getDisplay() {
            return this.definition == null ? "??" : this.definition.getDisplay();
        }

        public ValueSet.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public ValidationMessage.IssueSeverity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

