/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Attachment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Communication", profile="http://hl7.org/fhir/Profile/Communication")
public class Communication
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).")
    protected List<Identifier> identifier;
    @Child(name="definition", type={PlanDefinition.class, ActivityDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Instantiates protocol or definition", formalDefinition="A protocol, guideline, or other definition that was adhered to in whole or in part by this communication event.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request fulfilled by this communication", formalDefinition="An order, proposal or plan fulfilled in whole or in part by this Communication.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="partOf", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Part of this action", formalDefinition="Part of this action.")
    protected List<Reference> partOf;
    protected List<Resource> partOfTarget;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="preparation | in-progress | suspended | aborted | completed | entered-in-error", formalDefinition="The status of the transmission.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/event-status")
    protected Enumeration<CommunicationStatus> status;
    @Child(name="notDone", type={BooleanType.class}, order=5, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Communication did not occur", formalDefinition="If true, indicates that the described communication event did not actually occur.")
    protected BooleanType notDone;
    @Child(name="notDoneReason", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Why communication did not occur", formalDefinition="Describes why the communication event did not occur in coded and/or textual form.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/communication-not-done-reason")
    protected CodeableConcept notDoneReason;
    @Child(name="category", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message category", formalDefinition="The type of message conveyed such as alert, notification, reminder, instruction, etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/communication-category")
    protected List<CodeableConcept> category;
    @Child(name="medium", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A channel of communication", formalDefinition="A channel that was used for this communication (e.g. email, fax).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ParticipationMode")
    protected List<CodeableConcept> medium;
    @Child(name="subject", type={Patient.class, Group.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of message", formalDefinition="The patient or group that was the focus of this communication.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="recipient", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Group.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message recipient", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).")
    protected List<Reference> recipient;
    protected List<Resource> recipientTarget;
    @Child(name="topic", type={Reference.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Focal resources", formalDefinition="The resources which were responsible for or related to producing this communication.")
    protected List<Reference> topic;
    protected List<Resource> topicTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter or episode leading to message", formalDefinition="The encounter within which the communication was sent.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="sent", type={DateTimeType.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When sent", formalDefinition="The time when this communication was sent.")
    protected DateTimeType sent;
    @Child(name="received", type={DateTimeType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="When received", formalDefinition="The time when this communication arrived at the destination.")
    protected DateTimeType received;
    @Child(name="sender", type={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Message sender", formalDefinition="The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.")
    protected Reference sender;
    protected Resource senderTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Indication for message", formalDefinition="The reason or justification for the communication.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/clinical-findings")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Why was communication done?", formalDefinition="Indicates another resource whose existence justifies this communication.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="payload", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Message payload", formalDefinition="Text, attachment(s), or resource(s) that was communicated to the recipient.")
    protected List<CommunicationPayloadComponent> payload;
    @Child(name="note", type={Annotation.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments made about the communication", formalDefinition="Additional notes or commentary about the communication by the sender, receiver or other interested parties.")
    protected List<Annotation> note;
    private static final long serialVersionUID = -1362735590L;
    @SearchParamDefinition(name="identifier", path="Communication.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="Communication.subject", description="Focus of message", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Communication:subject").toLocked();
    @SearchParamDefinition(name="received", path="Communication.received", description="When received", type="date")
    public static final String SP_RECEIVED = "received";
    public static final DateClientParam RECEIVED = new DateClientParam("received");
    @SearchParamDefinition(name="part-of", path="Communication.partOf", description="Part of this action", type="reference")
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Communication:part-of").toLocked();
    @SearchParamDefinition(name="medium", path="Communication.medium", description="A channel of communication", type="token")
    public static final String SP_MEDIUM = "medium";
    public static final TokenClientParam MEDIUM = new TokenClientParam("medium");
    @SearchParamDefinition(name="encounter", path="Communication.context", description="Encounter leading to message", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("Communication:encounter").toLocked();
    @SearchParamDefinition(name="sent", path="Communication.sent", description="When sent", type="date")
    public static final String SP_SENT = "sent";
    public static final DateClientParam SENT = new DateClientParam("sent");
    @SearchParamDefinition(name="based-on", path="Communication.basedOn", description="Request fulfilled by this communication", type="reference")
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Communication:based-on").toLocked();
    @SearchParamDefinition(name="sender", path="Communication.sender", description="Message sender", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_SENDER = "sender";
    public static final ReferenceClientParam SENDER = new ReferenceClientParam("sender");
    public static final Include INCLUDE_SENDER = new Include("Communication:sender").toLocked();
    @SearchParamDefinition(name="patient", path="Communication.subject", description="Focus of message", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Communication:patient").toLocked();
    @SearchParamDefinition(name="recipient", path="Communication.recipient", description="Message recipient", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, Group.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("Communication:recipient").toLocked();
    @SearchParamDefinition(name="context", path="Communication.context", description="Encounter or episode leading to message", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("Communication:context").toLocked();
    @SearchParamDefinition(name="definition", path="Communication.definition", description="Instantiates protocol or definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("Communication:definition").toLocked();
    @SearchParamDefinition(name="category", path="Communication.category", description="Message category", type="token")
    public static final String SP_CATEGORY = "category";
    public static final TokenClientParam CATEGORY = new TokenClientParam("category");
    @SearchParamDefinition(name="status", path="Communication.status", description="preparation | in-progress | suspended | aborted | completed | entered-in-error", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Communication() {
    }

    public Communication(Enumeration<CommunicationStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Communication setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Communication addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public Communication setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public Communication addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Communication setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Communication addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getPartOf() {
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        return this.partOf;
    }

    public Communication setPartOf(List<Reference> thePartOf) {
        this.partOf = thePartOf;
        return this;
    }

    public boolean hasPartOf() {
        if (this.partOf == null) {
            return false;
        }
        for (Reference item : this.partOf) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addPartOf() {
        Reference t = new Reference();
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return t;
    }

    public Communication addPartOf(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.partOf == null) {
            this.partOf = new ArrayList<Reference>();
        }
        this.partOf.add(t);
        return this;
    }

    public Reference getPartOfFirstRep() {
        if (this.getPartOf().isEmpty()) {
            this.addPartOf();
        }
        return this.getPartOf().get(0);
    }

    @Deprecated
    public List<Resource> getPartOfTarget() {
        if (this.partOfTarget == null) {
            this.partOfTarget = new ArrayList<Resource>();
        }
        return this.partOfTarget;
    }

    public Enumeration<CommunicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<CommunicationStatus>(new CommunicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Communication setStatusElement(Enumeration<CommunicationStatus> value) {
        this.status = value;
        return this;
    }

    public CommunicationStatus getStatus() {
        return this.status == null ? null : (CommunicationStatus)((Object)this.status.getValue());
    }

    public Communication setStatus(CommunicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<CommunicationStatus>(new CommunicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public BooleanType getNotDoneElement() {
        if (this.notDone == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.notDone");
            }
            if (Configuration.doAutoCreate()) {
                this.notDone = new BooleanType();
            }
        }
        return this.notDone;
    }

    public boolean hasNotDoneElement() {
        return this.notDone != null && !this.notDone.isEmpty();
    }

    public boolean hasNotDone() {
        return this.notDone != null && !this.notDone.isEmpty();
    }

    public Communication setNotDoneElement(BooleanType value) {
        this.notDone = value;
        return this;
    }

    public boolean getNotDone() {
        return this.notDone == null || this.notDone.isEmpty() ? false : (Boolean)this.notDone.getValue();
    }

    public Communication setNotDone(boolean value) {
        if (this.notDone == null) {
            this.notDone = new BooleanType();
        }
        this.notDone.setValue((Object)value);
        return this;
    }

    public CodeableConcept getNotDoneReason() {
        if (this.notDoneReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.notDoneReason");
            }
            if (Configuration.doAutoCreate()) {
                this.notDoneReason = new CodeableConcept();
            }
        }
        return this.notDoneReason;
    }

    public boolean hasNotDoneReason() {
        return this.notDoneReason != null && !this.notDoneReason.isEmpty();
    }

    public Communication setNotDoneReason(CodeableConcept value) {
        this.notDoneReason = value;
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public Communication setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public Communication addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public List<CodeableConcept> getMedium() {
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        return this.medium;
    }

    public Communication setMedium(List<CodeableConcept> theMedium) {
        this.medium = theMedium;
        return this;
    }

    public boolean hasMedium() {
        if (this.medium == null) {
            return false;
        }
        for (CodeableConcept item : this.medium) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addMedium() {
        CodeableConcept t = new CodeableConcept();
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return t;
    }

    public Communication addMedium(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.medium == null) {
            this.medium = new ArrayList<CodeableConcept>();
        }
        this.medium.add(t);
        return this;
    }

    public CodeableConcept getMediumFirstRep() {
        if (this.getMedium().isEmpty()) {
            this.addMedium();
        }
        return this.getMedium().get(0);
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Communication setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Communication setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<Reference> getRecipient() {
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        return this.recipient;
    }

    public Communication setRecipient(List<Reference> theRecipient) {
        this.recipient = theRecipient;
        return this;
    }

    public boolean hasRecipient() {
        if (this.recipient == null) {
            return false;
        }
        for (Reference item : this.recipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRecipient() {
        Reference t = new Reference();
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return t;
    }

    public Communication addRecipient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.recipient == null) {
            this.recipient = new ArrayList<Reference>();
        }
        this.recipient.add(t);
        return this;
    }

    public Reference getRecipientFirstRep() {
        if (this.getRecipient().isEmpty()) {
            this.addRecipient();
        }
        return this.getRecipient().get(0);
    }

    @Deprecated
    public List<Resource> getRecipientTarget() {
        if (this.recipientTarget == null) {
            this.recipientTarget = new ArrayList<Resource>();
        }
        return this.recipientTarget;
    }

    public List<Reference> getTopic() {
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        return this.topic;
    }

    public Communication setTopic(List<Reference> theTopic) {
        this.topic = theTopic;
        return this;
    }

    public boolean hasTopic() {
        if (this.topic == null) {
            return false;
        }
        for (Reference item : this.topic) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addTopic() {
        Reference t = new Reference();
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        this.topic.add(t);
        return t;
    }

    public Communication addTopic(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.topic == null) {
            this.topic = new ArrayList<Reference>();
        }
        this.topic.add(t);
        return this;
    }

    public Reference getTopicFirstRep() {
        if (this.getTopic().isEmpty()) {
            this.addTopic();
        }
        return this.getTopic().get(0);
    }

    @Deprecated
    public List<Resource> getTopicTarget() {
        if (this.topicTarget == null) {
            this.topicTarget = new ArrayList<Resource>();
        }
        return this.topicTarget;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public Communication setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public Communication setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public DateTimeType getSentElement() {
        if (this.sent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.sent");
            }
            if (Configuration.doAutoCreate()) {
                this.sent = new DateTimeType();
            }
        }
        return this.sent;
    }

    public boolean hasSentElement() {
        return this.sent != null && !this.sent.isEmpty();
    }

    public boolean hasSent() {
        return this.sent != null && !this.sent.isEmpty();
    }

    public Communication setSentElement(DateTimeType value) {
        this.sent = value;
        return this;
    }

    public Date getSent() {
        return this.sent == null ? null : (Date)this.sent.getValue();
    }

    public Communication setSent(Date value) {
        if (value == null) {
            this.sent = null;
        } else {
            if (this.sent == null) {
                this.sent = new DateTimeType();
            }
            this.sent.setValue(value);
        }
        return this;
    }

    public DateTimeType getReceivedElement() {
        if (this.received == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.received");
            }
            if (Configuration.doAutoCreate()) {
                this.received = new DateTimeType();
            }
        }
        return this.received;
    }

    public boolean hasReceivedElement() {
        return this.received != null && !this.received.isEmpty();
    }

    public boolean hasReceived() {
        return this.received != null && !this.received.isEmpty();
    }

    public Communication setReceivedElement(DateTimeType value) {
        this.received = value;
        return this;
    }

    public Date getReceived() {
        return this.received == null ? null : (Date)this.received.getValue();
    }

    public Communication setReceived(Date value) {
        if (value == null) {
            this.received = null;
        } else {
            if (this.received == null) {
                this.received = new DateTimeType();
            }
            this.received.setValue(value);
        }
        return this;
    }

    public Reference getSender() {
        if (this.sender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Communication.sender");
            }
            if (Configuration.doAutoCreate()) {
                this.sender = new Reference();
            }
        }
        return this.sender;
    }

    public boolean hasSender() {
        return this.sender != null && !this.sender.isEmpty();
    }

    public Communication setSender(Reference value) {
        this.sender = value;
        return this;
    }

    public Resource getSenderTarget() {
        return this.senderTarget;
    }

    public Communication setSenderTarget(Resource value) {
        this.senderTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public Communication setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public Communication addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public Communication setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public Communication addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<CommunicationPayloadComponent> getPayload() {
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        return this.payload;
    }

    public Communication setPayload(List<CommunicationPayloadComponent> thePayload) {
        this.payload = thePayload;
        return this;
    }

    public boolean hasPayload() {
        if (this.payload == null) {
            return false;
        }
        for (CommunicationPayloadComponent item : this.payload) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CommunicationPayloadComponent addPayload() {
        CommunicationPayloadComponent t = new CommunicationPayloadComponent();
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        this.payload.add(t);
        return t;
    }

    public Communication addPayload(CommunicationPayloadComponent t) {
        if (t == null) {
            return this;
        }
        if (this.payload == null) {
            this.payload = new ArrayList<CommunicationPayloadComponent>();
        }
        this.payload.add(t);
        return this;
    }

    public CommunicationPayloadComponent getPayloadFirstRep() {
        if (this.getPayload().isEmpty()) {
            this.addPayload();
        }
        return this.getPayload().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public Communication setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public Communication addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition)", "A protocol, guideline, or other definition that was adhered to in whole or in part by this communication event.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(Any)", "An order, proposal or plan fulfilled in whole or in part by this Communication.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property("partOf", "Reference(Any)", "Part of this action.", 0, Integer.MAX_VALUE, this.partOf));
        children.add(new Property(SP_STATUS, "code", "The status of the transmission.", 0, 1, this.status));
        children.add(new Property("notDone", "boolean", "If true, indicates that the described communication event did not actually occur.", 0, 1, this.notDone));
        children.add(new Property("notDoneReason", "CodeableConcept", "Describes why the communication event did not occur in coded and/or textual form.", 0, 1, this.notDoneReason));
        children.add(new Property(SP_CATEGORY, "CodeableConcept", "The type of message conveyed such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group that was the focus of this communication.", 0, 1, this.subject));
        children.add(new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson|Group)", "The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).", 0, Integer.MAX_VALUE, this.recipient));
        children.add(new Property("topic", "Reference(Any)", "The resources which were responsible for or related to producing this communication.", 0, Integer.MAX_VALUE, this.topic));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter within which the communication was sent.", 0, 1, this.context));
        children.add(new Property(SP_SENT, "dateTime", "The time when this communication was sent.", 0, 1, this.sent));
        children.add(new Property(SP_RECEIVED, "dateTime", "The time when this communication arrived at the destination.", 0, 1, this.received));
        children.add(new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.", 0, 1, this.sender));
        children.add(new Property("reasonCode", "CodeableConcept", "The reason or justification for the communication.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "Indicates another resource whose existence justifies this communication.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("payload", "", "Text, attachment(s), or resource(s) that was communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload));
        children.add(new Property("note", "Annotation", "Additional notes or commentary about the communication by the sender, receiver or other interested parties.", 0, Integer.MAX_VALUE, this.note));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers associated with this Communication that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "Reference(PlanDefinition|ActivityDefinition)", "A protocol, guideline, or other definition that was adhered to in whole or in part by this communication event.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "An order, proposal or plan fulfilled in whole or in part by this Communication.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Any)", "Part of this action.", 0, Integer.MAX_VALUE, this.partOf);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of the transmission.", 0, 1, this.status);
            }
            case 2128257269: {
                return new Property("notDone", "boolean", "If true, indicates that the described communication event did not actually occur.", 0, 1, this.notDone);
            }
            case -1973169255: {
                return new Property("notDoneReason", "CodeableConcept", "Describes why the communication event did not occur in coded and/or textual form.", 0, 1, this.notDoneReason);
            }
            case 50511102: {
                return new Property(SP_CATEGORY, "CodeableConcept", "The type of message conveyed such as alert, notification, reminder, instruction, etc.", 0, Integer.MAX_VALUE, this.category);
            }
            case -1078030475: {
                return new Property(SP_MEDIUM, "CodeableConcept", "A channel that was used for this communication (e.g. email, fax).", 0, Integer.MAX_VALUE, this.medium);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group that was the focus of this communication.", 0, 1, this.subject);
            }
            case 820081177: {
                return new Property(SP_RECIPIENT, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson|Group)", "The entity (e.g. person, organization, clinical information system, or device) which was the target of the communication. If receipts need to be tracked by individual, a separate resource instance will need to be created for each recipient. \u00a0Multiple recipient communications are intended where either a receipt(s) is not tracked (e.g. a mass mail-out) or is captured in aggregate (all emails confirmed received by a particular time).", 0, Integer.MAX_VALUE, this.recipient);
            }
            case 110546223: {
                return new Property("topic", "Reference(Any)", "The resources which were responsible for or related to producing this communication.", 0, Integer.MAX_VALUE, this.topic);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "The encounter within which the communication was sent.", 0, 1, this.context);
            }
            case 3526552: {
                return new Property(SP_SENT, "dateTime", "The time when this communication was sent.", 0, 1, this.sent);
            }
            case -808719903: {
                return new Property(SP_RECEIVED, "dateTime", "The time when this communication arrived at the destination.", 0, 1, this.received);
            }
            case -905962955: {
                return new Property(SP_SENDER, "Reference(Device|Organization|Patient|Practitioner|RelatedPerson)", "The entity (e.g. person, organization, clinical information system, or device) which was the source of the communication.", 0, 1, this.sender);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "The reason or justification for the communication.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "Indicates another resource whose existence justifies this communication.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case -786701938: {
                return new Property("payload", "", "Text, attachment(s), or resource(s) that was communicated to the recipient.", 0, Integer.MAX_VALUE, this.payload);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Additional notes or commentary about the communication by the sender, receiver or other interested parties.", 0, Integer.MAX_VALUE, this.note);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -995410646: {
                return this.partOf == null ? new Base[]{} : this.partOf.toArray(new Base[this.partOf.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case 2128257269: {
                Base[] baseArray;
                if (this.notDone == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.notDone;
                }
                return baseArray;
            }
            case -1973169255: {
                Base[] baseArray;
                if (this.notDoneReason == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.notDoneReason;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case -1078030475: {
                return this.medium == null ? new Base[]{} : this.medium.toArray(new Base[this.medium.size()]);
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case 820081177: {
                return this.recipient == null ? new Base[]{} : this.recipient.toArray(new Base[this.recipient.size()]);
            }
            case 110546223: {
                return this.topic == null ? new Base[]{} : this.topic.toArray(new Base[this.topic.size()]);
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.context;
                }
                return baseArray;
            }
            case 3526552: {
                Base[] baseArray;
                if (this.sent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.sent;
                }
                return baseArray;
            }
            case -808719903: {
                Base[] baseArray;
                if (this.received == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.received;
                }
                return baseArray;
            }
            case -905962955: {
                Base[] baseArray;
                if (this.sender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.sender;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case -786701938: {
                return this.payload == null ? new Base[]{} : this.payload.toArray(new Base[this.payload.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -995410646: {
                this.getPartOf().add(this.castToReference(value));
                return value;
            }
            case -892481550: {
                value = new CommunicationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case 2128257269: {
                this.notDone = this.castToBoolean(value);
                return value;
            }
            case -1973169255: {
                this.notDoneReason = this.castToCodeableConcept(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1078030475: {
                this.getMedium().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 820081177: {
                this.getRecipient().add(this.castToReference(value));
                return value;
            }
            case 110546223: {
                this.getTopic().add(this.castToReference(value));
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 3526552: {
                this.sent = this.castToDateTime(value);
                return value;
            }
            case -808719903: {
                this.received = this.castToDateTime(value);
                return value;
            }
            case -905962955: {
                this.sender = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case -786701938: {
                this.getPayload().add((CommunicationPayloadComponent)((Object)value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals("partOf")) {
            this.getPartOf().add(this.castToReference(value));
        } else if (name.equals(SP_STATUS)) {
            value = new CommunicationStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("notDone")) {
            this.notDone = this.castToBoolean(value);
        } else if (name.equals("notDoneReason")) {
            this.notDoneReason = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_MEDIUM)) {
            this.getMedium().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_RECIPIENT)) {
            this.getRecipient().add(this.castToReference(value));
        } else if (name.equals("topic")) {
            this.getTopic().add(this.castToReference(value));
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals(SP_SENT)) {
            this.sent = this.castToDateTime(value);
        } else if (name.equals(SP_RECEIVED)) {
            this.received = this.castToDateTime(value);
        } else if (name.equals(SP_SENDER)) {
            this.sender = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("payload")) {
            this.getPayload().add((CommunicationPayloadComponent)((Object)value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -995410646: {
                return this.addPartOf();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case 2128257269: {
                return this.getNotDoneElement();
            }
            case -1973169255: {
                return this.getNotDoneReason();
            }
            case 50511102: {
                return this.addCategory();
            }
            case -1078030475: {
                return this.addMedium();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 820081177: {
                return this.addRecipient();
            }
            case 110546223: {
                return this.addTopic();
            }
            case 951530927: {
                return this.getContext();
            }
            case 3526552: {
                return this.getSentElement();
            }
            case -808719903: {
                return this.getReceivedElement();
            }
            case -905962955: {
                return this.getSender();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case -786701938: {
                return this.addPayload();
            }
            case 3387378: {
                return this.addNote();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case 2128257269: {
                return new String[]{"boolean"};
            }
            case -1973169255: {
                return new String[]{"CodeableConcept"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case -1078030475: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 820081177: {
                return new String[]{"Reference"};
            }
            case 110546223: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 3526552: {
                return new String[]{"dateTime"};
            }
            case -808719903: {
                return new String[]{"dateTime"};
            }
            case -905962955: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case -786701938: {
                return new String[0];
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals("partOf")) {
            return this.addPartOf();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.status");
        }
        if (name.equals("notDone")) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.notDone");
        }
        if (name.equals("notDoneReason")) {
            this.notDoneReason = new CodeableConcept();
            return this.notDoneReason;
        }
        if (name.equals(SP_CATEGORY)) {
            return this.addCategory();
        }
        if (name.equals(SP_MEDIUM)) {
            return this.addMedium();
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_RECIPIENT)) {
            return this.addRecipient();
        }
        if (name.equals("topic")) {
            return this.addTopic();
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals(SP_SENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.sent");
        }
        if (name.equals(SP_RECEIVED)) {
            throw new FHIRException("Cannot call addChild on a primitive type Communication.received");
        }
        if (name.equals(SP_SENDER)) {
            this.sender = new Reference();
            return this.sender;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("payload")) {
            return this.addPayload();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Communication";
    }

    @Override
    public Communication copy() {
        Communication dst = new Communication();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.partOf != null) {
            dst.partOf = new ArrayList<Reference>();
            for (Reference reference : this.partOf) {
                dst.partOf.add(reference.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.notDone = this.notDone == null ? null : this.notDone.copy();
        CodeableConcept codeableConcept = dst.notDoneReason = this.notDoneReason == null ? null : this.notDoneReason.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.category) {
                dst.category.add(codeableConcept2.copy());
            }
        }
        if (this.medium != null) {
            dst.medium = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.medium) {
                dst.medium.add(codeableConcept3.copy());
            }
        }
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.recipient != null) {
            dst.recipient = new ArrayList<Reference>();
            for (Reference reference2 : this.recipient) {
                dst.recipient.add(reference2.copy());
            }
        }
        if (this.topic != null) {
            dst.topic = new ArrayList<Reference>();
            for (Reference reference3 : this.topic) {
                dst.topic.add(reference3.copy());
            }
        }
        dst.context = this.context == null ? null : this.context.copy();
        dst.sent = this.sent == null ? null : this.sent.copy();
        dst.received = this.received == null ? null : this.received.copy();
        Reference reference4 = dst.sender = this.sender == null ? null : this.sender.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.reasonCode) {
                dst.reasonCode.add(codeableConcept4.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference5 : this.reasonReference) {
                dst.reasonReference.add(reference5.copy());
            }
        }
        if (this.payload != null) {
            dst.payload = new ArrayList<CommunicationPayloadComponent>();
            for (CommunicationPayloadComponent communicationPayloadComponent : this.payload) {
                dst.payload.add(communicationPayloadComponent.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        return dst;
    }

    protected Communication typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Communication)) {
            return false;
        }
        Communication o = (Communication)other_;
        return Communication.compareDeep(this.identifier, o.identifier, true) && Communication.compareDeep(this.definition, o.definition, true) && Communication.compareDeep(this.basedOn, o.basedOn, true) && Communication.compareDeep(this.partOf, o.partOf, true) && Communication.compareDeep(this.status, o.status, true) && Communication.compareDeep(this.notDone, o.notDone, true) && Communication.compareDeep(this.notDoneReason, o.notDoneReason, true) && Communication.compareDeep(this.category, o.category, true) && Communication.compareDeep(this.medium, o.medium, true) && Communication.compareDeep(this.subject, o.subject, true) && Communication.compareDeep(this.recipient, o.recipient, true) && Communication.compareDeep(this.topic, o.topic, true) && Communication.compareDeep(this.context, o.context, true) && Communication.compareDeep(this.sent, o.sent, true) && Communication.compareDeep(this.received, o.received, true) && Communication.compareDeep(this.sender, o.sender, true) && Communication.compareDeep(this.reasonCode, o.reasonCode, true) && Communication.compareDeep(this.reasonReference, o.reasonReference, true) && Communication.compareDeep(this.payload, o.payload, true) && Communication.compareDeep(this.note, o.note, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Communication)) {
            return false;
        }
        Communication o = (Communication)other_;
        return Communication.compareValues(this.status, o.status, true) && Communication.compareValues(this.notDone, o.notDone, true) && Communication.compareValues(this.sent, o.sent, true) && Communication.compareValues(this.received, o.received, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.definition, this.basedOn, this.partOf, this.status, this.notDone, this.notDoneReason, this.category, this.medium, this.subject, this.recipient, this.topic, this.context, this.sent, this.received, this.sender, this.reasonCode, this.reasonReference, this.payload, this.note});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Communication;
    }

    @Block
    public static class CommunicationPayloadComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={StringType.class, Attachment.class, Reference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Message part content", formalDefinition="A communicated content (or for multi-part communications, one portion of the communication).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public CommunicationPayloadComponent() {
        }

        public CommunicationPayloadComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public StringType getContentStringType() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (StringType)this.content;
        }

        public boolean hasContentStringType() {
            return this != null && this.content instanceof StringType;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this != null && this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (this.content == null) {
                return null;
            }
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this != null && this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public CommunicationPayloadComponent setContent(Type value) throws FHIRFormatError {
            if (!(value == null || value instanceof StringType || value instanceof Attachment || value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for Communication.payload.content[x]: " + value.fhirType());
            }
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 264548711: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case 951530617: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case -326336022: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case -702028164: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
                case 1193747154: {
                    return new Property("content[x]", "string|Attachment|Reference(Any)", "A communicated content (or for multi-part communications, one portion of the communication).", 0, 1, this.content);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    Base[] baseArray;
                    if (this.content == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.content;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    this.content = this.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("content[x]")) {
                return super.setProperty(name, value);
            }
            this.content = this.castToType(value);
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 264548711: {
                    return this.getContent();
                }
                case 951530617: {
                    return this.getContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 951530617: {
                    return new String[]{"string", "Attachment", "Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentString")) {
                this.content = new StringType();
                return this.content;
            }
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public CommunicationPayloadComponent copy() {
            CommunicationPayloadComponent dst = new CommunicationPayloadComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof CommunicationPayloadComponent)) {
                return false;
            }
            CommunicationPayloadComponent o = (CommunicationPayloadComponent)other_;
            return CommunicationPayloadComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof CommunicationPayloadComponent)) {
                return false;
            }
            CommunicationPayloadComponent o = (CommunicationPayloadComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.content});
        }

        @Override
        public String fhirType() {
            return "Communication.payload";
        }
    }

    public static class CommunicationStatusEnumFactory
    implements EnumFactory<CommunicationStatus> {
        @Override
        public CommunicationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return CommunicationStatus.PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return CommunicationStatus.INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return CommunicationStatus.SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return CommunicationStatus.ABORTED;
            }
            if ("completed".equals(codeString)) {
                return CommunicationStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return CommunicationStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return CommunicationStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        public Enumeration<CommunicationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CommunicationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.PREPARATION);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.INPROGRESS);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.SUSPENDED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.ABORTED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<CommunicationStatus>(this, CommunicationStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(CommunicationStatus code) {
            if (code == CommunicationStatus.PREPARATION) {
                return "preparation";
            }
            if (code == CommunicationStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == CommunicationStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == CommunicationStatus.ABORTED) {
                return "aborted";
            }
            if (code == CommunicationStatus.COMPLETED) {
                return "completed";
            }
            if (code == CommunicationStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == CommunicationStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(CommunicationStatus code) {
            return code.getSystem();
        }
    }

    public static enum CommunicationStatus {
        PREPARATION,
        INPROGRESS,
        SUSPENDED,
        ABORTED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static CommunicationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("preparation".equals(codeString)) {
                return PREPARATION;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CommunicationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PREPARATION: {
                    return "preparation";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case ABORTED: {
                    return "aborted";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PREPARATION: {
                    return "http://hl7.org/fhir/event-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/event-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/event-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/event-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/event-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PREPARATION: {
                    return "The core event has not started yet, but some staging activities have begun (e.g. surgical suite preparation).  Preparation stages may be tracked for billing purposes.";
                }
                case INPROGRESS: {
                    return "The event is currently occurring";
                }
                case SUSPENDED: {
                    return "The event has been temporarily stopped but is expected to resume in the future";
                }
                case ABORTED: {
                    return "The event was  prior to the full completion of the intended actions";
                }
                case COMPLETED: {
                    return "The event has now concluded";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" - one of the listed statuses is presumed to apply, it's just not known which one.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PREPARATION: {
                    return "Preparation";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

