/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ActionSelectionBehavior {
    ANY,
    ALL,
    ALLORNONE,
    EXACTLYONE,
    ATMOSTONE,
    ONEORMORE,
    NULL;


    public static ActionSelectionBehavior fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("any".equals(codeString)) {
            return ANY;
        }
        if ("all".equals(codeString)) {
            return ALL;
        }
        if ("all-or-none".equals(codeString)) {
            return ALLORNONE;
        }
        if ("exactly-one".equals(codeString)) {
            return EXACTLYONE;
        }
        if ("at-most-one".equals(codeString)) {
            return ATMOSTONE;
        }
        if ("one-or-more".equals(codeString)) {
            return ONEORMORE;
        }
        throw new FHIRException("Unknown ActionSelectionBehavior code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ANY: {
                return "any";
            }
            case ALL: {
                return "all";
            }
            case ALLORNONE: {
                return "all-or-none";
            }
            case EXACTLYONE: {
                return "exactly-one";
            }
            case ATMOSTONE: {
                return "at-most-one";
            }
            case ONEORMORE: {
                return "one-or-more";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/action-selection-behavior";
    }

    public String getDefinition() {
        switch (this) {
            case ANY: {
                return "Any number of the actions in the group may be chosen, from zero to all";
            }
            case ALL: {
                return "All the actions in the group must be selected as a single unit";
            }
            case ALLORNONE: {
                return "All the actions in the group are meant to be chosen as a single unit: either all must be selected by the end user, or none may be selected";
            }
            case EXACTLYONE: {
                return "The end user must choose one and only one of the selectable actions in the group. The user may not choose none of the actions in the group";
            }
            case ATMOSTONE: {
                return "The end user may choose zero or at most one of the actions in the group";
            }
            case ONEORMORE: {
                return "The end user must choose a minimum of one, and as many additional as desired";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ANY: {
                return "Any";
            }
            case ALL: {
                return "All";
            }
            case ALLORNONE: {
                return "All Or None";
            }
            case EXACTLYONE: {
                return "Exactly One";
            }
            case ATMOSTONE: {
                return "At Most One";
            }
            case ONEORMORE: {
                return "One Or More";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

