/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CarePlanStatus {
    DRAFT,
    ACTIVE,
    SUSPENDED,
    COMPLETED,
    ENTEREDINERROR,
    CANCELLED,
    UNKNOWN,
    NULL;


    public static CarePlanStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return DRAFT;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("suspended".equals(codeString)) {
            return SUSPENDED;
        }
        if ("completed".equals(codeString)) {
            return COMPLETED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown CarePlanStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DRAFT: {
                return "draft";
            }
            case ACTIVE: {
                return "active";
            }
            case SUSPENDED: {
                return "suspended";
            }
            case COMPLETED: {
                return "completed";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case UNKNOWN: {
                return "unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/care-plan-status";
    }

    public String getDefinition() {
        switch (this) {
            case DRAFT: {
                return "The plan is in development or awaiting use but is not yet intended to be acted upon.";
            }
            case ACTIVE: {
                return "The plan is intended to be followed and used as part of patient care.";
            }
            case SUSPENDED: {
                return "The plan has been temporarily stopped but is expected to resume in the future.";
            }
            case COMPLETED: {
                return "The plan is no longer in use and is not expected to be followed or used in patient care.";
            }
            case ENTEREDINERROR: {
                return "The plan was entered in error and voided.";
            }
            case CANCELLED: {
                return "The plan has been terminated prior to reaching completion (though it may have been replaced by a new plan).";
            }
            case UNKNOWN: {
                return "The authoring system doesn't know the current state of the care plan.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DRAFT: {
                return "Pending";
            }
            case ACTIVE: {
                return "Active";
            }
            case SUSPENDED: {
                return "Suspended";
            }
            case COMPLETED: {
                return "Completed";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case UNKNOWN: {
                return "Unknown";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

