/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConditionClinical {
    ACTIVE,
    RECURRENCE,
    INACTIVE,
    REMISSION,
    RESOLVED,
    NULL;


    public static ConditionClinical fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("recurrence".equals(codeString)) {
            return RECURRENCE;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("remission".equals(codeString)) {
            return REMISSION;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        throw new FHIRException("Unknown ConditionClinical code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case RECURRENCE: {
                return "recurrence";
            }
            case INACTIVE: {
                return "inactive";
            }
            case REMISSION: {
                return "remission";
            }
            case RESOLVED: {
                return "resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/condition-clinical";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "The subject is currently experiencing the symptoms of the condition or there is evidence of the condition.";
            }
            case RECURRENCE: {
                return "The subject is having a relapse or re-experiencing the condition after a period of remission or presumed resolution.";
            }
            case INACTIVE: {
                return "The subject is no longer experiencing the symptoms of the condition or there is no longer evidence of the condition.";
            }
            case REMISSION: {
                return "The subject is no longer experiencing the symptoms of the condition, but there is a risk of the symptoms returning.";
            }
            case RESOLVED: {
                return "The subject is no longer experiencing the symptoms of the condition and there is a negligible perceived risk of the symptoms returning.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case RECURRENCE: {
                return "Recurrence";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case REMISSION: {
                return "Remission";
            }
            case RESOLVED: {
                return "Resolved";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

