/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContributorType {
    AUTHOR,
    EDITOR,
    REVIEWER,
    ENDORSER,
    NULL;


    public static ContributorType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("author".equals(codeString)) {
            return AUTHOR;
        }
        if ("editor".equals(codeString)) {
            return EDITOR;
        }
        if ("reviewer".equals(codeString)) {
            return REVIEWER;
        }
        if ("endorser".equals(codeString)) {
            return ENDORSER;
        }
        throw new FHIRException("Unknown ContributorType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AUTHOR: {
                return "author";
            }
            case EDITOR: {
                return "editor";
            }
            case REVIEWER: {
                return "reviewer";
            }
            case ENDORSER: {
                return "endorser";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/contributor-type";
    }

    public String getDefinition() {
        switch (this) {
            case AUTHOR: {
                return "An author of the content of the module";
            }
            case EDITOR: {
                return "An editor of the content of the module";
            }
            case REVIEWER: {
                return "A reviewer of the content of the module";
            }
            case ENDORSER: {
                return "An endorser of the content of the module";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AUTHOR: {
                return "Author";
            }
            case EDITOR: {
                return "Editor";
            }
            case REVIEWER: {
                return "Reviewer";
            }
            case ENDORSER: {
                return "Endorser";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

