/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CqifRecommendationStrength {
    STRONG,
    WEAK,
    NULL;


    public static CqifRecommendationStrength fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("strong".equals(codeString)) {
            return STRONG;
        }
        if ("weak".equals(codeString)) {
            return WEAK;
        }
        throw new FHIRException("Unknown CqifRecommendationStrength code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case STRONG: {
                return "strong";
            }
            case WEAK: {
                return "weak";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/recommendation-strength";
    }

    public String getDefinition() {
        switch (this) {
            case STRONG: {
                return "Strong recommendation";
            }
            case WEAK: {
                return "Weak recommendation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case STRONG: {
                return "Strong";
            }
            case WEAK: {
                return "Weak";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

