/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.DaysOfWeek;

public class DaysOfWeekEnumFactory
implements EnumFactory<DaysOfWeek> {
    @Override
    public DaysOfWeek fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("mon".equals(codeString)) {
            return DaysOfWeek.MON;
        }
        if ("tue".equals(codeString)) {
            return DaysOfWeek.TUE;
        }
        if ("wed".equals(codeString)) {
            return DaysOfWeek.WED;
        }
        if ("thu".equals(codeString)) {
            return DaysOfWeek.THU;
        }
        if ("fri".equals(codeString)) {
            return DaysOfWeek.FRI;
        }
        if ("sat".equals(codeString)) {
            return DaysOfWeek.SAT;
        }
        if ("sun".equals(codeString)) {
            return DaysOfWeek.SUN;
        }
        throw new IllegalArgumentException("Unknown DaysOfWeek code '" + codeString + "'");
    }

    @Override
    public String toCode(DaysOfWeek code) {
        if (code == DaysOfWeek.MON) {
            return "mon";
        }
        if (code == DaysOfWeek.TUE) {
            return "tue";
        }
        if (code == DaysOfWeek.WED) {
            return "wed";
        }
        if (code == DaysOfWeek.THU) {
            return "thu";
        }
        if (code == DaysOfWeek.FRI) {
            return "fri";
        }
        if (code == DaysOfWeek.SAT) {
            return "sat";
        }
        if (code == DaysOfWeek.SUN) {
            return "sun";
        }
        return "?";
    }

    @Override
    public String toSystem(DaysOfWeek code) {
        return code.getSystem();
    }
}

