/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HttpOperations {
    DELETE,
    GET,
    OPTIONS,
    PATCH,
    POST,
    PUT,
    NULL;


    public static HttpOperations fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("delete".equals(codeString)) {
            return DELETE;
        }
        if ("get".equals(codeString)) {
            return GET;
        }
        if ("options".equals(codeString)) {
            return OPTIONS;
        }
        if ("patch".equals(codeString)) {
            return PATCH;
        }
        if ("post".equals(codeString)) {
            return POST;
        }
        if ("put".equals(codeString)) {
            return PUT;
        }
        throw new FHIRException("Unknown HttpOperations code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DELETE: {
                return "delete";
            }
            case GET: {
                return "get";
            }
            case OPTIONS: {
                return "options";
            }
            case PATCH: {
                return "patch";
            }
            case POST: {
                return "post";
            }
            case PUT: {
                return "put";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/http-operations";
    }

    public String getDefinition() {
        switch (this) {
            case DELETE: {
                return "HTTP DELETE operation";
            }
            case GET: {
                return "HTTP GET operation";
            }
            case OPTIONS: {
                return "HTTP OPTIONS operation";
            }
            case PATCH: {
                return "HTTP PATCH operation";
            }
            case POST: {
                return "HTTP POST operation";
            }
            case PUT: {
                return "HTTP PUT operation";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DELETE: {
                return "DELETE";
            }
            case GET: {
                return "GET";
            }
            case OPTIONS: {
                return "OPTIONS";
            }
            case PATCH: {
                return "PATCH";
            }
            case POST: {
                return "POST";
            }
            case PUT: {
                return "PUT";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

