/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.codesystems.LinkType;

public class LinkTypeEnumFactory
implements EnumFactory<LinkType> {
    @Override
    public LinkType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("replaced-by".equals(codeString)) {
            return LinkType.REPLACEDBY;
        }
        if ("replaces".equals(codeString)) {
            return LinkType.REPLACES;
        }
        if ("refer".equals(codeString)) {
            return LinkType.REFER;
        }
        if ("seealso".equals(codeString)) {
            return LinkType.SEEALSO;
        }
        throw new IllegalArgumentException("Unknown LinkType code '" + codeString + "'");
    }

    @Override
    public String toCode(LinkType code) {
        if (code == LinkType.REPLACEDBY) {
            return "replaced-by";
        }
        if (code == LinkType.REPLACES) {
            return "replaces";
        }
        if (code == LinkType.REFER) {
            return "refer";
        }
        if (code == LinkType.SEEALSO) {
            return "seealso";
        }
        return "?";
    }

    @Override
    public String toSystem(LinkType code) {
        return code.getSystem();
    }
}

