package org.hl7.fhir.r4.model.codesystems;

/*-
 * #%L
 * org.hl7.fhir.r4
 * %%
 * Copyright (C) 2014 - 2019 Health Level 7
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


/*
  Copyright (c) 2011+, HL7, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without modification, 
  are permitted provided that the following conditions are met:
  
   * Redistributions of source code must retain the above copyright notice, this 
     list of conditions and the following disclaimer.
   * Redistributions in binary form must reproduce the above copyright notice, 
     this list of conditions and the following disclaimer in the documentation 
     and/or other materials provided with the distribution.
   * Neither the name of HL7 nor the names of its contributors may be used to 
     endorse or promote products derived from this software without specific 
     prior written permission.
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND 
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) 
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE 
  POSSIBILITY OF SUCH DAMAGE.
  
*/

// Generated on Wed, Jan 30, 2019 16:19-0500 for FHIR v4.0.0


import org.hl7.fhir.r4.model.EnumFactory;

public class V3NullFlavorEnumFactory implements EnumFactory<V3NullFlavor> {

  public V3NullFlavor fromCode(String codeString) throws IllegalArgumentException {
    if (codeString == null || "".equals(codeString))
      return null;
    if ("NI".equals(codeString))
      return V3NullFlavor.NI;
    if ("INV".equals(codeString))
      return V3NullFlavor.INV;
    if ("DER".equals(codeString))
      return V3NullFlavor.DER;
    if ("OTH".equals(codeString))
      return V3NullFlavor.OTH;
    if ("NINF".equals(codeString))
      return V3NullFlavor.NINF;
    if ("PINF".equals(codeString))
      return V3NullFlavor.PINF;
    if ("UNC".equals(codeString))
      return V3NullFlavor.UNC;
    if ("MSK".equals(codeString))
      return V3NullFlavor.MSK;
    if ("NA".equals(codeString))
      return V3NullFlavor.NA;
    if ("UNK".equals(codeString))
      return V3NullFlavor.UNK;
    if ("ASKU".equals(codeString))
      return V3NullFlavor.ASKU;
    if ("NAV".equals(codeString))
      return V3NullFlavor.NAV;
    if ("NASK".equals(codeString))
      return V3NullFlavor.NASK;
    if ("NAVU".equals(codeString))
      return V3NullFlavor.NAVU;
    if ("QS".equals(codeString))
      return V3NullFlavor.QS;
    if ("TRC".equals(codeString))
      return V3NullFlavor.TRC;
    if ("NP".equals(codeString))
      return V3NullFlavor.NP;
    throw new IllegalArgumentException("Unknown V3NullFlavor code '"+codeString+"'");
  }

  public String toCode(V3NullFlavor code) {
    if (code == V3NullFlavor.NI)
      return "NI";
    if (code == V3NullFlavor.INV)
      return "INV";
    if (code == V3NullFlavor.DER)
      return "DER";
    if (code == V3NullFlavor.OTH)
      return "OTH";
    if (code == V3NullFlavor.NINF)
      return "NINF";
    if (code == V3NullFlavor.PINF)
      return "PINF";
    if (code == V3NullFlavor.UNC)
      return "UNC";
    if (code == V3NullFlavor.MSK)
      return "MSK";
    if (code == V3NullFlavor.NA)
      return "NA";
    if (code == V3NullFlavor.UNK)
      return "UNK";
    if (code == V3NullFlavor.ASKU)
      return "ASKU";
    if (code == V3NullFlavor.NAV)
      return "NAV";
    if (code == V3NullFlavor.NASK)
      return "NASK";
    if (code == V3NullFlavor.NAVU)
      return "NAVU";
    if (code == V3NullFlavor.QS)
      return "QS";
    if (code == V3NullFlavor.TRC)
      return "TRC";
    if (code == V3NullFlavor.NP)
      return "NP";
    return "?";
  }

    public String toSystem(V3NullFlavor code) {
      return code.getSystem();
      }

}

