/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.formats;

import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.XmlParserBase;
import org.hl7.fhir.r4.model.Account;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.AdverseEvent;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.AllergyIntolerance;
import org.hl7.fhir.r4.model.Annotation;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.BackboneType;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Base64BinaryType;
import org.hl7.fhir.r4.model.Basic;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r4.model.BodyStructure;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CareTeam;
import org.hl7.fhir.r4.model.CatalogEntry;
import org.hl7.fhir.r4.model.ChargeItem;
import org.hl7.fhir.r4.model.ChargeItemDefinition;
import org.hl7.fhir.r4.model.Claim;
import org.hl7.fhir.r4.model.ClaimResponse;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.CompartmentDefinition;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.Consent;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Contract;
import org.hl7.fhir.r4.model.Contributor;
import org.hl7.fhir.r4.model.Count;
import org.hl7.fhir.r4.model.Coverage;
import org.hl7.fhir.r4.model.CoverageEligibilityRequest;
import org.hl7.fhir.r4.model.CoverageEligibilityResponse;
import org.hl7.fhir.r4.model.DataRequirement;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DeviceDefinition;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.DeviceRequest;
import org.hl7.fhir.r4.model.DeviceUseStatement;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.EffectEvidenceSynthesis;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.EnrollmentRequest;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.EventDefinition;
import org.hl7.fhir.r4.model.Evidence;
import org.hl7.fhir.r4.model.EvidenceVariable;
import org.hl7.fhir.r4.model.ExampleScenario;
import org.hl7.fhir.r4.model.ExplanationOfBenefit;
import org.hl7.fhir.r4.model.Expression;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.ExtensionHelper;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.GraphDefinition;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.GuidanceResponse;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.ImagingStudy;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImmunizationEvaluation;
import org.hl7.fhir.r4.model.ImmunizationRecommendation;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.InsurancePlan;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Invoice;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Linkage;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MarketingStatus;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MeasureReport;
import org.hl7.fhir.r4.model.Media;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.MedicationAdministration;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationKnowledge;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MedicinalProduct;
import org.hl7.fhir.r4.model.MedicinalProductAuthorization;
import org.hl7.fhir.r4.model.MedicinalProductContraindication;
import org.hl7.fhir.r4.model.MedicinalProductIndication;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.MedicinalProductInteraction;
import org.hl7.fhir.r4.model.MedicinalProductManufactured;
import org.hl7.fhir.r4.model.MedicinalProductPackaged;
import org.hl7.fhir.r4.model.MedicinalProductPharmaceutical;
import org.hl7.fhir.r4.model.MedicinalProductUndesirableEffect;
import org.hl7.fhir.r4.model.MessageDefinition;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.MolecularSequence;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.NutritionOrder;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.ObservationDefinition;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.hl7.fhir.r4.model.ParameterDefinition;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PaymentNotice;
import org.hl7.fhir.r4.model.PaymentReconciliation;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PlanDefinition;
import org.hl7.fhir.r4.model.Population;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Procedure;
import org.hl7.fhir.r4.model.ProdCharacteristic;
import org.hl7.fhir.r4.model.ProductShelfLife;
import org.hl7.fhir.r4.model.Provenance;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Range;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedArtifact;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.RequestGroup;
import org.hl7.fhir.r4.model.ResearchDefinition;
import org.hl7.fhir.r4.model.ResearchElementDefinition;
import org.hl7.fhir.r4.model.ResearchStudy;
import org.hl7.fhir.r4.model.ResearchSubject;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.RiskEvidenceSynthesis;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.Schedule;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.ServiceRequest;
import org.hl7.fhir.r4.model.Signature;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.Specimen;
import org.hl7.fhir.r4.model.SpecimenDefinition;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.StructureMap;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SubstanceAmount;
import org.hl7.fhir.r4.model.SubstanceNucleicAcid;
import org.hl7.fhir.r4.model.SubstancePolymer;
import org.hl7.fhir.r4.model.SubstanceProtein;
import org.hl7.fhir.r4.model.SubstanceReferenceInformation;
import org.hl7.fhir.r4.model.SubstanceSourceMaterial;
import org.hl7.fhir.r4.model.SubstanceSpecification;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestReport;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.TriggerDefinition;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.UuidType;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.model.VerificationResult;
import org.hl7.fhir.r4.model.VisionPrescription;
import org.hl7.fhir.utilities.Utilities;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class XmlParser
extends XmlParserBase {
    public XmlParser() {
    }

    public XmlParser(boolean allowUnknownContent) {
        this.setAllowUnknownContent(allowUnknownContent);
    }

    protected boolean parseElementContent(int eventType, XmlPullParser xpp, Element res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("extension")) {
            return false;
        }
        res.getExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneElement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("modifierExtension")) {
            return this.parseElementContent(eventType, xpp, res);
        }
        res.getModifierExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected boolean parseBackboneElementContent(int eventType, XmlPullParser xpp, BackboneType res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType != 2 || !xpp.getName().equals("modifierExtension")) {
            return this.parseElementContent(eventType, xpp, res);
        }
        res.getModifierExtension().add(this.parseExtension(xpp));
        return true;
    }

    protected <E extends Enum<E>> Enumeration<E> parseEnumeration(XmlPullParser xpp, E item, EnumFactory e) throws XmlPullParserException, IOException, FHIRFormatError {
        Enumeration res = new Enumeration(e);
        this.parseElementAttributes(xpp, res);
        res.setValue(e.fromCode(xpp.getAttributeValue(null, "value")));
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateType parseDate(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateType res = new DateType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DateTimeType parseDateTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DateTimeType res = new DateTimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CodeType parseCode(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeType res = new CodeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected StringType parseString(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        StringType res = new StringType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IntegerType parseInteger(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IntegerType res = new IntegerType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected OidType parseOid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        OidType res = new OidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected CanonicalType parseCanonical(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CanonicalType res = new CanonicalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UriType parseUri(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UriType res = new UriType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UuidType parseUuid(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UuidType res = new UuidType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UrlType parseUrl(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UrlType res = new UrlType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected InstantType parseInstant(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InstantType res = new InstantType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected BooleanType parseBoolean(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BooleanType res = new BooleanType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Base64BinaryType parseBase64Binary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Base64BinaryType res = new Base64BinaryType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected UnsignedIntType parseUnsignedInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UnsignedIntType res = new UnsignedIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected MarkdownType parseMarkdown(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarkdownType res = new MarkdownType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected TimeType parseTime(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TimeType res = new TimeType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected IdType parseId(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        IdType res = new IdType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected PositiveIntType parsePositiveInt(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        PositiveIntType res = new PositiveIntType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected DecimalType parseDecimal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DecimalType res = new DecimalType(xpp.getAttributeValue(null, "value"));
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected Extension parseExtension(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Extension res = new Extension();
        this.parseElementAttributes(xpp, res);
        if (xpp.getAttributeValue(null, "url") != null) {
            res.setUrl(xpp.getAttributeValue(null, "url"));
        }
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExtensionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExtensionContent(int eventType, XmlPullParser xpp, Extension res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Narrative parseNarrative(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Narrative res = new Narrative();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNarrativeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNarrativeContent(int eventType, XmlPullParser xpp, Narrative res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Narrative.NarrativeStatus.NULL, new Narrative.NarrativeStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("div")) {
            res.setDiv(this.parseXhtml(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Meta parseMeta(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Meta res = new Meta();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMetaContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMetaContent(int eventType, XmlPullParser xpp, Meta res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("versionId")) {
            res.setVersionIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
            res.setLastUpdatedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.getSecurity().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("tag")) {
            res.getTag().add(this.parseCoding(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Address parseAddress(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Address res = new Address();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAddressContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAddressContent(int eventType, XmlPullParser xpp, Address res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Address.AddressUse.NULL, new Address.AddressUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Address.AddressType.NULL, new Address.AddressTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("line")) {
            res.getLine().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("city")) {
            res.setCityElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("district")) {
            res.setDistrictElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("postalCode")) {
            res.setPostalCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contributor parseContributor(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contributor res = new Contributor();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContributorContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContributorContent(int eventType, XmlPullParser xpp, Contributor res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Contributor.ContributorType.NULL, new Contributor.ContributorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Attachment parseAttachment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Attachment res = new Attachment();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAttachmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAttachmentContent(int eventType, XmlPullParser xpp, Attachment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("size")) {
            res.setSizeElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hash")) {
            res.setHashElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("creation")) {
            res.setCreationElement(this.parseDateTime(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Count parseCount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Count res = new Count();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCountContent(int eventType, XmlPullParser xpp, Count res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected DataRequirement parseDataRequirement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement res = new DataRequirement();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementContent(int eventType, XmlPullParser xpp, DataRequirement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.getMustSupport().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("codeFilter")) {
            res.getCodeFilter().add(this.parseDataRequirementDataRequirementCodeFilterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("dateFilter")) {
            res.getDateFilter().add(this.parseDataRequirementDataRequirementDateFilterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("limit")) {
            res.setLimitElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sort")) {
            res.getSort().add(this.parseDataRequirementDataRequirementSortComponent(xpp, res));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementCodeFilterComponent parseDataRequirementDataRequirementCodeFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementCodeFilterComponent res = new DataRequirement.DataRequirementCodeFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDataRequirementCodeFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDataRequirementCodeFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementCodeFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.setSearchParamElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementDateFilterComponent parseDataRequirementDataRequirementDateFilterComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementDateFilterComponent res = new DataRequirement.DataRequirementDateFilterComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDataRequirementDateFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDataRequirementDateFilterComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementDateFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.setSearchParamElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DataRequirement.DataRequirementSortComponent parseDataRequirementDataRequirementSortComponent(XmlPullParser xpp, DataRequirement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DataRequirement.DataRequirementSortComponent res = new DataRequirement.DataRequirementSortComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDataRequirementDataRequirementSortComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDataRequirementDataRequirementSortComponentContent(int eventType, XmlPullParser xpp, DataRequirement owner, DataRequirement.DataRequirementSortComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("direction")) {
            res.setDirectionElement(this.parseEnumeration(xpp, DataRequirement.SortDirection.NULL, new DataRequirement.SortDirectionEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Dosage parseDosage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Dosage res = new Dosage();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDosageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDosageContent(int eventType, XmlPullParser xpp, Dosage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalInstruction")) {
            res.getAdditionalInstruction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("timing")) {
            res.setTiming(this.parseTiming(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "asNeeded")) {
            res.setAsNeeded(this.parseType("asNeeded", xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseAndRate")) {
            res.getDoseAndRate().add(this.parseDosageDosageDoseAndRateComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerPeriod")) {
            res.setMaxDosePerPeriod(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerAdministration")) {
            res.setMaxDosePerAdministration(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerLifetime")) {
            res.setMaxDosePerLifetime(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Dosage.DosageDoseAndRateComponent parseDosageDosageDoseAndRateComponent(XmlPullParser xpp, Dosage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Dosage.DosageDoseAndRateComponent res = new Dosage.DosageDoseAndRateComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDosageDosageDoseAndRateComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDosageDosageDoseAndRateComponentContent(int eventType, XmlPullParser xpp, Dosage owner, Dosage.DosageDoseAndRateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "dose")) {
            res.setDose(this.parseType("dose", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Money parseMoney(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Money res = new Money();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMoneyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMoneyContent(int eventType, XmlPullParser xpp, Money res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("currency")) {
            res.setCurrencyElement(this.parseCode(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HumanName parseHumanName(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HumanName res = new HumanName();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHumanNameContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHumanNameContent(int eventType, XmlPullParser xpp, HumanName res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, HumanName.NameUse.NULL, new HumanName.NameUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("family")) {
            res.setFamilyElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("given")) {
            res.getGiven().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prefix")) {
            res.getPrefix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suffix")) {
            res.getSuffix().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactPoint parseContactPoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactPoint res = new ContactPoint();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactPointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactPointContent(int eventType, XmlPullParser xpp, ContactPoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseEnumeration(xpp, ContactPoint.ContactPointSystem.NULL, new ContactPoint.ContactPointSystemEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ContactPoint.ContactPointUse.NULL, new ContactPoint.ContactPointUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MarketingStatus parseMarketingStatus(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MarketingStatus res = new MarketingStatus();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMarketingStatusContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMarketingStatusContent(int eventType, XmlPullParser xpp, MarketingStatus res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountry(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdiction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateRange")) {
            res.setDateRange(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("restoreDate")) {
            res.setRestoreDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Identifier parseIdentifier(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Identifier res = new Identifier();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseIdentifierContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseIdentifierContent(int eventType, XmlPullParser xpp, Identifier res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Identifier.IdentifierUse.NULL, new Identifier.IdentifierUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assigner")) {
            res.setAssigner(this.parseReference(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SubstanceAmount parseSubstanceAmount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SubstanceAmount res = new SubstanceAmount();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubstanceAmountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubstanceAmountContent(int eventType, XmlPullParser xpp, SubstanceAmount res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "amount")) {
            res.setAmount(this.parseType("amount", xpp));
        } else if (eventType == 2 && xpp.getName().equals("amountType")) {
            res.setAmountType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amountText")) {
            res.setAmountTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceRange")) {
            res.setReferenceRange(this.parseSubstanceAmountSubstanceAmountReferenceRangeComponent(xpp, res));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SubstanceAmount.SubstanceAmountReferenceRangeComponent parseSubstanceAmountSubstanceAmountReferenceRangeComponent(XmlPullParser xpp, SubstanceAmount owner) throws XmlPullParserException, IOException, FHIRFormatError {
        SubstanceAmount.SubstanceAmountReferenceRangeComponent res = new SubstanceAmount.SubstanceAmountReferenceRangeComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSubstanceAmountSubstanceAmountReferenceRangeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSubstanceAmountSubstanceAmountReferenceRangeComponentContent(int eventType, XmlPullParser xpp, SubstanceAmount owner, SubstanceAmount.SubstanceAmountReferenceRangeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("lowLimit")) {
            res.setLowLimit(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("highLimit")) {
            res.setHighLimit(this.parseQuantity(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coding parseCoding(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coding res = new Coding();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodingContent(int eventType, XmlPullParser xpp, Coding res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("userSelected")) {
            res.setUserSelectedElement(this.parseBoolean(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected SampledData parseSampledData(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        SampledData res = new SampledData();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSampledDataContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSampledDataContent(int eventType, XmlPullParser xpp, SampledData res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriodElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lowerLimit")) {
            res.setLowerLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("upperLimit")) {
            res.setUpperLimitElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dimensions")) {
            res.setDimensionsElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Population parsePopulation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Population res = new Population();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePopulationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePopulationContent(int eventType, XmlPullParser xpp, Population res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
            res.setAge(this.parseType("age", xpp));
        } else if (eventType == 2 && xpp.getName().equals("gender")) {
            res.setGender(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("race")) {
            res.setRace(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physiologicalCondition")) {
            res.setPhysiologicalCondition(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Ratio parseRatio(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Ratio res = new Ratio();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRatioContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRatioContent(int eventType, XmlPullParser xpp, Ratio res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("numerator")) {
            res.setNumerator(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("denominator")) {
            res.setDenominator(this.parseQuantity(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Distance parseDistance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Distance res = new Distance();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDistanceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDistanceContent(int eventType, XmlPullParser xpp, Distance res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Age parseAge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Age res = new Age();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAgeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAgeContent(int eventType, XmlPullParser xpp, Age res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Reference parseReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Reference res = new Reference();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseReferenceContent(int eventType, XmlPullParser xpp, Reference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected TriggerDefinition parseTriggerDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        TriggerDefinition res = new TriggerDefinition();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTriggerDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTriggerDefinitionContent(int eventType, XmlPullParser xpp, TriggerDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, TriggerDefinition.TriggerType.NULL, new TriggerDefinition.TriggerTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseExpression(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Quantity parseQuantity(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Quantity res = new Quantity();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseQuantityContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseQuantityContent(int eventType, XmlPullParser xpp, Quantity res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comparator")) {
            res.setComparatorElement(this.parseEnumeration(xpp, Quantity.QuantityComparator.NULL, new Quantity.QuantityComparatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnitElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Period parsePeriod(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Period res = new Period();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parsePeriodContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parsePeriodContent(int eventType, XmlPullParser xpp, Period res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseDateTime(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Duration parseDuration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Duration res = new Duration();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDurationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDurationContent(int eventType, XmlPullParser xpp, Duration res) throws XmlPullParserException, IOException, FHIRFormatError {
        return this.parseQuantityContent(eventType, xpp, res);
    }

    protected Range parseRange(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Range res = new Range();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRangeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRangeContent(int eventType, XmlPullParser xpp, Range res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("low")) {
            res.setLow(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("high")) {
            res.setHigh(this.parseQuantity(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected RelatedArtifact parseRelatedArtifact(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        RelatedArtifact res = new RelatedArtifact();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseRelatedArtifactContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseRelatedArtifactContent(int eventType, XmlPullParser xpp, RelatedArtifact res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, RelatedArtifact.RelatedArtifactType.NULL, new RelatedArtifact.RelatedArtifactTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("citation")) {
            res.setCitationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.setDocument(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResourceElement(this.parseCanonical(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Annotation parseAnnotation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Annotation res = new Annotation();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAnnotationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAnnotationContent(int eventType, XmlPullParser xpp, Annotation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "author")) {
            res.setAuthor(this.parseType("author", xpp));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseMarkdown(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProductShelfLife parseProductShelfLife(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProductShelfLife res = new ProductShelfLife();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProductShelfLifeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProductShelfLifeContent(int eventType, XmlPullParser xpp, ProductShelfLife res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialPrecautionsForStorage")) {
            res.getSpecialPrecautionsForStorage().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ContactDetail parseContactDetail(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ContactDetail res = new ContactDetail();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContactDetailContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContactDetailContent(int eventType, XmlPullParser xpp, ContactDetail res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected UsageContext parseUsageContext(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        UsageContext res = new UsageContext();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseUsageContextContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseUsageContextContent(int eventType, XmlPullParser xpp, UsageContext res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCoding(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Expression parseExpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Expression res = new Expression();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExpressionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExpressionContent(int eventType, XmlPullParser xpp, Expression res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Signature parseSignature(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Signature res = new Signature();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseSignatureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseSignatureContent(int eventType, XmlPullParser xpp, Signature res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.setWhenElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("who")) {
            res.setWho(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetFormat")) {
            res.setTargetFormatElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sigFormat")) {
            res.setSigFormatElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing parseTiming(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing res = new Timing();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingContent(int eventType, XmlPullParser xpp, Timing res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repeat")) {
            res.setRepeat(this.parseTimingTimingRepeatComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Timing.TimingRepeatComponent parseTimingTimingRepeatComponent(XmlPullParser xpp, Timing owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Timing.TimingRepeatComponent res = new Timing.TimingRepeatComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseTimingTimingRepeatComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseTimingTimingRepeatComponentContent(int eventType, XmlPullParser xpp, Timing owner, Timing.TimingRepeatComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "bounds")) {
            res.setBounds(this.parseType("bounds", xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("countMax")) {
            res.setCountMaxElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationMax")) {
            res.setDurationMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("durationUnit")) {
            res.setDurationUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("frequency")) {
            res.setFrequencyElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frequencyMax")) {
            res.setFrequencyMaxElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriodElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodMax")) {
            res.setPeriodMaxElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodUnit")) {
            res.setPeriodUnitElement(this.parseEnumeration(xpp, Timing.UnitsOfTime.NULL, new Timing.UnitsOfTimeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dayOfWeek")) {
            res.getDayOfWeek().add(this.parseEnumeration(xpp, Timing.DayOfWeek.NULL, new Timing.DayOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("timeOfDay")) {
            res.getTimeOfDay().add(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("when")) {
            res.getWhen().add(this.parseEnumeration(xpp, Timing.EventTiming.NULL, new Timing.EventTimingEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("offset")) {
            res.setOffsetElement(this.parseUnsignedInt(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ProdCharacteristic parseProdCharacteristic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ProdCharacteristic res = new ProdCharacteristic();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseProdCharacteristicContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseProdCharacteristicContent(int eventType, XmlPullParser xpp, ProdCharacteristic res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("height")) {
            res.setHeight(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("width")) {
            res.setWidth(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("depth")) {
            res.setDepth(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("weight")) {
            res.setWeight(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nominalVolume")) {
            res.setNominalVolume(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("externalDiameter")) {
            res.setExternalDiameter(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shape")) {
            res.setShapeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("color")) {
            res.getColor().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imprint")) {
            res.getImprint().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoring")) {
            res.setScoring(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeableConcept parseCodeableConcept(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeableConcept res = new CodeableConcept();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeableConceptContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeableConceptContent(int eventType, XmlPullParser xpp, CodeableConcept res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coding")) {
            res.getCoding().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ParameterDefinition parseParameterDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ParameterDefinition res = new ParameterDefinition();
        this.parseTypeAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParameterDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParameterDefinitionContent(int eventType, XmlPullParser xpp, ParameterDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ParameterDefinition.ParameterUse.NULL, new ParameterDefinition.ParameterUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition parseElementDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition res = new ElementDefinition();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionContent(int eventType, XmlPullParser xpp, ElementDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("representation")) {
            res.getRepresentation().add(this.parseEnumeration(xpp, ElementDefinition.PropertyRepresentation.NULL, new ElementDefinition.PropertyRepresentationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sliceIsConstraining")) {
            res.setSliceIsConstrainingElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slicing")) {
            res.setSlicing(this.parseElementDefinitionElementDefinitionSlicingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("short")) {
            res.setShortElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBase(this.parseElementDefinitionElementDefinitionBaseComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("contentReference")) {
            res.setContentReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseElementDefinitionTypeRefComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "defaultValue")) {
            res.setDefaultValue(this.parseType("defaultValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("meaningWhenMissing")) {
            res.setMeaningWhenMissingElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderMeaning")) {
            res.setOrderMeaningElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "fixed")) {
            res.setFixed(this.parseType("fixed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "pattern")) {
            res.setPattern(this.parseType("pattern", xpp));
        } else if (eventType == 2 && xpp.getName().equals("example")) {
            res.getExample().add(this.parseElementDefinitionElementDefinitionExampleComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "minValue")) {
            res.setMinValue(this.parseType("minValue", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "maxValue")) {
            res.setMaxValue(this.parseType("maxValue", xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxLength")) {
            res.setMaxLengthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("constraint")) {
            res.getConstraint().add(this.parseElementDefinitionElementDefinitionConstraintComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("mustSupport")) {
            res.setMustSupportElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isModifier")) {
            res.setIsModifierElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isModifierReason")) {
            res.setIsModifierReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isSummary")) {
            res.setIsSummaryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("binding")) {
            res.setBinding(this.parseElementDefinitionElementDefinitionBindingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("mapping")) {
            res.getMapping().add(this.parseElementDefinitionElementDefinitionMappingComponent(xpp, res));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingComponent parseElementDefinitionElementDefinitionSlicingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingComponent res = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionSlicingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionSlicingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("discriminator")) {
            res.getDiscriminator().add(this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ordered")) {
            res.setOrderedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rules")) {
            res.setRulesElement(this.parseEnumeration(xpp, ElementDefinition.SlicingRules.NULL, new ElementDefinition.SlicingRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent parseElementDefinitionElementDefinitionSlicingDiscriminatorComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res = new ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionSlicingDiscriminatorComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ElementDefinition.DiscriminatorType.NULL, new ElementDefinition.DiscriminatorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBaseComponent parseElementDefinitionElementDefinitionBaseComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBaseComponent res = new ElementDefinition.ElementDefinitionBaseComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionBaseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionBaseComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBaseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.TypeRefComponent parseElementDefinitionTypeRefComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.TypeRefComponent res = new ElementDefinition.TypeRefComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionTypeRefComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionTypeRefComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.TypeRefComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.getProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetProfile")) {
            res.getTargetProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("aggregation")) {
            res.getAggregation().add(this.parseEnumeration(xpp, ElementDefinition.AggregationMode.NULL, new ElementDefinition.AggregationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, ElementDefinition.ReferenceVersionRules.NULL, new ElementDefinition.ReferenceVersionRulesEnumFactory()));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionExampleComponent parseElementDefinitionElementDefinitionExampleComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionExampleComponent res = new ElementDefinition.ElementDefinitionExampleComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionExampleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionExampleComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionExampleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("label")) {
            res.setLabelElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionConstraintComponent parseElementDefinitionElementDefinitionConstraintComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionConstraintComponent res = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionConstraintComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionConstraintComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionConstraintComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("key")) {
            res.setKeyElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirements")) {
            res.setRequirementsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, ElementDefinition.ConstraintSeverity.NULL, new ElementDefinition.ConstraintSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("human")) {
            res.setHumanElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("xpath")) {
            res.setXpathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseCanonical(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionBindingComponent parseElementDefinitionElementDefinitionBindingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionBindingComponent res = new ElementDefinition.ElementDefinitionBindingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionBindingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionBindingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionBindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrengthElement(this.parseEnumeration(xpp, Enumerations.BindingStrength.NULL, new Enumerations.BindingStrengthEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ElementDefinition.ElementDefinitionMappingComponent parseElementDefinitionElementDefinitionMappingComponent(XmlPullParser xpp, ElementDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ElementDefinition.ElementDefinitionMappingComponent res = new ElementDefinition.ElementDefinitionMappingComponent();
        this.parseElementAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseElementDefinitionElementDefinitionMappingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseElementDefinitionElementDefinitionMappingComponentContent(int eventType, XmlPullParser xpp, ElementDefinition owner, ElementDefinition.ElementDefinitionMappingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identity")) {
            res.setIdentityElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("map")) {
            res.setMapElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected void parseDomainResourceAttributes(XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        this.parseResourceAttributes(xpp, res);
    }

    protected boolean parseDomainResourceContent(int eventType, XmlPullParser xpp, DomainResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contained")) {
            res.getContained().add(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extension")) {
            res.getExtension().add(this.parseExtension(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifierExtension")) {
            res.getModifierExtension().add(this.parseExtension(xpp));
        } else {
            return this.parseResourceContent(eventType, xpp, res);
        }
        return true;
    }

    protected Parameters parseParameters(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters res = new Parameters();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParametersContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParametersContent(int eventType, XmlPullParser xpp, Parameters res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseParametersParametersParameterComponent(xpp, res));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Parameters.ParametersParameterComponent parseParametersParametersParameterComponent(XmlPullParser xpp, Parameters owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Parameters.ParametersParameterComponent res = new Parameters.ParametersParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseParametersParametersParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseParametersParametersParameterComponentContent(int eventType, XmlPullParser xpp, Parameters owner, Parameters.ParametersParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("part")) {
            res.getPart().add(this.parseParametersParametersParameterComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected void parseResourceAttributes(XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (!this.comments.isEmpty()) {
            res.getFormatCommentsPre().addAll(this.comments);
            this.comments.clear();
        }
    }

    protected boolean parseResourceContent(int eventType, XmlPullParser xpp, Resource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("id")) {
            res.setIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("meta")) {
            res.setMeta(this.parseMeta(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicitRules")) {
            res.setImplicitRulesElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else {
            return false;
        }
        return true;
    }

    protected Account parseAccount(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Account res = new Account();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountContent(int eventType, XmlPullParser xpp, Account res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Account.AccountStatus.NULL, new Account.AccountStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("servicePeriod")) {
            res.setServicePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.getCoverage().add(this.parseAccountCoverageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guarantor")) {
            res.getGuarantor().add(this.parseAccountGuarantorComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.CoverageComponent parseAccountCoverageComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.CoverageComponent res = new Account.CoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountCoverageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountCoverageComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.CoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Account.GuarantorComponent parseAccountGuarantorComponent(XmlPullParser xpp, Account owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Account.GuarantorComponent res = new Account.GuarantorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAccountGuarantorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAccountGuarantorComponentContent(int eventType, XmlPullParser xpp, Account owner, Account.GuarantorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onHold")) {
            res.setOnHoldElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition parseActivityDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition res = new ActivityDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionContent(int eventType, XmlPullParser xpp, ActivityDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, ActivityDefinition.ActivityDefinitionKind.NULL, new ActivityDefinition.ActivityDefinitionKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, ActivityDefinition.RequestIntent.NULL, new ActivityDefinition.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, ActivityDefinition.RequestPriority.NULL, new ActivityDefinition.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseActivityDefinitionActivityDefinitionParticipantComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimenRequirement")) {
            res.getSpecimenRequirement().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observationRequirement")) {
            res.getObservationRequirement().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observationResultRequirement")) {
            res.getObservationResultRequirement().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("transform")) {
            res.setTransformElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dynamicValue")) {
            res.getDynamicValue().add(this.parseActivityDefinitionActivityDefinitionDynamicValueComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionParticipantComponent parseActivityDefinitionActivityDefinitionParticipantComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionParticipantComponent res = new ActivityDefinition.ActivityDefinitionParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionActivityDefinitionParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionActivityDefinitionParticipantComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ActivityDefinition.ActivityParticipantType.NULL, new ActivityDefinition.ActivityParticipantTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ActivityDefinition.ActivityDefinitionDynamicValueComponent parseActivityDefinitionActivityDefinitionDynamicValueComponent(XmlPullParser xpp, ActivityDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ActivityDefinition.ActivityDefinitionDynamicValueComponent res = new ActivityDefinition.ActivityDefinitionDynamicValueComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseActivityDefinitionActivityDefinitionDynamicValueComponentContent(int eventType, XmlPullParser xpp, ActivityDefinition owner, ActivityDefinition.ActivityDefinitionDynamicValueComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpression(this.parseExpression(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent parseAdverseEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent res = new AdverseEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventContent(int eventType, XmlPullParser xpp, AdverseEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actuality")) {
            res.setActualityElement(this.parseEnumeration(xpp, AdverseEvent.AdverseEventActuality.NULL, new AdverseEvent.AdverseEventActualityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.setEvent(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detected")) {
            res.setDetectedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resultingCondition")) {
            res.getResultingCondition().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("seriousness")) {
            res.setSeriousness(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("suspectEntity")) {
            res.getSuspectEntity().add(this.parseAdverseEventAdverseEventSuspectEntityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("subjectMedicalHistory")) {
            res.getSubjectMedicalHistory().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceDocument")) {
            res.getReferenceDocument().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("study")) {
            res.getStudy().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSuspectEntityComponent parseAdverseEventAdverseEventSuspectEntityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityComponent res = new AdverseEvent.AdverseEventSuspectEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventAdverseEventSuspectEntityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventAdverseEventSuspectEntityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("instance")) {
            res.setInstance(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("causality")) {
            res.getCausality().add(this.parseAdverseEventAdverseEventSuspectEntityCausalityComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AdverseEvent.AdverseEventSuspectEntityCausalityComponent parseAdverseEventAdverseEventSuspectEntityCausalityComponent(XmlPullParser xpp, AdverseEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AdverseEvent.AdverseEventSuspectEntityCausalityComponent res = new AdverseEvent.AdverseEventSuspectEntityCausalityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAdverseEventAdverseEventSuspectEntityCausalityComponentContent(int eventType, XmlPullParser xpp, AdverseEvent owner, AdverseEvent.AdverseEventSuspectEntityCausalityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("assessment")) {
            res.setAssessment(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productRelatedness")) {
            res.setProductRelatednessElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance parseAllergyIntolerance(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance res = new AllergyIntolerance();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceContent(int eventType, XmlPullParser xpp, AllergyIntolerance res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceType.NULL, new AllergyIntolerance.AllergyIntoleranceTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCategory.NULL, new AllergyIntolerance.AllergyIntoleranceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("criticality")) {
            res.setCriticalityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceCriticality.NULL, new AllergyIntolerance.AllergyIntoleranceCriticalityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asserter")) {
            res.setAsserter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastOccurrence")) {
            res.setLastOccurrenceElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseAllergyIntoleranceAllergyIntoleranceReactionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AllergyIntolerance.AllergyIntoleranceReactionComponent parseAllergyIntoleranceAllergyIntoleranceReactionComponent(XmlPullParser xpp, AllergyIntolerance owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AllergyIntolerance.AllergyIntoleranceReactionComponent res = new AllergyIntolerance.AllergyIntoleranceReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAllergyIntoleranceAllergyIntoleranceReactionComponentContent(int eventType, XmlPullParser xpp, AllergyIntolerance owner, AllergyIntolerance.AllergyIntoleranceReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manifestation")) {
            res.getManifestation().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onset")) {
            res.setOnsetElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, AllergyIntolerance.AllergyIntoleranceSeverity.NULL, new AllergyIntolerance.AllergyIntoleranceSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("exposureRoute")) {
            res.setExposureRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment parseAppointment(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment res = new Appointment();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentContent(int eventType, XmlPullParser xpp, Appointment res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Appointment.AppointmentStatus.NULL, new Appointment.AppointmentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cancelationReason")) {
            res.setCancelationReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceCategory")) {
            res.getServiceCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.getServiceType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentType")) {
            res.setAppointmentType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("minutesDuration")) {
            res.setMinutesDurationElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("slot")) {
            res.getSlot().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientInstruction")) {
            res.setPatientInstructionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseAppointmentAppointmentParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("requestedPeriod")) {
            res.getRequestedPeriod().add(this.parsePeriod(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Appointment.AppointmentParticipantComponent parseAppointmentAppointmentParticipantComponent(XmlPullParser xpp, Appointment owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Appointment.AppointmentParticipantComponent res = new Appointment.AppointmentParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentAppointmentParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentAppointmentParticipantComponentContent(int eventType, XmlPullParser xpp, Appointment owner, Appointment.AppointmentParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("required")) {
            res.setRequiredElement(this.parseEnumeration(xpp, Appointment.ParticipantRequired.NULL, new Appointment.ParticipantRequiredEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Appointment.ParticipationStatus.NULL, new Appointment.ParticipationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AppointmentResponse parseAppointmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AppointmentResponse res = new AppointmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAppointmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAppointmentResponseContent(int eventType, XmlPullParser xpp, AppointmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.setAppointment(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantType")) {
            res.getParticipantType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participantStatus")) {
            res.setParticipantStatusElement(this.parseEnumeration(xpp, AppointmentResponse.ParticipantStatus.NULL, new AppointmentResponse.ParticipantStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent parseAuditEvent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent res = new AuditEvent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventContent(int eventType, XmlPullParser xpp, AuditEvent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtype")) {
            res.getSubtype().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.setActionElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAction.NULL, new AuditEvent.AuditEventActionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorded")) {
            res.setRecordedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventOutcome.NULL, new AuditEvent.AuditEventOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("outcomeDesc")) {
            res.setOutcomeDescElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purposeOfEvent")) {
            res.getPurposeOfEvent().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("agent")) {
            res.getAgent().add(this.parseAuditEventAuditEventAgentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseAuditEventAuditEventSourceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("entity")) {
            res.getEntity().add(this.parseAuditEventAuditEventEntityComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventAgentComponent parseAuditEventAuditEventAgentComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentComponent res = new AuditEvent.AuditEventAgentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventAgentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventAgentComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("who")) {
            res.setWho(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("altId")) {
            res.setAltIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestorElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("media")) {
            res.setMedia(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseAuditEventAuditEventAgentNetworkComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("purposeOfUse")) {
            res.getPurposeOfUse().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventAgentNetworkComponent parseAuditEventAuditEventAgentNetworkComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventAgentNetworkComponent res = new AuditEvent.AuditEventAgentNetworkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventAgentNetworkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventAgentNetworkComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventAgentNetworkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, AuditEvent.AuditEventAgentNetworkType.NULL, new AuditEvent.AuditEventAgentNetworkTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventSourceComponent parseAuditEventAuditEventSourceComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventSourceComponent res = new AuditEvent.AuditEventSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventSourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventSourceComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSiteElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observer")) {
            res.setObserver(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityComponent parseAuditEventAuditEventEntityComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityComponent res = new AuditEvent.AuditEventEntityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventEntityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventEntityComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("what")) {
            res.setWhat(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycle")) {
            res.setLifecycle(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("query")) {
            res.setQueryElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseAuditEventAuditEventEntityDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected AuditEvent.AuditEventEntityDetailComponent parseAuditEventAuditEventEntityDetailComponent(XmlPullParser xpp, AuditEvent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        AuditEvent.AuditEventEntityDetailComponent res = new AuditEvent.AuditEventEntityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseAuditEventAuditEventEntityDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseAuditEventAuditEventEntityDetailComponentContent(int eventType, XmlPullParser xpp, AuditEvent owner, AuditEvent.AuditEventEntityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Basic parseBasic(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Basic res = new Basic();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBasicContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBasicContent(int eventType, XmlPullParser xpp, Basic res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Binary parseBinary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Binary res = new Binary();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBinaryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBinaryContent(int eventType, XmlPullParser xpp, Binary res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("contentType")) {
            res.setContentTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityContext")) {
            res.setSecurityContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.setDataElement(this.parseBase64Binary(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct parseBiologicallyDerivedProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct res = new BiologicallyDerivedProduct();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productCategory")) {
            res.setProductCategoryElement(this.parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductCategory.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("productCode")) {
            res.setProductCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStatus.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.getRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantityElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("collection")) {
            res.setCollection(this.parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("processing")) {
            res.getProcessing().add(this.parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("manipulation")) {
            res.setManipulation(this.parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("storage")) {
            res.getStorage().add(this.parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductCollectionComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductCollectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("collector")) {
            res.setCollector(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "collected")) {
            res.setCollected(this.parseType("collected", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductProcessingComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductProcessingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.setProcedure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additive")) {
            res.setAdditive(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "time")) {
            res.setTime(this.parseType("time", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductManipulationComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductManipulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "time")) {
            res.setTime(this.parseType("time", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponent(XmlPullParser xpp, BiologicallyDerivedProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res = new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBiologicallyDerivedProductBiologicallyDerivedProductStorageComponentContent(int eventType, XmlPullParser xpp, BiologicallyDerivedProduct owner, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("temperature")) {
            res.setTemperatureElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scale")) {
            res.setScaleElement(this.parseEnumeration(xpp, BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScale.NULL, new BiologicallyDerivedProduct.BiologicallyDerivedProductStorageScaleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDuration(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected BodyStructure parseBodyStructure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        BodyStructure res = new BodyStructure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBodyStructureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBodyStructureContent(int eventType, XmlPullParser xpp, BodyStructure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("morphology")) {
            res.setMorphology(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("locationQualifier")) {
            res.getLocationQualifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle parseBundle(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle res = new Bundle();
        this.parseResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleContent(int eventType, XmlPullParser xpp, Bundle res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Bundle.BundleType.NULL, new Bundle.BundleTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("timestamp")) {
            res.setTimestampElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotalElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleBundleLinkComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseBundleBundleEntryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.setSignature(this.parseSignature(xpp));
        } else if (!this.parseResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleLinkComponent parseBundleBundleLinkComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleLinkComponent res = new Bundle.BundleLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleLinkComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relation")) {
            res.setRelationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryComponent parseBundleBundleEntryComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryComponent res = new Bundle.BundleEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseBundleBundleLinkComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("fullUrl")) {
            res.setFullUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseResourceContained(xpp));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearch(this.parseBundleBundleEntrySearchComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseBundleBundleEntryRequestComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseBundleBundleEntryResponseComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntrySearchComponent parseBundleBundleEntrySearchComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntrySearchComponent res = new Bundle.BundleEntrySearchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntrySearchComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntrySearchComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntrySearchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Bundle.SearchEntryMode.NULL, new Bundle.SearchEntryModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScoreElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryRequestComponent parseBundleBundleEntryRequestComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryRequestComponent res = new Bundle.BundleEntryRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryRequestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryRequestComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethodElement(this.parseEnumeration(xpp, Bundle.HTTPVerb.NULL, new Bundle.HTTPVerbEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneMatch")) {
            res.setIfNoneMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifModifiedSince")) {
            res.setIfModifiedSinceElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifMatch")) {
            res.setIfMatchElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ifNoneExist")) {
            res.setIfNoneExistElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Bundle.BundleEntryResponseComponent parseBundleBundleEntryResponseComponent(XmlPullParser xpp, Bundle owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Bundle.BundleEntryResponseComponent res = new Bundle.BundleEntryResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseBundleBundleEntryResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseBundleBundleEntryResponseComponentContent(int eventType, XmlPullParser xpp, Bundle owner, Bundle.BundleEntryResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocationElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("etag")) {
            res.setEtagElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastModified")) {
            res.setLastModifiedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseResourceContained(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement parseCapabilityStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement res = new CapabilityStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementContent(int eventType, XmlPullParser xpp, CapabilityStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, CapabilityStatement.CapabilityStatementKind.NULL, new CapabilityStatement.CapabilityStatementKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("instantiates")) {
            res.getInstantiates().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imports")) {
            res.getImports().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("software")) {
            res.setSoftware(this.parseCapabilityStatementCapabilityStatementSoftwareComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("implementation")) {
            res.setImplementation(this.parseCapabilityStatementCapabilityStatementImplementationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.setFhirVersionElement(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.getFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patchFormat")) {
            res.getPatchFormat().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implementationGuide")) {
            res.getImplementationGuide().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rest")) {
            res.getRest().add(this.parseCapabilityStatementCapabilityStatementRestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("messaging")) {
            res.getMessaging().add(this.parseCapabilityStatementCapabilityStatementMessagingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("document")) {
            res.getDocument().add(this.parseCapabilityStatementCapabilityStatementDocumentComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementSoftwareComponent parseCapabilityStatementCapabilityStatementSoftwareComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementSoftwareComponent res = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementSoftwareComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementSoftwareComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementSoftwareComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("releaseDate")) {
            res.setReleaseDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementImplementationComponent parseCapabilityStatementCapabilityStatementImplementationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementImplementationComponent res = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementImplementationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementImplementationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementImplementationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestComponent parseCapabilityStatementCapabilityStatementRestComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestComponent res = new CapabilityStatement.CapabilityStatementRestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.RestfulCapabilityMode.NULL, new CapabilityStatement.RestfulCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("security")) {
            res.setSecurity(this.parseCapabilityStatementCapabilityStatementRestSecurityComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCapabilityStatementCapabilityStatementRestResourceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementSystemInteractionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestSecurityComponent parseCapabilityStatementCapabilityStatementRestSecurityComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestSecurityComponent res = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestSecurityComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestSecurityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("cors")) {
            res.setCorsElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceComponent parseCapabilityStatementCapabilityStatementRestResourceComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceComponent res = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestResourceComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportedProfile")) {
            res.getSupportedProfile().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interaction")) {
            res.getInteraction().add(this.parseCapabilityStatementResourceInteractionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("versioning")) {
            res.setVersioningElement(this.parseEnumeration(xpp, CapabilityStatement.ResourceVersionPolicy.NULL, new CapabilityStatement.ResourceVersionPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("readHistory")) {
            res.setReadHistoryElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("updateCreate")) {
            res.setUpdateCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalCreate")) {
            res.setConditionalCreateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalRead")) {
            res.setConditionalReadElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalReadStatus.NULL, new CapabilityStatement.ConditionalReadStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("conditionalUpdate")) {
            res.setConditionalUpdateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conditionalDelete")) {
            res.setConditionalDeleteElement(this.parseEnumeration(xpp, CapabilityStatement.ConditionalDeleteStatus.NULL, new CapabilityStatement.ConditionalDeleteStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("referencePolicy")) {
            res.getReferencePolicy().add(this.parseEnumeration(xpp, CapabilityStatement.ReferenceHandlingPolicy.NULL, new CapabilityStatement.ReferenceHandlingPolicyEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("searchInclude")) {
            res.getSearchInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchRevInclude")) {
            res.getSearchRevInclude().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("searchParam")) {
            res.getSearchParam().add(this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.getOperation().add(this.parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.ResourceInteractionComponent parseCapabilityStatementResourceInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.ResourceInteractionComponent res = new CapabilityStatement.ResourceInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementResourceInteractionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementResourceInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.ResourceInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.TypeRestfulInteraction.NULL, new CapabilityStatement.TypeRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestResourceSearchParamComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.SearchParamType.NULL, new Enumerations.SearchParamTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementRestResourceOperationComponent parseCapabilityStatementCapabilityStatementRestResourceOperationComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent res = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementRestResourceOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementRestResourceOperationComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementRestResourceOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.SystemInteractionComponent parseCapabilityStatementSystemInteractionComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.SystemInteractionComponent res = new CapabilityStatement.SystemInteractionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementSystemInteractionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementSystemInteractionComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.SystemInteractionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CapabilityStatement.SystemRestfulInteraction.NULL, new CapabilityStatement.SystemRestfulInteractionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingComponent parseCapabilityStatementCapabilityStatementMessagingComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingComponent res = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("reliableCache")) {
            res.setReliableCacheElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportedMessage")) {
            res.getSupportedMessage().add(this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingEndpointComponent parseCapabilityStatementCapabilityStatementMessagingEndpointComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent res = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingEndpointComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingEndpointComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.setProtocol(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res = new CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementMessagingSupportedMessageComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementMessagingSupportedMessageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.EventCapabilityMode.NULL, new CapabilityStatement.EventCapabilityModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CapabilityStatement.CapabilityStatementDocumentComponent parseCapabilityStatementCapabilityStatementDocumentComponent(XmlPullParser xpp, CapabilityStatement owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CapabilityStatement.CapabilityStatementDocumentComponent res = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCapabilityStatementCapabilityStatementDocumentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCapabilityStatementCapabilityStatementDocumentComponentContent(int eventType, XmlPullParser xpp, CapabilityStatement owner, CapabilityStatement.CapabilityStatementDocumentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, CapabilityStatement.DocumentMode.NULL, new CapabilityStatement.DocumentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan parseCarePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan res = new CarePlan();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanContent(int eventType, XmlPullParser xpp, CarePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanStatus.NULL, new CarePlan.CarePlanStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, CarePlan.CarePlanIntent.NULL, new CarePlan.CarePlanIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributor")) {
            res.getContributor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("activity")) {
            res.getActivity().add(this.parseCarePlanCarePlanActivityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityComponent parseCarePlanCarePlanActivityComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityComponent res = new CarePlan.CarePlanActivityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanCarePlanActivityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanCarePlanActivityComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("outcomeCodeableConcept")) {
            res.getOutcomeCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeReference")) {
            res.getOutcomeReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("progress")) {
            res.getProgress().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetail(this.parseCarePlanCarePlanActivityDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CarePlan.CarePlanActivityDetailComponent parseCarePlanCarePlanActivityDetailComponent(XmlPullParser xpp, CarePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CarePlan.CarePlanActivityDetailComponent res = new CarePlan.CarePlanActivityDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCarePlanCarePlanActivityDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCarePlanCarePlanActivityDetailComponentContent(int eventType, XmlPullParser xpp, CarePlan owner, CarePlan.CarePlanActivityDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityKind.NULL, new CarePlan.CarePlanActivityKindEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("goal")) {
            res.getGoal().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CarePlan.CarePlanActivityStatus.NULL, new CarePlan.CarePlanActivityStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "scheduled")) {
            res.setScheduled(this.parseType("scheduled", xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dailyAmount")) {
            res.setDailyAmount(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam parseCareTeam(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam res = new CareTeam();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamContent(int eventType, XmlPullParser xpp, CareTeam res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CareTeam.CareTeamStatus.NULL, new CareTeam.CareTeamStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseCareTeamCareTeamParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.getManagingOrganization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CareTeam.CareTeamParticipantComponent parseCareTeamCareTeamParticipantComponent(XmlPullParser xpp, CareTeam owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CareTeam.CareTeamParticipantComponent res = new CareTeam.CareTeamParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCareTeamCareTeamParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCareTeamCareTeamParticipantComponentContent(int eventType, XmlPullParser xpp, CareTeam owner, CareTeam.CareTeamParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.getRole().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.setMember(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onBehalfOf")) {
            res.setOnBehalfOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CatalogEntry parseCatalogEntry(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CatalogEntry res = new CatalogEntry();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCatalogEntryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCatalogEntryContent(int eventType, XmlPullParser xpp, CatalogEntry res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderable")) {
            res.setOrderableElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referencedItem")) {
            res.setReferencedItem(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalIdentifier")) {
            res.getAdditionalIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.getClassification().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validTo")) {
            res.setValidToElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastUpdated")) {
            res.setLastUpdatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalCharacteristic")) {
            res.getAdditionalCharacteristic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalClassification")) {
            res.getAdditionalClassification().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedEntry")) {
            res.getRelatedEntry().add(this.parseCatalogEntryCatalogEntryRelatedEntryComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CatalogEntry.CatalogEntryRelatedEntryComponent parseCatalogEntryCatalogEntryRelatedEntryComponent(XmlPullParser xpp, CatalogEntry owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CatalogEntry.CatalogEntryRelatedEntryComponent res = new CatalogEntry.CatalogEntryRelatedEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCatalogEntryCatalogEntryRelatedEntryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCatalogEntryCatalogEntryRelatedEntryComponentContent(int eventType, XmlPullParser xpp, CatalogEntry owner, CatalogEntry.CatalogEntryRelatedEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("relationtype")) {
            res.setRelationtypeElement(this.parseEnumeration(xpp, CatalogEntry.CatalogEntryRelationType.NULL, new CatalogEntry.CatalogEntryRelationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem parseChargeItem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem res = new ChargeItem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemContent(int eventType, XmlPullParser xpp, ChargeItem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionUri")) {
            res.getDefinitionUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definitionCanonical")) {
            res.getDefinitionCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ChargeItem.ChargeItemStatus.NULL, new ChargeItem.ChargeItemStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseChargeItemChargeItemPerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("performingOrganization")) {
            res.setPerformingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestingOrganization")) {
            res.setRequestingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("costCenter")) {
            res.setCostCenter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodysite")) {
            res.getBodysite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factorOverride")) {
            res.setFactorOverrideElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priceOverride")) {
            res.setPriceOverride(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("overrideReason")) {
            res.setOverrideReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enteredDate")) {
            res.setEnteredDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("service")) {
            res.getService().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "product")) {
            res.setProduct(this.parseType("product", xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItem.ChargeItemPerformerComponent parseChargeItemChargeItemPerformerComponent(XmlPullParser xpp, ChargeItem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItem.ChargeItemPerformerComponent res = new ChargeItem.ChargeItemPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemChargeItemPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemChargeItemPerformerComponentContent(int eventType, XmlPullParser xpp, ChargeItem owner, ChargeItem.ChargeItemPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition parseChargeItemDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition res = new ChargeItemDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionContent(int eventType, XmlPullParser xpp, ChargeItemDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFromUri")) {
            res.getDerivedFromUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.getApplicability().add(this.parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("propertyGroup")) {
            res.getPropertyGroup().add(this.parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res = new ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionApplicabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionChargeItemDefinitionPropertyGroupComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.getApplicability().add(this.parseChargeItemDefinitionChargeItemDefinitionApplicabilityComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("priceComponent")) {
            res.getPriceComponent().add(this.parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponent(XmlPullParser xpp, ChargeItemDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res = new ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseChargeItemDefinitionChargeItemDefinitionPropertyGroupPriceComponentComponentContent(int eventType, XmlPullParser xpp, ChargeItemDefinition owner, ChargeItemDefinition.ChargeItemDefinitionPropertyGroupPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ChargeItemDefinition.ChargeItemDefinitionPriceComponentType.NULL, new ChargeItemDefinition.ChargeItemDefinitionPriceComponentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim parseClaim(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim res = new Claim();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimContent(int eventType, XmlPullParser xpp, Claim res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Claim.ClaimStatus.NULL, new Claim.ClaimStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, Claim.Use.NULL, new Claim.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseClaimRelatedClaimComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseClaimPayeeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseClaimCareTeamComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseClaimSupportingInformationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseClaimDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseClaimProcedureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseClaimAccidentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.setTotal(this.parseMoney(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.RelatedClaimComponent parseClaimRelatedClaimComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.RelatedClaimComponent res = new Claim.RelatedClaimComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimRelatedClaimComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimRelatedClaimComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.PayeeComponent parseClaimPayeeComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.PayeeComponent res = new Claim.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimPayeeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimPayeeComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.CareTeamComponent parseClaimCareTeamComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.CareTeamComponent res = new Claim.CareTeamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimCareTeamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimCareTeamComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualification")) {
            res.setQualification(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SupportingInformationComponent parseClaimSupportingInformationComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SupportingInformationComponent res = new Claim.SupportingInformationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSupportingInformationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSupportingInformationComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DiagnosisComponent parseClaimDiagnosisComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DiagnosisComponent res = new Claim.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDiagnosisComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ProcedureComponent parseClaimProcedureComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ProcedureComponent res = new Claim.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimProcedureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimProcedureComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.InsuranceComponent parseClaimInsuranceComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.InsuranceComponent res = new Claim.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimInsuranceComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.AccidentComponent parseClaimAccidentComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.AccidentComponent res = new Claim.AccidentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimAccidentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimAccidentComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.ItemComponent parseClaimItemComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.ItemComponent res = new Claim.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimItemComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamSequence")) {
            res.getCareTeamSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisSequence")) {
            res.getDiagnosisSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureSequence")) {
            res.getProcedureSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSequence")) {
            res.getInformationSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.DetailComponent parseClaimDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.DetailComponent res = new Claim.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Claim.SubDetailComponent parseClaimSubDetailComponent(XmlPullParser xpp, Claim owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Claim.SubDetailComponent res = new Claim.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimSubDetailComponentContent(int eventType, XmlPullParser xpp, Claim owner, Claim.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse parseClaimResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse res = new ClaimResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseContent(int eventType, XmlPullParser xpp, ClaimResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ClaimResponse.ClaimResponseStatus.NULL, new ClaimResponse.ClaimResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ClaimResponse.Use.NULL, new ClaimResponse.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, ClaimResponse.RemittanceOutcome.NULL, new ClaimResponse.RemittanceOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthPeriod")) {
            res.setPreAuthPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payeeType")) {
            res.setPayeeType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseClaimResponseItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseClaimResponseAddedItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.getTotal().add(this.parseClaimResponseTotalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseClaimResponsePaymentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("formCode")) {
            res.setFormCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseClaimResponseNoteComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("communicationRequest")) {
            res.getCommunicationRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseClaimResponseInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseClaimResponseErrorComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemComponent parseClaimResponseItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemComponent res = new ClaimResponse.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseItemDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AdjudicationComponent parseClaimResponseAdjudicationComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AdjudicationComponent res = new ClaimResponse.AdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAdjudicationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAdjudicationComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ItemDetailComponent parseClaimResponseItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ItemDetailComponent res = new ClaimResponse.ItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseItemDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimResponseSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.SubDetailComponent parseClaimResponseSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.SubDetailComponent res = new ClaimResponse.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemComponent parseClaimResponseAddedItemComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemComponent res = new ClaimResponse.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.getItemSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.getDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subdetailSequence")) {
            res.getSubdetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.getProvider().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseClaimResponseAddedItemDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemDetailComponent parseClaimResponseAddedItemDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemDetailComponent res = new ClaimResponse.AddedItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseClaimResponseAddedItemSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.AddedItemSubDetailComponent parseClaimResponseAddedItemSubDetailComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.AddedItemSubDetailComponent res = new ClaimResponse.AddedItemSubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseAddedItemSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseAddedItemSubDetailComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.AddedItemSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseClaimResponseAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.TotalComponent parseClaimResponseTotalComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.TotalComponent res = new ClaimResponse.TotalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseTotalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseTotalComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.PaymentComponent parseClaimResponsePaymentComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.PaymentComponent res = new ClaimResponse.PaymentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponsePaymentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponsePaymentComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.NoteComponent parseClaimResponseNoteComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.NoteComponent res = new ClaimResponse.NoteComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseNoteComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseNoteComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.InsuranceComponent parseClaimResponseInsuranceComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.InsuranceComponent res = new ClaimResponse.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClaimResponse.ErrorComponent parseClaimResponseErrorComponent(XmlPullParser xpp, ClaimResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClaimResponse.ErrorComponent res = new ClaimResponse.ErrorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClaimResponseErrorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClaimResponseErrorComponentContent(int eventType, XmlPullParser xpp, ClaimResponse owner, ClaimResponse.ErrorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.setItemSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.setDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.setSubDetailSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression parseClinicalImpression(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression res = new ClinicalImpression();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionContent(int eventType, XmlPullParser xpp, ClinicalImpression res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ClinicalImpression.ClinicalImpressionStatus.NULL, new ClinicalImpression.ClinicalImpressionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assessor")) {
            res.setAssessor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("previous")) {
            res.setPrevious(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("problem")) {
            res.getProblem().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("investigation")) {
            res.getInvestigation().add(this.parseClinicalImpressionClinicalImpressionInvestigationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("protocol")) {
            res.getProtocol().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummaryElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("finding")) {
            res.getFinding().add(this.parseClinicalImpressionClinicalImpressionFindingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prognosisCodeableConcept")) {
            res.getPrognosisCodeableConcept().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("prognosisReference")) {
            res.getPrognosisReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression.ClinicalImpressionInvestigationComponent parseClinicalImpressionClinicalImpressionInvestigationComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionInvestigationComponent res = new ClinicalImpression.ClinicalImpressionInvestigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionClinicalImpressionInvestigationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionClinicalImpressionInvestigationComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionInvestigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ClinicalImpression.ClinicalImpressionFindingComponent parseClinicalImpressionClinicalImpressionFindingComponent(XmlPullParser xpp, ClinicalImpression owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ClinicalImpression.ClinicalImpressionFindingComponent res = new ClinicalImpression.ClinicalImpressionFindingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseClinicalImpressionClinicalImpressionFindingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseClinicalImpressionClinicalImpressionFindingComponentContent(int eventType, XmlPullParser xpp, ClinicalImpression owner, ClinicalImpression.ClinicalImpressionFindingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemCodeableConcept")) {
            res.setItemCodeableConcept(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("itemReference")) {
            res.setItemReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basis")) {
            res.setBasisElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem parseCodeSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem res = new CodeSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemContent(int eventType, XmlPullParser xpp, CodeSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("caseSensitive")) {
            res.setCaseSensitiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueSet")) {
            res.setValueSetElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hierarchyMeaning")) {
            res.setHierarchyMeaningElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemHierarchyMeaning.NULL, new CodeSystem.CodeSystemHierarchyMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("compositional")) {
            res.setCompositionalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versionNeeded")) {
            res.setVersionNeededElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContentElement(this.parseEnumeration(xpp, CodeSystem.CodeSystemContentMode.NULL, new CodeSystem.CodeSystemContentModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("supplements")) {
            res.setSupplementsElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("filter")) {
            res.getFilter().add(this.parseCodeSystemCodeSystemFilterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemPropertyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.CodeSystemFilterComponent parseCodeSystemCodeSystemFilterComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.CodeSystemFilterComponent res = new CodeSystem.CodeSystemFilterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemCodeSystemFilterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemCodeSystemFilterComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.CodeSystemFilterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.getOperator().add(this.parseEnumeration(xpp, CodeSystem.FilterOperator.NULL, new CodeSystem.FilterOperatorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.PropertyComponent parseCodeSystemPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.PropertyComponent res = new CodeSystem.PropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemPropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.PropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, CodeSystem.PropertyType.NULL, new CodeSystem.PropertyTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionComponent parseCodeSystemConceptDefinitionComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent res = new CodeSystem.ConceptDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("designation")) {
            res.getDesignation().add(this.parseCodeSystemConceptDefinitionDesignationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseCodeSystemConceptPropertyComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("concept")) {
            res.getConcept().add(this.parseCodeSystemConceptDefinitionComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptDefinitionDesignationComponent parseCodeSystemConceptDefinitionDesignationComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptDefinitionDesignationComponent res = new CodeSystem.ConceptDefinitionDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptDefinitionDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptDefinitionDesignationComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptDefinitionDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguageElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CodeSystem.ConceptPropertyComponent parseCodeSystemConceptPropertyComponent(XmlPullParser xpp, CodeSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CodeSystem.ConceptPropertyComponent res = new CodeSystem.ConceptPropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCodeSystemConceptPropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCodeSystemConceptPropertyComponentContent(int eventType, XmlPullParser xpp, CodeSystem owner, CodeSystem.ConceptPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication parseCommunication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication res = new Communication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationContent(int eventType, XmlPullParser xpp, Communication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inResponseTo")) {
            res.getInResponseTo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Communication.CommunicationStatus.NULL, new Communication.CommunicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, Communication.CommunicationPriority.NULL, new Communication.CommunicationPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.setTopic(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("about")) {
            res.getAbout().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sent")) {
            res.setSentElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("received")) {
            res.setReceivedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationCommunicationPayloadComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Communication.CommunicationPayloadComponent parseCommunicationCommunicationPayloadComponent(XmlPullParser xpp, Communication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Communication.CommunicationPayloadComponent res = new Communication.CommunicationPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationCommunicationPayloadComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationCommunicationPayloadComponentContent(int eventType, XmlPullParser xpp, Communication owner, Communication.CommunicationPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest parseCommunicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest res = new CommunicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestContent(int eventType, XmlPullParser xpp, CommunicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationRequestStatus.NULL, new CommunicationRequest.CommunicationRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, CommunicationRequest.CommunicationPriority.NULL, new CommunicationRequest.CommunicationPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("medium")) {
            res.getMedium().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("about")) {
            res.getAbout().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payload")) {
            res.getPayload().add(this.parseCommunicationRequestCommunicationRequestPayloadComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CommunicationRequest.CommunicationRequestPayloadComponent parseCommunicationRequestCommunicationRequestPayloadComponent(XmlPullParser xpp, CommunicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CommunicationRequest.CommunicationRequestPayloadComponent res = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCommunicationRequestCommunicationRequestPayloadComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCommunicationRequestCommunicationRequestPayloadComponentContent(int eventType, XmlPullParser xpp, CommunicationRequest owner, CommunicationRequest.CommunicationRequestPayloadComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition parseCompartmentDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition res = new CompartmentDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionContent(int eventType, XmlPullParser xpp, CompartmentDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, CompartmentDefinition.CompartmentType.NULL, new CompartmentDefinition.CompartmentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("search")) {
            res.setSearchElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseCompartmentDefinitionCompartmentDefinitionResourceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CompartmentDefinition.CompartmentDefinitionResourceComponent parseCompartmentDefinitionCompartmentDefinitionResourceComponent(XmlPullParser xpp, CompartmentDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CompartmentDefinition.CompartmentDefinitionResourceComponent res = new CompartmentDefinition.CompartmentDefinitionResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompartmentDefinitionCompartmentDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, CompartmentDefinition owner, CompartmentDefinition.CompartmentDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("param")) {
            res.getParam().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("documentation")) {
            res.setDocumentationElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition parseComposition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition res = new Composition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionContent(int eventType, XmlPullParser xpp, Composition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Composition.CompositionStatus.NULL, new Composition.CompositionStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("confidentiality")) {
            res.setConfidentialityElement(this.parseEnumeration(xpp, Composition.DocumentConfidentiality.NULL, new Composition.DocumentConfidentialityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("attester")) {
            res.getAttester().add(this.parseCompositionCompositionAttesterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseCompositionCompositionRelatesToComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCompositionCompositionEventComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionAttesterComponent parseCompositionCompositionAttesterComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionAttesterComponent res = new Composition.CompositionAttesterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionAttesterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionAttesterComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionAttesterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Composition.CompositionAttestationMode.NULL, new Composition.CompositionAttestationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionRelatesToComponent parseCompositionCompositionRelatesToComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionRelatesToComponent res = new Composition.CompositionRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionRelatesToComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionRelatesToComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, Composition.DocumentRelationshipType.NULL, new Composition.DocumentRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
            res.setTarget(this.parseType("target", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.CompositionEventComponent parseCompositionCompositionEventComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.CompositionEventComponent res = new Composition.CompositionEventComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionCompositionEventComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionCompositionEventComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.CompositionEventComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Composition.SectionComponent parseCompositionSectionComponent(XmlPullParser xpp, Composition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Composition.SectionComponent res = new Composition.SectionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCompositionSectionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCompositionSectionComponentContent(int eventType, XmlPullParser xpp, Composition owner, Composition.SectionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.setFocus(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setText(this.parseNarrative(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Composition.SectionMode.NULL, new Composition.SectionModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("section")) {
            res.getSection().add(this.parseCompositionSectionComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap parseConceptMap(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap res = new ConceptMap();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapContent(int eventType, XmlPullParser xpp, ConceptMap res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "target")) {
            res.setTarget(this.parseType("target", xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseConceptMapConceptMapGroupComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupComponent parseConceptMapConceptMapGroupComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupComponent res = new ConceptMap.ConceptMapGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapConceptMapGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapConceptMapGroupComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourceVersion")) {
            res.setSourceVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTargetElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetVersion")) {
            res.setTargetVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("element")) {
            res.getElement().add(this.parseConceptMapSourceElementComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("unmapped")) {
            res.setUnmapped(this.parseConceptMapConceptMapGroupUnmappedComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.SourceElementComponent parseConceptMapSourceElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.SourceElementComponent res = new ConceptMap.SourceElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapSourceElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapSourceElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.SourceElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseConceptMapTargetElementComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.TargetElementComponent parseConceptMapTargetElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.TargetElementComponent res = new ConceptMap.TargetElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapTargetElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapTargetElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.TargetElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("equivalence")) {
            res.setEquivalenceElement(this.parseEnumeration(xpp, Enumerations.ConceptMapEquivalence.NULL, new Enumerations.ConceptMapEquivalenceEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.getDependsOn().add(this.parseConceptMapOtherElementComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("product")) {
            res.getProduct().add(this.parseConceptMapOtherElementComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.OtherElementComponent parseConceptMapOtherElementComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.OtherElementComponent res = new ConceptMap.OtherElementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapOtherElementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapOtherElementComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.OtherElementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("property")) {
            res.setPropertyElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("system")) {
            res.setSystemElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ConceptMap.ConceptMapGroupUnmappedComponent parseConceptMapConceptMapGroupUnmappedComponent(XmlPullParser xpp, ConceptMap owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ConceptMap.ConceptMapGroupUnmappedComponent res = new ConceptMap.ConceptMapGroupUnmappedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConceptMapConceptMapGroupUnmappedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConceptMapConceptMapGroupUnmappedComponentContent(int eventType, XmlPullParser xpp, ConceptMap owner, ConceptMap.ConceptMapGroupUnmappedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ConceptMap.ConceptMapGroupUnmappedMode.NULL, new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("display")) {
            res.setDisplayElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition parseCondition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition res = new Condition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionContent(int eventType, XmlPullParser xpp, Condition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalStatus")) {
            res.setClinicalStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationStatus")) {
            res.setVerificationStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverity(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.getBodySite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "abatement")) {
            res.setAbatement(this.parseType("abatement", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedDate")) {
            res.setRecordedDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("asserter")) {
            res.setAsserter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stage")) {
            res.getStage().add(this.parseConditionConditionStageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("evidence")) {
            res.getEvidence().add(this.parseConditionConditionEvidenceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionStageComponent parseConditionConditionStageComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionStageComponent res = new Condition.ConditionStageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionConditionStageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionConditionStageComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionStageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("summary")) {
            res.setSummary(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("assessment")) {
            res.getAssessment().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Condition.ConditionEvidenceComponent parseConditionConditionEvidenceComponent(XmlPullParser xpp, Condition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Condition.ConditionEvidenceComponent res = new Condition.ConditionEvidenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConditionConditionEvidenceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConditionConditionEvidenceComponentContent(int eventType, XmlPullParser xpp, Condition owner, Condition.ConditionEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent parseConsent(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent res = new Consent();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentContent(int eventType, XmlPullParser xpp, Consent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Consent.ConsentState.NULL, new Consent.ConsentStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScope(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.getOrganization().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "source")) {
            res.setSource(this.parseType("source", xpp));
        } else if (eventType == 2 && xpp.getName().equals("policy")) {
            res.getPolicy().add(this.parseConsentConsentPolicyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("policyRule")) {
            res.setPolicyRule(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verification")) {
            res.getVerification().add(this.parseConsentConsentVerificationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("provision")) {
            res.setProvision(this.parseConsentprovisionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentPolicyComponent parseConsentConsentPolicyComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentPolicyComponent res = new Consent.ConsentPolicyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentConsentPolicyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentConsentPolicyComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentPolicyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthorityElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.ConsentVerificationComponent parseConsentConsentVerificationComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.ConsentVerificationComponent res = new Consent.ConsentVerificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentConsentVerificationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentConsentVerificationComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.ConsentVerificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("verified")) {
            res.setVerifiedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verifiedWith")) {
            res.setVerifiedWith(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("verificationDate")) {
            res.setVerificationDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.provisionComponent parseConsentprovisionComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.provisionComponent res = new Consent.provisionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentprovisionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentprovisionComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Consent.ConsentProvisionType.NULL, new Consent.ConsentProvisionTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseConsentprovisionActorComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataPeriod")) {
            res.setDataPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("data")) {
            res.getData().add(this.parseConsentprovisionDataComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("provision")) {
            res.getProvision().add(this.parseConsentprovisionComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.provisionActorComponent parseConsentprovisionActorComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.provisionActorComponent res = new Consent.provisionActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentprovisionActorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentprovisionActorComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Consent.provisionDataComponent parseConsentprovisionDataComponent(XmlPullParser xpp, Consent owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Consent.provisionDataComponent res = new Consent.provisionDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseConsentprovisionDataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseConsentprovisionDataComponentContent(int eventType, XmlPullParser xpp, Consent owner, Consent.provisionDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("meaning")) {
            res.setMeaningElement(this.parseEnumeration(xpp, Consent.ConsentDataMeaning.NULL, new Consent.ConsentDataMeaningEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract parseContract(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract res = new Contract();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContent(int eventType, XmlPullParser xpp, Contract res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Contract.ContractStatus.NULL, new Contract.ContractStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("legalState")) {
            res.setLegalState(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.setInstantiatesCanonical(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.setInstantiatesUriElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentDerivative")) {
            res.setContentDerivative(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationType")) {
            res.setExpirationType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.getAuthority().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("domain")) {
            res.getDomain().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.getSite().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScope(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "topic")) {
            res.setTopic(this.parseType("topic", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.getSubType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contentDefinition")) {
            res.setContentDefinition(this.parseContractContentDefinitionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.getTerm().add(this.parseContractTermComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signer")) {
            res.getSigner().add(this.parseContractSignatoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("friendly")) {
            res.getFriendly().add(this.parseContractFriendlyLanguageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("legal")) {
            res.getLegal().add(this.parseContractLegalLanguageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.getRule().add(this.parseContractComputableLanguageComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "legallyBinding")) {
            res.setLegallyBinding(this.parseType("legallyBinding", xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContentDefinitionComponent parseContractContentDefinitionComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContentDefinitionComponent res = new Contract.ContentDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContentDefinitionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContentDefinitionComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContentDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisher(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationStatus")) {
            res.setPublicationStatusElement(this.parseEnumeration(xpp, Contract.ContractPublicationStatus.NULL, new Contract.ContractPublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.TermComponent parseContractTermComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.TermComponent res = new Contract.TermComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractTermComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractTermComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.TermComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applies")) {
            res.setApplies(this.parsePeriod(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "topic")) {
            res.setTopic(this.parseType("topic", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseContractSecurityLabelComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("offer")) {
            res.setOffer(this.parseContractContractOfferComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("asset")) {
            res.getAsset().add(this.parseContractContractAssetComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("action")) {
            res.getAction().add(this.parseContractActionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseContractTermComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.SecurityLabelComponent parseContractSecurityLabelComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SecurityLabelComponent res = new Contract.SecurityLabelComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractSecurityLabelComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractSecurityLabelComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SecurityLabelComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.getNumber().add(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.setClassification(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("control")) {
            res.getControl().add(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractOfferComponent parseContractContractOfferComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractOfferComponent res = new Contract.ContractOfferComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContractOfferComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContractOfferComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractOfferComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.getParty().add(this.parseContractContractPartyComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.setTopic(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decision")) {
            res.setDecision(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("decisionMode")) {
            res.getDecisionMode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("answer")) {
            res.getAnswer().add(this.parseContractAnswerComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractPartyComponent parseContractContractPartyComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractPartyComponent res = new Contract.ContractPartyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContractPartyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContractPartyComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractPartyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.AnswerComponent parseContractAnswerComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AnswerComponent res = new Contract.AnswerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAnswerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAnswerComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AnswerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ContractAssetComponent parseContractContractAssetComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ContractAssetComponent res = new Contract.ContractAssetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractContractAssetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractContractAssetComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ContractAssetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScope(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("typeReference")) {
            res.getTypeReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtype")) {
            res.getSubtype().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.getContext().add(this.parseContractAssetContextComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setConditionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("periodType")) {
            res.getPeriodType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.getPeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usePeriod")) {
            res.getUsePeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("answer")) {
            res.getAnswer().add(this.parseContractAnswerComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valuedItem")) {
            res.getValuedItem().add(this.parseContractValuedItemComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.AssetContextComponent parseContractAssetContextComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.AssetContextComponent res = new Contract.AssetContextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractAssetContextComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractAssetContextComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.AssetContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ValuedItemComponent parseContractValuedItemComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ValuedItemComponent res = new Contract.ValuedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractValuedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractValuedItemComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ValuedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "entity")) {
            res.setEntity(this.parseType("entity", xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectiveTime")) {
            res.setEffectiveTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("points")) {
            res.setPointsElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPaymentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paymentDate")) {
            res.setPaymentDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsible(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.setRecipient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ActionComponent parseContractActionComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ActionComponent res = new Contract.ActionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractActionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractActionComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ActionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseContractActionSubjectComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntent(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("linkId")) {
            res.getLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contextLinkId")) {
            res.getContextLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.getRequester().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requesterLinkId")) {
            res.getRequesterLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.getPerformerType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerRole")) {
            res.setPerformerRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerLinkId")) {
            res.getPerformerLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonLinkId")) {
            res.getReasonLinkId().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabelNumber")) {
            res.getSecurityLabelNumber().add(this.parseUnsignedInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ActionSubjectComponent parseContractActionSubjectComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ActionSubjectComponent res = new Contract.ActionSubjectComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractActionSubjectComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractActionSubjectComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ActionSubjectComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.SignatoryComponent parseContractSignatoryComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.SignatoryComponent res = new Contract.SignatoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractSignatoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractSignatoryComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.SignatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("signature")) {
            res.getSignature().add(this.parseSignature(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.FriendlyLanguageComponent parseContractFriendlyLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.FriendlyLanguageComponent res = new Contract.FriendlyLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractFriendlyLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractFriendlyLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.FriendlyLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.LegalLanguageComponent parseContractLegalLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.LegalLanguageComponent res = new Contract.LegalLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractLegalLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractLegalLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.LegalLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Contract.ComputableLanguageComponent parseContractComputableLanguageComponent(XmlPullParser xpp, Contract owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Contract.ComputableLanguageComponent res = new Contract.ComputableLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseContractComputableLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseContractComputableLanguageComponentContent(int eventType, XmlPullParser xpp, Contract owner, Contract.ComputableLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "content")) {
            res.setContent(this.parseType("content", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage parseCoverage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage res = new Coverage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageContent(int eventType, XmlPullParser xpp, Coverage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Coverage.CoverageStatus.NULL, new Coverage.CoverageStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("policyHolder")) {
            res.setPolicyHolder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriber")) {
            res.setSubscriber(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subscriberId")) {
            res.setSubscriberIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("beneficiary")) {
            res.setBeneficiary(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dependent")) {
            res.setDependentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payor")) {
            res.getPayor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.getClass_().add(this.parseCoverageClassComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("order")) {
            res.setOrderElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetworkElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("costToBeneficiary")) {
            res.getCostToBeneficiary().add(this.parseCoverageCostToBeneficiaryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("subrogation")) {
            res.setSubrogationElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contract")) {
            res.getContract().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.ClassComponent parseCoverageClassComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.ClassComponent res = new Coverage.ClassComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageClassComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageClassComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.ClassComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.CostToBeneficiaryComponent parseCoverageCostToBeneficiaryComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.CostToBeneficiaryComponent res = new Coverage.CostToBeneficiaryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageCostToBeneficiaryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageCostToBeneficiaryComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.CostToBeneficiaryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exception")) {
            res.getException().add(this.parseCoverageExemptionComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Coverage.ExemptionComponent parseCoverageExemptionComponent(XmlPullParser xpp, Coverage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Coverage.ExemptionComponent res = new Coverage.ExemptionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageExemptionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageExemptionComponentContent(int eventType, XmlPullParser xpp, Coverage owner, Coverage.ExemptionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest parseCoverageEligibilityRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest res = new CoverageEligibilityRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestStatus.NULL, new CoverageEligibilityRequest.EligibilityRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseEnumeration(xpp, CoverageEligibilityRequest.EligibilityRequestPurpose.NULL, new CoverageEligibilityRequest.EligibilityRequestPurposeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseCoverageEligibilityRequestSupportingInformationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseCoverageEligibilityRequestInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseCoverageEligibilityRequestDetailsComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.SupportingInformationComponent parseCoverageEligibilityRequestSupportingInformationComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.SupportingInformationComponent res = new CoverageEligibilityRequest.SupportingInformationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestSupportingInformationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestSupportingInformationComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("information")) {
            res.setInformation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appliesToAll")) {
            res.setAppliesToAllElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.InsuranceComponent parseCoverageEligibilityRequestInsuranceComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.InsuranceComponent res = new CoverageEligibilityRequest.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("businessArrangement")) {
            res.setBusinessArrangementElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.DetailsComponent parseCoverageEligibilityRequestDetailsComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.DetailsComponent res = new CoverageEligibilityRequest.DetailsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestDetailsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestDetailsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DetailsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("supportingInfoSequence")) {
            res.getSupportingInfoSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseCoverageEligibilityRequestDiagnosisComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityRequest.DiagnosisComponent parseCoverageEligibilityRequestDiagnosisComponent(XmlPullParser xpp, CoverageEligibilityRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityRequest.DiagnosisComponent res = new CoverageEligibilityRequest.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityRequestDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityRequestDiagnosisComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityRequest owner, CoverageEligibilityRequest.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse parseCoverageEligibilityResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse res = new CoverageEligibilityResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponseStatus.NULL, new CoverageEligibilityResponse.EligibilityResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.getPurpose().add(this.parseEnumeration(xpp, CoverageEligibilityResponse.EligibilityResponsePurpose.NULL, new CoverageEligibilityResponse.EligibilityResponsePurposeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestor")) {
            res.setRequestor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseCoverageEligibilityResponseInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.setPreAuthRefElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("error")) {
            res.getError().add(this.parseCoverageEligibilityResponseErrorsComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.InsuranceComponent parseCoverageEligibilityResponseInsuranceComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.InsuranceComponent res = new CoverageEligibilityResponse.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseInsuranceComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inforce")) {
            res.setInforceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseCoverageEligibilityResponseItemsComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.ItemsComponent parseCoverageEligibilityResponseItemsComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.ItemsComponent res = new CoverageEligibilityResponse.ItemsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseItemsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseItemsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ItemsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseCoverageEligibilityResponseBenefitComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("authorizationRequired")) {
            res.setAuthorizationRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizationSupporting")) {
            res.getAuthorizationSupporting().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizationUrl")) {
            res.setAuthorizationUrlElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.BenefitComponent parseCoverageEligibilityResponseBenefitComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.BenefitComponent res = new CoverageEligibilityResponse.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseBenefitComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected CoverageEligibilityResponse.ErrorsComponent parseCoverageEligibilityResponseErrorsComponent(XmlPullParser xpp, CoverageEligibilityResponse owner) throws XmlPullParserException, IOException, FHIRFormatError {
        CoverageEligibilityResponse.ErrorsComponent res = new CoverageEligibilityResponse.ErrorsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseCoverageEligibilityResponseErrorsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseCoverageEligibilityResponseErrorsComponentContent(int eventType, XmlPullParser xpp, CoverageEligibilityResponse owner, CoverageEligibilityResponse.ErrorsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue parseDetectedIssue(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue res = new DetectedIssue();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueContent(int eventType, XmlPullParser xpp, DetectedIssue res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueStatus.NULL, new DetectedIssue.DetectedIssueStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("severity")) {
            res.setSeverityElement(this.parseEnumeration(xpp, DetectedIssue.DetectedIssueSeverity.NULL, new DetectedIssue.DetectedIssueSeverityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "identified")) {
            res.setIdentified(this.parseType("identified", xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("implicated")) {
            res.getImplicated().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evidence")) {
            res.getEvidence().add(this.parseDetectedIssueDetectedIssueEvidenceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetailElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mitigation")) {
            res.getMitigation().add(this.parseDetectedIssueDetectedIssueMitigationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue.DetectedIssueEvidenceComponent parseDetectedIssueDetectedIssueEvidenceComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueEvidenceComponent res = new DetectedIssue.DetectedIssueEvidenceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueDetectedIssueEvidenceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueDetectedIssueEvidenceComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueEvidenceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DetectedIssue.DetectedIssueMitigationComponent parseDetectedIssueDetectedIssueMitigationComponent(XmlPullParser xpp, DetectedIssue owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DetectedIssue.DetectedIssueMitigationComponent res = new DetectedIssue.DetectedIssueMitigationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDetectedIssueDetectedIssueMitigationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDetectedIssueDetectedIssueMitigationComponentContent(int eventType, XmlPullParser xpp, DetectedIssue owner, DetectedIssue.DetectedIssueMitigationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("action")) {
            res.setAction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device parseDevice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Device res = new Device();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceContent(int eventType, XmlPullParser xpp, Device res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udiCarrier")) {
            res.getUdiCarrier().add(this.parseDeviceDeviceUdiCarrierComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Device.FHIRDeviceStatus.NULL, new Device.FHIRDeviceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.getStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("distinctIdentifier")) {
            res.setDistinctIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturerElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufactureDate")) {
            res.setManufactureDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serialNumber")) {
            res.setSerialNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
            res.getDeviceName().add(this.parseDeviceDeviceDeviceNameComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("modelNumber")) {
            res.setModelNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partNumber")) {
            res.setPartNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialization")) {
            res.getSpecialization().add(this.parseDeviceDeviceSpecializationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseDeviceDeviceVersionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseDeviceDevicePropertyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("safety")) {
            res.getSafety().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceUdiCarrierComponent parseDeviceDeviceUdiCarrierComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceUdiCarrierComponent res = new Device.DeviceUdiCarrierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceUdiCarrierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceUdiCarrierComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceUdiCarrierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierAIDC")) {
            res.setCarrierAIDCElement(this.parseBase64Binary(xpp));
        } else if (eventType == 2 && xpp.getName().equals("carrierHRF")) {
            res.setCarrierHRFElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entryType")) {
            res.setEntryTypeElement(this.parseEnumeration(xpp, Device.UDIEntryType.NULL, new Device.UDIEntryTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceDeviceNameComponent parseDeviceDeviceDeviceNameComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceDeviceNameComponent res = new Device.DeviceDeviceNameComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceDeviceNameComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceDeviceNameComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Device.DeviceNameType.NULL, new Device.DeviceNameTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceSpecializationComponent parseDeviceDeviceSpecializationComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceSpecializationComponent res = new Device.DeviceSpecializationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceSpecializationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceSpecializationComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("systemType")) {
            res.setSystemType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DeviceVersionComponent parseDeviceDeviceVersionComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DeviceVersionComponent res = new Device.DeviceVersionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDeviceVersionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDeviceVersionComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DeviceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.setComponent(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Device.DevicePropertyComponent parseDeviceDevicePropertyComponent(XmlPullParser xpp, Device owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Device.DevicePropertyComponent res = new Device.DevicePropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDevicePropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDevicePropertyComponentContent(int eventType, XmlPullParser xpp, Device owner, Device.DevicePropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueQuantity")) {
            res.getValueQuantity().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
            res.getValueCode().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition parseDeviceDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition res = new DeviceDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionContent(int eventType, XmlPullParser xpp, DeviceDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udiDeviceIdentifier")) {
            res.getUdiDeviceIdentifier().add(this.parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(xpp, res));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "manufacturer")) {
            res.setManufacturer(this.parseType("manufacturer", xpp));
        } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
            res.getDeviceName().add(this.parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("modelNumber")) {
            res.setModelNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialization")) {
            res.getSpecialization().add(this.parseDeviceDefinitionDeviceDefinitionSpecializationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("safety")) {
            res.getSafety().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shelfLifeStorage")) {
            res.getShelfLifeStorage().add(this.parseProductShelfLife(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physicalCharacteristics")) {
            res.setPhysicalCharacteristics(this.parseProdCharacteristic(xpp));
        } else if (eventType == 2 && xpp.getName().equals("languageCode")) {
            res.getLanguageCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("capability")) {
            res.getCapability().add(this.parseDeviceDefinitionDeviceDefinitionCapabilityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("property")) {
            res.getProperty().add(this.parseDeviceDefinitionDeviceDefinitionPropertyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("owner")) {
            res.setOwner(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onlineInformation")) {
            res.setOnlineInformationElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parentDevice")) {
            res.setParentDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("material")) {
            res.getMaterial().add(this.parseDeviceDefinitionDeviceDefinitionMaterialComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res = new DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionUdiDeviceIdentifierComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionUdiDeviceIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("deviceIdentifier")) {
            res.setDeviceIdentifierElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuerElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdictionElement(this.parseUri(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionDeviceNameComponent parseDeviceDefinitionDeviceDefinitionDeviceNameComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionDeviceNameComponent res = new DeviceDefinition.DeviceDefinitionDeviceNameComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionDeviceNameComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionDeviceNameComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionDeviceNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, DeviceDefinition.DeviceNameType.NULL, new DeviceDefinition.DeviceNameTypeEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionSpecializationComponent parseDeviceDefinitionDeviceDefinitionSpecializationComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionSpecializationComponent res = new DeviceDefinition.DeviceDefinitionSpecializationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionSpecializationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionSpecializationComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionSpecializationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("systemType")) {
            res.setSystemTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionCapabilityComponent parseDeviceDefinitionDeviceDefinitionCapabilityComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionCapabilityComponent res = new DeviceDefinition.DeviceDefinitionCapabilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionCapabilityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionCapabilityComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionCapabilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.getDescription().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionPropertyComponent parseDeviceDefinitionDeviceDefinitionPropertyComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionPropertyComponent res = new DeviceDefinition.DeviceDefinitionPropertyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionPropertyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionPropertyComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionPropertyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueQuantity")) {
            res.getValueQuantity().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("valueCode")) {
            res.getValueCode().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceDefinition.DeviceDefinitionMaterialComponent parseDeviceDefinitionDeviceDefinitionMaterialComponent(XmlPullParser xpp, DeviceDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceDefinition.DeviceDefinitionMaterialComponent res = new DeviceDefinition.DeviceDefinitionMaterialComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceDefinitionDeviceDefinitionMaterialComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceDefinitionDeviceDefinitionMaterialComponentContent(int eventType, XmlPullParser xpp, DeviceDefinition owner, DeviceDefinition.DeviceDefinitionMaterialComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alternate")) {
            res.setAlternateElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric parseDeviceMetric(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric res = new DeviceMetric();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricContent(int eventType, XmlPullParser xpp, DeviceMetric res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.setParent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatusElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricOperationalStatus.NULL, new DeviceMetric.DeviceMetricOperationalStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("color")) {
            res.setColorElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricColor.NULL, new DeviceMetric.DeviceMetricColorEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCategory.NULL, new DeviceMetric.DeviceMetricCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("measurementPeriod")) {
            res.setMeasurementPeriod(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("calibration")) {
            res.getCalibration().add(this.parseDeviceMetricDeviceMetricCalibrationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceMetric.DeviceMetricCalibrationComponent parseDeviceMetricDeviceMetricCalibrationComponent(XmlPullParser xpp, DeviceMetric owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceMetric.DeviceMetricCalibrationComponent res = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceMetricDeviceMetricCalibrationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceMetricDeviceMetricCalibrationComponentContent(int eventType, XmlPullParser xpp, DeviceMetric owner, DeviceMetric.DeviceMetricCalibrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationType.NULL, new DeviceMetric.DeviceMetricCalibrationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("state")) {
            res.setStateElement(this.parseEnumeration(xpp, DeviceMetric.DeviceMetricCalibrationState.NULL, new DeviceMetric.DeviceMetricCalibrationStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("time")) {
            res.setTimeElement(this.parseInstant(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest parseDeviceRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest res = new DeviceRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestContent(int eventType, XmlPullParser xpp, DeviceRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priorRequest")) {
            res.getPriorRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceRequest.DeviceRequestStatus.NULL, new DeviceRequest.DeviceRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, DeviceRequest.RequestIntent.NULL, new DeviceRequest.RequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, DeviceRequest.RequestPriority.NULL, new DeviceRequest.RequestPriorityEnumFactory()));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "code")) {
            res.setCode(this.parseType("code", xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseDeviceRequestDeviceRequestParameterComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relevantHistory")) {
            res.getRelevantHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceRequest.DeviceRequestParameterComponent parseDeviceRequestDeviceRequestParameterComponent(XmlPullParser xpp, DeviceRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceRequest.DeviceRequestParameterComponent res = new DeviceRequest.DeviceRequestParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceRequestDeviceRequestParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceRequestDeviceRequestParameterComponentContent(int eventType, XmlPullParser xpp, DeviceRequest owner, DeviceRequest.DeviceRequestParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DeviceUseStatement parseDeviceUseStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DeviceUseStatement res = new DeviceUseStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDeviceUseStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDeviceUseStatementContent(int eventType, XmlPullParser xpp, DeviceUseStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DeviceUseStatement.DeviceUseStatementStatus.NULL, new DeviceUseStatement.DeviceUseStatementStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recordedOn")) {
            res.setRecordedOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport parseDiagnosticReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport res = new DiagnosticReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportContent(int eventType, XmlPullParser xpp, DiagnosticReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, DiagnosticReport.DiagnosticReportStatus.NULL, new DiagnosticReport.DiagnosticReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resultsInterpreter")) {
            res.getResultsInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.getResult().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("imagingStudy")) {
            res.getImagingStudy().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("media")) {
            res.getMedia().add(this.parseDiagnosticReportDiagnosticReportMediaComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("conclusion")) {
            res.setConclusionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("conclusionCode")) {
            res.getConclusionCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("presentedForm")) {
            res.getPresentedForm().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DiagnosticReport.DiagnosticReportMediaComponent parseDiagnosticReportDiagnosticReportMediaComponent(XmlPullParser xpp, DiagnosticReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DiagnosticReport.DiagnosticReportMediaComponent res = new DiagnosticReport.DiagnosticReportMediaComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDiagnosticReportDiagnosticReportMediaComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDiagnosticReportDiagnosticReportMediaComponentContent(int eventType, XmlPullParser xpp, DiagnosticReport owner, DiagnosticReport.DiagnosticReportMediaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.setLink(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest parseDocumentManifest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest res = new DocumentManifest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestContent(int eventType, XmlPullParser xpp, DocumentManifest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.getRecipient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseDocumentManifestDocumentManifestRelatedComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentManifest.DocumentManifestRelatedComponent parseDocumentManifestDocumentManifestRelatedComponent(XmlPullParser xpp, DocumentManifest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentManifest.DocumentManifestRelatedComponent res = new DocumentManifest.DocumentManifestRelatedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentManifestDocumentManifestRelatedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentManifestDocumentManifestRelatedComponentContent(int eventType, XmlPullParser xpp, DocumentManifest owner, DocumentManifest.DocumentManifestRelatedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ref")) {
            res.setRef(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference parseDocumentReference(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference res = new DocumentReference();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceContent(int eventType, XmlPullParser xpp, DocumentReference res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("masterIdentifier")) {
            res.setMasterIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.DocumentReferenceStatus.NULL, new Enumerations.DocumentReferenceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("docStatus")) {
            res.setDocStatusElement(this.parseEnumeration(xpp, DocumentReference.ReferredDocumentStatus.NULL, new DocumentReference.ReferredDocumentStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authenticator")) {
            res.setAuthenticator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("custodian")) {
            res.setCustodian(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatesTo")) {
            res.getRelatesTo().add(this.parseDocumentReferenceDocumentReferenceRelatesToComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("securityLabel")) {
            res.getSecurityLabel().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseDocumentReferenceDocumentReferenceContentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseDocumentReferenceDocumentReferenceContextComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceRelatesToComponent parseDocumentReferenceDocumentReferenceRelatesToComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceRelatesToComponent res = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceRelatesToComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceRelatesToComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceRelatesToComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, DocumentReference.DocumentRelationshipType.NULL, new DocumentReference.DocumentRelationshipTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContentComponent parseDocumentReferenceDocumentReferenceContentComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContentComponent res = new DocumentReference.DocumentReferenceContentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceContentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceContentComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("attachment")) {
            res.setAttachment(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("format")) {
            res.setFormat(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected DocumentReference.DocumentReferenceContextComponent parseDocumentReferenceDocumentReferenceContextComponent(XmlPullParser xpp, DocumentReference owner) throws XmlPullParserException, IOException, FHIRFormatError {
        DocumentReference.DocumentReferenceContextComponent res = new DocumentReference.DocumentReferenceContextComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseDocumentReferenceDocumentReferenceContextComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseDocumentReferenceDocumentReferenceContextComponentContent(int eventType, XmlPullParser xpp, DocumentReference owner, DocumentReference.DocumentReferenceContextComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("event")) {
            res.getEvent().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facilityType")) {
            res.setFacilityType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("practiceSetting")) {
            res.setPracticeSetting(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sourcePatientInfo")) {
            res.setSourcePatientInfo(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis parseEffectEvidenceSynthesis(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis res = new EffectEvidenceSynthesis();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("synthesisType")) {
            res.setSynthesisType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("studyType")) {
            res.setStudyType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.setPopulation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exposure")) {
            res.setExposure(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exposureAlternative")) {
            res.setExposureAlternative(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sampleSize")) {
            res.setSampleSize(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("resultsByExposure")) {
            res.getResultsByExposure().add(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("effectEstimate")) {
            res.getEffectEstimate().add(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("certainty")) {
            res.getCertainty().add(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisSampleSizeComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisSampleSizeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfStudies")) {
            res.setNumberOfStudiesElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfParticipants")) {
            res.setNumberOfParticipantsElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisResultsByExposureComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisResultsByExposureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exposureState")) {
            res.setExposureStateElement(this.parseEnumeration(xpp, EffectEvidenceSynthesis.ExposureState.NULL, new EffectEvidenceSynthesis.ExposureStateEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("variantState")) {
            res.setVariantState(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("riskEvidenceSynthesis")) {
            res.setRiskEvidenceSynthesis(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimateComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variantState")) {
            res.setVariantState(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitOfMeasure")) {
            res.setUnitOfMeasure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precisionEstimate")) {
            res.getPrecisionEstimate().add(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisEffectEstimatePrecisionEstimateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("level")) {
            res.setLevelElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("from")) {
            res.setFromElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("to")) {
            res.setToElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("rating")) {
            res.getRating().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("certaintySubcomponent")) {
            res.getCertaintySubcomponent().add(this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent(XmlPullParser xpp, EffectEvidenceSynthesis owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent res = new EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEffectEvidenceSynthesisEffectEvidenceSynthesisCertaintyCertaintySubcomponentComponentContent(int eventType, XmlPullParser xpp, EffectEvidenceSynthesis owner, EffectEvidenceSynthesis.EffectEvidenceSynthesisCertaintyCertaintySubcomponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rating")) {
            res.getRating().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter parseEncounter(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter res = new Encounter();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterContent(int eventType, XmlPullParser xpp, Encounter res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEncounterStatusHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classHistory")) {
            res.getClassHistory().add(this.parseEncounterClassHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceType")) {
            res.setServiceType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("episodeOfCare")) {
            res.getEpisodeOfCare().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseEncounterEncounterParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("appointment")) {
            res.getAppointment().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("length")) {
            res.setLength(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEncounterDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hospitalization")) {
            res.setHospitalization(this.parseEncounterEncounterHospitalizationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseEncounterEncounterLocationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvider")) {
            res.setServiceProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.StatusHistoryComponent parseEncounterStatusHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.StatusHistoryComponent res = new Encounter.StatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterStatusHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterStatusHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.StatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterStatus.NULL, new Encounter.EncounterStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.ClassHistoryComponent parseEncounterClassHistoryComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.ClassHistoryComponent res = new Encounter.ClassHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterClassHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterClassHistoryComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.ClassHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("class")) {
            res.setClass_(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterParticipantComponent parseEncounterEncounterParticipantComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterParticipantComponent res = new Encounter.EncounterParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterParticipantComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("individual")) {
            res.setIndividual(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.DiagnosisComponent parseEncounterDiagnosisComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.DiagnosisComponent res = new Encounter.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterDiagnosisComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUse(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterHospitalizationComponent parseEncounterEncounterHospitalizationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterHospitalizationComponent res = new Encounter.EncounterHospitalizationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterHospitalizationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterHospitalizationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterHospitalizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("preAdmissionIdentifier")) {
            res.setPreAdmissionIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("origin")) {
            res.setOrigin(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("admitSource")) {
            res.setAdmitSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reAdmission")) {
            res.setReAdmission(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dietPreference")) {
            res.getDietPreference().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialCourtesy")) {
            res.getSpecialCourtesy().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialArrangement")) {
            res.getSpecialArrangement().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dischargeDisposition")) {
            res.setDischargeDisposition(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Encounter.EncounterLocationComponent parseEncounterEncounterLocationComponent(XmlPullParser xpp, Encounter owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Encounter.EncounterLocationComponent res = new Encounter.EncounterLocationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEncounterEncounterLocationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEncounterEncounterLocationComponentContent(int eventType, XmlPullParser xpp, Encounter owner, Encounter.EncounterLocationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Encounter.EncounterLocationStatus.NULL, new Encounter.EncounterLocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Endpoint parseEndpoint(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Endpoint res = new Endpoint();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEndpointContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEndpointContent(int eventType, XmlPullParser xpp, Endpoint res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Endpoint.EndpointStatus.NULL, new Endpoint.EndpointStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("connectionType")) {
            res.setConnectionType(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadType")) {
            res.getPayloadType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payloadMimeType")) {
            res.getPayloadMimeType().add(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddressElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("header")) {
            res.getHeader().add(this.parseString(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentRequest parseEnrollmentRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentRequest res = new EnrollmentRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentRequestContent(int eventType, XmlPullParser xpp, EnrollmentRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EnrollmentRequest.EnrollmentRequestStatus.NULL, new EnrollmentRequest.EnrollmentRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("candidate")) {
            res.setCandidate(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EnrollmentResponse parseEnrollmentResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EnrollmentResponse res = new EnrollmentResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEnrollmentResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEnrollmentResponseContent(int eventType, XmlPullParser xpp, EnrollmentResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EnrollmentResponse.EnrollmentResponseStatus.NULL, new EnrollmentResponse.EnrollmentResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, Enumerations.RemittanceOutcome.NULL, new Enumerations.RemittanceOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("organization")) {
            res.setOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requestProvider")) {
            res.setRequestProvider(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare parseEpisodeOfCare(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare res = new EpisodeOfCare();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareContent(int eventType, XmlPullParser xpp, EpisodeOfCare res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusHistory")) {
            res.getStatusHistory().add(this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseEpisodeOfCareDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralRequest")) {
            res.getReferralRequest().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careManager")) {
            res.setCareManager(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("team")) {
            res.getTeam().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.getAccount().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.EpisodeOfCareStatusHistoryComponent parseEpisodeOfCareEpisodeOfCareStatusHistoryComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareEpisodeOfCareStatusHistoryComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.EpisodeOfCareStatusHistoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, EpisodeOfCare.EpisodeOfCareStatus.NULL, new EpisodeOfCare.EpisodeOfCareStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EpisodeOfCare.DiagnosisComponent parseEpisodeOfCareDiagnosisComponent(XmlPullParser xpp, EpisodeOfCare owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EpisodeOfCare.DiagnosisComponent res = new EpisodeOfCare.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEpisodeOfCareDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEpisodeOfCareDiagnosisComponentContent(int eventType, XmlPullParser xpp, EpisodeOfCare owner, EpisodeOfCare.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("condition")) {
            res.setCondition(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rank")) {
            res.setRankElement(this.parsePositiveInt(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EventDefinition parseEventDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EventDefinition res = new EventDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEventDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEventDefinitionContent(int eventType, XmlPullParser xpp, EventDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("trigger")) {
            res.getTrigger().add(this.parseTriggerDefinition(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Evidence parseEvidence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Evidence res = new Evidence();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceContent(int eventType, XmlPullParser xpp, Evidence res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shortTitle")) {
            res.setShortTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exposureBackground")) {
            res.setExposureBackground(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exposureVariant")) {
            res.getExposureVariant().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.getOutcome().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable parseEvidenceVariable(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable res = new EvidenceVariable();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableContent(int eventType, XmlPullParser xpp, EvidenceVariable res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shortTitle")) {
            res.setShortTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, EvidenceVariable.EvidenceVariableType.NULL, new EvidenceVariable.EvidenceVariableTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseEvidenceVariableEvidenceVariableCharacteristicComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected EvidenceVariable.EvidenceVariableCharacteristicComponent parseEvidenceVariableEvidenceVariableCharacteristicComponent(XmlPullParser xpp, EvidenceVariable owner) throws XmlPullParserException, IOException, FHIRFormatError {
        EvidenceVariable.EvidenceVariableCharacteristicComponent res = new EvidenceVariable.EvidenceVariableCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseEvidenceVariableEvidenceVariableCharacteristicComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseEvidenceVariableEvidenceVariableCharacteristicComponentContent(int eventType, XmlPullParser xpp, EvidenceVariable owner, EvidenceVariable.EvidenceVariableCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "definition")) {
            res.setDefinition(this.parseType("definition", xpp));
        } else if (eventType == 2 && xpp.getName().equals("usageContext")) {
            res.getUsageContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "participantEffective")) {
            res.setParticipantEffective(this.parseType("participantEffective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("timeFromStart")) {
            res.setTimeFromStart(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupMeasure")) {
            res.setGroupMeasureElement(this.parseEnumeration(xpp, EvidenceVariable.GroupMeasure.NULL, new EvidenceVariable.GroupMeasureEnumFactory()));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario parseExampleScenario(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario res = new ExampleScenario();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioContent(int eventType, XmlPullParser xpp, ExampleScenario res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.getActor().add(this.parseExampleScenarioExampleScenarioActorComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseExampleScenarioExampleScenarioInstanceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("process")) {
            res.getProcess().add(this.parseExampleScenarioExampleScenarioProcessComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("workflow")) {
            res.getWorkflow().add(this.parseCanonical(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioActorComponent parseExampleScenarioExampleScenarioActorComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioActorComponent res = new ExampleScenario.ExampleScenarioActorComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioActorComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioActorComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioActorComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("actorId")) {
            res.setActorIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, ExampleScenario.ExampleScenarioActorType.NULL, new ExampleScenario.ExampleScenarioActorTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceComponent parseExampleScenarioExampleScenarioInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("resourceId")) {
            res.setResourceIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resourceType")) {
            res.setResourceTypeElement(this.parseEnumeration(xpp, ExampleScenario.FHIRResourceType.NULL, new ExampleScenario.FHIRResourceTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.getVersion().add(this.parseExampleScenarioExampleScenarioInstanceVersionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("containedInstance")) {
            res.getContainedInstance().add(this.parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceVersionComponent parseExampleScenarioExampleScenarioInstanceVersionComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceVersionComponent res = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioInstanceVersionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioInstanceVersionComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceVersionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("versionId")) {
            res.setVersionIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioInstanceContainedInstanceComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("resourceId")) {
            res.setResourceIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("versionId")) {
            res.setVersionIdElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessComponent parseExampleScenarioExampleScenarioProcessComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessComponent res = new ExampleScenario.ExampleScenarioProcessComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioProcessComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioProcessComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preConditions")) {
            res.setPreConditionsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("postConditions")) {
            res.setPostConditionsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("step")) {
            res.getStep().add(this.parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepComponent parseExampleScenarioExampleScenarioProcessStepComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepComponent res = new ExampleScenario.ExampleScenarioProcessStepComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioProcessStepComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioProcessStepComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("process")) {
            res.getProcess().add(this.parseExampleScenarioExampleScenarioProcessComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("pause")) {
            res.setPauseElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operation")) {
            res.setOperation(this.parseExampleScenarioExampleScenarioProcessStepOperationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("alternative")) {
            res.getAlternative().add(this.parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepOperationComponent parseExampleScenarioExampleScenarioProcessStepOperationComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepOperationComponent res = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioProcessStepOperationComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("initiator")) {
            res.setInitiatorElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.setReceiverElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("initiatorActive")) {
            res.setInitiatorActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiverActive")) {
            res.setReceiverActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseExampleScenarioExampleScenarioInstanceContainedInstanceComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExampleScenario.ExampleScenarioProcessStepAlternativeComponent parseExampleScenarioExampleScenarioProcessStepAlternativeComponent(XmlPullParser xpp, ExampleScenario owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExampleScenarioExampleScenarioProcessStepAlternativeComponentContent(int eventType, XmlPullParser xpp, ExampleScenario owner, ExampleScenario.ExampleScenarioProcessStepAlternativeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("step")) {
            res.getStep().add(this.parseExampleScenarioExampleScenarioProcessStepComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit parseExplanationOfBenefit(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit res = new ExplanationOfBenefit();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL, new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subType")) {
            res.setSubType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, ExplanationOfBenefit.Use.NULL, new ExplanationOfBenefit.UseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("billablePeriod")) {
            res.setBillablePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("created")) {
            res.setCreatedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurer")) {
            res.setInsurer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserveRequested")) {
            res.setFundsReserveRequested(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundsReserve")) {
            res.setFundsReserve(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("related")) {
            res.getRelated().add(this.parseExplanationOfBenefitRelatedClaimComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("prescription")) {
            res.setPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("originalPrescription")) {
            res.setOriginalPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("payee")) {
            res.setPayee(this.parseExplanationOfBenefitPayeeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("referral")) {
            res.setReferral(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("facility")) {
            res.setFacility(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("claimResponse")) {
            res.setClaimResponse(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcomeElement(this.parseEnumeration(xpp, ExplanationOfBenefit.RemittanceOutcome.NULL, new ExplanationOfBenefit.RemittanceOutcomeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("disposition")) {
            res.setDispositionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRefPeriod")) {
            res.getPreAuthRefPeriod().add(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeam")) {
            res.getCareTeam().add(this.parseExplanationOfBenefitCareTeamComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supportingInfo")) {
            res.getSupportingInfo().add(this.parseExplanationOfBenefitSupportingInformationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("diagnosis")) {
            res.getDiagnosis().add(this.parseExplanationOfBenefitDiagnosisComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.getProcedure().add(this.parseExplanationOfBenefitProcedureComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("precedence")) {
            res.setPrecedenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseExplanationOfBenefitInsuranceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("accident")) {
            res.setAccident(this.parseExplanationOfBenefitAccidentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseExplanationOfBenefitItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("addItem")) {
            res.getAddItem().add(this.parseExplanationOfBenefitAddedItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("total")) {
            res.getTotal().add(this.parseExplanationOfBenefitTotalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("payment")) {
            res.setPayment(this.parseExplanationOfBenefitPaymentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("formCode")) {
            res.setFormCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("processNote")) {
            res.getProcessNote().add(this.parseExplanationOfBenefitNoteComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("benefitPeriod")) {
            res.setBenefitPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefitBalance")) {
            res.getBenefitBalance().add(this.parseExplanationOfBenefitBenefitBalanceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.RelatedClaimComponent parseExplanationOfBenefitRelatedClaimComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.RelatedClaimComponent res = new ExplanationOfBenefit.RelatedClaimComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitRelatedClaimComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitRelatedClaimComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.RelatedClaimComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("claim")) {
            res.setClaim(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PayeeComponent parseExplanationOfBenefitPayeeComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PayeeComponent res = new ExplanationOfBenefit.PayeeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPayeeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPayeeComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PayeeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("party")) {
            res.setParty(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.CareTeamComponent parseExplanationOfBenefitCareTeamComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.CareTeamComponent res = new ExplanationOfBenefit.CareTeamComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitCareTeamComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitCareTeamComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.CareTeamComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.setProvider(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualification")) {
            res.setQualification(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SupportingInformationComponent parseExplanationOfBenefitSupportingInformationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SupportingInformationComponent res = new ExplanationOfBenefit.SupportingInformationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSupportingInformationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSupportingInformationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SupportingInformationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "timing")) {
            res.setTiming(this.parseType("timing", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DiagnosisComponent parseExplanationOfBenefitDiagnosisComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DiagnosisComponent res = new ExplanationOfBenefit.DiagnosisComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDiagnosisComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDiagnosisComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DiagnosisComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "diagnosis")) {
            res.setDiagnosis(this.parseType("diagnosis", xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("onAdmission")) {
            res.setOnAdmission(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageCode")) {
            res.setPackageCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ProcedureComponent parseExplanationOfBenefitProcedureComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ProcedureComponent res = new ExplanationOfBenefit.ProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitProcedureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitProcedureComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "procedure")) {
            res.setProcedure(this.parseType("procedure", xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.InsuranceComponent parseExplanationOfBenefitInsuranceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.InsuranceComponent res = new ExplanationOfBenefit.InsuranceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitInsuranceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitInsuranceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.InsuranceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("focal")) {
            res.setFocalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.setCoverage(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preAuthRef")) {
            res.getPreAuthRef().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AccidentComponent parseExplanationOfBenefitAccidentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AccidentComponent res = new ExplanationOfBenefit.AccidentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAccidentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAccidentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AccidentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.ItemComponent parseExplanationOfBenefitItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.ItemComponent res = new ExplanationOfBenefit.ItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.ItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("careTeamSequence")) {
            res.getCareTeamSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diagnosisSequence")) {
            res.getDiagnosisSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureSequence")) {
            res.getProcedureSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSequence")) {
            res.getInformationSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.getEncounter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AdjudicationComponent parseExplanationOfBenefitAdjudicationComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AdjudicationComponent res = new ExplanationOfBenefit.AdjudicationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAdjudicationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAdjudicationComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AdjudicationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.DetailComponent parseExplanationOfBenefitDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.DetailComponent res = new ExplanationOfBenefit.DetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.DetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseExplanationOfBenefitSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.SubDetailComponent parseExplanationOfBenefitSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.SubDetailComponent res = new ExplanationOfBenefit.SubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.SubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("revenue")) {
            res.setRevenue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("udi")) {
            res.getUdi().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemComponent parseExplanationOfBenefitAddedItemComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemComponent res = new ExplanationOfBenefit.AddedItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("itemSequence")) {
            res.getItemSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detailSequence")) {
            res.getDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subDetailSequence")) {
            res.getSubDetailSequence().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("provider")) {
            res.getProvider().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("programCode")) {
            res.getProgramCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "serviced")) {
            res.setServiced(this.parseType("serviced", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "location")) {
            res.setLocation(this.parseType("location", xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subSite")) {
            res.getSubSite().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.getDetail().add(this.parseExplanationOfBenefitAddedItemDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemDetailComponent parseExplanationOfBenefitAddedItemDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailComponent res = new ExplanationOfBenefit.AddedItemDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("subDetail")) {
            res.getSubDetail().add(this.parseExplanationOfBenefitAddedItemDetailSubDetailComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.AddedItemDetailSubDetailComponent parseExplanationOfBenefitAddedItemDetailSubDetailComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent res = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitAddedItemDetailSubDetailComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.AddedItemDetailSubDetailComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productOrService")) {
            res.setProductOrService(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.getModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitPrice")) {
            res.setUnitPrice(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("net")) {
            res.setNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("noteNumber")) {
            res.getNoteNumber().add(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjudication")) {
            res.getAdjudication().add(this.parseExplanationOfBenefitAdjudicationComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.TotalComponent parseExplanationOfBenefitTotalComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.TotalComponent res = new ExplanationOfBenefit.TotalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitTotalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitTotalComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.TotalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.PaymentComponent parseExplanationOfBenefitPaymentComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.PaymentComponent res = new ExplanationOfBenefit.PaymentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitPaymentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitPaymentComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.PaymentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustment")) {
            res.setAdjustment(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("adjustmentReason")) {
            res.setAdjustmentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.NoteComponent parseExplanationOfBenefitNoteComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.NoteComponent res = new ExplanationOfBenefit.NoteComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitNoteComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitNoteComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.NoteComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Enumerations.NoteType.NULL, new Enumerations.NoteTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitBalanceComponent parseExplanationOfBenefitBenefitBalanceComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitBalanceComponent res = new ExplanationOfBenefit.BenefitBalanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitBalanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitBalanceComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitBalanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excluded")) {
            res.setExcludedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.setNetwork(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unit")) {
            res.setUnit(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("term")) {
            res.setTerm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("financial")) {
            res.getFinancial().add(this.parseExplanationOfBenefitBenefitComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ExplanationOfBenefit.BenefitComponent parseExplanationOfBenefitBenefitComponent(XmlPullParser xpp, ExplanationOfBenefit owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ExplanationOfBenefit.BenefitComponent res = new ExplanationOfBenefit.BenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseExplanationOfBenefitBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseExplanationOfBenefitBenefitComponentContent(int eventType, XmlPullParser xpp, ExplanationOfBenefit owner, ExplanationOfBenefit.BenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "used")) {
            res.setUsed(this.parseType("used", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory parseFamilyMemberHistory(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory res = new FamilyMemberHistory();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryContent(int eventType, XmlPullParser xpp, FamilyMemberHistory res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, FamilyMemberHistory.FamilyHistoryStatus.NULL, new FamilyMemberHistory.FamilyHistoryStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dataAbsentReason")) {
            res.setDataAbsentReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relationship")) {
            res.setRelationship(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sex")) {
            res.setSex(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "born")) {
            res.setBorn(this.parseType("born", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "age")) {
            res.setAge(this.parseType("age", xpp));
        } else if (eventType == 2 && xpp.getName().equals("estimatedAge")) {
            res.setEstimatedAgeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "deceased")) {
            res.setDeceased(this.parseType("deceased", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("condition")) {
            res.getCondition().add(this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected FamilyMemberHistory.FamilyMemberHistoryConditionComponent parseFamilyMemberHistoryFamilyMemberHistoryConditionComponent(XmlPullParser xpp, FamilyMemberHistory owner) throws XmlPullParserException, IOException, FHIRFormatError {
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent res = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFamilyMemberHistoryFamilyMemberHistoryConditionComponentContent(int eventType, XmlPullParser xpp, FamilyMemberHistory owner, FamilyMemberHistory.FamilyMemberHistoryConditionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcome")) {
            res.setOutcome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contributedToDeath")) {
            res.setContributedToDeathElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "onset")) {
            res.setOnset(this.parseType("onset", xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Flag parseFlag(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Flag res = new Flag();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseFlagContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseFlagContent(int eventType, XmlPullParser xpp, Flag res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Flag.FlagStatus.NULL, new Flag.FlagStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal parseGoal(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal res = new Goal();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalContent(int eventType, XmlPullParser xpp, Goal res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lifecycleStatus")) {
            res.setLifecycleStatusElement(this.parseEnumeration(xpp, Goal.GoalLifecycleStatus.NULL, new Goal.GoalLifecycleStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("achievementStatus")) {
            res.setAchievementStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriority(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescription(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "start")) {
            res.setStart(this.parseType("start", xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseGoalGoalTargetComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.setStatusDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expressedBy")) {
            res.setExpressedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("addresses")) {
            res.getAddresses().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeCode")) {
            res.getOutcomeCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outcomeReference")) {
            res.getOutcomeReference().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Goal.GoalTargetComponent parseGoalGoalTargetComponent(XmlPullParser xpp, Goal owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Goal.GoalTargetComponent res = new Goal.GoalTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGoalGoalTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGoalGoalTargetComponentContent(int eventType, XmlPullParser xpp, Goal owner, Goal.GoalTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "detail")) {
            res.setDetail(this.parseType("detail", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "due")) {
            res.setDue(this.parseType("due", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition parseGraphDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition res = new GraphDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionContent(int eventType, XmlPullParser xpp, GraphDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkComponent parseGraphDefinitionGraphDefinitionLinkComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkComponent res = new GraphDefinition.GraphDefinitionLinkComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("path")) {
            res.setPathElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sliceName")) {
            res.setSliceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.getTarget().add(this.parseGraphDefinitionGraphDefinitionLinkTargetComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkTargetComponent parseGraphDefinitionGraphDefinitionLinkTargetComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetComponent res = new GraphDefinition.GraphDefinitionLinkTargetComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkTargetComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("params")) {
            res.setParamsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compartment")) {
            res.getCompartment().add(this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("link")) {
            res.getLink().add(this.parseGraphDefinitionGraphDefinitionLinkComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponent(XmlPullParser xpp, GraphDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res = new GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGraphDefinitionGraphDefinitionLinkTargetCompartmentComponentContent(int eventType, XmlPullParser xpp, GraphDefinition owner, GraphDefinition.GraphDefinitionLinkTargetCompartmentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("use")) {
            res.setUseElement(this.parseEnumeration(xpp, GraphDefinition.GraphCompartmentUse.NULL, new GraphDefinition.GraphCompartmentUseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, GraphDefinition.CompartmentCode.NULL, new GraphDefinition.CompartmentCodeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("rule")) {
            res.setRuleElement(this.parseEnumeration(xpp, GraphDefinition.GraphCompartmentRule.NULL, new GraphDefinition.GraphCompartmentRuleEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("expression")) {
            res.setExpressionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group parseGroup(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Group res = new Group();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupContent(int eventType, XmlPullParser xpp, Group res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Group.GroupType.NULL, new Group.GroupTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("actual")) {
            res.setActualElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantityElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("managingEntity")) {
            res.setManagingEntity(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseGroupGroupCharacteristicComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("member")) {
            res.getMember().add(this.parseGroupGroupMemberComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupCharacteristicComponent parseGroupGroupCharacteristicComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupCharacteristicComponent res = new Group.GroupCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupGroupCharacteristicComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupGroupCharacteristicComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (eventType == 2 && xpp.getName().equals("exclude")) {
            res.setExcludeElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Group.GroupMemberComponent parseGroupGroupMemberComponent(XmlPullParser xpp, Group owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Group.GroupMemberComponent res = new Group.GroupMemberComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGroupGroupMemberComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGroupGroupMemberComponentContent(int eventType, XmlPullParser xpp, Group owner, Group.GroupMemberComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("entity")) {
            res.setEntity(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("inactive")) {
            res.setInactiveElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected GuidanceResponse parseGuidanceResponse(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        GuidanceResponse res = new GuidanceResponse();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseGuidanceResponseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseGuidanceResponseContent(int eventType, XmlPullParser xpp, GuidanceResponse res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("requestIdentifier")) {
            res.setRequestIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "module")) {
            res.setModule(this.parseType("module", xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, GuidanceResponse.GuidanceResponseStatus.NULL, new GuidanceResponse.GuidanceResponseStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("occurrenceDateTime")) {
            res.setOccurrenceDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("evaluationMessage")) {
            res.getEvaluationMessage().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outputParameters")) {
            res.setOutputParameters(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("result")) {
            res.setResult(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService parseHealthcareService(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService res = new HealthcareService();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceContent(int eventType, XmlPullParser xpp, HealthcareService res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("providedBy")) {
            res.setProvidedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialty")) {
            res.getSpecialty().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.getLocation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("extraDetails")) {
            res.setExtraDetailsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("photo")) {
            res.setPhoto(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("serviceProvisionCode")) {
            res.getServiceProvisionCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eligibility")) {
            res.getEligibility().add(this.parseHealthcareServiceHealthcareServiceEligibilityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("program")) {
            res.getProgram().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristic")) {
            res.getCharacteristic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("communication")) {
            res.getCommunication().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referralMethod")) {
            res.getReferralMethod().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("appointmentRequired")) {
            res.setAppointmentRequiredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableTime")) {
            res.getAvailableTime().add(this.parseHealthcareServiceHealthcareServiceAvailableTimeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("notAvailable")) {
            res.getNotAvailable().add(this.parseHealthcareServiceHealthcareServiceNotAvailableComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceEligibilityComponent parseHealthcareServiceHealthcareServiceEligibilityComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceEligibilityComponent res = new HealthcareService.HealthcareServiceEligibilityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceHealthcareServiceEligibilityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceHealthcareServiceEligibilityComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceEligibilityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceAvailableTimeComponent parseHealthcareServiceHealthcareServiceAvailableTimeComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceAvailableTimeComponent res = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceHealthcareServiceAvailableTimeComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceAvailableTimeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
            res.getDaysOfWeek().add(this.parseEnumeration(xpp, HealthcareService.DaysOfWeek.NULL, new HealthcareService.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allDay")) {
            res.setAllDayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableStartTime")) {
            res.setAvailableStartTimeElement(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("availableEndTime")) {
            res.setAvailableEndTimeElement(this.parseTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected HealthcareService.HealthcareServiceNotAvailableComponent parseHealthcareServiceHealthcareServiceNotAvailableComponent(XmlPullParser xpp, HealthcareService owner) throws XmlPullParserException, IOException, FHIRFormatError {
        HealthcareService.HealthcareServiceNotAvailableComponent res = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseHealthcareServiceHealthcareServiceNotAvailableComponentContent(int eventType, XmlPullParser xpp, HealthcareService owner, HealthcareService.HealthcareServiceNotAvailableComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("during")) {
            res.setDuring(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy parseImagingStudy(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy res = new ImagingStudy();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyContent(int eventType, XmlPullParser xpp, ImagingStudy res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ImagingStudy.ImagingStudyStatus.NULL, new ImagingStudy.ImagingStudyStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.getModality().add(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referrer")) {
            res.setReferrer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interpreter")) {
            res.getInterpreter().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfSeries")) {
            res.setNumberOfSeriesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureReference")) {
            res.setProcedureReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedureCode")) {
            res.getProcedureCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.getSeries().add(this.parseImagingStudyImagingStudySeriesComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesComponent parseImagingStudyImagingStudySeriesComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesComponent res = new ImagingStudy.ImagingStudySeriesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyImagingStudySeriesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyImagingStudySeriesComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.setModality(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfInstances")) {
            res.setNumberOfInstancesElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("laterality")) {
            res.setLaterality(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.getSpecimen().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("started")) {
            res.setStartedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseImagingStudyImagingStudySeriesPerformerComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("instance")) {
            res.getInstance().add(this.parseImagingStudyImagingStudySeriesInstanceComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesPerformerComponent parseImagingStudyImagingStudySeriesPerformerComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesPerformerComponent res = new ImagingStudy.ImagingStudySeriesPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyImagingStudySeriesPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyImagingStudySeriesPerformerComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImagingStudy.ImagingStudySeriesInstanceComponent parseImagingStudyImagingStudySeriesInstanceComponent(XmlPullParser xpp, ImagingStudy owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImagingStudy.ImagingStudySeriesInstanceComponent res = new ImagingStudy.ImagingStudySeriesInstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImagingStudyImagingStudySeriesInstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImagingStudyImagingStudySeriesInstanceComponentContent(int eventType, XmlPullParser xpp, ImagingStudy owner, ImagingStudy.ImagingStudySeriesInstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uid")) {
            res.setUidElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sopClass")) {
            res.setSopClass(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("number")) {
            res.setNumberElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization parseImmunization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization res = new Immunization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationContent(int eventType, XmlPullParser xpp, Immunization res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Immunization.ImmunizationStatus.NULL, new Immunization.ImmunizationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.setVaccineCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "occurrence")) {
            res.setOccurrence(this.parseType("occurrence", xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorded")) {
            res.setRecordedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("primarySource")) {
            res.setPrimarySourceElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reportOrigin")) {
            res.setReportOrigin(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseQuantity")) {
            res.setDoseQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseImmunizationImmunizationPerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("isSubpotent")) {
            res.setIsSubpotentElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subpotentReason")) {
            res.getSubpotentReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("education")) {
            res.getEducation().add(this.parseImmunizationImmunizationEducationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("programEligibility")) {
            res.getProgramEligibility().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fundingSource")) {
            res.setFundingSource(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reaction")) {
            res.getReaction().add(this.parseImmunizationImmunizationReactionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("protocolApplied")) {
            res.getProtocolApplied().add(this.parseImmunizationImmunizationProtocolAppliedComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationPerformerComponent parseImmunizationImmunizationPerformerComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationPerformerComponent res = new Immunization.ImmunizationPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationPerformerComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationEducationComponent parseImmunizationImmunizationEducationComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationEducationComponent res = new Immunization.ImmunizationEducationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationEducationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationEducationComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationEducationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("documentType")) {
            res.setDocumentTypeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReferenceElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publicationDate")) {
            res.setPublicationDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("presentationDate")) {
            res.setPresentationDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationReactionComponent parseImmunizationImmunizationReactionComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationReactionComponent res = new Immunization.ImmunizationReactionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationReactionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationReactionComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationReactionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detail")) {
            res.setDetail(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reported")) {
            res.setReportedElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Immunization.ImmunizationProtocolAppliedComponent parseImmunizationImmunizationProtocolAppliedComponent(XmlPullParser xpp, Immunization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Immunization.ImmunizationProtocolAppliedComponent res = new Immunization.ImmunizationProtocolAppliedComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationImmunizationProtocolAppliedComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationImmunizationProtocolAppliedComponentContent(int eventType, XmlPullParser xpp, Immunization owner, Immunization.ImmunizationProtocolAppliedComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.getTargetDisease().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "doseNumber")) {
            res.setDoseNumber(this.parseType("doseNumber", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "seriesDoses")) {
            res.setSeriesDoses(this.parseType("seriesDoses", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationEvaluation parseImmunizationEvaluation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationEvaluation res = new ImmunizationEvaluation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationEvaluationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationEvaluationContent(int eventType, XmlPullParser xpp, ImmunizationEvaluation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ImmunizationEvaluation.ImmunizationEvaluationStatus.NULL, new ImmunizationEvaluation.ImmunizationEvaluationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("immunizationEvent")) {
            res.setImmunizationEvent(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatus")) {
            res.setDoseStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseStatusReason")) {
            res.getDoseStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "doseNumber")) {
            res.setDoseNumber(this.parseType("doseNumber", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "seriesDoses")) {
            res.setSeriesDoses(this.parseType("seriesDoses", xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation parseImmunizationRecommendation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation res = new ImmunizationRecommendation();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authority")) {
            res.setAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recommendation")) {
            res.getRecommendation().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("vaccineCode")) {
            res.getVaccineCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetDisease")) {
            res.setTargetDisease(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contraindicatedVaccineCode")) {
            res.getContraindicatedVaccineCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forecastStatus")) {
            res.setForecastStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("forecastReason")) {
            res.getForecastReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateCriterion")) {
            res.getDateCriterion().add(this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("series")) {
            res.setSeriesElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "doseNumber")) {
            res.setDoseNumber(this.parseType("doseNumber", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "seriesDoses")) {
            res.setSeriesDoses(this.parseType("seriesDoses", xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingImmunization")) {
            res.getSupportingImmunization().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingPatientInformation")) {
            res.getSupportingPatientInformation().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponent(XmlPullParser xpp, ImmunizationRecommendation owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res = new ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImmunizationRecommendationImmunizationRecommendationRecommendationDateCriterionComponentContent(int eventType, XmlPullParser xpp, ImmunizationRecommendation owner, ImmunizationRecommendation.ImmunizationRecommendationRecommendationDateCriterionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide parseImplementationGuide(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide res = new ImplementationGuide();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideContent(int eventType, XmlPullParser xpp, ImplementationGuide res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageId")) {
            res.setPackageIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("license")) {
            res.setLicenseElement(this.parseEnumeration(xpp, ImplementationGuide.SPDXLicense.NULL, new ImplementationGuide.SPDXLicenseEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.getFhirVersion().add(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("dependsOn")) {
            res.getDependsOn().add(this.parseImplementationGuideImplementationGuideDependsOnComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("global")) {
            res.getGlobal().add(this.parseImplementationGuideImplementationGuideGlobalComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinition(this.parseImplementationGuideImplementationGuideDefinitionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("manifest")) {
            res.setManifest(this.parseImplementationGuideImplementationGuideManifestComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDependsOnComponent parseImplementationGuideImplementationGuideDependsOnComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDependsOnComponent res = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDependsOnComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDependsOnComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDependsOnComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("uri")) {
            res.setUriElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageId")) {
            res.setPackageIdElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideGlobalComponent parseImplementationGuideImplementationGuideGlobalComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideGlobalComponent res = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideGlobalComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideGlobalComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideGlobalComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionComponent parseImplementationGuideImplementationGuideDefinitionComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionComponent res = new ImplementationGuide.ImplementationGuideDefinitionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("grouping")) {
            res.getGrouping().add(this.parseImplementationGuideImplementationGuideDefinitionGroupingComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseImplementationGuideImplementationGuideDefinitionResourceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.setPage(this.parseImplementationGuideImplementationGuideDefinitionPageComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseImplementationGuideImplementationGuideDefinitionParameterComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("template")) {
            res.getTemplate().add(this.parseImplementationGuideImplementationGuideDefinitionTemplateComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionGroupingComponent parseImplementationGuideImplementationGuideDefinitionGroupingComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionGroupingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionGroupingComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionGroupingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionResourceComponent parseImplementationGuideImplementationGuideDefinitionResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent res = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fhirVersion")) {
            res.getFhirVersion().add(this.parseEnumeration(xpp, Enumerations.FHIRVersion.NULL, new Enumerations.FHIRVersionEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "example")) {
            res.setExample(this.parseType("example", xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupingId")) {
            res.setGroupingIdElement(this.parseId(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionPageComponent parseImplementationGuideImplementationGuideDefinitionPageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionPageComponent res = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionPageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "name")) {
            res.setName(this.parseType("name", xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("generation")) {
            res.setGenerationElement(this.parseEnumeration(xpp, ImplementationGuide.GuidePageGeneration.NULL, new ImplementationGuide.GuidePageGenerationEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.getPage().add(this.parseImplementationGuideImplementationGuideDefinitionPageComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionParameterComponent parseImplementationGuideImplementationGuideDefinitionParameterComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionParameterComponent res = new ImplementationGuide.ImplementationGuideDefinitionParameterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionParameterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionParameterComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionParameterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideDefinitionTemplateComponent parseImplementationGuideImplementationGuideDefinitionTemplateComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res = new ImplementationGuide.ImplementationGuideDefinitionTemplateComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideDefinitionTemplateComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideDefinitionTemplateComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideDefinitionTemplateComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scope")) {
            res.setScopeElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ImplementationGuideManifestComponent parseImplementationGuideImplementationGuideManifestComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ImplementationGuideManifestComponent res = new ImplementationGuide.ImplementationGuideManifestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideImplementationGuideManifestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideImplementationGuideManifestComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ImplementationGuideManifestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("rendering")) {
            res.setRenderingElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.getResource().add(this.parseImplementationGuideManifestResourceComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("page")) {
            res.getPage().add(this.parseImplementationGuideManifestPageComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("image")) {
            res.getImage().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("other")) {
            res.getOther().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ManifestResourceComponent parseImplementationGuideManifestResourceComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ManifestResourceComponent res = new ImplementationGuide.ManifestResourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideManifestResourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideManifestResourceComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ManifestResourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("reference")) {
            res.setReference(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "example")) {
            res.setExample(this.parseType("example", xpp));
        } else if (eventType == 2 && xpp.getName().equals("relativePath")) {
            res.setRelativePathElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ImplementationGuide.ManifestPageComponent parseImplementationGuideManifestPageComponent(XmlPullParser xpp, ImplementationGuide owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ImplementationGuide.ManifestPageComponent res = new ImplementationGuide.ManifestPageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseImplementationGuideManifestPageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseImplementationGuideManifestPageComponentContent(int eventType, XmlPullParser xpp, ImplementationGuide owner, ImplementationGuide.ManifestPageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("anchor")) {
            res.getAnchor().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan parseInsurancePlan(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan res = new InsurancePlan();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanContent(int eventType, XmlPullParser xpp, InsurancePlan res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ownedBy")) {
            res.setOwnedBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administeredBy")) {
            res.setAdministeredBy(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseInsurancePlanInsurancePlanContactComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverage")) {
            res.getCoverage().add(this.parseInsurancePlanInsurancePlanCoverageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("plan")) {
            res.getPlan().add(this.parseInsurancePlanInsurancePlanPlanComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanContactComponent parseInsurancePlanInsurancePlanContactComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanContactComponent res = new InsurancePlan.InsurancePlanContactComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanInsurancePlanContactComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanInsurancePlanContactComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanContactComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurpose(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setName(this.parseHumanName(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanCoverageComponent parseInsurancePlanInsurancePlanCoverageComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanCoverageComponent res = new InsurancePlan.InsurancePlanCoverageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanInsurancePlanCoverageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanInsurancePlanCoverageComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanCoverageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseInsurancePlanCoverageBenefitComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.CoverageBenefitComponent parseInsurancePlanCoverageBenefitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.CoverageBenefitComponent res = new InsurancePlan.CoverageBenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanCoverageBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanCoverageBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.CoverageBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requirement")) {
            res.setRequirementElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("limit")) {
            res.getLimit().add(this.parseInsurancePlanCoverageBenefitLimitComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.CoverageBenefitLimitComponent parseInsurancePlanCoverageBenefitLimitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.CoverageBenefitLimitComponent res = new InsurancePlan.CoverageBenefitLimitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanCoverageBenefitLimitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanCoverageBenefitLimitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.CoverageBenefitLimitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanComponent parseInsurancePlanInsurancePlanPlanComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanComponent res = new InsurancePlan.InsurancePlanPlanComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanInsurancePlanPlanComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanInsurancePlanPlanComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("coverageArea")) {
            res.getCoverageArea().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("network")) {
            res.getNetwork().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("generalCost")) {
            res.getGeneralCost().add(this.parseInsurancePlanInsurancePlanPlanGeneralCostComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("specificCost")) {
            res.getSpecificCost().add(this.parseInsurancePlanInsurancePlanPlanSpecificCostComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanGeneralCostComponent parseInsurancePlanInsurancePlanPlanGeneralCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanGeneralCostComponent res = new InsurancePlan.InsurancePlanPlanGeneralCostComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanInsurancePlanPlanGeneralCostComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanInsurancePlanPlanGeneralCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanGeneralCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupSize")) {
            res.setGroupSizeElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.setCost(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.InsurancePlanPlanSpecificCostComponent parseInsurancePlanInsurancePlanPlanSpecificCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.InsurancePlanPlanSpecificCostComponent res = new InsurancePlan.InsurancePlanPlanSpecificCostComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanInsurancePlanPlanSpecificCostComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanInsurancePlanPlanSpecificCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.InsurancePlanPlanSpecificCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("benefit")) {
            res.getBenefit().add(this.parseInsurancePlanPlanBenefitComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.PlanBenefitComponent parseInsurancePlanPlanBenefitComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.PlanBenefitComponent res = new InsurancePlan.PlanBenefitComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanBenefitComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanBenefitComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.PlanBenefitComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.getCost().add(this.parseInsurancePlanPlanBenefitCostComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected InsurancePlan.PlanBenefitCostComponent parseInsurancePlanPlanBenefitCostComponent(XmlPullParser xpp, InsurancePlan owner) throws XmlPullParserException, IOException, FHIRFormatError {
        InsurancePlan.PlanBenefitCostComponent res = new InsurancePlan.PlanBenefitCostComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInsurancePlanPlanBenefitCostComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInsurancePlanPlanBenefitCostComponentContent(int eventType, XmlPullParser xpp, InsurancePlan owner, InsurancePlan.PlanBenefitCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("applicability")) {
            res.setApplicability(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("qualifiers")) {
            res.getQualifiers().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice parseInvoice(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice res = new Invoice();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceContent(int eventType, XmlPullParser xpp, Invoice res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Invoice.InvoiceStatus.NULL, new Invoice.InvoiceStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("cancelledReason")) {
            res.setCancelledReasonElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recipient")) {
            res.setRecipient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("participant")) {
            res.getParticipant().add(this.parseInvoiceInvoiceParticipantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("issuer")) {
            res.setIssuer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("account")) {
            res.setAccount(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lineItem")) {
            res.getLineItem().add(this.parseInvoiceInvoiceLineItemComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("totalPriceComponent")) {
            res.getTotalPriceComponent().add(this.parseInvoiceInvoiceLineItemPriceComponentComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("totalNet")) {
            res.setTotalNet(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("totalGross")) {
            res.setTotalGross(this.parseMoney(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paymentTerms")) {
            res.setPaymentTermsElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice.InvoiceParticipantComponent parseInvoiceInvoiceParticipantComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice.InvoiceParticipantComponent res = new Invoice.InvoiceParticipantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceInvoiceParticipantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceInvoiceParticipantComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceParticipantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice.InvoiceLineItemComponent parseInvoiceInvoiceLineItemComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice.InvoiceLineItemComponent res = new Invoice.InvoiceLineItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceInvoiceLineItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceInvoiceLineItemComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceLineItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("sequence")) {
            res.setSequenceElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "chargeItem")) {
            res.setChargeItem(this.parseType("chargeItem", xpp));
        } else if (eventType == 2 && xpp.getName().equals("priceComponent")) {
            res.getPriceComponent().add(this.parseInvoiceInvoiceLineItemPriceComponentComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Invoice.InvoiceLineItemPriceComponentComponent parseInvoiceInvoiceLineItemPriceComponentComponent(XmlPullParser xpp, Invoice owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Invoice.InvoiceLineItemPriceComponentComponent res = new Invoice.InvoiceLineItemPriceComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseInvoiceInvoiceLineItemPriceComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseInvoiceInvoiceLineItemPriceComponentComponentContent(int eventType, XmlPullParser xpp, Invoice owner, Invoice.InvoiceLineItemPriceComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Invoice.InvoicePriceComponentType.NULL, new Invoice.InvoicePriceComponentTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("factor")) {
            res.setFactorElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Library parseLibrary(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Library res = new Library();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLibraryContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLibraryContent(int eventType, XmlPullParser xpp, Library res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parameter")) {
            res.getParameter().add(this.parseParameterDefinition(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataRequirement")) {
            res.getDataRequirement().add(this.parseDataRequirement(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.getContent().add(this.parseAttachment(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage parseLinkage(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage res = new Linkage();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageContent(int eventType, XmlPullParser xpp, Linkage res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("active")) {
            res.setActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.getItem().add(this.parseLinkageLinkageItemComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Linkage.LinkageItemComponent parseLinkageLinkageItemComponent(XmlPullParser xpp, Linkage owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Linkage.LinkageItemComponent res = new Linkage.LinkageItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLinkageLinkageItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLinkageLinkageItemComponentContent(int eventType, XmlPullParser xpp, Linkage owner, Linkage.LinkageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, Linkage.LinkageType.NULL, new Linkage.LinkageTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("resource")) {
            res.setResource(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource parseListResource(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource res = new ListResource();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceContent(int eventType, XmlPullParser xpp, ListResource res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, ListResource.ListStatus.NULL, new ListResource.ListStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, ListResource.ListMode.NULL, new ListResource.ListModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderedBy")) {
            res.setOrderedBy(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("entry")) {
            res.getEntry().add(this.parseListResourceListEntryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("emptyReason")) {
            res.setEmptyReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected ListResource.ListEntryComponent parseListResourceListEntryComponent(XmlPullParser xpp, ListResource owner) throws XmlPullParserException, IOException, FHIRFormatError {
        ListResource.ListEntryComponent res = new ListResource.ListEntryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseListResourceListEntryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseListResourceListEntryComponentContent(int eventType, XmlPullParser xpp, ListResource owner, ListResource.ListEntryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("flag")) {
            res.setFlag(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deleted")) {
            res.setDeletedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("item")) {
            res.setItem(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location parseLocation(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Location res = new Location();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationContent(int eventType, XmlPullParser xpp, Location res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Location.LocationStatus.NULL, new Location.LocationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("operationalStatus")) {
            res.setOperationalStatus(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alias")) {
            res.getAlias().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("mode")) {
            res.setModeElement(this.parseEnumeration(xpp, Location.LocationMode.NULL, new Location.LocationModeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("telecom")) {
            res.getTelecom().add(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("address")) {
            res.setAddress(this.parseAddress(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physicalType")) {
            res.setPhysicalType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("position")) {
            res.setPosition(this.parseLocationLocationPositionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("managingOrganization")) {
            res.setManagingOrganization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.setPartOf(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("hoursOfOperation")) {
            res.getHoursOfOperation().add(this.parseLocationLocationHoursOfOperationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("availabilityExceptions")) {
            res.setAvailabilityExceptionsElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.getEndpoint().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location.LocationPositionComponent parseLocationLocationPositionComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationPositionComponent res = new Location.LocationPositionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationLocationPositionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationLocationPositionComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationPositionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("longitude")) {
            res.setLongitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("latitude")) {
            res.setLatitudeElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("altitude")) {
            res.setAltitudeElement(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Location.LocationHoursOfOperationComponent parseLocationLocationHoursOfOperationComponent(XmlPullParser xpp, Location owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Location.LocationHoursOfOperationComponent res = new Location.LocationHoursOfOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseLocationLocationHoursOfOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseLocationLocationHoursOfOperationComponentContent(int eventType, XmlPullParser xpp, Location owner, Location.LocationHoursOfOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("daysOfWeek")) {
            res.getDaysOfWeek().add(this.parseEnumeration(xpp, Location.DaysOfWeek.NULL, new Location.DaysOfWeekEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allDay")) {
            res.setAllDayElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("openingTime")) {
            res.setOpeningTimeElement(this.parseTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("closingTime")) {
            res.setClosingTimeElement(this.parseTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure parseMeasure(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure res = new Measure();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureContent(int eventType, XmlPullParser xpp, Measure res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subtitle")) {
            res.setSubtitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "subject")) {
            res.setSubject(this.parseType("subject", xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("approvalDate")) {
            res.setApprovalDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lastReviewDate")) {
            res.setLastReviewDateElement(this.parseDate(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectivePeriod")) {
            res.setEffectivePeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("topic")) {
            res.getTopic().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.getAuthor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("editor")) {
            res.getEditor().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reviewer")) {
            res.getReviewer().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endorser")) {
            res.getEndorser().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedArtifact")) {
            res.getRelatedArtifact().add(this.parseRelatedArtifact(xpp));
        } else if (eventType == 2 && xpp.getName().equals("library")) {
            res.getLibrary().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disclaimer")) {
            res.setDisclaimerElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("scoring")) {
            res.setScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("compositeScoring")) {
            res.setCompositeScoring(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("riskAdjustment")) {
            res.setRiskAdjustmentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rateAggregation")) {
            res.setRateAggregationElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("rationale")) {
            res.setRationaleElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalRecommendationStatement")) {
            res.setClinicalRecommendationStatementElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
            res.setImprovementNotation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.getDefinition().add(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("guidance")) {
            res.setGuidanceElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseMeasureMeasureGroupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supplementalData")) {
            res.getSupplementalData().add(this.parseMeasureMeasureSupplementalDataComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupComponent parseMeasureMeasureGroupComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupComponent res = new Measure.MeasureGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureMeasureGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
            res.getStratifier().add(this.parseMeasureMeasureGroupStratifierComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupPopulationComponent parseMeasureMeasureGroupPopulationComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupPopulationComponent res = new Measure.MeasureGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupPopulationComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupStratifierComponent parseMeasureMeasureGroupStratifierComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponent res = new Measure.MeasureGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupStratifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupStratifierComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseMeasureMeasureGroupStratifierComponentComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureGroupStratifierComponentComponent parseMeasureMeasureGroupStratifierComponentComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureGroupStratifierComponentComponent res = new Measure.MeasureGroupStratifierComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureGroupStratifierComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureGroupStratifierComponentComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureGroupStratifierComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Measure.MeasureSupplementalDataComponent parseMeasureMeasureSupplementalDataComponent(XmlPullParser xpp, Measure owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Measure.MeasureSupplementalDataComponent res = new Measure.MeasureSupplementalDataComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureMeasureSupplementalDataComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureMeasureSupplementalDataComponentContent(int eventType, XmlPullParser xpp, Measure owner, Measure.MeasureSupplementalDataComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.getUsage().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("criteria")) {
            res.setCriteria(this.parseExpression(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport parseMeasureReport(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport res = new MeasureReport();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportContent(int eventType, XmlPullParser xpp, MeasureReport res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportStatus.NULL, new MeasureReport.MeasureReportStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MeasureReport.MeasureReportType.NULL, new MeasureReport.MeasureReportTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("measure")) {
            res.setMeasureElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reporter")) {
            res.setReporter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("improvementNotation")) {
            res.setImprovementNotation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.getGroup().add(this.parseMeasureReportMeasureReportGroupComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("evaluatedResource")) {
            res.getEvaluatedResource().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupComponent parseMeasureReportMeasureReportGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupComponent res = new MeasureReport.MeasureReportGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureReportMeasureReportGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
            res.setMeasureScore(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stratifier")) {
            res.getStratifier().add(this.parseMeasureReportMeasureReportGroupStratifierComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupPopulationComponent parseMeasureReportMeasureReportGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupPopulationComponent res = new MeasureReport.MeasureReportGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subjectResults")) {
            res.setSubjectResults(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.MeasureReportGroupStratifierComponent parseMeasureReportMeasureReportGroupStratifierComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.MeasureReportGroupStratifierComponent res = new MeasureReport.MeasureReportGroupStratifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportMeasureReportGroupStratifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportMeasureReportGroupStratifierComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.MeasureReportGroupStratifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.getCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("stratum")) {
            res.getStratum().add(this.parseMeasureReportStratifierGroupComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.StratifierGroupComponent parseMeasureReportStratifierGroupComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.StratifierGroupComponent res = new MeasureReport.StratifierGroupComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportStratifierGroupComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportStratifierGroupComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("component")) {
            res.getComponent().add(this.parseMeasureReportStratifierGroupComponentComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parseMeasureReportStratifierGroupPopulationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("measureScore")) {
            res.setMeasureScore(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.StratifierGroupComponentComponent parseMeasureReportStratifierGroupComponentComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.StratifierGroupComponentComponent res = new MeasureReport.StratifierGroupComponentComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportStratifierGroupComponentComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportStratifierGroupComponentComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupComponentComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MeasureReport.StratifierGroupPopulationComponent parseMeasureReportStratifierGroupPopulationComponent(XmlPullParser xpp, MeasureReport owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MeasureReport.StratifierGroupPopulationComponent res = new MeasureReport.StratifierGroupPopulationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMeasureReportStratifierGroupPopulationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMeasureReportStratifierGroupPopulationComponentContent(int eventType, XmlPullParser xpp, MeasureReport owner, MeasureReport.StratifierGroupPopulationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("count")) {
            res.setCountElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subjectResults")) {
            res.setSubjectResults(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Media parseMedia(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Media res = new Media();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMediaContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMediaContent(int eventType, XmlPullParser xpp, Media res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Media.MediaStatus.NULL, new Media.MediaStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("modality")) {
            res.setModality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("view")) {
            res.setView(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "created")) {
            res.setCreated(this.parseType("created", xpp));
        } else if (eventType == 2 && xpp.getName().equals("issued")) {
            res.setIssuedElement(this.parseInstant(xpp));
        } else if (eventType == 2 && xpp.getName().equals("operator")) {
            res.setOperator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("bodySite")) {
            res.setBodySite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("deviceName")) {
            res.setDeviceNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("height")) {
            res.setHeightElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("width")) {
            res.setWidthElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frames")) {
            res.setFramesElement(this.parsePositiveInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDurationElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("content")) {
            res.setContent(this.parseAttachment(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication parseMedication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication res = new Medication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationContent(int eventType, XmlPullParser xpp, Medication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, Medication.MedicationStatus.NULL, new Medication.MedicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("form")) {
            res.setForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseMedicationMedicationIngredientComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("batch")) {
            res.setBatch(this.parseMedicationMedicationBatchComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationIngredientComponent parseMedicationMedicationIngredientComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationIngredientComponent res = new Medication.MedicationIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationIngredientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationIngredientComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (eventType == 2 && xpp.getName().equals("isActive")) {
            res.setIsActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrength(this.parseRatio(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected Medication.MedicationBatchComponent parseMedicationMedicationBatchComponent(XmlPullParser xpp, Medication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        Medication.MedicationBatchComponent res = new Medication.MedicationBatchComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationMedicationBatchComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationMedicationBatchComponentContent(int eventType, XmlPullParser xpp, Medication owner, Medication.MedicationBatchComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("lotNumber")) {
            res.setLotNumberElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expirationDate")) {
            res.setExpirationDateElement(this.parseDateTime(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration parseMedicationAdministration(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration res = new MedicationAdministration();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationContent(int eventType, XmlPullParser xpp, MedicationAdministration res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiates")) {
            res.getInstantiates().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.getStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseMedicationAdministrationMedicationAdministrationPerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("request")) {
            res.setRequest(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.getDevice().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.setDosage(this.parseMedicationAdministrationMedicationAdministrationDosageComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration.MedicationAdministrationPerformerComponent parseMedicationAdministrationMedicationAdministrationPerformerComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationPerformerComponent res = new MedicationAdministration.MedicationAdministrationPerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationMedicationAdministrationPerformerComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationPerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationAdministration.MedicationAdministrationDosageComponent parseMedicationAdministrationMedicationAdministrationDosageComponent(XmlPullParser xpp, MedicationAdministration owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationAdministration.MedicationAdministrationDosageComponent res = new MedicationAdministration.MedicationAdministrationDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationAdministrationMedicationAdministrationDosageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationAdministrationMedicationAdministrationDosageComponentContent(int eventType, XmlPullParser xpp, MedicationAdministration owner, MedicationAdministration.MedicationAdministrationDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("text")) {
            res.setTextElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("site")) {
            res.setSite(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("route")) {
            res.setRoute(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dose")) {
            res.setDose(this.parseQuantity(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "rate")) {
            res.setRate(this.parseType("rate", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense parseMedicationDispense(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense res = new MedicationDispense();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseContent(int eventType, XmlPullParser xpp, MedicationDispense res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseCode(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "statusReason")) {
            res.setStatusReason(this.parseType("statusReason", xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.getPerformer().add(this.parseMedicationDispenseMedicationDispensePerformerComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("location")) {
            res.setLocation(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorizingPrescription")) {
            res.getAuthorizingPrescription().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("daysSupply")) {
            res.setDaysSupply(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenPrepared")) {
            res.setWhenPreparedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("whenHandedOver")) {
            res.setWhenHandedOverElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.setDestination(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.getReceiver().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
            res.getDosageInstruction().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("substitution")) {
            res.setSubstitution(this.parseMedicationDispenseMedicationDispenseSubstitutionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("detectedIssue")) {
            res.getDetectedIssue().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense.MedicationDispensePerformerComponent parseMedicationDispenseMedicationDispensePerformerComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispensePerformerComponent res = new MedicationDispense.MedicationDispensePerformerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseMedicationDispensePerformerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseMedicationDispensePerformerComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispensePerformerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("function")) {
            res.setFunction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("actor")) {
            res.setActor(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationDispense.MedicationDispenseSubstitutionComponent parseMedicationDispenseMedicationDispenseSubstitutionComponent(XmlPullParser xpp, MedicationDispense owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationDispense.MedicationDispenseSubstitutionComponent res = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationDispenseMedicationDispenseSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationDispense owner, MedicationDispense.MedicationDispenseSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("wasSubstituted")) {
            res.setWasSubstitutedElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.getReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsibleParty")) {
            res.getResponsibleParty().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge parseMedicationKnowledge(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge res = new MedicationKnowledge();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeContent(int eventType, XmlPullParser xpp, MedicationKnowledge res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.setManufacturer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("doseForm")) {
            res.setDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("synonym")) {
            res.getSynonym().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("relatedMedicationKnowledge")) {
            res.getRelatedMedicationKnowledge().add(this.parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("associatedMedication")) {
            res.getAssociatedMedication().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productType")) {
            res.getProductType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("monograph")) {
            res.getMonograph().add(this.parseMedicationKnowledgeMedicationKnowledgeMonographComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("preparationInstruction")) {
            res.setPreparationInstructionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intendedRoute")) {
            res.getIntendedRoute().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.getCost().add(this.parseMedicationKnowledgeMedicationKnowledgeCostComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("monitoringProgram")) {
            res.getMonitoringProgram().add(this.parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("administrationGuidelines")) {
            res.getAdministrationGuidelines().add(this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("medicineClassification")) {
            res.getMedicineClassification().add(this.parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("packaging")) {
            res.setPackaging(this.parseMedicationKnowledgeMedicationKnowledgePackagingComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("drugCharacteristic")) {
            res.getDrugCharacteristic().add(this.parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("contraindication")) {
            res.getContraindication().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regulatory")) {
            res.getRegulatory().add(this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("kinetics")) {
            res.getKinetics().add(this.parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res = new MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeRelatedMedicationKnowledgeComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRelatedMedicationKnowledgeComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reference")) {
            res.getReference().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeMonographComponent parseMedicationKnowledgeMedicationKnowledgeMonographComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeMonographComponent res = new MedicationKnowledge.MedicationKnowledgeMonographComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeMonographComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeMonographComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonographComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeIngredientComponent parseMedicationKnowledgeMedicationKnowledgeIngredientComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeIngredientComponent res = new MedicationKnowledge.MedicationKnowledgeIngredientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeIngredientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeIngredientComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeIngredientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (eventType == 2 && xpp.getName().equals("isActive")) {
            res.setIsActiveElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrength(this.parseRatio(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeCostComponent parseMedicationKnowledgeMedicationKnowledgeCostComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeCostComponent res = new MedicationKnowledge.MedicationKnowledgeCostComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeCostComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeCostComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeCostComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSourceElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cost")) {
            res.setCost(this.parseMoney(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res = new MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeMonitoringProgramComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMonitoringProgramComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(xpp, owner));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "indication")) {
            res.setIndication(this.parseType("indication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("patientCharacteristics")) {
            res.getPatientCharacteristics().add(this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesDosageComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesDosageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res = new MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeAdministrationGuidelinesPatientCharacteristicsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "characteristic")) {
            res.setCharacteristic(this.parseType("characteristic", xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.getValue().add(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res = new MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeMedicineClassificationComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeMedicineClassificationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.getClassification().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgePackagingComponent parseMedicationKnowledgeMedicationKnowledgePackagingComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgePackagingComponent res = new MedicationKnowledge.MedicationKnowledgePackagingComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgePackagingComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgePackagingComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgePackagingComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res = new MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeDrugCharacteristicComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeDrugCharacteristicComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "value")) {
            res.setValue(this.parseType("value", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeRegulatoryComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatoryComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("regulatoryAuthority")) {
            res.setRegulatoryAuthority(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("substitution")) {
            res.getSubstitution().add(this.parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.getSchedule().add(this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("maxDispense")) {
            res.setMaxDispense(this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatorySubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatorySubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allowed")) {
            res.setAllowedElement(this.parseBoolean(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatoryScheduleComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryScheduleComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.setSchedule(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res = new MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeRegulatoryMaxDispenseComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeRegulatoryMaxDispenseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parseDuration(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationKnowledge.MedicationKnowledgeKineticsComponent parseMedicationKnowledgeMedicationKnowledgeKineticsComponent(XmlPullParser xpp, MedicationKnowledge owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationKnowledge.MedicationKnowledgeKineticsComponent res = new MedicationKnowledge.MedicationKnowledgeKineticsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationKnowledgeMedicationKnowledgeKineticsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationKnowledgeMedicationKnowledgeKineticsComponentContent(int eventType, XmlPullParser xpp, MedicationKnowledge owner, MedicationKnowledge.MedicationKnowledgeKineticsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("areaUnderCurve")) {
            res.getAreaUnderCurve().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("lethalDose50")) {
            res.getLethalDose50().add(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("halfLifePeriod")) {
            res.setHalfLifePeriod(this.parseDuration(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest parseMedicationRequest(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest res = new MedicationRequest();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestContent(int eventType, XmlPullParser xpp, MedicationRequest res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestStatus.NULL, new MedicationRequest.MedicationRequestStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.setStatusReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestIntent.NULL, new MedicationRequest.MedicationRequestIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.getCategory().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("priority")) {
            res.setPriorityElement(this.parseEnumeration(xpp, MedicationRequest.MedicationRequestPriority.NULL, new MedicationRequest.MedicationRequestPriorityEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("doNotPerform")) {
            res.setDoNotPerformElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "reported")) {
            res.setReported(this.parseType("reported", xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.getSupportingInformation().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authoredOn")) {
            res.setAuthoredOnElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("requester")) {
            res.setRequester(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performerType")) {
            res.setPerformerType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recorder")) {
            res.setRecorder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("groupIdentifier")) {
            res.setGroupIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("courseOfTherapyType")) {
            res.setCourseOfTherapyType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("insurance")) {
            res.getInsurance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosageInstruction")) {
            res.getDosageInstruction().add(this.parseDosage(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dispenseRequest")) {
            res.setDispenseRequest(this.parseMedicationRequestMedicationRequestDispenseRequestComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("substitution")) {
            res.setSubstitution(this.parseMedicationRequestMedicationRequestSubstitutionComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("priorPrescription")) {
            res.setPriorPrescription(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("detectedIssue")) {
            res.getDetectedIssue().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("eventHistory")) {
            res.getEventHistory().add(this.parseReference(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestDispenseRequestComponent parseMedicationRequestMedicationRequestDispenseRequestComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestDispenseRequestComponent res = new MedicationRequest.MedicationRequestDispenseRequestComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestDispenseRequestComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestDispenseRequestComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("initialFill")) {
            res.setInitialFill(this.parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("dispenseInterval")) {
            res.setDispenseInterval(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numberOfRepeatsAllowed")) {
            res.setNumberOfRepeatsAllowedElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("expectedSupplyDuration")) {
            res.setExpectedSupplyDuration(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res = new MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestDispenseRequestInitialFillComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestDispenseRequestInitialFillComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDuration(this.parseDuration(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationRequest.MedicationRequestSubstitutionComponent parseMedicationRequestMedicationRequestSubstitutionComponent(XmlPullParser xpp, MedicationRequest owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationRequest.MedicationRequestSubstitutionComponent res = new MedicationRequest.MedicationRequestSubstitutionComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationRequestMedicationRequestSubstitutionComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationRequestMedicationRequestSubstitutionComponentContent(int eventType, XmlPullParser xpp, MedicationRequest owner, MedicationRequest.MedicationRequestSubstitutionComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "allowed")) {
            res.setAllowed(this.parseType("allowed", xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicationStatement parseMedicationStatement(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicationStatement res = new MedicationStatement();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicationStatementContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicationStatementContent(int eventType, XmlPullParser xpp, MedicationStatement res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("basedOn")) {
            res.getBasedOn().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("partOf")) {
            res.getPartOf().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, MedicationStatement.MedicationStatementStatus.NULL, new MedicationStatement.MedicationStatementStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("statusReason")) {
            res.getStatusReason().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategory(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("context")) {
            res.setContext(this.parseReference(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "effective")) {
            res.setEffective(this.parseType("effective", xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateAsserted")) {
            res.setDateAssertedElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("informationSource")) {
            res.setInformationSource(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("derivedFrom")) {
            res.getDerivedFrom().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonCode")) {
            res.getReasonCode().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reasonReference")) {
            res.getReasonReference().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dosage")) {
            res.getDosage().add(this.parseDosage(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct parseMedicinalProduct(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct res = new MedicinalProduct();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductContent(int eventType, XmlPullParser xpp, MedicinalProduct res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("domain")) {
            res.setDomain(this.parseCoding(xpp));
        } else if (eventType == 2 && xpp.getName().equals("combinedPharmaceuticalDoseForm")) {
            res.setCombinedPharmaceuticalDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("legalStatusOfSupply")) {
            res.setLegalStatusOfSupply(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additionalMonitoringIndicator")) {
            res.setAdditionalMonitoringIndicator(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specialMeasures")) {
            res.getSpecialMeasures().add(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("paediatricUseIndicator")) {
            res.setPaediatricUseIndicator(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productClassification")) {
            res.getProductClassification().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("marketingStatus")) {
            res.getMarketingStatus().add(this.parseMarketingStatus(xpp));
        } else if (eventType == 2 && xpp.getName().equals("pharmaceuticalProduct")) {
            res.getPharmaceuticalProduct().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packagedMedicinalProduct")) {
            res.getPackagedMedicinalProduct().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("attachedDocument")) {
            res.getAttachedDocument().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("masterFile")) {
            res.getMasterFile().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("clinicalTrial")) {
            res.getClinicalTrial().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.getName().add(this.parseMedicinalProductMedicinalProductNameComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("crossReference")) {
            res.getCrossReference().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturingBusinessOperation")) {
            res.getManufacturingBusinessOperation().add(this.parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("specialDesignation")) {
            res.getSpecialDesignation().add(this.parseMedicinalProductMedicinalProductSpecialDesignationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct.MedicinalProductNameComponent parseMedicinalProductMedicinalProductNameComponent(XmlPullParser xpp, MedicinalProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct.MedicinalProductNameComponent res = new MedicinalProduct.MedicinalProductNameComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductMedicinalProductNameComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductMedicinalProductNameComponentContent(int eventType, XmlPullParser xpp, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("productName")) {
            res.setProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("namePart")) {
            res.getNamePart().add(this.parseMedicinalProductMedicinalProductNameNamePartComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("countryLanguage")) {
            res.getCountryLanguage().add(this.parseMedicinalProductMedicinalProductNameCountryLanguageComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct.MedicinalProductNameNamePartComponent parseMedicinalProductMedicinalProductNameNamePartComponent(XmlPullParser xpp, MedicinalProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct.MedicinalProductNameNamePartComponent res = new MedicinalProduct.MedicinalProductNameNamePartComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductMedicinalProductNameNamePartComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductMedicinalProductNameNamePartComponentContent(int eventType, XmlPullParser xpp, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameNamePartComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("part")) {
            res.setPartElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCoding(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct.MedicinalProductNameCountryLanguageComponent parseMedicinalProductMedicinalProductNameCountryLanguageComponent(XmlPullParser xpp, MedicinalProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct.MedicinalProductNameCountryLanguageComponent res = new MedicinalProduct.MedicinalProductNameCountryLanguageComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductMedicinalProductNameCountryLanguageComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductMedicinalProductNameCountryLanguageComponentContent(int eventType, XmlPullParser xpp, MedicinalProduct owner, MedicinalProduct.MedicinalProductNameCountryLanguageComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountry(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.setJurisdiction(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("language")) {
            res.setLanguage(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponent(XmlPullParser xpp, MedicinalProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res = new MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductMedicinalProductManufacturingBusinessOperationComponentContent(int eventType, XmlPullParser xpp, MedicinalProduct owner, MedicinalProduct.MedicinalProductManufacturingBusinessOperationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("operationType")) {
            res.setOperationType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("authorisationReferenceNumber")) {
            res.setAuthorisationReferenceNumber(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effectiveDate")) {
            res.setEffectiveDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("confidentialityIndicator")) {
            res.setConfidentialityIndicator(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regulator")) {
            res.setRegulator(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProduct.MedicinalProductSpecialDesignationComponent parseMedicinalProductMedicinalProductSpecialDesignationComponent(XmlPullParser xpp, MedicinalProduct owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProduct.MedicinalProductSpecialDesignationComponent res = new MedicinalProduct.MedicinalProductSpecialDesignationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductMedicinalProductSpecialDesignationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductMedicinalProductSpecialDesignationComponentContent(int eventType, XmlPullParser xpp, MedicinalProduct owner, MedicinalProduct.MedicinalProductSpecialDesignationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intendedUse")) {
            res.setIntendedUse(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "indication")) {
            res.setIndication(this.parseType("indication", xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("species")) {
            res.setSpecies(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductAuthorization parseMedicinalProductAuthorization(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductAuthorization res = new MedicinalProductAuthorization();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductAuthorizationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductAuthorizationContent(int eventType, XmlPullParser xpp, MedicinalProductAuthorization res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.setSubject(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.getCountry().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("statusDate")) {
            res.setStatusDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("restoreDate")) {
            res.setRestoreDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dataExclusivityPeriod")) {
            res.setDataExclusivityPeriod(this.parsePeriod(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateOfFirstAuthorization")) {
            res.setDateOfFirstAuthorizationElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("internationalBirthDate")) {
            res.setInternationalBirthDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("legalBasis")) {
            res.setLegalBasis(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdictionalAuthorization")) {
            res.getJurisdictionalAuthorization().add(this.parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("holder")) {
            res.setHolder(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("regulator")) {
            res.setRegulator(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("procedure")) {
            res.setProcedure(this.parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponent(XmlPullParser xpp, MedicinalProductAuthorization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductAuthorizationMedicinalProductAuthorizationJurisdictionalAuthorizationComponentContent(int eventType, XmlPullParser xpp, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationJurisdictionalAuthorizationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.setCountry(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("legalStatusOfSupply")) {
            res.setLegalStatusOfSupply(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("validityPeriod")) {
            res.setValidityPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(XmlPullParser xpp, MedicinalProductAuthorization owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res = new MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponentContent(int eventType, XmlPullParser xpp, MedicinalProductAuthorization owner, MedicinalProductAuthorization.MedicinalProductAuthorizationProcedureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "date")) {
            res.setDate(this.parseType("date", xpp));
        } else if (eventType == 2 && xpp.getName().equals("application")) {
            res.getApplication().add(this.parseMedicinalProductAuthorizationMedicinalProductAuthorizationProcedureComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductContraindication parseMedicinalProductContraindication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductContraindication res = new MedicinalProductContraindication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductContraindicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductContraindicationContent(int eventType, XmlPullParser xpp, MedicinalProductContraindication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("disease")) {
            res.setDisease(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comorbidity")) {
            res.getComorbidity().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("therapeuticIndication")) {
            res.getTherapeuticIndication().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherTherapy")) {
            res.getOtherTherapy().add(this.parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parsePopulation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponent(XmlPullParser xpp, MedicinalProductContraindication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res = new MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductContraindicationMedicinalProductContraindicationOtherTherapyComponentContent(int eventType, XmlPullParser xpp, MedicinalProductContraindication owner, MedicinalProductContraindication.MedicinalProductContraindicationOtherTherapyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("therapyRelationshipType")) {
            res.setTherapyRelationshipType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIndication parseMedicinalProductIndication(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIndication res = new MedicinalProductIndication();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIndicationContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIndicationContent(int eventType, XmlPullParser xpp, MedicinalProductIndication res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diseaseSymptomProcedure")) {
            res.setDiseaseSymptomProcedure(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("diseaseStatus")) {
            res.setDiseaseStatus(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comorbidity")) {
            res.getComorbidity().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("intendedEffect")) {
            res.setIntendedEffect(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("duration")) {
            res.setDuration(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherTherapy")) {
            res.getOtherTherapy().add(this.parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("undesirableEffect")) {
            res.getUndesirableEffect().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parsePopulation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponent(XmlPullParser xpp, MedicinalProductIndication owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res = new MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIndicationMedicinalProductIndicationOtherTherapyComponentContent(int eventType, XmlPullParser xpp, MedicinalProductIndication owner, MedicinalProductIndication.MedicinalProductIndicationOtherTherapyComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("therapyRelationshipType")) {
            res.setTherapyRelationshipType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "medication")) {
            res.setMedication(this.parseType("medication", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIngredient parseMedicinalProductIngredient(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIngredient res = new MedicinalProductIngredient();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIngredientContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIngredientContent(int eventType, XmlPullParser xpp, MedicinalProductIngredient res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifier(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("role")) {
            res.setRole(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergenicIndicator")) {
            res.setAllergenicIndicatorElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specifiedSubstance")) {
            res.getSpecifiedSubstance().add(this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponent(XmlPullParser xpp, MedicinalProductIngredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceComponentContent(int eventType, XmlPullParser xpp, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("group")) {
            res.setGroup(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("confidentiality")) {
            res.setConfidentiality(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.getStrength().add(this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(XmlPullParser xpp, MedicinalProductIngredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponentContent(int eventType, XmlPullParser xpp, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("presentation")) {
            res.setPresentation(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("presentationLowLimit")) {
            res.setPresentationLowLimit(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("concentration")) {
            res.setConcentration(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("concentrationLowLimit")) {
            res.setConcentrationLowLimit(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.getCountry().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceStrength")) {
            res.getReferenceStrength().add(this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent(XmlPullParser xpp, MedicinalProductIngredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponentContent(int eventType, XmlPullParser xpp, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSpecifiedSubstanceStrengthReferenceStrengthComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("substance")) {
            res.setSubstance(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.setStrength(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strengthLowLimit")) {
            res.setStrengthLowLimit(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("measurementPoint")) {
            res.setMeasurementPointElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("country")) {
            res.getCountry().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponent(XmlPullParser xpp, MedicinalProductIngredient owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res = new MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductIngredientMedicinalProductIngredientSubstanceComponentContent(int eventType, XmlPullParser xpp, MedicinalProductIngredient owner, MedicinalProductIngredient.MedicinalProductIngredientSubstanceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strength")) {
            res.getStrength().add(this.parseMedicinalProductIngredientMedicinalProductIngredientSpecifiedSubstanceStrengthComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductInteraction parseMedicinalProductInteraction(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductInteraction res = new MedicinalProductInteraction();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductInteractionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductInteractionContent(int eventType, XmlPullParser xpp, MedicinalProductInteraction res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("interactant")) {
            res.getInteractant().add(this.parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("effect")) {
            res.setEffect(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("incidence")) {
            res.setIncidence(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("management")) {
            res.setManagement(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponent(XmlPullParser xpp, MedicinalProductInteraction owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent res = new MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductInteractionMedicinalProductInteractionInteractantComponentContent(int eventType, XmlPullParser xpp, MedicinalProductInteraction owner, MedicinalProductInteraction.MedicinalProductInteractionInteractantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "item")) {
            res.setItem(this.parseType("item", xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductManufactured parseMedicinalProductManufactured(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductManufactured res = new MedicinalProductManufactured();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductManufacturedContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductManufacturedContent(int eventType, XmlPullParser xpp, MedicinalProductManufactured res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("manufacturedDoseForm")) {
            res.setManufacturedDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("physicalCharacteristics")) {
            res.setPhysicalCharacteristics(this.parseProdCharacteristic(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherCharacteristics")) {
            res.getOtherCharacteristics().add(this.parseCodeableConcept(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPackaged parseMedicinalProductPackaged(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPackaged res = new MedicinalProductPackaged();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPackagedContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPackagedContent(int eventType, XmlPullParser xpp, MedicinalProductPackaged res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("legalStatusOfSupply")) {
            res.setLegalStatusOfSupply(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("marketingStatus")) {
            res.getMarketingStatus().add(this.parseMarketingStatus(xpp));
        } else if (eventType == 2 && xpp.getName().equals("marketingAuthorization")) {
            res.setMarketingAuthorization(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("batchIdentifier")) {
            res.getBatchIdentifier().add(this.parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("packageItem")) {
            res.getPackageItem().add(this.parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponent(XmlPullParser xpp, MedicinalProductPackaged owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res = new MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPackagedMedicinalProductPackagedBatchIdentifierComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedBatchIdentifierComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("outerPackaging")) {
            res.setOuterPackaging(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("immediatePackaging")) {
            res.setImmediatePackaging(this.parseIdentifier(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(XmlPullParser xpp, MedicinalProductPackaged owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res = new MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPackaged owner, MedicinalProductPackaged.MedicinalProductPackagedPackageItemComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("material")) {
            res.getMaterial().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("alternateMaterial")) {
            res.getAlternateMaterial().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.getDevice().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturedItem")) {
            res.getManufacturedItem().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("packageItem")) {
            res.getPackageItem().add(this.parseMedicinalProductPackagedMedicinalProductPackagedPackageItemComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("physicalCharacteristics")) {
            res.setPhysicalCharacteristics(this.parseProdCharacteristic(xpp));
        } else if (eventType == 2 && xpp.getName().equals("otherCharacteristics")) {
            res.getOtherCharacteristics().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("shelfLifeStorage")) {
            res.getShelfLifeStorage().add(this.parseProductShelfLife(xpp));
        } else if (eventType == 2 && xpp.getName().equals("manufacturer")) {
            res.getManufacturer().add(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPharmaceutical parseMedicinalProductPharmaceutical(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPharmaceutical res = new MedicinalProductPharmaceutical();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPharmaceuticalContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPharmaceuticalContent(int eventType, XmlPullParser xpp, MedicinalProductPharmaceutical res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administrableDoseForm")) {
            res.setAdministrableDoseForm(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("unitOfPresentation")) {
            res.setUnitOfPresentation(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("ingredient")) {
            res.getIngredient().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.getDevice().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("characteristics")) {
            res.getCharacteristics().add(this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("routeOfAdministration")) {
            res.getRouteOfAdministration().add(this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponent(XmlPullParser xpp, MedicinalProductPharmaceutical owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalCharacteristicsComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalCharacteristicsComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatus(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponent(XmlPullParser xpp, MedicinalProductPharmaceutical owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("firstDose")) {
            res.setFirstDose(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxSingleDose")) {
            res.setMaxSingleDose(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerDay")) {
            res.setMaxDosePerDay(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxDosePerTreatmentPeriod")) {
            res.setMaxDosePerTreatmentPeriod(this.parseRatio(xpp));
        } else if (eventType == 2 && xpp.getName().equals("maxTreatmentPeriod")) {
            res.setMaxTreatmentPeriod(this.parseDuration(xpp));
        } else if (eventType == 2 && xpp.getName().equals("targetSpecies")) {
            res.getTargetSpecies().add(this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent(XmlPullParser xpp, MedicinalProductPharmaceutical owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCode(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("withdrawalPeriod")) {
            res.getWithdrawalPeriod().add(this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent(XmlPullParser xpp, MedicinalProductPharmaceutical owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res = new MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductPharmaceuticalMedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponentContent(int eventType, XmlPullParser xpp, MedicinalProductPharmaceutical owner, MedicinalProductPharmaceutical.MedicinalProductPharmaceuticalRouteOfAdministrationTargetSpeciesWithdrawalPeriodComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("tissue")) {
            res.setTissue(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValue(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("supportingInformation")) {
            res.setSupportingInformationElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MedicinalProductUndesirableEffect parseMedicinalProductUndesirableEffect(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MedicinalProductUndesirableEffect res = new MedicinalProductUndesirableEffect();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMedicinalProductUndesirableEffectContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMedicinalProductUndesirableEffectContent(int eventType, XmlPullParser xpp, MedicinalProductUndesirableEffect res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("subject")) {
            res.getSubject().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("symptomConditionEffect")) {
            res.setSymptomConditionEffect(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("classification")) {
            res.setClassification(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("frequencyOfOccurrence")) {
            res.setFrequencyOfOccurrence(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("population")) {
            res.getPopulation().add(this.parsePopulation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition parseMessageDefinition(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition res = new MessageDefinition();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionContent(int eventType, XmlPullParser xpp, MessageDefinition res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("title")) {
            res.setTitleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("replaces")) {
            res.getReplaces().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("experimental")) {
            res.setExperimentalElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("purpose")) {
            res.setPurposeElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("copyright")) {
            res.setCopyrightElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("base")) {
            res.setBaseElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("parent")) {
            res.getParent().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && this.nameIsTypeName(xpp, "event")) {
            res.setEvent(this.parseType("event", xpp));
        } else if (eventType == 2 && xpp.getName().equals("category")) {
            res.setCategoryElement(this.parseEnumeration(xpp, MessageDefinition.MessageSignificanceCategory.NULL, new MessageDefinition.MessageSignificanceCategoryEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseMessageDefinitionMessageDefinitionFocusComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("responseRequired")) {
            res.setResponseRequiredElement(this.parseEnumeration(xpp, MessageDefinition.MessageheaderResponseRequest.NULL, new MessageDefinition.MessageheaderResponseRequestEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("allowedResponse")) {
            res.getAllowedResponse().add(this.parseMessageDefinitionMessageDefinitionAllowedResponseComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("graph")) {
            res.getGraph().add(this.parseCanonical(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition.MessageDefinitionFocusComponent parseMessageDefinitionMessageDefinitionFocusComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionFocusComponent res = new MessageDefinition.MessageDefinitionFocusComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionMessageDefinitionFocusComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionMessageDefinitionFocusComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionFocusComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseCode(xpp));
        } else if (eventType == 2 && xpp.getName().equals("profile")) {
            res.setProfileElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("min")) {
            res.setMinElement(this.parseUnsignedInt(xpp));
        } else if (eventType == 2 && xpp.getName().equals("max")) {
            res.setMaxElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageDefinition.MessageDefinitionAllowedResponseComponent parseMessageDefinitionMessageDefinitionAllowedResponseComponent(XmlPullParser xpp, MessageDefinition owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageDefinition.MessageDefinitionAllowedResponseComponent res = new MessageDefinition.MessageDefinitionAllowedResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageDefinitionMessageDefinitionAllowedResponseComponentContent(int eventType, XmlPullParser xpp, MessageDefinition owner, MessageDefinition.MessageDefinitionAllowedResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("message")) {
            res.setMessageElement(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("situation")) {
            res.setSituationElement(this.parseMarkdown(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader parseMessageHeader(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader res = new MessageHeader();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderContent(int eventType, XmlPullParser xpp, MessageHeader res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && this.nameIsTypeName(xpp, "event")) {
            res.setEvent(this.parseType("event", xpp));
        } else if (eventType == 2 && xpp.getName().equals("destination")) {
            res.getDestination().add(this.parseMessageHeaderMessageDestinationComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("sender")) {
            res.setSender(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("enterer")) {
            res.setEnterer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("author")) {
            res.setAuthor(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("source")) {
            res.setSource(this.parseMessageHeaderMessageSourceComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsible(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("reason")) {
            res.setReason(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("response")) {
            res.setResponse(this.parseMessageHeaderMessageHeaderResponseComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("focus")) {
            res.getFocus().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("definition")) {
            res.setDefinitionElement(this.parseCanonical(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageDestinationComponent parseMessageHeaderMessageDestinationComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageDestinationComponent res = new MessageHeader.MessageDestinationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageDestinationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageDestinationComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageDestinationComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("target")) {
            res.setTarget(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.setEndpointElement(this.parseUrl(xpp));
        } else if (eventType == 2 && xpp.getName().equals("receiver")) {
            res.setReceiver(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageSourceComponent parseMessageHeaderMessageSourceComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageSourceComponent res = new MessageHeader.MessageSourceComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageSourceComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageSourceComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageSourceComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("software")) {
            res.setSoftwareElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("version")) {
            res.setVersionElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.setContact(this.parseContactPoint(xpp));
        } else if (eventType == 2 && xpp.getName().equals("endpoint")) {
            res.setEndpointElement(this.parseUrl(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MessageHeader.MessageHeaderResponseComponent parseMessageHeaderMessageHeaderResponseComponent(XmlPullParser xpp, MessageHeader owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MessageHeader.MessageHeaderResponseComponent res = new MessageHeader.MessageHeaderResponseComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMessageHeaderMessageHeaderResponseComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMessageHeaderMessageHeaderResponseComponentContent(int eventType, XmlPullParser xpp, MessageHeader owner, MessageHeader.MessageHeaderResponseComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.setIdentifierElement(this.parseId(xpp));
        } else if (eventType == 2 && xpp.getName().equals("code")) {
            res.setCodeElement(this.parseEnumeration(xpp, MessageHeader.ResponseType.NULL, new MessageHeader.ResponseTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("details")) {
            res.setDetails(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence parseMolecularSequence(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence res = new MolecularSequence();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceContent(int eventType, XmlPullParser xpp, MolecularSequence res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MolecularSequence.SequenceType.NULL, new MolecularSequence.SequenceTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("coordinateSystem")) {
            res.setCoordinateSystemElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("specimen")) {
            res.setSpecimen(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("device")) {
            res.setDevice(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("performer")) {
            res.setPerformer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeq")) {
            res.setReferenceSeq(this.parseMolecularSequenceMolecularSequenceReferenceSeqComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("variant")) {
            res.getVariant().add(this.parseMolecularSequenceMolecularSequenceVariantComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("observedSeq")) {
            res.setObservedSeqElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quality")) {
            res.getQuality().add(this.parseMolecularSequenceMolecularSequenceQualityComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("readCoverage")) {
            res.setReadCoverageElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("repository")) {
            res.getRepository().add(this.parseMolecularSequenceMolecularSequenceRepositoryComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("pointer")) {
            res.getPointer().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("structureVariant")) {
            res.getStructureVariant().add(this.parseMolecularSequenceMolecularSequenceStructureVariantComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceReferenceSeqComponent parseMolecularSequenceMolecularSequenceReferenceSeqComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceReferenceSeqComponent res = new MolecularSequence.MolecularSequenceReferenceSeqComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceReferenceSeqComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceReferenceSeqComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceReferenceSeqComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("chromosome")) {
            res.setChromosome(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("genomeBuild")) {
            res.setGenomeBuildElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orientation")) {
            res.setOrientationElement(this.parseEnumeration(xpp, MolecularSequence.OrientationType.NULL, new MolecularSequence.OrientationTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqId")) {
            res.setReferenceSeqId(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqPointer")) {
            res.setReferenceSeqPointer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceSeqString")) {
            res.setReferenceSeqStringElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("strand")) {
            res.setStrandElement(this.parseEnumeration(xpp, MolecularSequence.StrandType.NULL, new MolecularSequence.StrandTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("windowStart")) {
            res.setWindowStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("windowEnd")) {
            res.setWindowEndElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceVariantComponent parseMolecularSequenceMolecularSequenceVariantComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceVariantComponent res = new MolecularSequence.MolecularSequenceVariantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceVariantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("observedAllele")) {
            res.setObservedAlleleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("referenceAllele")) {
            res.setReferenceAlleleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("cigar")) {
            res.setCigarElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variantPointer")) {
            res.setVariantPointer(this.parseReference(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceQualityComponent parseMolecularSequenceMolecularSequenceQualityComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceQualityComponent res = new MolecularSequence.MolecularSequenceQualityComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceQualityComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceQualityComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MolecularSequence.QualityType.NULL, new MolecularSequence.QualityTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("standardSequence")) {
            res.setStandardSequence(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("score")) {
            res.setScore(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("method")) {
            res.setMethod(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("truthTP")) {
            res.setTruthTPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("queryTP")) {
            res.setQueryTPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("truthFN")) {
            res.setTruthFNElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("queryFP")) {
            res.setQueryFPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("gtFP")) {
            res.setGtFPElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.setPrecisionElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("recall")) {
            res.setRecallElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fScore")) {
            res.setFScoreElement(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("roc")) {
            res.setRoc(this.parseMolecularSequenceMolecularSequenceQualityRocComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceQualityRocComponent parseMolecularSequenceMolecularSequenceQualityRocComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceQualityRocComponent res = new MolecularSequence.MolecularSequenceQualityRocComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceQualityRocComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceQualityRocComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceQualityRocComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("score")) {
            res.getScore().add(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numTP")) {
            res.getNumTP().add(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numFP")) {
            res.getNumFP().add(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("numFN")) {
            res.getNumFN().add(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("precision")) {
            res.getPrecision().add(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("sensitivity")) {
            res.getSensitivity().add(this.parseDecimal(xpp));
        } else if (eventType == 2 && xpp.getName().equals("fMeasure")) {
            res.getFMeasure().add(this.parseDecimal(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceRepositoryComponent parseMolecularSequenceMolecularSequenceRepositoryComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceRepositoryComponent res = new MolecularSequence.MolecularSequenceRepositoryComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceRepositoryComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceRepositoryComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceRepositoryComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, MolecularSequence.RepositoryType.NULL, new MolecularSequence.RepositoryTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("url")) {
            res.setUrlElement(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("datasetId")) {
            res.setDatasetIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("variantsetId")) {
            res.setVariantsetIdElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("readsetId")) {
            res.setReadsetIdElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceStructureVariantComponent parseMolecularSequenceMolecularSequenceStructureVariantComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceStructureVariantComponent res = new MolecularSequence.MolecularSequenceStructureVariantComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceStructureVariantComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceStructureVariantComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("variantType")) {
            res.setVariantType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("exact")) {
            res.setExactElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("length")) {
            res.setLengthElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("outer")) {
            res.setOuter(this.parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("inner")) {
            res.setInner(this.parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(xpp, owner));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceStructureVariantOuterComponent parseMolecularSequenceMolecularSequenceStructureVariantOuterComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceStructureVariantOuterComponent res = new MolecularSequence.MolecularSequenceStructureVariantOuterComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceStructureVariantOuterComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantOuterComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected MolecularSequence.MolecularSequenceStructureVariantInnerComponent parseMolecularSequenceMolecularSequenceStructureVariantInnerComponent(XmlPullParser xpp, MolecularSequence owner) throws XmlPullParserException, IOException, FHIRFormatError {
        MolecularSequence.MolecularSequenceStructureVariantInnerComponent res = new MolecularSequence.MolecularSequenceStructureVariantInnerComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseMolecularSequenceMolecularSequenceStructureVariantInnerComponentContent(int eventType, XmlPullParser xpp, MolecularSequence owner, MolecularSequence.MolecularSequenceStructureVariantInnerComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("start")) {
            res.setStartElement(this.parseInteger(xpp));
        } else if (eventType == 2 && xpp.getName().equals("end")) {
            res.setEndElement(this.parseInteger(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NamingSystem parseNamingSystem(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem res = new NamingSystem();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNamingSystemContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNamingSystemContent(int eventType, XmlPullParser xpp, NamingSystem res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("name")) {
            res.setNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement((Enumeration)this.parseEnumeration(xpp, Enumerations.PublicationStatus.NULL, new Enumerations.PublicationStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("kind")) {
            res.setKindElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemType.NULL, new NamingSystem.NamingSystemTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("date")) {
            res.setDateElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("publisher")) {
            res.setPublisherElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("contact")) {
            res.getContact().add(this.parseContactDetail(xpp));
        } else if (eventType == 2 && xpp.getName().equals("responsible")) {
            res.setResponsibleElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("description")) {
            res.setDescriptionElement(this.parseMarkdown(xpp));
        } else if (eventType == 2 && xpp.getName().equals("useContext")) {
            res.getUseContext().add(this.parseUsageContext(xpp));
        } else if (eventType == 2 && xpp.getName().equals("jurisdiction")) {
            res.getJurisdiction().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("usage")) {
            res.setUsageElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("uniqueId")) {
            res.getUniqueId().add(this.parseNamingSystemNamingSystemUniqueIdComponent(xpp, res));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NamingSystem.NamingSystemUniqueIdComponent parseNamingSystemNamingSystemUniqueIdComponent(XmlPullParser xpp, NamingSystem owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NamingSystem.NamingSystemUniqueIdComponent res = new NamingSystem.NamingSystemUniqueIdComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNamingSystemNamingSystemUniqueIdComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNamingSystemNamingSystemUniqueIdComponentContent(int eventType, XmlPullParser xpp, NamingSystem owner, NamingSystem.NamingSystemUniqueIdComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setTypeElement(this.parseEnumeration(xpp, NamingSystem.NamingSystemIdentifierType.NULL, new NamingSystem.NamingSystemIdentifierTypeEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("value")) {
            res.setValueElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("preferred")) {
            res.setPreferredElement(this.parseBoolean(xpp));
        } else if (eventType == 2 && xpp.getName().equals("comment")) {
            res.setCommentElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("period")) {
            res.setPeriod(this.parsePeriod(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder parseNutritionOrder(XmlPullParser xpp) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder res = new NutritionOrder();
        this.parseDomainResourceAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderContent(eventType, xpp, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderContent(int eventType, XmlPullParser xpp, NutritionOrder res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("identifier")) {
            res.getIdentifier().add(this.parseIdentifier(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesCanonical")) {
            res.getInstantiatesCanonical().add(this.parseCanonical(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiatesUri")) {
            res.getInstantiatesUri().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instantiates")) {
            res.getInstantiates().add(this.parseUri(xpp));
        } else if (eventType == 2 && xpp.getName().equals("status")) {
            res.setStatusElement(this.parseEnumeration(xpp, NutritionOrder.NutritionOrderStatus.NULL, new NutritionOrder.NutritionOrderStatusEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("intent")) {
            res.setIntentElement(this.parseEnumeration(xpp, NutritionOrder.NutritiionOrderIntent.NULL, new NutritionOrder.NutritiionOrderIntentEnumFactory()));
        } else if (eventType == 2 && xpp.getName().equals("patient")) {
            res.setPatient(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("encounter")) {
            res.setEncounter(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("dateTime")) {
            res.setDateTimeElement(this.parseDateTime(xpp));
        } else if (eventType == 2 && xpp.getName().equals("orderer")) {
            res.setOrderer(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("allergyIntolerance")) {
            res.getAllergyIntolerance().add(this.parseReference(xpp));
        } else if (eventType == 2 && xpp.getName().equals("foodPreferenceModifier")) {
            res.getFoodPreferenceModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("excludeFoodModifier")) {
            res.getExcludeFoodModifier().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("oralDiet")) {
            res.setOralDiet(this.parseNutritionOrderNutritionOrderOralDietComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("supplement")) {
            res.getSupplement().add(this.parseNutritionOrderNutritionOrderSupplementComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("enteralFormula")) {
            res.setEnteralFormula(this.parseNutritionOrderNutritionOrderEnteralFormulaComponent(xpp, res));
        } else if (eventType == 2 && xpp.getName().equals("note")) {
            res.getNote().add(this.parseAnnotation(xpp));
        } else if (!this.parseDomainResourceContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietComponent parseNutritionOrderNutritionOrderOralDietComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietComponent res = new NutritionOrder.NutritionOrderOralDietComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.getType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.getSchedule().add(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("nutrient")) {
            res.getNutrient().add(this.parseNutritionOrderNutritionOrderOralDietNutrientComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("texture")) {
            res.getTexture().add(this.parseNutritionOrderNutritionOrderOralDietTextureComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("fluidConsistencyType")) {
            res.getFluidConsistencyType().add(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instruction")) {
            res.setInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietNutrientComponent parseNutritionOrderNutritionOrderOralDietNutrientComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietNutrientComponent res = new NutritionOrder.NutritionOrderOralDietNutrientComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietNutrientComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietNutrientComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.setModifier(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("amount")) {
            res.setAmount(this.parseQuantity(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderOralDietTextureComponent parseNutritionOrderNutritionOrderOralDietTextureComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderOralDietTextureComponent res = new NutritionOrder.NutritionOrderOralDietTextureComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderOralDietTextureComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderOralDietTextureComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderOralDietTextureComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("modifier")) {
            res.setModifier(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("foodType")) {
            res.setFoodType(this.parseCodeableConcept(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderSupplementComponent parseNutritionOrderNutritionOrderSupplementComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderSupplementComponent res = new NutritionOrder.NutritionOrderSupplementComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderSupplementComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderSupplementComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderSupplementComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("type")) {
            res.setType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("productName")) {
            res.setProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("schedule")) {
            res.getSchedule().add(this.parseTiming(xpp));
        } else if (eventType == 2 && xpp.getName().equals("quantity")) {
            res.setQuantity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("instruction")) {
            res.setInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaComponent parseNutritionOrderNutritionOrderEnteralFormulaComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaComponent res = new NutritionOrder.NutritionOrderEnteralFormulaComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderEnteralFormulaComponentContent(int eventType, XmlPullParser xpp, NutritionOrder owner, NutritionOrder.NutritionOrderEnteralFormulaComponent res) throws XmlPullParserException, IOException, FHIRFormatError {
        if (eventType == 2 && xpp.getName().equals("baseFormulaType")) {
            res.setBaseFormulaType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("baseFormulaProductName")) {
            res.setBaseFormulaProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additiveType")) {
            res.setAdditiveType(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("additiveProductName")) {
            res.setAdditiveProductNameElement(this.parseString(xpp));
        } else if (eventType == 2 && xpp.getName().equals("caloricDensity")) {
            res.setCaloricDensity(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("routeofAdministration")) {
            res.setRouteofAdministration(this.parseCodeableConcept(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administration")) {
            res.getAdministration().add(this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(xpp, owner));
        } else if (eventType == 2 && xpp.getName().equals("maxVolumeToDeliver")) {
            res.setMaxVolumeToDeliver(this.parseQuantity(xpp));
        } else if (eventType == 2 && xpp.getName().equals("administrationInstruction")) {
            res.setAdministrationInstructionElement(this.parseString(xpp));
        } else if (!this.parseBackboneElementContent(eventType, xpp, res)) {
            return false;
        }
        return true;
    }

    protected NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponent(XmlPullParser xpp, NutritionOrder owner) throws XmlPullParserException, IOException, FHIRFormatError {
        NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent res = new NutritionOrder.NutritionOrderEnteralFormulaAdministrationComponent();
        this.parseBackboneAttributes(xpp, res);
        this.next(xpp);
        int eventType = this.nextNoWhitespace(xpp);
        while (eventType != 3) {
            if (!this.parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(eventType, xpp, owner, res)) {
                this.unknownContent(xpp);
            }
            eventType = this.nextNoWhitespace(xpp);
        }
        this.next(xpp);
        this.parseElementClose(res);
        return res;
    }

    protected boolean parseNutritionOrderNutritionOrderEnteralFormulaAdministrationComponentContent(int eventType, XmlPullParser xpp, NutritionOrd